#!/usr/bin/env python




##################################################
## DEPENDENCIES
import sys
import os
import os.path
try:
    import builtins as builtin
except ImportError:
    import __builtin__ as builtin
from os.path import getmtime, exists
import time
import types
from Cheetah.Version import MinCompatibleVersion as RequiredCheetahVersion
from Cheetah.Version import MinCompatibleVersionTuple as RequiredCheetahVersionTuple
from Cheetah.Template import Template
from Cheetah.DummyTransaction import *
from Cheetah.NameMapper import NotFound, valueForName, valueFromSearchList, valueFromFrameOrSearchList
from Cheetah.CacheRegion import CacheRegion
import Cheetah.Filters as Filters
import Cheetah.ErrorCatchers as ErrorCatchers
from xpdeint.Features.Transforms._FourierTransformFFTW3MPI import _FourierTransformFFTW3MPI
import operator
from xpdeint.Geometry.UniformDimensionRepresentation import UniformDimensionRepresentation
from xpdeint.Geometry.SplitUniformDimensionRepresentation import SplitUniformDimensionRepresentation
from xpdeint.Utilities import permutations

##################################################
## MODULE CONSTANTS
VFFSL=valueFromFrameOrSearchList
VFSL=valueFromSearchList
VFN=valueForName
currentTime=time.time
__CHEETAH_version__ = '2.4.4'
__CHEETAH_versionTuple__ = (2, 4, 4, 'development', 0)
__CHEETAH_genTime__ = 1484975071.654019
__CHEETAH_genTimestamp__ = 'Sat Jan 21 16:04:31 2017'
__CHEETAH_src__ = '/home/mattias/xmds-2.2.3/admin/staging/xmds-2.2.3/xpdeint/Features/Transforms/FourierTransformFFTW3MPI.tmpl'
__CHEETAH_srcLastModified__ = 'Tue May 22 16:27:12 2012'
__CHEETAH_docstring__ = 'Autogenerated by Cheetah: The Python-Powered Template Engine'

if __CHEETAH_versionTuple__ < RequiredCheetahVersionTuple:
    raise AssertionError(
      'This template was compiled with Cheetah version'
      ' %s. Templates compiled before version %s must be recompiled.'%(
         __CHEETAH_version__, RequiredCheetahVersion))

##################################################
## CLASSES

class FourierTransformFFTW3MPI(_FourierTransformFFTW3MPI):

    ##################################################
    ## CHEETAH GENERATED METHODS


    def __init__(self, *args, **KWs):

        super(FourierTransformFFTW3MPI, self).__init__(*args, **KWs)
        if not self._CHEETAH__instanceInitialized:
            cheetahKWArgs = {}
            allowedKWs = 'searchList namespaces filter filtersLib errorCatcher'.split()
            for k,v in KWs.items():
                if k in allowedKWs: cheetahKWArgs[k] = v
            self._initCheetahInstance(**cheetahKWArgs)
        

    def description(self, **KWS):



        ## Generated from @def description: FFTW3 with MPI at line 29, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        write(u'''FFTW3 with MPI''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def includes(self, **KWS):



        ## CHEETAH: generated from @def includes at line 32, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = super(FourierTransformFFTW3MPI, self).includes()
        if _v is not None: write(_filter(_v))
        # 
        write(u'''#include <fftw3-mpi.h>
''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def globals(self, **KWS):



        ## CHEETAH: generated from @def globals at line 39, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = super(FourierTransformFFTW3MPI, self).globals()
        if _v is not None: write(_filter(_v))
        # 
        for dimRep in [dimRep for dim in self.mpiDimensions for dimRep in dim.representations if dimRep.hasLocalOffset]: # generated from line 43, col 3
            write(u'''ptrdiff_t _block_size_''')
            _v = VFFSL(SL,"dimRep.name",True) # u'${dimRep.name}' on line 44, col 23
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.name}')) # from line 44, col 23.
            write(u''' = FFTW_MPI_DEFAULT_BLOCK;
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def setLocalLatticeAndOffsetVariables(self, **KWS):



        ## CHEETAH: generated from @def setLocalLatticeAndOffsetVariables at line 49, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write(u'''// First work out the local lattice and offset for the geometry
ptrdiff_t _sizes[''')
        _v = VFFSL(SL,"len",False)(VFFSL(SL,"geometry.dimensions",True)) # u'${len($geometry.dimensions)}' on line 52, col 18
        if _v is not None: write(_filter(_v, rawExpr=u'${len($geometry.dimensions)}')) # from line 52, col 18.
        write(u'''];
''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 53, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 53, col 1.
        write(u'''_mpi_init();
''')
        for firstMPIDimRep, secondMPIDimRep in permutations(*[dim.representations for dim in self.mpiDimensions]): # generated from line 54, col 3
            if not (firstMPIDimRep.hasLocalOffset and secondMPIDimRep.hasLocalOffset): # generated from line 55, col 5
                continue
            write(u'''_sizes[0] = ''')
            _v = VFFSL(SL,"firstMPIDimRep.globalLattice",True) # u'${firstMPIDimRep.globalLattice}' on line 58, col 13
            if _v is not None: write(_filter(_v, rawExpr=u'${firstMPIDimRep.globalLattice}')) # from line 58, col 13.
            write(u'''; _sizes[1] = ''')
            _v = VFFSL(SL,"secondMPIDimRep.globalLattice",True) # u'${secondMPIDimRep.globalLattice}' on line 58, col 58
            if _v is not None: write(_filter(_v, rawExpr=u'${secondMPIDimRep.globalLattice}')) # from line 58, col 58.
            write(u''';
''')
            _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 59, col 1
            if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 59, col 1.
            write(u'''_mpi_local_size_many_transposed(
  2, _sizes, 1, _block_size_''')
            _v = VFFSL(SL,"firstMPIDimRep.name",True) # u'${firstMPIDimRep.name}' on line 60, col 29
            if _v is not None: write(_filter(_v, rawExpr=u'${firstMPIDimRep.name}')) # from line 60, col 29.
            write(u''', _block_size_''')
            _v = VFFSL(SL,"secondMPIDimRep.name",True) # u'${secondMPIDimRep.name}' on line 60, col 65
            if _v is not None: write(_filter(_v, rawExpr=u'${secondMPIDimRep.name}')) # from line 60, col 65.
            write(u''', MPI_COMM_WORLD,
  &''')
            _v = VFFSL(SL,"firstMPIDimRep.localLattice",True) # u'${firstMPIDimRep.localLattice}' on line 61, col 4
            if _v is not None: write(_filter(_v, rawExpr=u'${firstMPIDimRep.localLattice}')) # from line 61, col 4.
            write(u''', &''')
            _v = VFFSL(SL,"firstMPIDimRep.localOffset",True) # u'${firstMPIDimRep.localOffset}' on line 61, col 37
            if _v is not None: write(_filter(_v, rawExpr=u'${firstMPIDimRep.localOffset}')) # from line 61, col 37.
            write(u''',
  &''')
            _v = VFFSL(SL,"secondMPIDimRep.localLattice",True) # u'${secondMPIDimRep.localLattice}' on line 62, col 4
            if _v is not None: write(_filter(_v, rawExpr=u'${secondMPIDimRep.localLattice}')) # from line 62, col 4.
            write(u''', &''')
            _v = VFFSL(SL,"secondMPIDimRep.localOffset",True) # u'${secondMPIDimRep.localOffset}' on line 62, col 38
            if _v is not None: write(_filter(_v, rawExpr=u'${secondMPIDimRep.localOffset}')) # from line 62, col 38.
            write(u'''
);

if (_rank == 0) {
  _block_size_''')
            _v = VFFSL(SL,"firstMPIDimRep.name",True) # u'${firstMPIDimRep.name}' on line 66, col 15
            if _v is not None: write(_filter(_v, rawExpr=u'${firstMPIDimRep.name}')) # from line 66, col 15.
            write(u''' = ''')
            _v = VFFSL(SL,"firstMPIDimRep.localLattice",True) # u'${firstMPIDimRep.localLattice}' on line 66, col 40
            if _v is not None: write(_filter(_v, rawExpr=u'${firstMPIDimRep.localLattice}')) # from line 66, col 40.
            write(u''';
  _block_size_''')
            _v = VFFSL(SL,"secondMPIDimRep.name",True) # u'${secondMPIDimRep.name}' on line 67, col 15
            if _v is not None: write(_filter(_v, rawExpr=u'${secondMPIDimRep.name}')) # from line 67, col 15.
            write(u''' = ''')
            _v = VFFSL(SL,"secondMPIDimRep.localLattice",True) # u'${secondMPIDimRep.localLattice}' on line 67, col 41
            if _v is not None: write(_filter(_v, rawExpr=u'${secondMPIDimRep.localLattice}')) # from line 67, col 41.
            write(u''';
}
MPI_Bcast(&_block_size_''')
            _v = VFFSL(SL,"firstMPIDimRep.name",True) # u'${firstMPIDimRep.name}' on line 69, col 24
            if _v is not None: write(_filter(_v, rawExpr=u'${firstMPIDimRep.name}')) # from line 69, col 24.
            write(u''', sizeof(ptrdiff_t), MPI_BYTE, 0, MPI_COMM_WORLD);
MPI_Bcast(&_block_size_''')
            _v = VFFSL(SL,"secondMPIDimRep.name",True) # u'${secondMPIDimRep.name}' on line 70, col 24
            if _v is not None: write(_filter(_v, rawExpr=u'${secondMPIDimRep.name}')) # from line 70, col 24.
            write(u''', sizeof(ptrdiff_t), MPI_BYTE, 0, MPI_COMM_WORLD);

''')
        # 
        firstMPIDim, secondMPIDim = VFFSL(SL,"mpiDimensions",True)
        for field in VFFSL(SL,"fields",True): # generated from line 75, col 3
            if field.name == 'geometry' or not field.isDistributed: # generated from line 76, col 5
                continue
            # 
            #  Set the local_lattice and local_offset variables based on the
            #  values for the geometry's version of these
            fieldMPIDim1 = field.dimensionWithName(firstMPIDim.name)
            fieldMPIDim2 = field.dimensionWithName(secondMPIDim.name)
            for fieldDim, geometryDim in [(fieldMPIDim1, firstMPIDim), (fieldMPIDim2, secondMPIDim)]: # generated from line 84, col 5
                for fieldRep, geometryRep in zip(fieldDim.representations, geometryDim.representations): # generated from line 85, col 7
                    if (not fieldRep) or (not fieldRep.hasLocalOffset) or (not fieldRep.parent is fieldDim): # generated from line 86, col 9
                        continue
                    write(u"""// Set the local lattice and offset variables for the '""")
                    _v = VFFSL(SL,"field.name",True) # u'${field.name}' on line 89, col 56
                    if _v is not None: write(_filter(_v, rawExpr=u'${field.name}')) # from line 89, col 56.
                    write(u"""' field
""")
                    if fieldRep == geometryRep: # generated from line 90, col 9
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # u'${fieldRep.localLattice}' on line 91, col 1
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localLattice}')) # from line 91, col 1.
                        write(u''' = ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # u'${geometryRep.localLattice}' on line 91, col 28
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localLattice}')) # from line 91, col 28.
                        write(u''';
''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # u'${fieldRep.localOffset}' on line 92, col 1
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localOffset}')) # from line 92, col 1.
                        write(u''' = ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 92, col 27
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 92, col 27.
                        write(u''';
''')
                    elif fieldRep.reductionMethod == fieldRep.ReductionMethod.fixedRange: # generated from line 93, col 9
                        #  In this case we are in 'x' space and are subdividing a distributed dimension
                        #  fixedRange reduction method means we take every nth point.
                        write(u'''ptrdiff_t _''')
                        _v = VFFSL(SL,"field.name",True) # u'${field.name}' on line 96, col 12
                        if _v is not None: write(_filter(_v, rawExpr=u'${field.name}')) # from line 96, col 12.
                        write(u'''_''')
                        _v = VFFSL(SL,"fieldRep.name",True) # u'${fieldRep.name}' on line 96, col 26
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.name}')) # from line 96, col 26.
                        write(u'''_skip_size = ''')
                        _v = VFFSL(SL,"geometryRep.globalLattice",True) # u'${geometryRep.globalLattice}' on line 96, col 55
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.globalLattice}')) # from line 96, col 55.
                        write(u'''/''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # u'${fieldRep.globalLattice}' on line 96, col 84
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.globalLattice}')) # from line 96, col 84.
                        write(u''';
if (_rank == 0) {
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # u'${fieldRep.localOffset}' on line 98, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localOffset}')) # from line 98, col 3.
                        write(u'''  = 0;
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # u'${fieldRep.localLattice}' on line 99, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localLattice}')) # from line 99, col 3.
                        write(u''' = (''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # u'${geometryRep.localLattice}' on line 99, col 31
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localLattice}')) # from line 99, col 31.
                        write(u'''-1)/_''')
                        _v = VFFSL(SL,"field.name",True) # u'${field.name}' on line 99, col 63
                        if _v is not None: write(_filter(_v, rawExpr=u'${field.name}')) # from line 99, col 63.
                        write(u'''_''')
                        _v = VFFSL(SL,"fieldRep.name",True) # u'${fieldRep.name}' on line 99, col 77
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.name}')) # from line 99, col 77.
                        write(u'''_skip_size + 1;
} else {
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # u'${fieldRep.localOffset}' on line 101, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localOffset}')) # from line 101, col 3.
                        write(u'''  = (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 101, col 31
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 101, col 31.
                        write(u'''-1)/_''')
                        _v = VFFSL(SL,"field.name",True) # u'${field.name}' on line 101, col 62
                        if _v is not None: write(_filter(_v, rawExpr=u'${field.name}')) # from line 101, col 62.
                        write(u'''_''')
                        _v = VFFSL(SL,"fieldRep.name",True) # u'${fieldRep.name}' on line 101, col 76
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.name}')) # from line 101, col 76.
                        write(u'''_skip_size + 1;
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # u'${fieldRep.localLattice}' on line 102, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localLattice}')) # from line 102, col 3.
                        write(u''' = (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 102, col 31
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 102, col 31.
                        write(u''' + ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # u'${geometryRep.localLattice}' on line 102, col 60
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localLattice}')) # from line 102, col 60.
                        write(u''' - 1)/_''')
                        _v = VFFSL(SL,"field.name",True) # u'${field.name}' on line 102, col 94
                        if _v is not None: write(_filter(_v, rawExpr=u'${field.name}')) # from line 102, col 94.
                        write(u'''_''')
                        _v = VFFSL(SL,"fieldRep.name",True) # u'${fieldRep.name}' on line 102, col 108
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.name}')) # from line 102, col 108.
                        write(u'''_skip_size
                             + 1 - ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # u'${fieldRep.localOffset}' on line 103, col 36
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localOffset}')) # from line 103, col 36.
                        write(u''';
}
''')
                    elif isinstance(fieldRep, UniformDimensionRepresentation): # generated from line 105, col 9
                        #  In this case, we are in 'k' space and may be subdividing a UniformDimensionRepresentation (dct/dst)
                        #  Note that this is a fixedStep reduction method
                        write(u'''if (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 108, col 5
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 108, col 5.
                        write(u''' >= ''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # u'${fieldRep.globalLattice}' on line 108, col 35
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.globalLattice}')) # from line 108, col 35.
                        write(u''') {
  // No points here
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # u'${fieldRep.localOffset}' on line 110, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localOffset}')) # from line 110, col 3.
                        write(u''' = 0;
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # u'${fieldRep.localLattice}' on line 111, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localLattice}')) # from line 111, col 3.
                        write(u''' = 0;
} else if (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 112, col 12
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 112, col 12.
                        write(u''' + ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # u'${geometryRep.localLattice}' on line 112, col 41
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localLattice}')) # from line 112, col 41.
                        write(u''' > ''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # u'${fieldRep.globalLattice}' on line 112, col 71
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.globalLattice}')) # from line 112, col 71.
                        write(u'''){
  // The upper edge is here
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # u'${fieldRep.localOffset}' on line 114, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localOffset}')) # from line 114, col 3.
                        write(u''' = ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 114, col 29
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 114, col 29.
                        write(u''';
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # u'${fieldRep.localLattice}' on line 115, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localLattice}')) # from line 115, col 3.
                        write(u''' = ''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # u'${fieldRep.globalLattice}' on line 115, col 30
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.globalLattice}')) # from line 115, col 30.
                        write(u''' - ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 115, col 58
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 115, col 58.
                        write(u''';
} else {
  // somewhere near the start
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # u'${fieldRep.localOffset}' on line 118, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localOffset}')) # from line 118, col 3.
                        write(u''' = ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 118, col 29
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 118, col 29.
                        write(u''';
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # u'${fieldRep.localLattice}' on line 119, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localLattice}')) # from line 119, col 3.
                        write(u''' = ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # u'${geometryRep.localLattice}' on line 119, col 30
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localLattice}')) # from line 119, col 30.
                        write(u''';
}
''')
                    elif isinstance(fieldRep, SplitUniformDimensionRepresentation): # generated from line 121, col 9
                        #  In this case, we are in 'k' space and may be subdividing a SplitUniformDimensionRepresentation (dft)
                        #  Note that this is a fixedStep reduction method
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # u'${fieldRep.localOffset}' on line 124, col 1
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localOffset}')) # from line 124, col 1.
                        write(u''' = -1;
if (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 125, col 5
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 125, col 5.
                        write(u''' >= (''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # u'${fieldRep.globalLattice}' on line 125, col 36
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.globalLattice}')) # from line 125, col 36.
                        write(u"""+1)/2) {
  // No points due to positive 'k' values.
} else if (""")
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 127, col 12
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 127, col 12.
                        write(u''' + ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # u'${geometryRep.localLattice}' on line 127, col 41
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localLattice}')) # from line 127, col 41.
                        write(u''' > (''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # u'${fieldRep.globalLattice}' on line 127, col 72
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.globalLattice}')) # from line 127, col 72.
                        write(u'''+1)/2) {
  // the upper edge of the positive values are here
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # u'${fieldRep.localOffset}' on line 129, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localOffset}')) # from line 129, col 3.
                        write(u''' = ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 129, col 29
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 129, col 29.
                        write(u''';
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # u'${fieldRep.localLattice}' on line 130, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localLattice}')) # from line 130, col 3.
                        write(u''' = (''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # u'${fieldRep.globalLattice}' on line 130, col 31
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.globalLattice}')) # from line 130, col 31.
                        write(u'''+1)/2 - ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 130, col 64
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 130, col 64.
                        write(u''';
} else if (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 131, col 12
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 131, col 12.
                        write(u''' < (''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # u'${fieldRep.globalLattice}' on line 131, col 42
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.globalLattice}')) # from line 131, col 42.
                        write(u'''+1)/2) {
  // somewhere near the start of the positive values
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # u'${fieldRep.localOffset}' on line 133, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localOffset}')) # from line 133, col 3.
                        write(u''' = ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 133, col 29
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 133, col 29.
                        write(u''';
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # u'${fieldRep.localLattice}' on line 134, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localLattice}')) # from line 134, col 3.
                        write(u''' = ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # u'${geometryRep.localLattice}' on line 134, col 30
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localLattice}')) # from line 134, col 30.
                        write(u''';
}

if (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 137, col 5
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 137, col 5.
                        write(u''' + ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # u'${geometryRep.localLattice}' on line 137, col 34
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localLattice}')) # from line 137, col 34.
                        write(u''' <= ''')
                        _v = VFFSL(SL,"geometryRep.globalLattice",True) # u'${geometryRep.globalLattice}' on line 137, col 65
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.globalLattice}')) # from line 137, col 65.
                        write(u''' - ''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # u'${fieldRep.globalLattice}' on line 137, col 96
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.globalLattice}')) # from line 137, col 96.
                        write(u"""/2) {
  // No points due to negative 'k' values.
} else if (""")
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 139, col 12
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 139, col 12.
                        write(u''' < ''')
                        _v = VFFSL(SL,"geometryRep.globalLattice",True) # u'${geometryRep.globalLattice}' on line 139, col 41
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.globalLattice}')) # from line 139, col 41.
                        write(u''' - ''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # u'${fieldRep.globalLattice}' on line 139, col 72
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.globalLattice}')) # from line 139, col 72.
                        write(u'''/2) {
  // the lower edge of the negative values are here
  if (''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # u'${fieldRep.localOffset}' on line 141, col 7
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localOffset}')) # from line 141, col 7.
                        write(u''' == -1)
    ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # u'${fieldRep.localOffset}' on line 142, col 5
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localOffset}')) # from line 142, col 5.
                        write(u''' = (''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # u'${fieldRep.globalLattice}' on line 142, col 32
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.globalLattice}')) # from line 142, col 32.
                        write(u'''+1)/2;
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # u'${fieldRep.localLattice}' on line 143, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localLattice}')) # from line 143, col 3.
                        write(u''' += ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # u'${geometryRep.localLattice}' on line 143, col 31
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localLattice}')) # from line 143, col 31.
                        write(u''' - (''')
                        _v = VFFSL(SL,"geometryRep.globalLattice",True) # u'${geometryRep.globalLattice}' on line 143, col 62
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.globalLattice}')) # from line 143, col 62.
                        write(u'''-''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # u'${fieldRep.globalLattice}' on line 143, col 91
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.globalLattice}')) # from line 143, col 91.
                        write(u'''/2-''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 143, col 119
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 143, col 119.
                        write(u''');
} else if (''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 144, col 12
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 144, col 12.
                        write(u''' + ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # u'${geometryRep.localLattice}' on line 144, col 41
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localLattice}')) # from line 144, col 41.
                        write(u''' > ''')
                        _v = VFFSL(SL,"geometryRep.globalLattice",True) # u'${geometryRep.globalLattice}' on line 144, col 71
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.globalLattice}')) # from line 144, col 71.
                        write(u''' - ''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # u'${fieldRep.globalLattice}' on line 144, col 102
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.globalLattice}')) # from line 144, col 102.
                        write(u'''/2) {
  // somewhere near the end of the negative values
  ''')
                        _v = VFFSL(SL,"fieldRep.localOffset",True) # u'${fieldRep.localOffset}' on line 146, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localOffset}')) # from line 146, col 3.
                        write(u''' = ''')
                        _v = VFFSL(SL,"geometryRep.localOffset",True) # u'${geometryRep.localOffset}' on line 146, col 29
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localOffset}')) # from line 146, col 29.
                        write(u''' - (''')
                        _v = VFFSL(SL,"geometryRep.globalLattice",True) # u'${geometryRep.globalLattice}' on line 146, col 59
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.globalLattice}')) # from line 146, col 59.
                        write(u'''-''')
                        _v = VFFSL(SL,"fieldRep.globalLattice",True) # u'${fieldRep.globalLattice}' on line 146, col 88
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.globalLattice}')) # from line 146, col 88.
                        write(u''');
  ''')
                        _v = VFFSL(SL,"fieldRep.localLattice",True) # u'${fieldRep.localLattice}' on line 147, col 3
                        if _v is not None: write(_filter(_v, rawExpr=u'${fieldRep.localLattice}')) # from line 147, col 3.
                        write(u''' = ''')
                        _v = VFFSL(SL,"geometryRep.localLattice",True) # u'${geometryRep.localLattice}' on line 147, col 30
                        if _v is not None: write(_filter(_v, rawExpr=u'${geometryRep.localLattice}')) # from line 147, col 30.
                        write(u''';
}
''')
                    else: # generated from line 149, col 9
                        assert False
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def setVectorAllocSizes(self, vectors, **KWS):



        ## CHEETAH: generated from @def setVectorAllocSizes($vectors) at line 158, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write(u'''ptrdiff_t _local_alloc_size, _tmp;
''')
        for tID, transformation in self.transformations: # generated from line 161, col 3
            if not transformation.get('distributedTransform', False): # generated from line 162, col 5
                continue
            untransformedDimRepBasis, transformedDimRepBasis = transformation['transformPair']
            for dimNum, dimRep in enumerate(untransformedDimRepBasis): # generated from line 166, col 5
                write(u'''_sizes[''')
                _v = VFFSL(SL,"dimNum",True) # u'${dimNum}' on line 167, col 8
                if _v is not None: write(_filter(_v, rawExpr=u'${dimNum}')) # from line 167, col 8.
                write(u'''] = ''')
                _v = VFFSL(SL,"dimRep.globalLattice",True) # u'${dimRep.globalLattice}' on line 167, col 21
                if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.globalLattice}')) # from line 167, col 21.
                write(u''';
''')
            write(u'''_local_alloc_size = ''')
            _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 169, col 21
            if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 169, col 21.
            write(u'''_mpi_local_size_many_transposed(
  ''')
            _v = VFFSL(SL,"len",False)(untransformedDimRepBasis) # u'${len(untransformedDimRepBasis)}' on line 170, col 3
            if _v is not None: write(_filter(_v, rawExpr=u'${len(untransformedDimRepBasis)}')) # from line 170, col 3.
            write(u''', _sizes,
  (ptrdiff_t)''')
            _v = VFFSL(SL,"transformation",True)['postfixLatticeString'] # u"${transformation['postfixLatticeString']}" on line 171, col 14
            if _v is not None: write(_filter(_v, rawExpr=u"${transformation['postfixLatticeString']}")) # from line 171, col 14.
            write(u''',
  _block_size_''')
            _v = VFN(VFFSL(SL,"untransformedDimRepBasis",True)[0],"name",True) # u'${untransformedDimRepBasis[0].name}' on line 172, col 15
            if _v is not None: write(_filter(_v, rawExpr=u'${untransformedDimRepBasis[0].name}')) # from line 172, col 15.
            write(u''', _block_size_''')
            _v = VFN(VFFSL(SL,"transformedDimRepBasis",True)[0],"name",True) # u'${transformedDimRepBasis[0].name}' on line 172, col 64
            if _v is not None: write(_filter(_v, rawExpr=u'${transformedDimRepBasis[0].name}')) # from line 172, col 64.
            write(u''',
  MPI_COMM_WORLD,
  &_tmp, &_tmp, &_tmp, &_tmp /* Local lattices and offsets were obtained above */
);
''')
            for vector in transformation['vectors']: # generated from line 176, col 5
                _v = VFFSL(SL,"vector.allocSize",True) # u'${vector.allocSize}' on line 177, col 1
                if _v is not None: write(_filter(_v, rawExpr=u'${vector.allocSize}')) # from line 177, col 1.
                write(u''' = MAX(''')
                _v = VFFSL(SL,"vector.allocSize",True) # u'${vector.allocSize}' on line 177, col 27
                if _v is not None: write(_filter(_v, rawExpr=u'${vector.allocSize}')) # from line 177, col 27.
                write(u''', (_local_alloc_size''')
                _v = '+1) / 2' if vector.type == 'complex' and transformation.get('transformType', 'real') == 'real' else ')' # u"${'+1) / 2' if vector.type == 'complex' and transformation.get('transformType', 'real') == 'real' else ')'}" on line 177, col 66
                if _v is not None: write(_filter(_v, rawExpr=u"${'+1) / 2' if vector.type == 'complex' and transformation.get('transformType', 'real') == 'real' else ')'}")) # from line 177, col 66.
                write(u''');
''')
            write(u'''
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def transposeTransformFunction(self, transformID, transformDict, function, **KWS):



        ## CHEETAH: generated from @def transposeTransformFunction(transformID, transformDict, function) at line 184, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        runtimePrefix, prefixLattice, postfixLattice, runtimePostfix = transformDict['transformSpecifier']
        flags = ' | FFTW_MPI_TRANSPOSED_IN | FFTW_MPI_TRANSPOSED_OUT' if transformDict['transposedOrder'] else ''
        flags += ' | FFTW_DESTROY_INPUT' if transformDict.get('outOfPlace', False) else ''
        write(u'''// _prefix_lattice should be ''')
        _v = VFFSL(SL,"prefixLattice",True) # u'${prefixLattice}' on line 189, col 30
        if _v is not None: write(_filter(_v, rawExpr=u'${prefixLattice}')) # from line 189, col 30.
        write(u'''
// _postfix_lattice should be ''')
        _v = VFFSL(SL,"postfixLattice",True) # u'${postfixLattice}' on line 190, col 31
        if _v is not None: write(_filter(_v, rawExpr=u'${postfixLattice}')) # from line 190, col 31.
        write(u'''
static ''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 191, col 8
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 191, col 8.
        write(u'''_plan _fftw_forward_plan = NULL;
static ''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 192, col 8
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 192, col 8.
        write(u'''_plan _fftw_backward_plan = NULL;

if (!_fftw_forward_plan) {
  _LOG(_SIMULATION_LOG_LEVEL, "Planning for ''')
        _v = VFFSL(SL,"function.description",True) # u'${function.description}' on line 195, col 45
        if _v is not None: write(_filter(_v, rawExpr=u'${function.description}')) # from line 195, col 45.
        write(u'''...");
''')
        transformPair = transformDict['transformPair']
        if transformDict['transposedOrder']: # generated from line 197, col 3
            #  Reverse the order
            transformPair = transformPair[::-1]
        dataOut = '_data_out' if transformDict.get('outOfPlace', False) else '_data_in'
        write(u'''  
  _fftw_forward_plan = ''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 203, col 24
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 203, col 24.
        write(u'''_mpi_plan_many_transpose(
    ''')
        _v = ', '.join(dr.globalLattice for dr in transformPair[0]) # u"${', '.join(dr.globalLattice for dr in transformPair[0])}" on line 204, col 5
        if _v is not None: write(_filter(_v, rawExpr=u"${', '.join(dr.globalLattice for dr in transformPair[0])}")) # from line 204, col 5.
        write(u''',
    _postfix_lattice, _block_size_''')
        _v = VFN(VFFSL(SL,"transformPair",True)[0][0],"name",True) # u'${transformPair[0][0].name}' on line 205, col 35
        if _v is not None: write(_filter(_v, rawExpr=u'${transformPair[0][0].name}')) # from line 205, col 35.
        write(u''', _block_size_''')
        _v = VFN(VFFSL(SL,"transformPair",True)[1][0],"name",True) # u'${transformPair[1][0].name}' on line 205, col 76
        if _v is not None: write(_filter(_v, rawExpr=u'${transformPair[1][0].name}')) # from line 205, col 76.
        write(u''',
    reinterpret_cast<real*>(_data_in),
    reinterpret_cast<real*>(''')
        _v = VFFSL(SL,"dataOut",True) # u'$dataOut' on line 207, col 29
        if _v is not None: write(_filter(_v, rawExpr=u'$dataOut')) # from line 207, col 29.
        write(u'''),
    MPI_COMM_WORLD, ''')
        _v = VFFSL(SL,"planType",True) # u'${planType}' on line 208, col 21
        if _v is not None: write(_filter(_v, rawExpr=u'${planType}')) # from line 208, col 21.
        _v = VFFSL(SL,"flags",True) # u'${flags}' on line 208, col 32
        if _v is not None: write(_filter(_v, rawExpr=u'${flags}')) # from line 208, col 32.
        write(u'''
  );
  
  if (!_fftw_forward_plan)
    _LOG(_ERROR_LOG_LEVEL, "(%s: %i) Unable to create forward mpi transform plan.\\n", __FILE__, __LINE__);
  
  _fftw_backward_plan = ''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 214, col 25
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 214, col 25.
        write(u'''_mpi_plan_many_transpose(
    ''')
        _v = ', '.join(dr.globalLattice for dr in transformPair[1]) # u"${', '.join(dr.globalLattice for dr in transformPair[1])}" on line 215, col 5
        if _v is not None: write(_filter(_v, rawExpr=u"${', '.join(dr.globalLattice for dr in transformPair[1])}")) # from line 215, col 5.
        write(u''',
    _postfix_lattice, _block_size_''')
        _v = VFN(VFFSL(SL,"transformPair",True)[1][0],"name",True) # u'${transformPair[1][0].name}' on line 216, col 35
        if _v is not None: write(_filter(_v, rawExpr=u'${transformPair[1][0].name}')) # from line 216, col 35.
        write(u''', _block_size_''')
        _v = VFN(VFFSL(SL,"transformPair",True)[0][0],"name",True) # u'${transformPair[0][0].name}' on line 216, col 76
        if _v is not None: write(_filter(_v, rawExpr=u'${transformPair[0][0].name}')) # from line 216, col 76.
        write(u''',
    reinterpret_cast<real*>(_data_in),
    reinterpret_cast<real*>(''')
        _v = VFFSL(SL,"dataOut",True) # u'$dataOut' on line 218, col 29
        if _v is not None: write(_filter(_v, rawExpr=u'$dataOut')) # from line 218, col 29.
        write(u'''),
    MPI_COMM_WORLD, ''')
        _v = VFFSL(SL,"planType",True) # u'${planType}' on line 219, col 21
        if _v is not None: write(_filter(_v, rawExpr=u'${planType}')) # from line 219, col 21.
        _v = VFFSL(SL,"flags",True) # u'${flags}' on line 219, col 32
        if _v is not None: write(_filter(_v, rawExpr=u'${flags}')) # from line 219, col 32.
        write(u'''
  );
  
  if (!_fftw_backward_plan)
    _LOG(_ERROR_LOG_LEVEL, "(%s: %i) Unable to create backward mpi transform plan.\\n", __FILE__, __LINE__);
  
  // Save wisdom
  #if CFG_OSAPI == CFG_OSAPI_POSIX
  ''')
        _v = VFFSL(SL,"saveWisdom",True) # u'${saveWisdom, autoIndent=True}' on line 227, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr=u'${saveWisdom, autoIndent=True}')) # from line 227, col 3.
        write(u'''  #endif // POSIX
  
  _LOG(_SIMULATION_LOG_LEVEL, " done.\\n");
}

if (_forward) {
  ''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 234, col 3
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 234, col 3.
        write(u'''_execute_r2r(
    _fftw_forward_plan,
    reinterpret_cast<real*>(_data_in),
    reinterpret_cast<real*>(''')
        _v = VFFSL(SL,"dataOut",True) # u'${dataOut}' on line 237, col 29
        if _v is not None: write(_filter(_v, rawExpr=u'${dataOut}')) # from line 237, col 29.
        write(u''')
  );
} else {
  ''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 240, col 3
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 240, col 3.
        write(u'''_execute_r2r(
    _fftw_backward_plan,
    reinterpret_cast<real*>(_data_in),
    reinterpret_cast<real*>(''')
        _v = VFFSL(SL,"dataOut",True) # u'${dataOut}' on line 243, col 29
        if _v is not None: write(_filter(_v, rawExpr=u'${dataOut}')) # from line 243, col 29.
        write(u''')
  );
}
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def distributedTransformFunction(self, transformID, transformDict, function, **KWS):



        ## CHEETAH: generated from @def distributedTransformFunction(transformID, transformDict, function) at line 249, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        runtimePrefix, prefixLattice, postfixLattice, runtimePostfix = transformDict['transformSpecifier']
        write(u'''// _prefix_lattice should be ''')
        _v = VFFSL(SL,"prefixLattice",True) # u'${prefixLattice}' on line 252, col 30
        if _v is not None: write(_filter(_v, rawExpr=u'${prefixLattice}')) # from line 252, col 30.
        _v = ''.join([' * ' + runtimeLattice for runtimeLattice in runtimePrefix]) # u"${''.join([' * ' + runtimeLattice for runtimeLattice in runtimePrefix])}" on line 252, col 46
        if _v is not None: write(_filter(_v, rawExpr=u"${''.join([' * ' + runtimeLattice for runtimeLattice in runtimePrefix])}")) # from line 252, col 46.
        write(u'''
// _postfix_lattice should be ''')
        _v = VFFSL(SL,"postfixLattice",True) # u'${postfixLattice}' on line 253, col 31
        if _v is not None: write(_filter(_v, rawExpr=u'${postfixLattice}')) # from line 253, col 31.
        _v = ''.join([' * ' + runtimeLattice for runtimeLattice in runtimePostfix]) # u"${''.join([' * ' + runtimeLattice for runtimeLattice in runtimePostfix])}" on line 253, col 48
        if _v is not None: write(_filter(_v, rawExpr=u"${''.join([' * ' + runtimeLattice for runtimeLattice in runtimePostfix])}")) # from line 253, col 48.
        write(u'''
static ''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 254, col 8
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 254, col 8.
        write(u'''_plan _fftw_forward_plan = NULL;
static ''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 255, col 8
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 255, col 8.
        write(u'''_plan _fftw_backward_plan = NULL;

if (!_fftw_forward_plan) {
  _LOG(_SIMULATION_LOG_LEVEL, "Planning for ''')
        _v = VFFSL(SL,"function.description",True) # u'${function.description}' on line 258, col 45
        if _v is not None: write(_filter(_v, rawExpr=u'${function.description}')) # from line 258, col 45.
        write(u'''...");
''')
        transformPair = transformDict['transformPair']
        dimensionsBeingTransformed = len(transformPair[0])
        transformType = transformDict['transformType']
        dataOut = '_data_out' if transformDict.get('outOfPlace', False) else '_data_in'
        flags = ' | FFTW_DESTROY_INPUT' if transformDict.get('outOfPlace', False) else ''
        write(u'''  ptrdiff_t _transform_sizes[''')
        _v = VFFSL(SL,"dimensionsBeingTransformed",True) # u'${dimensionsBeingTransformed}' on line 264, col 30
        if _v is not None: write(_filter(_v, rawExpr=u'${dimensionsBeingTransformed}')) # from line 264, col 30.
        write(u'''];
''')
        if transformType == 'real': # generated from line 265, col 3
            write(u'''  ''')
            _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 266, col 3
            if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 266, col 3.
            write(u'''_r2r_kind _r2r_kinds[''')
            _v = VFFSL(SL,"dimensionsBeingTransformed",True) # u'${dimensionsBeingTransformed}' on line 266, col 37
            if _v is not None: write(_filter(_v, rawExpr=u'${dimensionsBeingTransformed}')) # from line 266, col 37.
            write(u'''];
''')
        write(u'''  
  int _transform_sizes_index = 0;
  
''')
        # 
        for dimID, dimRep in enumerate(transformPair[0]): # generated from line 272, col 3
            write(u'''  _transform_sizes[_transform_sizes_index++] = ''')
            _v = VFFSL(SL,"dimRep.globalLattice",True) # u'${dimRep.globalLattice}' on line 273, col 48
            if _v is not None: write(_filter(_v, rawExpr=u'${dimRep.globalLattice}')) # from line 273, col 48.
            write(u''';
''')
        write(u'''  
''')
        if transformType == 'complex': # generated from line 276, col 3
            guruPlanFunction = self.createGuruMPIDFTPlanInDirection
        else: # generated from line 278, col 3
            guruPlanFunction = self.createGuruMPIR2RPlanInDirection
        # 
        write(u'''  ''')
        _v = VFFSL(SL,"guruPlanFunction",False)(
      transformDict, 'forward', dataOut,
      '_block_size_' + transformPair[0][0].name, '_block_size_' + transformPair[1][0].name, 'FFTW_MPI_TRANSPOSED_OUT', flags
    )
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr=u"${guruPlanFunction(\n      transformDict, 'forward', dataOut,\n      '_block_size_' + transformPair[0][0].name, '_block_size_' + transformPair[1][0].name, 'FFTW_MPI_TRANSPOSED_OUT', flags\n    ), autoIndent=True}")) # from line 282, col 3.
        write(u'''  ''')
        _v = VFFSL(SL,"guruPlanFunction",False)(
      transformDict, 'backward', dataOut,
      '_block_size_' + transformPair[1][0].name, '_block_size_' + transformPair[0][0].name, 'FFTW_MPI_TRANSPOSED_IN', flags
    )
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr=u"${guruPlanFunction(\n      transformDict, 'backward', dataOut,\n      '_block_size_' + transformPair[1][0].name, '_block_size_' + transformPair[0][0].name, 'FFTW_MPI_TRANSPOSED_IN', flags\n    ), autoIndent=True}")) # from line 286, col 3.
        write(u'''  
  // Save wisdom
  #if CFG_OSAPI == CFG_OSAPI_POSIX
  ''')
        _v = VFFSL(SL,"saveWisdom",True) # u'${saveWisdom, autoIndent=True}' on line 293, col 3
        if _v is not None: write(_filter(_v, autoIndent=True, rawExpr=u'${saveWisdom, autoIndent=True}')) # from line 293, col 3.
        write(u'''  #endif // POSIX
  
  _LOG(_SIMULATION_LOG_LEVEL, " done.\\n");
}

if (_forward) {
  ''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 300, col 3
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 300, col 3.
        write(u'''_execute_r2r(
    _fftw_forward_plan,
    reinterpret_cast<real*>(_data_in),
    reinterpret_cast<real*>(''')
        _v = VFFSL(SL,"dataOut",True) # u'${dataOut}' on line 303, col 29
        if _v is not None: write(_filter(_v, rawExpr=u'${dataOut}')) # from line 303, col 29.
        write(u''')
  );
} else {
  ''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 306, col 3
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 306, col 3.
        write(u'''_execute_r2r(
    _fftw_backward_plan,
    reinterpret_cast<real*>(_data_in),
    reinterpret_cast<real*>(''')
        _v = VFFSL(SL,"dataOut",True) # u'${dataOut}' on line 309, col 29
        if _v is not None: write(_filter(_v, rawExpr=u'${dataOut}')) # from line 309, col 29.
        write(u''')
  );
}
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def createGuruMPIDFTPlanInDirection(self, transformDict, direction, dataOut, inBlockSize, outBlockSize, transposedState, flags, **KWS):



        ## CHEETAH: generated from @def createGuruMPIDFTPlanInDirection($transformDict, $direction, $dataOut, $inBlockSize, $outBlockSize, $transposedState, $flags) at line 315, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        write(u'''_fftw_''')
        _v = VFFSL(SL,"direction",True) # u'${direction}' on line 317, col 7
        if _v is not None: write(_filter(_v, rawExpr=u'${direction}')) # from line 317, col 7.
        write(u'''_plan = ''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 317, col 27
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 317, col 27.
        write(u'''_mpi_plan_many_dft(
  _transform_sizes_index, _transform_sizes, _postfix_lattice,
  ''')
        _v = VFFSL(SL,"inBlockSize",True) # u'${inBlockSize}' on line 319, col 3
        if _v is not None: write(_filter(_v, rawExpr=u'${inBlockSize}')) # from line 319, col 3.
        write(u''', ''')
        _v = VFFSL(SL,"outBlockSize",True) # u'${outBlockSize}' on line 319, col 19
        if _v is not None: write(_filter(_v, rawExpr=u'${outBlockSize}')) # from line 319, col 19.
        write(u''',
  reinterpret_cast<''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 320, col 20
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 320, col 20.
        write(u'''_complex*>(_data_in),
  reinterpret_cast<''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 321, col 20
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 321, col 20.
        write(u'''_complex*>(''')
        _v = VFFSL(SL,"dataOut",True) # u'${dataOut}' on line 321, col 44
        if _v is not None: write(_filter(_v, rawExpr=u'${dataOut}')) # from line 321, col 44.
        write(u'''),
  MPI_COMM_WORLD, FFTW_''')
        _v = VFN(VFFSL(SL,"direction",True),"upper",False)() # u'${direction.upper()}' on line 322, col 24
        if _v is not None: write(_filter(_v, rawExpr=u'${direction.upper()}')) # from line 322, col 24.
        write(u''', ''')
        _v = VFFSL(SL,"planType",True) # u'${planType}' on line 322, col 46
        if _v is not None: write(_filter(_v, rawExpr=u'${planType}')) # from line 322, col 46.
        write(u''' | ''')
        _v = VFFSL(SL,"transposedState",True) # u'${transposedState}' on line 322, col 60
        if _v is not None: write(_filter(_v, rawExpr=u'${transposedState}')) # from line 322, col 60.
        _v = VFFSL(SL,"flags",True) # u'${flags}' on line 322, col 78
        if _v is not None: write(_filter(_v, rawExpr=u'${flags}')) # from line 322, col 78.
        write(u'''
);
if (!_fftw_''')
        _v = VFFSL(SL,"direction",True) # u'${direction}' on line 324, col 12
        if _v is not None: write(_filter(_v, rawExpr=u'${direction}')) # from line 324, col 12.
        write(u'''_plan)
  _LOG(_ERROR_LOG_LEVEL, "(%s: %i) Unable to create ''')
        _v = VFFSL(SL,"direction",True) # u'${direction}' on line 325, col 53
        if _v is not None: write(_filter(_v, rawExpr=u'${direction}')) # from line 325, col 53.
        write(u''' mpi dft plan.\\n", __FILE__, __LINE__);

''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def createGuruMPIR2RPlanInDirection(self, transformDict, direction, dataOut, inBlockSize, outBlockSize, transposedState, flags, **KWS):



        ## CHEETAH: generated from @def createGuruMPIR2RPlanInDirection($transformDict, $direction, $dataOut, $inBlockSize, $outBlockSize, $transposedState, $flags) at line 330, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        for idx, dimRep in enumerate(transformDict['transformPair'][0]): # generated from line 332, col 3
            write(u'''_r2r_kinds[''')
            _v = VFFSL(SL,"idx",True) # u'${idx}' on line 333, col 12
            if _v is not None: write(_filter(_v, rawExpr=u'${idx}')) # from line 333, col 12.
            write(u'''] = ''')
            _v = VFFSL(SL,"r2rKindForDimensionAndDirection",False)(dimRep.name, direction) # u'${r2rKindForDimensionAndDirection(dimRep.name, direction)}' on line 333, col 22
            if _v is not None: write(_filter(_v, rawExpr=u'${r2rKindForDimensionAndDirection(dimRep.name, direction)}')) # from line 333, col 22.
            write(u''';
''')
        write(u'''
_fftw_''')
        _v = VFFSL(SL,"direction",True) # u'${direction}' on line 336, col 7
        if _v is not None: write(_filter(_v, rawExpr=u'${direction}')) # from line 336, col 7.
        write(u'''_plan = ''')
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 336, col 27
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 336, col 27.
        write(u'''_mpi_plan_many_r2r(
  _transform_sizes_index, _transform_sizes, _postfix_lattice,
  ''')
        _v = VFFSL(SL,"inBlockSize",True) # u'${inBlockSize}' on line 338, col 3
        if _v is not None: write(_filter(_v, rawExpr=u'${inBlockSize}')) # from line 338, col 3.
        write(u''', ''')
        _v = VFFSL(SL,"outBlockSize",True) # u'${outBlockSize}' on line 338, col 19
        if _v is not None: write(_filter(_v, rawExpr=u'${outBlockSize}')) # from line 338, col 19.
        write(u''',
  reinterpret_cast<real*>(_data_in),
  reinterpret_cast<real*>(''')
        _v = VFFSL(SL,"dataOut",True) # u'${dataOut}' on line 340, col 27
        if _v is not None: write(_filter(_v, rawExpr=u'${dataOut}')) # from line 340, col 27.
        write(u'''),
  MPI_COMM_WORLD, _r2r_kinds, ''')
        _v = VFFSL(SL,"planType",True) # u'${planType}' on line 341, col 31
        if _v is not None: write(_filter(_v, rawExpr=u'${planType}')) # from line 341, col 31.
        write(u''' | ''')
        _v = VFFSL(SL,"transposedState",True) # u'${transposedState}' on line 341, col 45
        if _v is not None: write(_filter(_v, rawExpr=u'${transposedState}')) # from line 341, col 45.
        _v = VFFSL(SL,"flags",True) # u'${flags}' on line 341, col 63
        if _v is not None: write(_filter(_v, rawExpr=u'${flags}')) # from line 341, col 63.
        write(u'''
);

if (!_fftw_''')
        _v = VFFSL(SL,"direction",True) # u'${direction}' on line 344, col 12
        if _v is not None: write(_filter(_v, rawExpr=u'${direction}')) # from line 344, col 12.
        write(u'''_plan)
  _LOG(_ERROR_LOG_LEVEL, "(%s: %i) Unable to create ''')
        _v = VFFSL(SL,"direction",True) # u'${direction}' on line 345, col 53
        if _v is not None: write(_filter(_v, rawExpr=u'${direction}')) # from line 345, col 53.
        write(u''' mpi r2r plan.\\n", __FILE__, __LINE__);
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def loadWisdom(self, **KWS):



        ## CHEETAH: generated from @def loadWisdom at line 350, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = super(FourierTransformFFTW3MPI, self).loadWisdom()
        if _v is not None: write(_filter(_v))
        # 
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 354, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 354, col 1.
        write(u'''_mpi_broadcast_wisdom(MPI_COMM_WORLD);
''')
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def saveWisdom(self, **KWS):



        ## CHEETAH: generated from @def saveWisdom at line 358, col 1.
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        _v = VFFSL(SL,"fftwPrefix",True) # u'${fftwPrefix}' on line 360, col 1
        if _v is not None: write(_filter(_v, rawExpr=u'${fftwPrefix}')) # from line 360, col 1.
        write(u'''_mpi_gather_wisdom(MPI_COMM_WORLD);
''')
        # 
        _v = super(FourierTransformFFTW3MPI, self).saveWisdom()
        if _v is not None: write(_filter(_v))
        # 
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        

    def writeBody(self, **KWS):



        ## CHEETAH: main method generated for this template
        trans = KWS.get("trans")
        if (not trans and not self._CHEETAH__isBuffering and not callable(self.transaction)):
            trans = self.transaction # is None unless self.awake() was called
        if not trans:
            trans = DummyTransaction()
            _dummyTrans = True
        else: _dummyTrans = False
        write = trans.response().write
        SL = self._CHEETAH__searchList
        _filter = self._CHEETAH__currentFilter
        
        ########################################
        ## START - generated method body
        
        # 
        # FourierTransformFFTW3MPI.tmpl
        # 
        # Created by Graham Dennis on 2008-06-06.
        # 
        # Copyright (c) 2008-2012, Graham Dennis
        # 
        # This program is free software: you can redistribute it and/or modify
        # it under the terms of the GNU General Public License as published by
        # the Free Software Foundation, either version 2 of the License, or
        # (at your option) any later version.
        # 
        # This program is distributed in the hope that it will be useful,
        # but WITHOUT ANY WARRANTY; without even the implied warranty of
        # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        # GNU General Public License for more details.
        # 
        # You should have received a copy of the GNU General Public License
        # along with this program.  If not, see <http://www.gnu.org/licenses/>.
        # 
        write(u'''












''')
        
        ########################################
        ## END - generated method body
        
        return _dummyTrans and trans.response().getvalue() or ""
        
    ##################################################
    ## CHEETAH GENERATED ATTRIBUTES


    _CHEETAH__instanceInitialized = False

    _CHEETAH_version = __CHEETAH_version__

    _CHEETAH_versionTuple = __CHEETAH_versionTuple__

    _CHEETAH_genTime = __CHEETAH_genTime__

    _CHEETAH_genTimestamp = __CHEETAH_genTimestamp__

    _CHEETAH_src = __CHEETAH_src__

    _CHEETAH_srcLastModified = __CHEETAH_srcLastModified__

    fftwSuffix = 'mpi'

    _mainCheetahMethod_for_FourierTransformFFTW3MPI= 'writeBody'

## END CLASS DEFINITION

if not hasattr(FourierTransformFFTW3MPI, '_initCheetahAttributes'):
    templateAPIClass = getattr(FourierTransformFFTW3MPI, '_CHEETAH_templateClass', Template)
    templateAPIClass._addCheetahPlumbingCodeToClass(FourierTransformFFTW3MPI)


# CHEETAH was developed by Tavis Rudd and Mike Orr
# with code, advice and input from many other volunteers.
# For more information visit http://www.CheetahTemplate.org/

##################################################
## if run from command line:
if __name__ == '__main__':
    from Cheetah.TemplateCmdLineIface import CmdLineIface
    CmdLineIface(templateObj=FourierTransformFFTW3MPI()).run()


