/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.swt;

import java.awt.Cursor;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.ListIterator;
import org.piccolo2d.PCamera;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PBasicInputEventHandler;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.event.PInputEventListener;
import org.piccolo2d.extras.swt.PSWTHandle;
import org.piccolo2d.extras.util.PBoundsLocator;
import org.piccolo2d.extras.util.PLocator;
import org.piccolo2d.util.PBounds;
import org.piccolo2d.util.PDimension;
import org.piccolo2d.util.PPickPath;

public class PSWTBoundsHandle
extends PSWTHandle {
    private static final long serialVersionUID = 1L;
    private PBasicInputEventHandler handleCursorHandler;

    public static void addBoundsHandlesTo(PNode node) {
        node.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createEastLocator((PNode)node)));
        node.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createWestLocator((PNode)node)));
        node.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createNorthLocator((PNode)node)));
        node.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createSouthLocator((PNode)node)));
        node.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createNorthEastLocator((PNode)node)));
        node.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createNorthWestLocator((PNode)node)));
        node.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createSouthEastLocator((PNode)node)));
        node.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createSouthWestLocator((PNode)node)));
    }

    public static void addStickyBoundsHandlesTo(PNode node, PCamera camera) {
        camera.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createEastLocator((PNode)node)));
        camera.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createWestLocator((PNode)node)));
        camera.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createNorthLocator((PNode)node)));
        camera.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createSouthLocator((PNode)node)));
        camera.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createNorthEastLocator((PNode)node)));
        camera.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createNorthWestLocator((PNode)node)));
        camera.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createSouthEastLocator((PNode)node)));
        camera.addChild((PNode)new PSWTBoundsHandle(PBoundsLocator.createSouthWestLocator((PNode)node)));
    }

    public static void removeBoundsHandlesFrom(PNode node) {
        ArrayList<PNode> handles = new ArrayList<PNode>();
        ListIterator i = node.getChildrenIterator();
        while (i.hasNext()) {
            PNode each = (PNode)i.next();
            if (!(each instanceof PSWTBoundsHandle)) continue;
            handles.add(each);
        }
        node.removeChildren(handles);
    }

    public PSWTBoundsHandle(PBoundsLocator locator) {
        super((PLocator)locator);
    }

    protected void installHandleEventHandlers() {
        super.installHandleEventHandlers();
        this.handleCursorHandler = new HandleCursorEventHandler();
        this.addInputEventListener((PInputEventListener)this.handleCursorHandler);
    }

    public PBasicInputEventHandler getHandleCursorEventHandler() {
        return this.handleCursorHandler;
    }

    public void startHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
        PBoundsLocator l = (PBoundsLocator)this.getLocator();
        l.getNode().startResizeBounds();
    }

    public void dragHandle(PDimension aLocalDimension, PInputEvent aEvent) {
        PBoundsLocator l = (PBoundsLocator)this.getLocator();
        PNode n = l.getNode();
        PBounds b = n.getBounds();
        PNode parent = this.getParent();
        if (parent != n && parent instanceof PCamera) {
            ((PCamera)parent).localToView((Dimension2D)aLocalDimension);
        }
        this.localToGlobal((Dimension2D)aLocalDimension);
        n.globalToLocal((Dimension2D)aLocalDimension);
        double dx = aLocalDimension.getWidth();
        double dy = aLocalDimension.getHeight();
        switch (l.getSide()) {
            case 1: {
                b.setRect(b.x, b.y + dy, b.width, b.height - dy);
                break;
            }
            case 5: {
                b.setRect(b.x, b.y, b.width, b.height + dy);
                break;
            }
            case 3: {
                b.setRect(b.x, b.y, b.width + dx, b.height);
                break;
            }
            case 7: {
                b.setRect(b.x + dx, b.y, b.width - dx, b.height);
                break;
            }
            case 8: {
                b.setRect(b.x + dx, b.y + dy, b.width - dx, b.height - dy);
                break;
            }
            case 6: {
                b.setRect(b.x + dx, b.y, b.width - dx, b.height + dy);
                break;
            }
            case 2: {
                b.setRect(b.x, b.y + dy, b.width + dx, b.height - dy);
                break;
            }
            case 4: {
                b.setRect(b.x, b.y, b.width + dx, b.height + dy);
                break;
            }
        }
        boolean flipX = false;
        boolean flipY = false;
        if (b.width < 0.0) {
            flipX = true;
            b.width = -b.width;
            b.x -= b.width;
        }
        if (b.height < 0.0) {
            flipY = true;
            b.height = -b.height;
            b.y -= b.height;
        }
        if (flipX || flipY) {
            this.flipSiblingBoundsHandles(flipX, flipY);
        }
        n.setBounds((Rectangle2D)b);
    }

    public void endHandleDrag(Point2D aLocalPoint, PInputEvent aEvent) {
        PBoundsLocator l = (PBoundsLocator)this.getLocator();
        l.getNode().endResizeBounds();
    }

    public void flipSiblingBoundsHandles(boolean flipX, boolean flipY) {
        ListIterator i = this.getParent().getChildrenIterator();
        while (i.hasNext()) {
            Object each = i.next();
            if (!(each instanceof PSWTBoundsHandle)) continue;
            ((PSWTBoundsHandle)((Object)each)).flipHandleIfNeeded(flipX, flipY);
        }
    }

    public void flipHandleIfNeeded(boolean flipX, boolean flipY) {
        if (!flipX && !flipY) {
            return;
        }
        PBoundsLocator l = (PBoundsLocator)this.getLocator();
        switch (l.getSide()) {
            case 1: {
                if (!flipY) break;
                l.setSide(5);
                break;
            }
            case 5: {
                if (!flipY) break;
                l.setSide(1);
                break;
            }
            case 3: {
                if (!flipX) break;
                l.setSide(7);
                break;
            }
            case 7: {
                if (!flipX) break;
                l.setSide(3);
                break;
            }
            case 8: {
                if (flipX && flipY) {
                    l.setSide(4);
                    break;
                }
                if (flipX) {
                    l.setSide(2);
                    break;
                }
                if (!flipY) break;
                l.setSide(6);
                break;
            }
            case 6: {
                if (flipX && flipY) {
                    l.setSide(2);
                    break;
                }
                if (flipX) {
                    l.setSide(4);
                    break;
                }
                if (!flipY) break;
                l.setSide(8);
                break;
            }
            case 2: {
                if (flipX && flipY) {
                    l.setSide(6);
                    break;
                }
                if (flipX) {
                    l.setSide(8);
                    break;
                }
                if (!flipY) break;
                l.setSide(4);
                break;
            }
            case 4: {
                if (flipX && flipY) {
                    l.setSide(8);
                    break;
                }
                if (flipX) {
                    l.setSide(6);
                    break;
                }
                if (!flipY) break;
                l.setSide(2);
                break;
            }
        }
        this.setLocator((PLocator)l);
    }

    public Cursor getCursorFor(int side) {
        switch (side) {
            case 1: {
                return new Cursor(8);
            }
            case 5: {
                return new Cursor(9);
            }
            case 3: {
                return new Cursor(11);
            }
            case 7: {
                return new Cursor(10);
            }
            case 8: {
                return new Cursor(6);
            }
            case 6: {
                return new Cursor(4);
            }
            case 2: {
                return new Cursor(7);
            }
            case 4: {
                return new Cursor(5);
            }
        }
        return null;
    }

    private final class HandleCursorEventHandler
    extends PBasicInputEventHandler {
        boolean cursorPushed = false;

        private HandleCursorEventHandler() {
        }

        public void mouseEntered(PInputEvent aEvent) {
            if (!this.cursorPushed) {
                aEvent.pushCursor(PSWTBoundsHandle.this.getCursorFor(((PBoundsLocator)PSWTBoundsHandle.this.getLocator()).getSide()));
                this.cursorPushed = true;
            }
        }

        public void mouseExited(PInputEvent aEvent) {
            PPickPath focus = aEvent.getInputManager().getMouseFocus();
            if (this.cursorPushed && this.isNewFocus(focus)) {
                aEvent.popCursor();
                this.cursorPushed = false;
            }
        }

        private boolean isNewFocus(PPickPath focus) {
            return focus == null || focus.getPickedNode() != PSWTBoundsHandle.this;
        }

        public void mouseReleased(PInputEvent event) {
            if (this.cursorPushed) {
                event.popCursor();
                this.cursorPushed = false;
            }
        }
    }
}

