package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachGadInstanceMember invokes the rds.DetachGadInstanceMember API synchronously
func (client *Client) DetachGadInstanceMember(request *DetachGadInstanceMemberRequest) (response *DetachGadInstanceMemberResponse, err error) {
	response = CreateDetachGadInstanceMemberResponse()
	err = client.DoAction(request, response)
	return
}

// DetachGadInstanceMemberWithChan invokes the rds.DetachGadInstanceMember API asynchronously
func (client *Client) DetachGadInstanceMemberWithChan(request *DetachGadInstanceMemberRequest) (<-chan *DetachGadInstanceMemberResponse, <-chan error) {
	responseChan := make(chan *DetachGadInstanceMemberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachGadInstanceMember(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachGadInstanceMemberWithCallback invokes the rds.DetachGadInstanceMember API asynchronously
func (client *Client) DetachGadInstanceMemberWithCallback(request *DetachGadInstanceMemberRequest, callback func(response *DetachGadInstanceMemberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachGadInstanceMemberResponse
		var err error
		defer close(result)
		response, err = client.DetachGadInstanceMember(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachGadInstanceMemberRequest is the request struct for api DetachGadInstanceMember
type DetachGadInstanceMemberRequest struct {
	*requests.RpcRequest
	MemberInstanceName string `position:"Query" name:"MemberInstanceName"`
	GadInstanceName    string `position:"Query" name:"GadInstanceName"`
}

// DetachGadInstanceMemberResponse is the response struct for api DetachGadInstanceMember
type DetachGadInstanceMemberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachGadInstanceMemberRequest creates a request to invoke DetachGadInstanceMember API
func CreateDetachGadInstanceMemberRequest() (request *DetachGadInstanceMemberRequest) {
	request = &DetachGadInstanceMemberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DetachGadInstanceMember", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetachGadInstanceMemberResponse creates a response to parse from DetachGadInstanceMember response
func CreateDetachGadInstanceMemberResponse() (response *DetachGadInstanceMemberResponse) {
	response = &DetachGadInstanceMemberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
