[manpage_begin math::figurate n 1.1]
[keywords {figurate numbers}]
[keywords mathematics]
[moddesc {Tcl Math Library}]
[titledesc {Evaluate figurate numbers}]
[category  Mathematics]
[require Tcl "8.6 9"]
[require math::figurate 1.0]
[description]
[para]

Sums of numbers that follow a particular pattern are called figurate numbers.
A simple example is the sum of integers 1, 2, ... up to n. You can arrange
1, 1+2=3, 1+2+3=6, ... objects in a triangle, hence the name triangular
numbers:
[example {
       *
       *  *
       *  *  *
       *  *  *  *
       ...
}]

The [package math::figurate] package consists of a collection of procedures to
evaluate a wide variety of figurate numbers. While all formulae are
straightforward, the details are sometimes puzzling.

[emph Note:] The procedures consider arguments lower than zero as to mean "no objects to be counted"
and therefore return 0.

[section "PROCEDURES"]
The procedures can be arranged in a few categories: sums of integers raised to a
particular power, sums of odd integers and general figurate numbers, for
instance the pentagonal numbers.

[list_begin definitions]

[call [cmd ::math::figurate::sum_sequence] [arg n]]
Return the sum of integers 1, 2, ..., n.

[list_begin arguments]
[arg_def int n] Highest integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_squares] [arg n]]
Return the sum of squares 1**2, 2**2, ..., n**2.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_cubes] [arg n]]
Return the sum of cubes 1**3, 2**3, ..., n**3.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_4th_power] [arg n]]
Return the sum of 4th powers 1**4, 2**4, ..., n**4.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_5th_power] [arg n]]
Return the sum of 5th powers 1**5, 2**5, ..., n**5.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_6th_power] [arg n]]
Return the sum of 6th powers 1**6, 2**6, ..., n**6.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_7th_power] [arg n]]
Return the sum of 7th powers 1**7, 2**7, ..., n**7.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]

[call [cmd ::math::figurate::sum_8th_power] [arg n]]
Return the sum of 8th powers 1**8, 2**8, ..., n**8.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_9th_power] [arg n]]
Return the sum of 9th powers 1**9, 2**9, ..., n**9.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_10th_power] [arg n]]
Return the sum of 10th powers 1**10, 2**10, ..., n**10.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]


[call [cmd ::math::figurate::sum_sequence_odd] [arg n]]
Return the sum of odd integers 1, 3, ..., 2n-1

[list_begin arguments]
[arg_def int n] Highest integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_squares_odd] [arg n]]
Return the sum of odd squares 1**2, 3**2, ..., (2n-1)**2.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_cubes_odd] [arg n]]
Return the sum of odd cubes 1**3, 3**3, ..., (2n-1)**3.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_4th_power_odd] [arg n]]
Return the sum of odd 4th powers 1**4, 2**4, ..., (2n-1)**4.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_5th_power_odd] [arg n]]
Return the sum of odd 5th powers 1**5, 2**5, ..., (2n-1)**5.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_6th_power_odd] [arg n]]
Return the sum of odd 6th powers 1**6, 2**6, ..., (2n-1)**6.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_7th_power_odd] [arg n]]
Return the sum of odd 7th powers 1**7, 2**7, ..., (2n-1)**7.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]

[call [cmd ::math::figurate::sum_8th_power_odd] [arg n]]
Return the sum of odd 8th powers 1**8, 2**8, ..., (2n-1)**8.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_9th_power_odd] [arg n]]
Return the sum of odd 9th powers 1**9, 2**9, ..., (2n-1)**9.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]

[call [cmd ::math::figurate::sum_10th_power_odd] [arg n]]
Return the sum of odd 10th powers 1**10, 2**10, ..., (2n-1)**10.

[list_begin arguments]
[arg_def int n] Highest base integer in the sum
[list_end]
[para]


[call [cmd ::math::figurate::oblong] [arg n]]
Return the nth oblong number (twice the nth triangular number)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::pronic] [arg n]]
Return the nth pronic number (synonym for oblong)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::triangular] [arg n]]
Return the nth triangular number

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::square] [arg n]]
Return the nth square number

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::cubic] [arg n]]
Return the nth cubic number

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::biquadratic] [arg n]]
Return the nth biquaratic number (i.e. n**4)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::centeredTriangular] [arg n]]
Return the nth centered triangular number (items arranged in concentric
squares)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::centeredSquare] [arg n]]
Return the nth centered square number (items arranged in concentric squares)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::centeredPentagonal] [arg n]]
Return the nth centered pentagonal number (items arranged in concentric
pentagons)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::centeredHexagonal] [arg n]]
Return the nth centered hexagonal number (items arranged in concentric
hexagons)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::centeredCube] [arg n]]
Return the nth centered cube number (items arranged in concentric
cubes)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::decagonal] [arg n]]
Return the nth decagonal number (items arranged in decagons with one common
vertex)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::heptagonal] [arg n]]
Return the nth heptagonal number (items arranged in heptagons with one
common vertex)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::hexagonal] [arg n]]
Return the nth hexagonal number (items arranged in hexagons with one
common vertex)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::octagonal] [arg n]]
Return the nth octagonal number (items arranged in octagons with one
common vertex)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::octahedral] [arg n]]
Return the nth octahedral number (items arranged in octahedrons with a
common centre)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::pentagonal] [arg n]]
Return the nth pentagonal number (items arranged in pentagons with one
common vertex)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::squarePyramidral] [arg n]]
Return the nth square pyramidral number (items arranged in a square pyramid)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::tetrahedral] [arg n]]
Return the nth tetrahedral number (items arranged in a triangular pyramid)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[call [cmd ::math::figurate::pentatope] [arg n]]
Return the nth pentatope number (items arranged in the four-dimensional analogue
of a triangular pyramid)

[list_begin arguments]
[arg_def int n] Required index
[list_end]
[para]

[list_end]

[vset CATEGORY {math :: figurate}]
[include ../common-text/feedback.inc]
[manpage_end]
