/*
 * VRT RULES
 *
 * Copyright (C) 2014-2022 Cisco and/or its affiliates. All rights reserved.
 * Copyright (C) 2005-2013 Sourcefire, Inc.
 *
 * This file is autogenerated via rules2c, by Brian Caswell <bmc@sourcefire.com>
 */


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"


/* declare detection functions */
int rule2486eval(void *p);

/* declare rule data structures */
/* precompile the stuff that needs pre-compiled */
// content:"|05|", offset 16, depth 1;
static ContentInfo rule2486content0 =
{
    (u_int8_t *)("|05|"), /* pattern (now in snort content format) */
    1, /* depth */
    16, /* offset */
    CONTENT_BUF_NORMALIZED, /* flags */ // XXX - need to add CONTENT_FAST_PATTERN support
    NULL, /* holder for boyer/moore PTR */
    NULL, /* more holder info - byteform */
    0, /* byteform length */
    0, /* increment length*/
    0,                      /* holder for fp offset */
    0,                      /* holder for fp length */
    0,                      /* holder for fp only */
    NULL, // offset_refId
    NULL, // depth_refId
    NULL, // offset_location
    NULL  // depth_location
};

static RuleOption rule2486option0 =
{
    OPTION_TYPE_CONTENT,
    { &rule2486content0 }
};
/* byte_test:size 2, value 4, operator >, offset 30; */
static ByteData rule2486byte_test1 =
{
    2, /* size */
    CHECK_GT, /* operator */
    4, /* value */
    30, /* offset */
    0, /*multiplier */
    BYTE_BIG_ENDIAN|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    0, /* post offset */
    NULL, // offset_refId
    NULL, // value_refId
    NULL, // offset_location
    NULL  // value_location
};

static RuleOption rule2486option1 =
{
    OPTION_TYPE_BYTE_TEST,
    { &rule2486byte_test1 }
};
/* byte_test:size 2, value 8, operator <, offset 30; */
static ByteData rule2486byte_test2 =
{
    2, /* size */
    CHECK_LT, /* operator */
    8, /* value */
    30, /* offset */
    0, /*multiplier */
    BYTE_BIG_ENDIAN|CONTENT_BUF_NORMALIZED|EXTRACT_AS_BYTE, /* flags */
    0, /* post offset */
    NULL, // offset_refId
    NULL, // value_refId
    NULL, // offset_location
    NULL  // value_location
};

static RuleOption rule2486option2 =
{
    OPTION_TYPE_BYTE_TEST,
    { &rule2486byte_test2 }
};

/* references for sid 2486 */
/* reference: bugtraq "10004"; */
static RuleReference rule2486ref1 =
{
    "bugtraq", /* type */
    "10004" /* value */
};

/* reference: cve "2004-0184"; */
static RuleReference rule2486ref2 =
{
    "cve", /* type */
    "2004-0184" /* value */
};

static RuleReference *rule2486refs[] =
{
    &rule2486ref1,
    &rule2486ref2,
    NULL
};
RuleOption *rule2486options[] =
{
    &rule2486option0,
    &rule2486option1,
    &rule2486option2,
    NULL
};

Rule rule2486 = {

   /* rule header, akin to => tcp any any -> any any               */{
       IPPROTO_UDP, /* proto */
       "$EXTERNAL_NET", /* SRCIP     */
       "any", /* SRCPORT   */
       1, /* DIRECTION */
       "$HOME_NET", /* DSTIP     */
       "500", /* DSTPORT   */
   },
   /* metadata */
   {
       3,  /* genid (HARDCODED!!!) */
       2486, /* sigid */
       5, /* revision */

       "attempted-dos", /* classification */
       0,  /* hardcoded priority XXX NOT PROVIDED BY GRAMMAR YET! */
       "DOS ISAKMP invalid identification payload attempt",     /* message */
       rule2486refs, /* ptr to references */
       NULL /* Meta data */
   },
   rule2486options, /* ptr to rule options */
   NULL, // &rule2486eval, /* use the built in detection function */
   0, /* am I initialized yet? */
   0,                                  /* Rule option count, used internally */
   0,                                  /* Flag with no alert, used internally */
   NULL /* ptr to internal data... setup during rule registration */
};


/* detection functions */
int rule2486eval(void *p) {
    //const u_int8_t *cursor_uri = 0;
    //const u_int8_t *cursor_raw = 0;
    const u_int8_t *cursor_normal = 0;


    // content:"|05|", offset 16, depth 1;
    if (contentMatch(p, rule2486options[0]->option_u.content, &cursor_normal) > 0) {
        // byte_test:size 2, value 4, operator >, offset 30;
        if (byteTest(p, rule2486options[1]->option_u.byte, cursor_normal) > 0) {
            // byte_test:size 2, value 8, operator <, offset 30;
            if (byteTest(p, rule2486options[2]->option_u.byte, cursor_normal) > 0) {
                return RULE_MATCH;
            }
        }
    }
    return RULE_NOMATCH;
}

