#!/bin/awk
# bbou@ac-toulouse.fr
# 2007-11-03 11:55:28     
# conf/pam_parse.awk

# HELPERS

function join(thisarray,p,q)
{
	thisresult=""
	for (j=p;j<=q;j++)
	{
		if(j!=p)
			thisresult=thisresult " "
		thisresult=thisresult thisarray[j]
	}
	return thisresult
}

# insertions
function insert_before(i,n,thesecontrols,theseprogs,theseargs,thiscontrol,thisprog,thisarg)
{
	if(i>n-1)
	{
		return append(n,thesecontrols,theseprogs,theseargs,thiscontrol,thisprog,thisarg)
	}
	for (j=n-1;j>=i;j--)
	{
		thesecontrols[j+1]=thesecontrols[j]
		theseprogs[j+1]=theseprogs[j]
		theseargs[j+1]=theseargs[j]
	}
	thesecontrols[i]=thiscontrol
	theseprogs[i]=thisprog
	theseargs[i]=thisarg
	return n+1;
}

function insert_after(i,n,thesecontrols,theseprogs,theseargs,thiscontrol,thisprog,thisarg)
{
	return insert_before(i+1,n,thesecontrols,theseprogs,theseargs,thiscontrol,thisprog,thisarg);
}

function append(n,thesecontrols,theseprogs,theseargs,thiscontrol,thisprog,thisarg)
{
	thesecontrols[n]=thiscontrol
	theseprogs[n]=thisprog
	theseargs[n]=thisarg
	return n+1
}

function prepend(n,thesecontrols,theseprogs,theseargs,thiscontrol,thisprog,thisarg)
{
	return insert_before(0,n,thesecontrols,theseprogs,theseargs,thiscontrol,thisprog,thisarg);
}


# deletions
function remove(i,n,thesecontrols,theseprogs,theseargs)
{
	delete thesecontrols[i]
	delete theseprogs[i]
	delete theseargs[i]
	for (j=i;j<n-1;j++)
	{
		thesecontrols[j]=thesecontrols[j+1]
		theseprogs[j]=theseprogs[j+1]
		theseargs[j]=theseargs[j+1]
	}
	delete thesecontrols[n-1]
	delete theseprogs[n-1]
	delete theseargs[n-1]
	return n-1	
}

# searches
function search_for_first_service(n,theseprogs,thisprog)
{
	for (j=0;j<n;j++)
	{
		if(index(theseprogs[j],thisprog))
			return j
	}
	return -1;
}

function search_for_last_service(n,theseprogs,thisprog)
{
	result=-1
	for (j=0;j<n;j++)
	{
		if (! j in theseprogs)
			continue
		if(index(theseprogs[j],thisprog))
			result=j
	}
	return result;
}

function search_for_last_service_of(n,theseprogs,thesekeys)
{
	result=-1
	nk=split(thesekeys,thiskeyarray,FS)
	for (j=0;j<n;j++)
	{
		if (! j in theseprogs)
			continue
		found=0
		for(k=1;k<=nk;k++)
		{
			if(index(theseprogs[j],thiskeyarray[k])!=0)
			{
				found=1
				break
			}
		}
		if(found)
			result=j
	}
	return result;
}

function search_for_first_control(n,thesecontrols,thiscontrol)
{
	for (j=0;j<n;j++)
	{
		if (! j in theseprogs)
			continue
		if(index(thesecontrols[j],thiscontrol)!=0)
			return j
	}
	return -1;
}

# WINBIND

function do_add_winbind_before()
{
	do_add_winbind_auth_before()
	do_add_winbind_account_before()		
	do_add_winbind_password_before()		
}

function do_remove_winbind_before()
{
	do_remove_winbind_auth_before()
	do_remove_winbind_account_before()
	do_remove_winbind_password_before()		
}

function do_add_winbind_after()
{
	do_add_winbind_auth_after()
	do_add_winbind_account_after()		
	do_add_winbind_password_after()		
}

function do_remove_winbind_after()
{
	do_remove_winbind_auth_after()
	do_remove_winbind_account_after()
	do_remove_winbind_password_after()		
}

# auth

function do_add_winbind_auth_before()
{
	# search for first pam_unix
	i=search_for_first_service(the_auth_count,the_auth_progs,"pam_unix")
	if (i!=-1)
	{
		# add use_first_pass param to pam_unix
		if(!index(the_auth_args[i],"use_first_pass"))
		{
			the_auth_args[i]="use_first_pass " the_auth_args[i]
		}
		# insert before pam_unix
		the_auth_count=insert_before(i,the_auth_count,the_auth_controls,the_auth_progs,the_auth_args,"sufficient",libpath "pam_winbind.so","")
		return 1
	}
	return 0
}

function do_remove_winbind_auth_before()
{
	# search for first pam_winbind
	i=search_for_first_service(the_auth_count,the_auth_progs,"pam_winbind")
	if (i!=-1)
	{
		# remove use_first_pass in subsequent pam_unix
		if(i<the_auth_count-1)
		{
			j=i+1
			if(j in the_auth_progs && j in the_auth_args && index(the_auth_progs[j],"pam_unix") && index(the_auth_args[j],"use_first_pass"))
			{
				sub(/use_first_pass /,"", the_auth_args[j])
				sub(/use_first_pass/,"", the_auth_args[j])
			}
		}
		# remove pam_winbind line
		the_auth_count=remove(i,the_auth_count,the_auth_controls,the_auth_progs,the_auth_args)
		return 1
	}
	return 0
}

function do_add_winbind_auth_after()
{
	# search for first pam_unix
	i=search_for_first_service(the_auth_count,the_auth_progs,"pam_unix")
	if (i!=-1)
	{
		# change required to sufficient for pam_unix
		if(match(the_auth_controls[i],"required"))
		{
			the_auth_controls[i]="sufficient"
			
			# insert at tail not to alter semantics when fall-throughs occur
			the_auth_count=append(the_auth_count,the_auth_controls,the_auth_progs,the_auth_args,"required",libpath "pam_deny.so","")
		}
		# insert after pam_unix
		the_auth_count=insert_after(i,the_auth_count,the_auth_controls,the_auth_progs,the_auth_args,"sufficient",libpath "pam_winbind.so","use_first_pass")

		return 1
	}
	return 0
}

function do_remove_winbind_auth_after()
{
	# search for first pam_winbind
	i=search_for_first_service(the_auth_count,the_auth_progs,"pam_winbind")
	if (i!=-1)
	{
		# no way of knowing if required was toggled to sufficient

		# remove pam_winbind line
		the_auth_count=remove(i,the_auth_count,the_auth_controls,the_auth_progs,the_auth_args)
		return 1
	}
	return 0
}

# account

function do_add_winbind_account_before()
{
	# search for first pam_unix
	i=search_for_first_service(the_account_count,the_account_progs,"pam_unix")
	if (i!=-1)
	{
		# insert before first pam_unix
		the_account_count=insert_before(i,the_account_count,the_account_controls,the_account_progs,the_account_args,"sufficient",libpath "pam_winbind.so","")
		return 1
	}
	return 0
}

function do_remove_winbind_account_before()
{
	# search for first pam_winbind
	i=search_for_first_service(the_account_count,the_account_progs,"pam_winbind")
	if (i!=-1)
	{
		# remove pam_winbind line
		the_account_count=remove(i,the_account_count,the_account_controls,the_account_progs,the_account_args)
		return 1
	}
	return 0
}

function do_add_winbind_account_after()
{
	# search for first pam_succeed_if
	i=search_for_first_service(the_account_count,the_account_progs,"pam_succeed_if")
	if (i==-1)
	{
		# search for first pam_unix
		i=search_for_first_service(the_account_count,the_account_progs,"pam_unix")
	}
	if (i!=-1)
	{
		# change required to sufficient for pam_succeed_if or pam_unix
		if(match(the_account_controls[i],"required"))
		{
			the_account_controls[i]="sufficient"
			
			# insert at tail not to alter semantics when fall-throughs occur
			the_account_count=append(the_account_count,the_account_controls,the_account_progs,the_account_args,"required",libpath "pam_permit.so","")
		}
		# insert after first pam_succeed_if or pam_unix
		the_account_count=insert_after(i,the_account_count,the_account_controls,the_account_progs,the_account_args,"[default=bad success=ok user_unknown=ignore]",libpath "pam_winbind.so","")
		return 1
	}
	return 0
}

function do_remove_winbind_account_after()
{
	# search for first pam_winbind
	i=search_for_first_service(the_account_count,the_account_progs,"pam_winbind")
	if (i!=-1)
	{
		# no way of knowing if required was toggled to sufficient

		# remove pam_winbind line
		the_account_count=remove(i,the_account_count,the_account_controls,the_account_progs,the_account_args)
		return 1 
	}
	return 0
}

# password

function do_add_winbind_password_before()
{
	# search for first pam_unix
	i=search_for_first_service(the_password_count,the_password_progs,"pam_unix")
	if (i!=-1)
	{
		# add use_first_pass param to pam_unix
		if(index(the_password_args[i],"use_first_pass")==0)
		{
			the_password_args[i]="use_first_pass " the_password_args[i]
		}
		# insert before first pam_unix
		the_password_count=insert_before(i,the_password_count,the_password_controls,the_password_progs,the_password_args,"sufficient",libpath "pam_winbind.so","use_authtok")
		return 1
	}
	return 0
}

function do_remove_winbind_password_before()
{
	# search for first pam_winbind
	i=search_for_first_service(the_password_count,the_password_progs,"pam_winbind")
	if (i!=-1)
	{
		# remove use_first_pass in subsequent pam_unix
		if(i<the_password_count-1)
		{
			if(index(the_password_progs[i+1],"pam_unix") && index(the_password_args[i+1],"use_first_pass"))
			{
				sub(/use_first_pass /,"", the_password_args[i+1])
				sub(/use_first_pass/,"", the_password_args[i+1])
			}
		}
		# remove pam_winbind line
		the_password_count=remove(i,the_password_count,the_password_controls,the_password_progs,the_password_args)
		return 1
	}
	return 0
}

function do_add_winbind_password_after()
{
	# search for first pam_unix
	i=search_for_first_service(the_password_count,the_password_progs,"pam_unix")
	if (i!=-1)
	{
		# change required to sufficient for pam_unix
		if(match(the_password_controls[i],"required"))
		{
			the_password_controls[i]="sufficient"
			
			# insert at tail not to alter semantics when fall-throughs occur
			the_password_count=append(the_password_count,the_password_controls,the_password_progs,the_password_args,"required",libpath "pam_deny.so","")
		}
		# insert after first pam_unix
		the_password_count=insert_after(i,the_password_count,the_password_controls,the_password_progs,the_password_args,"sufficient",libpath "pam_winbind.so","use_authtok")
		return 1
	}
	return 0
}

function do_remove_winbind_password_after()
{
	# search for first pam_winbind
	i=search_for_first_service(the_password_count,the_password_progs,"pam_winbind")
	if (i!=-1)
	{
		# no way of knowing if required was toggled to sufficient

		# remove pam_winbind line
		the_password_count=remove(i,the_password_count,the_password_controls,the_password_progs,the_password_args)
		return 1
	}
	return 0
}


# MOUNT

function do_add_pammount()
{
	do_add_pammount_auth()
	do_add_pammount_session()		
}

function do_remove_pammount()
{
	do_remove_pammount_auth()
	do_remove_pammount_session()
}

function do_add_pammount_auth()
{
	# search for first sufficient or default to 0
	i=search_for_first_control(the_auth_count,the_auth_controls,"sufficient")
	if(i==-1)
		i=0
	# insert before
	the_auth_count=insert_before(i,the_auth_count,the_auth_controls,the_auth_progs,the_auth_args,"required",libpath "pam_mount.so","")

	# add use_first_pass param to subsequent entries except for pam_deny
	for(++i;i<the_auth_count;i++)
	{
		if(index(the_auth_progs[i],"pam_deny")!=0)
			continue
		if(index(the_auth_args[i],"use_first_pass")!=0)
			continue
		the_auth_args[i]="use_first_pass " the_auth_args[i]
	}
	return 1
}

function do_remove_pammount_auth()
{
	# search for first pam_mount
	i=search_for_first_service(the_auth_count,the_auth_progs,"pam_mount")
	if (i!=-1)
	{
		# first subsequent use_first_pass
		for(j=i;j<the_auth_count;j++)
		{
			if(j in the_auth_args && index(the_auth_args[j],"use_first_pass")!=0)
			{
				sub(/use_first_pass /,"", the_auth_args[j])
				sub(/use_first_pass/,"", the_auth_args[j])
				break
			}
		}
		# remove pam_mount line
		the_auth_count=remove(i,the_auth_count,the_auth_controls,the_auth_progs,the_auth_args)
		return 1
	}
	return 0
}

function do_add_pammount_session()
{
	# append pam_mount
	the_session_count=append(the_session_count,the_session_controls,the_session_progs,the_session_args,"optional",libpath "pam_mount.so","")
}

function do_remove_pammount_session()
{
	# search for first pam_mount
	i=search_for_first_service(the_session_count,the_session_progs,"pam_mount")
	if(i!=-1)
	{
		# remove pam_mount line
		the_session_count=remove(i,the_session_count,the_session_controls,the_session_progs,the_session_args)
		return 1
	}
	return 0
}

# MKHOMEDIR

function do_add_pammkhomedir()
{
	do_add_pammkhomedir_session()
}

function do_remove_pammkhomedir()
{
	do_remove_pammkhomedir_session()
}

function do_add_pammkhomedir_session()
{
	# prepend pam_mount
	the_session_count=prepend(the_session_count,the_session_controls,the_session_progs,the_session_args,"required",libpath "pam_mkhomedir.so","skel=/etc/skel/ umask=0022")
}

function do_remove_pammkhomedir_session()
{
	# search for first pam_mkhomedir
	i=search_for_first_service(the_session_count,the_session_progs,"pam_mkhomedir")
	if(i!=-1)
	{
		# remove pam_mkhomedir line
		the_session_count=remove(i,the_session_count,the_session_controls,the_session_progs,the_session_args)
		return 1
	}
	return 0
}

# OUTPUT

function do_output_auth()
{
	#print "# auth"
	for (i=0;i<the_auth_count;i++)
	{
		if (i in the_auth_controls && i in the_auth_progs)
			printf "auth %s %s %s\n",the_auth_controls[i],the_auth_progs[i],the_auth_args[i]
	}
}

function do_output_account()
{
	#print "# account"
	for (i=0;i<the_account_count;i++)
	{
		if (i in the_account_controls && i in the_account_progs)
			printf "account %s %s %s\n",the_account_controls[i],the_account_progs[i],the_account_args[i]
	}
}

function do_output_password()
{
	#print "# password"
	for (i=0;i<the_password_count;i++)
	{
		if (i in the_password_controls && i in the_password_progs)
			printf "password %s %s %s\n",the_password_controls[i],the_password_progs[i],the_password_args[i]
	}
}

function do_output_session()
{
	#print "# session"
	for (i=0;i<the_session_count;i++)
	{
		if (i in the_session_controls && i in the_session_progs)
			printf "session %s %s %s\n",the_session_controls[i],the_session_progs[i],the_session_args[i]
	}
}

BEGIN \
{
	FS=" "; 
	the_auth_count=0
	the_account_count=0
	the_password_count=0
	the_session_count=0
}

{
	# skip comments
	if(match($0,"^#"))
		print $0
	else
	{

		# allow for new syntax
		sb=index($0,"[")
		sb2=index($0,"]")
		if(sb && sb2)
		{
			control=substr($0,sb,sb2-sb+1)
			gsub(/\[.*\]/,"[*]",$0)
		}
		else
			control=""

		# parse
		thisnfields=split($0,thesefields,FS)
		if(control!="")
			thesefields[2]=control

		if(match(thesefields[1],"auth"))
		{
			the_auth_controls[the_auth_count] = thesefields[2]
			the_auth_progs[the_auth_count] = thesefields[3]
			the_auth_args[the_auth_count] = join(thesefields,4,thisnfields)
			the_auth_count++
		}
		else if(match(thesefields[1],"account"))
		{
			the_account_controls[the_account_count] = thesefields[2]
			the_account_progs[the_account_count] = thesefields[3]
			the_account_args[the_account_count] = join(thesefields,4,thisnfields)
			the_account_count++
		}		
		else if(match(thesefields[1],"password"))
		{
			the_password_controls[the_password_count] = thesefields[2]
			the_password_progs[the_password_count] = thesefields[3]
			the_password_args[the_password_count] = join(thesefields,4,thisnfields)
			the_password_count++
		}		
		else if(match(thesefields[1],"session"))
		{
			the_session_controls[the_session_count] = thesefields[2]
			the_session_progs[the_session_count] = thesefields[3]
			the_session_args[the_session_count] = join(thesefields,4,thisnfields)
			the_session_count++
		}
	}		
}

END \
{
	if(add_pamwinbind)
		do_add_winbind_after()
	if(add_pammount)
		do_add_pammount()
	if(add_pammkhomedir)
		do_add_pammkhomedir()
	
	if(remove_pammkhomedir)
		do_remove_pammkhomedir()
	if(remove_pammount)
		do_remove_pammount()
	if(remove_pamwinbind)
		do_remove_winbind_after()

	if(output_all || output_auth)
		do_output_auth()
	if(output_all || output_account)
		do_output_account()
	if(output_all || output_password)
		do_output_password()
	if(output_all || output_session)
		do_output_session()
}
