# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class VerificationAttemptTestCase(IntegrationTestCase):

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.verify.v2.verification_attempts.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://verify.twilio.com/v2/Attempts',
        ))

    def test_list_verification_attempts_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "attempts": [],
                "meta": {
                    "key": "attempts",
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://verify.twilio.com/v2/Attempts?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://verify.twilio.com/v2/Attempts?PageSize=50&Page=0",
                    "next_page_url": null
                }
            }
            '''
        ))

        actual = self.client.verify.v2.verification_attempts.list()

        self.assertIsNotNone(actual)

    def test_list_verification_attempts_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "attempts": [
                    {
                        "sid": "VLaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "service_sid": "VAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "date_created": "2020-08-11T18:36:59Z",
                        "date_updated": "2020-08-11T18:37:00Z",
                        "conversion_status": "unconverted",
                        "channel": "sms",
                        "channel_data": {
                            "verification_sid": "VEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                            "to": "+573003003030",
                            "status": "unconfirmed",
                            "message_status": "undelivered",
                            "error_code": "30008",
                            "country": "CO",
                            "code_length": 6,
                            "locale": "es",
                            "mcc": "732",
                            "mnc": "103",
                            "carrier": "Colombia Movil (Tigo)"
                        },
                        "url": "https://verify.twilio.com/v2/Attempts/VLaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ],
                "meta": {
                    "key": "attempts",
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://verify.twilio.com/v2/Attempts?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://verify.twilio.com/v2/Attempts?PageSize=50&Page=0",
                    "next_page_url": null
                }
            }
            '''
        ))

        actual = self.client.verify.v2.verification_attempts.list()

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.verify.v2.verification_attempts("VLXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://verify.twilio.com/v2/Attempts/VLXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_verification_attempt_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "sid": "VLaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "service_sid": "VAaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2020-08-11T18:36:59Z",
                "date_updated": "2020-08-11T18:37:00Z",
                "conversion_status": "unconverted",
                "channel": "sms",
                "channel_data": {
                    "verification_sid": "VEaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                    "to": "+573003003030",
                    "status": "unconfirmed",
                    "message_status": "undelivered",
                    "error_code": "30008",
                    "country": "CO",
                    "code_length": 6,
                    "locale": "es",
                    "mcc": "732",
                    "mnc": "103",
                    "carrier": "Colombia Movil (Tigo)"
                },
                "url": "https://verify.twilio.com/v2/Attempts/VLaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.verify.v2.verification_attempts("VLXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)
