 ############################################################################
 #                                                                          #
 #                            CONFIG.PY                                     #
 #                                                                          #
 #           Copyright (C) 2008 - 2010 Ada Core Technologies, Inc.          #
 #                                                                          #
 # This program is free software: you can redistribute it and/or modify     #
 # it under the terms of the GNU General Public License as published by     #
 # the Free Software Foundation, either version 3 of the License, or        #
 # (at your option) any later version.                                      #
 #                                                                          #
 # This program is distributed in the hope that it will be useful,          #
 # but WITHOUT ANY WARRANTY; without even the implied warranty of           #
 # MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            #
 # GNU General Public License for more details.                             #
 #                                                                          #
 # You should have received a copy of the GNU General Public License        #
 # along with this program.  If not, see <http://www.gnu.org/licenses/>     #
 #                                                                          #
 ############################################################################

"""This file contains various configuration tables"""

cpu_info = {
    'alpha'     : {'endian' : 'little',  'bits' : 64},
    'arm'       : {'endian' : 'big',     'bits' : 32},
    'avr'       : {'endian' : 'little',  'bits' : 16},
    'erc32'     : {'endian' : 'big',     'bits' : 32},
    'hppa'      : {'endian' : 'big',     'bits' : 32},
    'ia64'      : {'endian' : 'little',  'bits' : 64},
    'leon'      : {'endian' : 'big',     'bits' : 32},
    'leon3'     : {'endian' : 'big',     'bits' : 32},
    'mips'      : {'endian' : 'big',     'bits' : 32},
    'powerpc'   : {'endian' : 'big',     'bits' : 32},
    'powerpc64' : {'endian' : 'big',     'bits' : 64},
    'sparc'     : {'endian' : 'big',     'bits' : 32},
    'sparc64'   : {'endian' : 'big',     'bits' : 64},
    'x86'       : {'endian' : 'little',  'bits' : 32},
    'x86_64'    : {'endian' : 'little',  'bits' : 64},
    'dotnetvm'  : {'endian' : 'unknown', 'bits' : 0},
    'jvm'       : {'endian' : 'unknown', 'bits' : 32}
}

os_info = {
    'aix'       : { 'is_bareboard' : False, 'version' : '5.2'    , 'exeext' : ''      , 'dllext' : '.so'},
    'darwin'    : { 'is_bareboard' : False, 'version' : '9.6.0'  , 'exeext' : ''      , 'dllext' : '.dylib'},
    'dotnet'    : { 'is_bareboard' : False, 'version' : '2.0'    , 'exeext' : '.exe'  , 'dllext' : '.dll'},
    'ElinOS'    : { 'is_bareboard' : False, 'version' : 'unknown', 'exeext' : ''      , 'dllext' : '.so'},
    'freebsd'   : { 'is_bareboard' : False, 'version' : 'unknown', 'exeext' : ''      , 'dllext' : '.so'},
    'openbsd'   : { 'is_bareboard' : False, 'version' : 'unknown', 'exeext' : ''      , 'dllext' : '.so'},
    'netbsd'    : { 'is_bareboard' : False, 'version' : 'unknown', 'exeext' : ''      , 'dllext' : '.so'},
    'dragonfly' : { 'is_bareboard' : False, 'version' : 'unknown', 'exeext' : ''      , 'dllext' : '.so'},
    'hp-ux'     : { 'is_bareboard' : False, 'version' : '11.00'  , 'exeext' : ''      , 'dllext' : '.sl'},
    'irix'      : { 'is_bareboard' : False, 'version' : '6.5'    , 'exeext' : ''      , 'dllext' : '.so'},
    'jvm'       : { 'is_bareboard' : False, 'version' : '1.5'    , 'exeext' : '.class', 'dllext' : '' },
    'linux'     : { 'is_bareboard' : False, 'version' : 'unknown', 'exeext' : ''      , 'dllext' : '.so'},
    'lynxos'    : { 'is_bareboard' : False, 'version' : 'unknown', 'exeext' : ''      , 'dllext' : '.so'},
    'nucleus'   : { 'is_bareboard' : False, 'version' : 'unknown', 'exeext' : ''      , 'dllext' : '.so'},
    'solaris'   : { 'is_bareboard' : False, 'version' : '2.8'    , 'exeext' : ''      , 'dllext' : '.so'},
    'tru64'     : { 'is_bareboard' : False, 'version' : '5.1'    , 'exeext' : ''      , 'dllext' : '.so'},
    'vms'       : { 'is_bareboard' : False, 'version' : 'unknown', 'exeext' : ''      , 'dllext' : ''},
    'vxworks'   : { 'is_bareboard' : False, 'version' : '5.5'    , 'exeext' : '.out'  , 'dllext' : ''},
    'vxworks6'  : { 'is_bareboard' : False, 'version' : '6.4'    , 'exeext' : '.out'  , 'dllext' : ''},
    'vxworksae' : { 'is_bareboard' : False, 'version' : '1.8'    , 'exeext' : '.out'  , 'dllext' : ''},
    'vxworksmils' : { 'is_bareboard' : False, 'version' : '2.0.1'    , 'exeext' : '.out', 'dllext' : ''},
    'windows'   : { 'is_bareboard' : False, 'version' : 'XP'     , 'exeext' : '.exe'  , 'dllext' : '.dll'},
    'wrslinux'  : { 'is_bareboard' : False, 'version' : 'unknown', 'exeext' : ''      , 'dllext' : '.so'},
    'none'      : { 'is_bareboard' : True,  'version' : 'unknown', 'exeext' : ''      , 'dllext' : ''}
}

platform_info = {
    'alpha-tru64'        : { 'cpu'    : 'alpha',   'os'     : 'tru64',    'is_hie' : False},
    'avr-elf'            : { 'cpu'    : 'avr',     'os'     : 'none',     'is_hie' : False},
    'arm-nucleus'        : { 'cpu'    : 'arm',     'os'     : 'nucleus',  'is_hie' : False},
    'dotnet'             : { 'cpu'    : 'dotnetvm','os'     : 'dotnet',   'is_hie' : False},
    'e500v2-vx6'         : { 'cpu'    : 'powerpc', 'os'     : 'vxworks6', 'is_hie' : False},
    'e500v2-vx653'       : { 'cpu'    : 'powerpc', 'os'     : 'vxworksae', 'is_hie' : False},
    'erc32-elf'          : { 'cpu'    : 'erc32',   'os'     : 'none',     'is_hie' : False},
    'ia64-hpux'          : { 'cpu'    : 'ia64',    'os'     : 'hp-ux',    'is_hie' : False},
    'ia64-openvms'       : { 'cpu'    : 'ia64',    'os'     : 'vms',      'is_hie' : False},
    'ia64-linux'         : { 'cpu'    : 'ia64',    'os'     : 'linux',    'is_hie' : False},
    'jvm'                : { 'cpu'    : 'jvm',     'os'     : 'jvm',      'is_hie' : False},
    'leon-elf'           : { 'cpu'    : 'leon',    'os'     : 'none',     'is_hie' : False},
    'leon3-elf'          : { 'cpu'    : 'leon3',   'os'     : 'none',     'is_hie' : False},
    'alpha-openvms'      : { 'cpu'    : 'alpha',   'os'     : 'vms',      'is_hie' : False},
    'mips-irix'          : { 'cpu'    : 'mips',    'os'     : 'irix',     'is_hie' : False},
    'p55-elf'            : { 'cpu'    : 'powerpc', 'os'     : 'none',     'is_hie' : False},
    'pa-hpux'            : { 'cpu'    : 'hppa',    'os'     : 'hp-ux',    'is_hie' : False},
    'ppc-aix'            : { 'cpu'    : 'powerpc', 'os'     : 'aix',      'is_hie' : False},
    'ppc-elf'            : { 'cpu'    : 'powerpc', 'os'     : 'none',     'is_hie' : False},
    'ppc-elinos'         : { 'cpu'    : 'powerpc', 'os'     : 'ElinOS',   'is_hie' : False},
    'ppc-linux'          : { 'cpu'    : 'powerpc', 'os'     : 'linux',    'is_hie' : False},
    'ppc-lynx'           : { 'cpu'    : 'powerpc', 'os'     : 'lynxos',   'is_hie' : False},
    'ppc-lynx5'          : { 'cpu'    : 'powerpc', 'os'     : 'lynxos',   'is_hie' : False},
    'ppc-vx178b'         : { 'cpu'    : 'powerpc', 'os'     : 'vxworks',  'is_hie' : False},
    'ppc-vx6'            : { 'cpu'    : 'powerpc', 'os'     : 'vxworks6', 'is_hie' : False},
    'ppc-vxmils'         : { 'cpu'    : 'powerpc', 'os'     : 'vxworksmils','is_hie' : False},
    'ppc-vx653'          : { 'cpu'    : 'powerpc', 'os'     : 'vxworksae','is_hie' : False},
    'ppc-vx6cert'        : { 'cpu'    : 'powerpc', 'os'     : 'vxworks6', 'is_hie' : False},
    'ppc-vxw'            : { 'cpu'    : 'powerpc', 'os'     : 'vxworks',  'is_hie' : False},
    'ppc-wrslinux'       : { 'cpu'    : 'powerpc', 'os'     : 'wrslinux', 'is_hie' : False},
    'sparc64-solaris'    : { 'cpu'    : 'sparc64', 'os'     : 'solaris',  'is_hie' : False},
    'sparc-elf'          : { 'cpu'    : 'sparc',   'os'     : 'none',     'is_hie' : False},
    'sparc-solaris'      : { 'cpu'    : 'sparc',   'os'     : 'solaris',  'is_hie' : False},
    'x86_64-linux'       : { 'cpu'    : 'x86_64',  'os'     : 'linux',    'is_hie' : False},
    'x86-darwin'         : { 'cpu'    : 'x86',     'os'     : 'darwin',   'is_hie' : False},
    'x86_64-darwin'      : { 'cpu'    : 'x86_64',  'os'     : 'darwin',   'is_hie' : False},
    'x86-elinos'         : { 'cpu'    : 'x86',     'os'     : 'ElinOS',   'is_hie' : False},
    'x86-freebsd'        : { 'cpu'    : 'x86',     'os'     : 'freebsd',  'is_hie' : False},
    'x86-openbsd'        : { 'cpu'    : 'x86',     'os'     : 'openbsd',  'is_hie' : False},
    'x86-netbsd'         : { 'cpu'    : 'x86',     'os'     : 'netbsd',   'is_hie' : False},
    'x86-dragonfly'      : { 'cpu'    : 'x86',     'os'     : 'dragonfly','is_hie' : False},
    'x86_64-freebsd'     : { 'cpu'    : 'x86_64',  'os'     : 'freebsd',  'is_hie' : False},
    'x86_64-openbsd'     : { 'cpu'    : 'x86_64',  'os'     : 'openbsd',  'is_hie' : False},
    'x86_64-netbsd'      : { 'cpu'    : 'x86_64',  'os'     : 'netbsd',   'is_hie' : False},
    'x86_64-dragonfly'   : { 'cpu'    : 'x86_64',  'os'     : 'dragonfly','is_hie' : False},
    'x86-linux'          : { 'cpu'    : 'x86',     'os'     : 'linux',    'is_hie' : False},
    'x86-lynx'           : { 'cpu'    : 'x86',     'os'     : 'lynxos',   'is_hie' : False},
    'x86-lynx5'          : { 'cpu'    : 'x86',     'os'     : 'lynxos',   'is_hie' : False},
    'x86-rtx'            : { 'cpu'    : 'x86',     'os'     : 'solaris',  'is_hie' : False},
    'x86-solaris'        : { 'cpu'    : 'x86',     'os'     : 'solaris',  'is_hie' : False},
    'x86_64-solaris'     : { 'cpu'    : 'x86_64',  'os'     : 'solaris',  'is_hie' : False},
    'x86-vx6'            : { 'cpu'    : 'x86',     'os'     : 'vxworks6', 'is_hie' : False},
    'x86-vx653'          : { 'cpu'    : 'x86',     'os'     : 'vxworksae','is_hie' : False},
    'x86-windows'        : { 'cpu'    : 'x86',     'os'     : 'windows',  'is_hie' : False},
    'x86-wrslinux'       : { 'cpu'    : 'x86',     'os'     : 'wrslinux', 'is_hie' : False},
    'x86_64-windows'     : { 'cpu'    : 'x86_64',  'os'     : 'windows',  'is_hie' : False},
    'mindstorms-nxt'     : { 'cpu'    : 'arm',     'os'     : 'none',     'is_hie' : False},
    }

build_targets = {
    'alpha-tru64'        : { 'name'        : 'alphaev56-dec-osf%(os_version)s'},
    'avr-elf'            : { 'name'        : 'avr'},
    'arm-nucleus'        : { 'name'        : 'arm-mentor-nucleus'},
    'dotnet'             : { 'name'        : 'dotnet'},
    'e500v2-vx6'         : { 'name'        : 'e500v2-wrs-vxworks'},
    'e500v2-vx653'       : { 'name'        : 'e500v2-wrs-vxworksae'},
    'erc32-elf'          : { 'name'        : 'erc32-elf'},
    'ia64-hpux'          : { 'name'        : 'ia64-hp-hpux%(os_version)s'},
    'ia64-openvms'       : { 'name'        : 'ia64-openvms'},
    'ia64-linux'         : { 'name'        : 'ia64-generic-linux-gnu'},
    'jvm'                : { 'name'        : 'jvm'},
    'leon-elf'           : { 'name'        : 'leon-elf'},
    'leon3-elf'          : { 'name'        : 'leon3-elf'},
    'alpha-openvms'      : { 'name'        : 'alpha-openvms'},
    'mips-irix'          : { 'name'        : 'mips-sgi-irix%(os_version)s'},
    'p55-elf'            : { 'name'        : 'powerpc-eabispe'},
    'pa-hpux'            : { 'name'        : 'hppa1.1-hp-hpux%(os_version)s'},
    'ppc-aix'            : { 'name'        : 'powerpc-ibm-aix%(os_version)s'},
    'ppc-elf'            : { 'name'        : 'powerpc-elf'},
    'ppc-elinos'         : { 'name'        : 'powerpc-elinos-linux'},
    'ppc-linux'          : { 'name'        : 'powerpc-generic-linux-gnu'},
    'ppc-lynx'           : { 'name'        : 'powerpc-elf-lynxos'},
    'ppc-lynx5'          : { 'name'        : 'powerpc-elf-lynxos5'},
    'ppc-vx178b'         : { 'name'        : 'powerpc-wrs-vxworks'},
    'ppc-vx6'            : { 'name'        : 'powerpc-wrs-vxworks'},
    'ppc-vx653'          : { 'name'        : 'powerpc-wrs-vxworksae'},
    'ppc-vxmils'         : { 'name'        : 'powerpc-wrs-vxworksmils'},
    'ppc-vx6cert'        : { 'name'        : 'powerpc-wrs-vxworks'},
    'ppc-vxw'            : { 'name'        : 'powerpc-wrs-vxworks'},
    'ppc-wrslinux'       : { 'name'        : 'powerpc-wrs-linux'},
    'sparc64-solaris'    : { 'name'        : 'sparc64-sun-solaris%(os_version)s'},
    'sparc-jgnat'        : { 'name'        : None},
    'sparc-elf'          : { 'name'        : 'sparc-elf'},
    'sparc-solaris'      : { 'name'        : 'sparc-sun-solaris%(os_version)s'},
    'x86_64-linux'       : { 'name'        : 'x86_64-pc-linux-gnu'},
    'x86-darwin'         : { 'name'        : 'i386-apple-darwin%(os_version)s'},
    'x86_64-darwin'      : { 'name'        : 'x86_64-apple-darwin%(os_version)s'},
    'x86-elinos'         : { 'name'        : 'i686-elinos-linux'},
    'x86-freebsd'        : { 'name'        : 'i386-pc-freebsd%(os_version)s'},
    'x86-openbsd'        : { 'name'        : 'i386-pc-openbsd%(os_version)s'},
    'x86-netbsd'         : { 'name'        : 'i386-pc-netbsd%(os_version)s'},
    'x86-dragonfly'      : { 'name'        : 'i386-pc-dragonfly%(os_version)s'},
    'x86_64-freebsd'     : { 'name'        : 'x86_64-pc-freebsd%(os_version)s'},
    'x86_64-openbsd'     : { 'name'        : 'x86_64-pc-openbsd%(os_version)s'},
    'x86_64-netbsd'      : { 'name'        : 'x86_64-pc-netbsd%(os_version)s'},
    'x86_64-dragonfly'   : { 'name'        : 'x86_64-pc-dragonfly%(os_version)s'},
    'x86-jgnat'          : { 'name'        : None},
    'x86-linux'          : { 'name'        : 'i686-pc-linux-gnu'},
    'x86-lynx'           : { 'name'        : ''},
    'x86-lynx5'          : { 'name'        : 'i386-elf-lynxos5'},
    'x86-rtx'            : { 'name'        : ''},
    'x86-solaris'        : { 'name'        : 'i686-pc-solaris%(os_version)s'},
    'x86_64-solaris'     : { 'name'        : 'x86_64-sun-solaris%(os_version)s'},
    'x86-vx6'            : { 'name'        : 'i586-wrs-vxworks'},
    'x86-vx653'          : { 'name'        : 'i586-wrs-vxworksae'},
    'x86-windows'        : { 'name'        : 'i686-pc-mingw32'},
    'x86-wrslinux'       : { 'name'        : 'i586-wrs-linux'},
    'x86_64-windows'     : { 'name'        : 'x86_64-pc-mingw32'},
    'mindstorms-nxt'     : { 'name'        : 'arm-eabi'},
    }

# The following table is used to guess a product name from the output of
# uname on the host. Users of this data are expected to match the specified
# regular expressions against that output to find a matching key. Order is
# not significant so if a traversal matches multiple entries the one matched
# is undefined. It is critical therefore that the supplied expressions match
# only the intended product and no other values of uname potentially output
# by a different host. IMPORTANT: Systems that can be only used as target in
# cross context should not be added to that table.

host_guess = {
    # platform : OS (uname[0]), machine (uname[1]), proc (uname[4 or 5])
    'ppc-aix'        : { 'os'      : 'AIX',       'machine' : None,                  'cpu'     : None},
    'ppc-darwin'     : { 'os'      : 'Darwin',    'machine' : None,                  'cpu'     : 'powerpc'},
    'x86-darwin'     : { 'os'      : 'Darwin',    'machine' : None,                  'cpu'     : 'i386'},
    'x86-freebsd'    : { 'os'      : 'FreeBSD',   'machine' : None,                  'cpu'     : None},
    'x86-openbsd'    : { 'os'      : 'OpenBSD',   'machine' : None,                  'cpu'     : None},
    'x86-netbsd'     : { 'os'      : 'NetBSD',    'machine' : None,                  'cpu'     : None},
    'x86-dragonfly'  : { 'os'      : 'DragonFly', 'machine' : None,                  'cpu'     : None},
    'x86_64-freebsd'   : { 'os'    : 'FreeBSD',   'machine' : None,                  'cpu'     : None},
    'x86_64-openbsd'   : { 'os'    : 'OpenBSD',   'machine' : None,                  'cpu'     : None},
    'x86_64-netbsd'    : { 'os'    : 'NetBSD',    'machine' : None,                  'cpu'     : None},
    'x86_64-dragonfly' : { 'os'    : 'DragonFly', 'machine' : None,                  'cpu'     : None},
    'ia64-hpux'      : { 'os'      : 'HP-UX',     'machine' : None,                  'cpu'     : 'ia64'},
    'pa-hpux'        : { 'os'      : 'HP-UX',     'machine' : None,                  'cpu'     : '9000/785'},
    'mips-irix'      : { 'os'      : 'IRIX64',    'machine' : None,                  'cpu'     : None},
    'x86-lynxos'     : { 'os'      : 'LynxOS',    'machine' : None,                  'cpu'     : None},
    'ia64-linux'     : { 'os'      : 'Linux',     'machine' : None,                  'cpu'     : 'ia64'},
    'ppc-linux'      : { 'os'      : 'Linux',     'machine' : None,                  'cpu'     : 'powerpc.*|ppc64'},
    'x86-linux'      : { 'os'      : 'Linux',     'machine' : None,                  'cpu'     : 'i.86|pentium'},
    'x86_64-linux'   : { 'os'      : 'Linux',     'machine' : None,                  'cpu'     : 'x86_64'},
    'sparc-solaris'  : { 'os'      : 'SunOS',     'machine' : None,                  'cpu'     : 'sparc'},
    'x86-solaris'    : { 'os'      : 'SunOS',     'machine' : None,                  'cpu'     : 'i386'},
    'alpha-tru64'    : { 'os'      : 'OSF1',      'machine' : None,                  'cpu'     : None},
    'x86-windows'    : { 'os'      : 'Windows',   'machine' : None,                  'cpu'     : None},
    'cygwin'         : { 'os'      : 'CYGWIN_NT', 'machine' : None,                  'cpu'     : None}
    }

host_aliases = {
    'cygwin' : 'x86-windows'
    }
