from fuzzconfig import FuzzConfig
import nonrouting
import pytrellis
import fuzzloops

jobs = [
    FuzzConfig(job="DCUCFG0", family="ECP5", device="LFE5UM5G-45F", ncl="empty.ncl",
                          tiles=["MIB_R71C42:DCU0", "MIB_R71C43:DCU1", "MIB_R71C44:DCU2", "MIB_R71C45:DCU3",
                                 "MIB_R71C46:DCU4", "MIB_R71C47:DCU5", "MIB_R71C48:DCU6", "MIB_R71C49:DCU7",
                                 "MIB_R71C50:DCU8"])
]

def tobinstr(x, size):
    return "0b" + "".join(reversed(["1" if x else "0" for x in  x]))

def tohexstr(x, size):
    res = 0
    for i in range(len(x)):
        if x[i]:
            res |= 1 << i
    return ("0x{{:0{}x}}".format((size + 3) // 4)).format(res)

def todecstr(x, size):
    res = 0
    for i in range(len(x)):
        if x[i]:
            res |= 1 << i
    return "0d{}".format(res)

def main():
    pytrellis.load_database("../../../database")

    def per_job(cfg):
        def get_substs(settings, mode="DCUA"):
            if mode == "NONE":
                comment = "//"
            else:
                comment = ""
            return dict(settings=",".join(["{}={}".format(k, v) for k, v in settings.items()]),
                        comment=comment)

        cfg.setup()
        empty_bitfile = cfg.build_design(cfg.ncl, {})
        cfg.ncl = "dcuconfig.ncl"

        nonrouting.fuzz_enum_setting(cfg, "DCU.MODE", ["NONE", "DCUA"],
                                     lambda x: get_substs(settings={}, mode=x), empty_bitfile, False)

        nonrouting.fuzz_word_setting(cfg, "DCU.D_MACROPDB", 1, lambda x: get_substs(settings={"D_MACROPDB": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_IB_PWDNB", 1, lambda x: get_substs(settings={"D_IB_PWDNB": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_XGE_MODE", 1, lambda x: get_substs(settings={"D_XGE_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_LOW_MARK", 4, lambda x: get_substs(settings={"D_LOW_MARK": todecstr(x, 4)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_HIGH_MARK", 4, lambda x: get_substs(settings={"D_HIGH_MARK": todecstr(x, 4)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_BUS8BIT_SEL", 1, lambda x: get_substs(settings={"D_BUS8BIT_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_CDR_LOL_SET", 2, lambda x: get_substs(settings={"D_CDR_LOL_SET": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_BITCLK_LOCAL_EN", 1, lambda x: get_substs(settings={"D_BITCLK_LOCAL_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_BITCLK_ND_EN", 1, lambda x: get_substs(settings={"D_BITCLK_ND_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_BITCLK_FROM_ND_EN", 1, lambda x: get_substs(settings={"D_BITCLK_FROM_ND_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_SYNC_LOCAL_EN", 1, lambda x: get_substs(settings={"D_SYNC_LOCAL_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_SYNC_ND_EN", 1, lambda x: get_substs(settings={"D_SYNC_ND_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_UC_MODE", 1, lambda x: get_substs(settings={"CH0_UC_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_UC_MODE", 1, lambda x: get_substs(settings={"CH1_UC_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_PCIE_MODE", 1, lambda x: get_substs(settings={"CH0_PCIE_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_PCIE_MODE", 1, lambda x: get_substs(settings={"CH1_PCIE_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RIO_MODE", 1, lambda x: get_substs(settings={"CH0_RIO_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RIO_MODE", 1, lambda x: get_substs(settings={"CH1_RIO_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_WA_MODE", 1, lambda x: get_substs(settings={"CH0_WA_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_WA_MODE", 1, lambda x: get_substs(settings={"CH1_WA_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_INVERT_RX", 1, lambda x: get_substs(settings={"CH0_INVERT_RX": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_INVERT_RX", 1, lambda x: get_substs(settings={"CH1_INVERT_RX": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_INVERT_TX", 1, lambda x: get_substs(settings={"CH0_INVERT_TX": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_INVERT_TX", 1, lambda x: get_substs(settings={"CH1_INVERT_TX": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_PRBS_SELECTION", 1, lambda x: get_substs(settings={"CH0_PRBS_SELECTION": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_PRBS_SELECTION", 1, lambda x: get_substs(settings={"CH1_PRBS_SELECTION": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_GE_AN_ENABLE", 1, lambda x: get_substs(settings={"CH0_GE_AN_ENABLE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_GE_AN_ENABLE", 1, lambda x: get_substs(settings={"CH1_GE_AN_ENABLE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_PRBS_LOCK", 1, lambda x: get_substs(settings={"CH0_PRBS_LOCK": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_PRBS_LOCK", 1, lambda x: get_substs(settings={"CH1_PRBS_LOCK": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_PRBS_ENABLE", 1, lambda x: get_substs(settings={"CH0_PRBS_ENABLE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_PRBS_ENABLE", 1, lambda x: get_substs(settings={"CH1_PRBS_ENABLE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_ENABLE_CG_ALIGN", 1, lambda x: get_substs(settings={"CH0_ENABLE_CG_ALIGN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_ENABLE_CG_ALIGN", 1, lambda x: get_substs(settings={"CH1_ENABLE_CG_ALIGN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TX_GEAR_MODE", 1, lambda x: get_substs(settings={"CH0_TX_GEAR_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TX_GEAR_MODE", 1, lambda x: get_substs(settings={"CH1_TX_GEAR_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RX_GEAR_MODE", 1, lambda x: get_substs(settings={"CH0_RX_GEAR_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RX_GEAR_MODE", 1, lambda x: get_substs(settings={"CH1_RX_GEAR_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_PCS_DET_TIME_SEL", 2, lambda x: get_substs(settings={"CH0_PCS_DET_TIME_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_PCS_DET_TIME_SEL", 2, lambda x: get_substs(settings={"CH1_PCS_DET_TIME_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_PCIE_EI_EN", 1, lambda x: get_substs(settings={"CH0_PCIE_EI_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_PCIE_EI_EN", 1, lambda x: get_substs(settings={"CH1_PCIE_EI_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TX_GEAR_BYPASS", 1, lambda x: get_substs(settings={"CH0_TX_GEAR_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TX_GEAR_BYPASS", 1, lambda x: get_substs(settings={"CH1_TX_GEAR_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_ENC_BYPASS", 1, lambda x: get_substs(settings={"CH0_ENC_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_ENC_BYPASS", 1, lambda x: get_substs(settings={"CH1_ENC_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_SB_BYPASS", 1, lambda x: get_substs(settings={"CH0_SB_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_SB_BYPASS", 1, lambda x: get_substs(settings={"CH1_SB_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RX_SB_BYPASS", 1, lambda x: get_substs(settings={"CH0_RX_SB_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RX_SB_BYPASS", 1, lambda x: get_substs(settings={"CH1_RX_SB_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_WA_BYPASS", 1, lambda x: get_substs(settings={"CH0_WA_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_WA_BYPASS", 1, lambda x: get_substs(settings={"CH1_WA_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DEC_BYPASS", 1, lambda x: get_substs(settings={"CH0_DEC_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DEC_BYPASS", 1, lambda x: get_substs(settings={"CH1_DEC_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_CTC_BYPASS", 1, lambda x: get_substs(settings={"CH0_CTC_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_CTC_BYPASS", 1, lambda x: get_substs(settings={"CH1_CTC_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RX_GEAR_BYPASS", 1, lambda x: get_substs(settings={"CH0_RX_GEAR_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RX_GEAR_BYPASS", 1, lambda x: get_substs(settings={"CH1_RX_GEAR_BYPASS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_LSM_DISABLE", 1, lambda x: get_substs(settings={"CH0_LSM_DISABLE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_LSM_DISABLE", 1, lambda x: get_substs(settings={"CH1_LSM_DISABLE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_MATCH_2_ENABLE", 1, lambda x: get_substs(settings={"CH0_MATCH_2_ENABLE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_MATCH_2_ENABLE", 1, lambda x: get_substs(settings={"CH1_MATCH_2_ENABLE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_MATCH_4_ENABLE", 1, lambda x: get_substs(settings={"CH0_MATCH_4_ENABLE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_MATCH_4_ENABLE", 1, lambda x: get_substs(settings={"CH1_MATCH_4_ENABLE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_MIN_IPG_CNT", 2, lambda x: get_substs(settings={"CH0_MIN_IPG_CNT": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_MIN_IPG_CNT", 2, lambda x: get_substs(settings={"CH1_MIN_IPG_CNT": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_CC_MATCH_1", 10, lambda x: get_substs(settings={"CH0_CC_MATCH_1": tohexstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_CC_MATCH_1", 10, lambda x: get_substs(settings={"CH1_CC_MATCH_1": tohexstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_CC_MATCH_2", 10, lambda x: get_substs(settings={"CH0_CC_MATCH_2": tohexstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_CC_MATCH_2", 10, lambda x: get_substs(settings={"CH1_CC_MATCH_2": tohexstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_CC_MATCH_3", 10, lambda x: get_substs(settings={"CH0_CC_MATCH_3": tohexstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_CC_MATCH_3", 10, lambda x: get_substs(settings={"CH1_CC_MATCH_3": tohexstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_CC_MATCH_4", 10, lambda x: get_substs(settings={"CH0_CC_MATCH_4": tohexstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_CC_MATCH_4", 10, lambda x: get_substs(settings={"CH1_CC_MATCH_4": tohexstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_UDF_COMMA_MASK", 10, lambda x: get_substs(settings={"CH0_UDF_COMMA_MASK": tohexstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_UDF_COMMA_MASK", 10, lambda x: get_substs(settings={"CH1_UDF_COMMA_MASK": tohexstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_UDF_COMMA_A", 10, lambda x: get_substs(settings={"CH0_UDF_COMMA_A": tohexstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_UDF_COMMA_A", 10, lambda x: get_substs(settings={"CH1_UDF_COMMA_A": tohexstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_UDF_COMMA_B", 10, lambda x: get_substs(settings={"CH0_UDF_COMMA_B": tohexstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_UDF_COMMA_B", 10, lambda x: get_substs(settings={"CH1_UDF_COMMA_B": tohexstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RX_DCO_CK_DIV", 3, lambda x: get_substs(settings={"CH0_RX_DCO_CK_DIV": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RX_DCO_CK_DIV", 3, lambda x: get_substs(settings={"CH1_RX_DCO_CK_DIV": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RCV_DCC_EN", 1, lambda x: get_substs(settings={"CH0_RCV_DCC_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RCV_DCC_EN", 1, lambda x: get_substs(settings={"CH1_RCV_DCC_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_REQ_LVL_SET", 2, lambda x: get_substs(settings={"CH0_REQ_LVL_SET": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_REQ_LVL_SET", 2, lambda x: get_substs(settings={"CH1_REQ_LVL_SET": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_REQ_EN", 1, lambda x: get_substs(settings={"CH0_REQ_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_REQ_EN", 1, lambda x: get_substs(settings={"CH1_REQ_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RTERM_RX", 5, lambda x: get_substs(settings={"CH0_RTERM_RX": todecstr(x, 5)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RTERM_RX", 5, lambda x: get_substs(settings={"CH1_RTERM_RX": todecstr(x, 5)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_PDEN_SEL", 1, lambda x: get_substs(settings={"CH0_PDEN_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_PDEN_SEL", 1, lambda x: get_substs(settings={"CH1_PDEN_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_LDR_RX2CORE_SEL", 1, lambda x: get_substs(settings={"CH0_LDR_RX2CORE_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_LDR_RX2CORE_SEL", 1, lambda x: get_substs(settings={"CH1_LDR_RX2CORE_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_LDR_CORE2TX_SEL", 1, lambda x: get_substs(settings={"CH0_LDR_CORE2TX_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_LDR_CORE2TX_SEL", 1, lambda x: get_substs(settings={"CH1_LDR_CORE2TX_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TPWDNB", 1, lambda x: get_substs(settings={"CH0_TPWDNB": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TPWDNB", 1, lambda x: get_substs(settings={"CH1_TPWDNB": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RATE_MODE_TX", 1, lambda x: get_substs(settings={"CH0_RATE_MODE_TX": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RATE_MODE_TX", 1, lambda x: get_substs(settings={"CH1_RATE_MODE_TX": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RTERM_TX", 5, lambda x: get_substs(settings={"CH0_RTERM_TX": todecstr(x, 5)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RTERM_TX", 5, lambda x: get_substs(settings={"CH1_RTERM_TX": todecstr(x, 5)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TX_CM_SEL", 2, lambda x: get_substs(settings={"CH0_TX_CM_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TX_CM_SEL", 2, lambda x: get_substs(settings={"CH1_TX_CM_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_PRE_EN", 1, lambda x: get_substs(settings={"CH0_TDRV_PRE_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_PRE_EN", 1, lambda x: get_substs(settings={"CH1_TDRV_PRE_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_SLICE0_SEL", 2, lambda x: get_substs(settings={"CH0_TDRV_SLICE0_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_SLICE0_SEL", 2, lambda x: get_substs(settings={"CH1_TDRV_SLICE0_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_SLICE1_SEL", 2, lambda x: get_substs(settings={"CH0_TDRV_SLICE1_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_SLICE1_SEL", 2, lambda x: get_substs(settings={"CH1_TDRV_SLICE1_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_SLICE2_SEL", 2, lambda x: get_substs(settings={"CH0_TDRV_SLICE2_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_SLICE2_SEL", 2, lambda x: get_substs(settings={"CH1_TDRV_SLICE2_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_SLICE3_SEL", 2, lambda x: get_substs(settings={"CH0_TDRV_SLICE3_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_SLICE3_SEL", 2, lambda x: get_substs(settings={"CH1_TDRV_SLICE3_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_SLICE4_SEL", 2, lambda x: get_substs(settings={"CH0_TDRV_SLICE4_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_SLICE4_SEL", 2, lambda x: get_substs(settings={"CH1_TDRV_SLICE4_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_SLICE5_SEL", 2, lambda x: get_substs(settings={"CH0_TDRV_SLICE5_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_SLICE5_SEL", 2, lambda x: get_substs(settings={"CH1_TDRV_SLICE5_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_SLICE0_CUR", 3, lambda x: get_substs(settings={"CH0_TDRV_SLICE0_CUR": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_SLICE0_CUR", 3, lambda x: get_substs(settings={"CH1_TDRV_SLICE0_CUR": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_SLICE1_CUR", 3, lambda x: get_substs(settings={"CH0_TDRV_SLICE1_CUR": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_SLICE1_CUR", 3, lambda x: get_substs(settings={"CH1_TDRV_SLICE1_CUR": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_SLICE2_CUR", 2, lambda x: get_substs(settings={"CH0_TDRV_SLICE2_CUR": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_SLICE2_CUR", 2, lambda x: get_substs(settings={"CH1_TDRV_SLICE2_CUR": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_SLICE3_CUR", 2, lambda x: get_substs(settings={"CH0_TDRV_SLICE3_CUR": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_SLICE3_CUR", 2, lambda x: get_substs(settings={"CH1_TDRV_SLICE3_CUR": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_SLICE4_CUR", 2, lambda x: get_substs(settings={"CH0_TDRV_SLICE4_CUR": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_SLICE4_CUR", 2, lambda x: get_substs(settings={"CH1_TDRV_SLICE4_CUR": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_SLICE5_CUR", 2, lambda x: get_substs(settings={"CH0_TDRV_SLICE5_CUR": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_SLICE5_CUR", 2, lambda x: get_substs(settings={"CH1_TDRV_SLICE5_CUR": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_DAT_SEL", 2, lambda x: get_substs(settings={"CH0_TDRV_DAT_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_DAT_SEL", 2, lambda x: get_substs(settings={"CH1_TDRV_DAT_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TX_DIV11_SEL", 1, lambda x: get_substs(settings={"CH0_TX_DIV11_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TX_DIV11_SEL", 1, lambda x: get_substs(settings={"CH1_TX_DIV11_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RPWDNB", 1, lambda x: get_substs(settings={"CH0_RPWDNB": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RPWDNB", 1, lambda x: get_substs(settings={"CH1_RPWDNB": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RATE_MODE_RX", 1, lambda x: get_substs(settings={"CH0_RATE_MODE_RX": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RATE_MODE_RX", 1, lambda x: get_substs(settings={"CH1_RATE_MODE_RX": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RLOS_SEL", 1, lambda x: get_substs(settings={"CH0_RLOS_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RLOS_SEL", 1, lambda x: get_substs(settings={"CH1_RLOS_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RX_LOS_LVL", 3, lambda x: get_substs(settings={"CH0_RX_LOS_LVL": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RX_LOS_LVL", 3, lambda x: get_substs(settings={"CH1_RX_LOS_LVL": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RX_LOS_CEQ", 2, lambda x: get_substs(settings={"CH0_RX_LOS_CEQ": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RX_LOS_CEQ", 2, lambda x: get_substs(settings={"CH1_RX_LOS_CEQ": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RX_LOS_HYST_EN", 1, lambda x: get_substs(settings={"CH0_RX_LOS_HYST_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RX_LOS_HYST_EN", 1, lambda x: get_substs(settings={"CH1_RX_LOS_HYST_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RX_LOS_EN", 1, lambda x: get_substs(settings={"CH0_RX_LOS_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RX_LOS_EN", 1, lambda x: get_substs(settings={"CH1_RX_LOS_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RX_DIV11_SEL", 1, lambda x: get_substs(settings={"CH0_RX_DIV11_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RX_DIV11_SEL", 1, lambda x: get_substs(settings={"CH1_RX_DIV11_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_SEL_SD_RX_CLK", 1, lambda x: get_substs(settings={"CH0_SEL_SD_RX_CLK": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_SEL_SD_RX_CLK", 1, lambda x: get_substs(settings={"CH1_SEL_SD_RX_CLK": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_FF_RX_H_CLK_EN", 1, lambda x: get_substs(settings={"CH0_FF_RX_H_CLK_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_FF_RX_H_CLK_EN", 1, lambda x: get_substs(settings={"CH1_FF_RX_H_CLK_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_FF_RX_F_CLK_DIS", 1, lambda x: get_substs(settings={"CH0_FF_RX_F_CLK_DIS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_FF_RX_F_CLK_DIS", 1, lambda x: get_substs(settings={"CH1_FF_RX_F_CLK_DIS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_FF_TX_H_CLK_EN", 1, lambda x: get_substs(settings={"CH0_FF_TX_H_CLK_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_FF_TX_H_CLK_EN", 1, lambda x: get_substs(settings={"CH1_FF_TX_H_CLK_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_FF_TX_F_CLK_DIS", 1, lambda x: get_substs(settings={"CH0_FF_TX_F_CLK_DIS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_FF_TX_F_CLK_DIS", 1, lambda x: get_substs(settings={"CH1_FF_TX_F_CLK_DIS": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RX_RATE_SEL", 4, lambda x: get_substs(settings={"CH0_RX_RATE_SEL": todecstr(x, 4)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RX_RATE_SEL", 4, lambda x: get_substs(settings={"CH1_RX_RATE_SEL": todecstr(x, 4)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TDRV_POST_EN", 1, lambda x: get_substs(settings={"CH0_TDRV_POST_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TDRV_POST_EN", 1, lambda x: get_substs(settings={"CH1_TDRV_POST_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TX_POST_SIGN", 1, lambda x: get_substs(settings={"CH0_TX_POST_SIGN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TX_POST_SIGN", 1, lambda x: get_substs(settings={"CH1_TX_POST_SIGN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TX_PRE_SIGN", 1, lambda x: get_substs(settings={"CH0_TX_PRE_SIGN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TX_PRE_SIGN", 1, lambda x: get_substs(settings={"CH1_TX_PRE_SIGN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RXTERM_CM", 2, lambda x: get_substs(settings={"CH0_RXTERM_CM": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RXTERM_CM", 2, lambda x: get_substs(settings={"CH1_RXTERM_CM": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_RXIN_CM", 2, lambda x: get_substs(settings={"CH0_RXIN_CM": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_RXIN_CM", 2, lambda x: get_substs(settings={"CH1_RXIN_CM": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_LEQ_OFFSET_SEL", 1, lambda x: get_substs(settings={"CH0_LEQ_OFFSET_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_LEQ_OFFSET_SEL", 1, lambda x: get_substs(settings={"CH1_LEQ_OFFSET_SEL": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_LEQ_OFFSET_TRIM", 3, lambda x: get_substs(settings={"CH0_LEQ_OFFSET_TRIM": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_LEQ_OFFSET_TRIM", 3, lambda x: get_substs(settings={"CH1_LEQ_OFFSET_TRIM": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_enum_setting(cfg, "DCU.CH0_TXAMPLITUDE",
                                     ["0d100", "0d120", "0d140", "0d160", "0d180", "0d200", "0d220", "0d240", "0d260",
                                      "0d280", "0d300", "0d320", "0d340", "0d360", "0d380", "0d400", "0d420", "0d440",
                                      "0d460", "0d480", "0d500", "0d520", "0d540", "0d560", "0d580", "0d600", "0d620",
                                      "0d640", "0d660", "0d680", "0d700", "0d720", "0d740", "0d760", "0d780", "0d800",
                                      "0d820", "0d840", "0d860", "0d880", "0d900", "0d920", "0d940", "0d960", "0d980",
                                      "0d1000", "0d1020", "0d1040", "0d1060", "0d1080", "0d1100", "0d1120", "0d1140",
                                      "0d1160", "0d1180", "0d1200", "0d1220", "0d1240", "0d1260", "0d1280", "0d1300"],
                                     lambda x: get_substs(settings={"CH0_TXAMPLITUDE": x}), empty_bitfile, False)
        nonrouting.fuzz_enum_setting(cfg, "DCU.CH1_TXAMPLITUDE",
                                     ["0d100", "0d120", "0d140", "0d160", "0d180", "0d200", "0d220", "0d240", "0d260",
                                      "0d280", "0d300", "0d320", "0d340", "0d360", "0d380", "0d400", "0d420", "0d440",
                                      "0d460", "0d480", "0d500", "0d520", "0d540", "0d560", "0d580", "0d600", "0d620",
                                      "0d640", "0d660", "0d680", "0d700", "0d720", "0d740", "0d760", "0d780", "0d800",
                                      "0d820", "0d840", "0d860", "0d880", "0d900", "0d920", "0d940", "0d960", "0d980",
                                      "0d1000", "0d1020", "0d1040", "0d1060", "0d1080", "0d1100", "0d1120", "0d1140",
                                      "0d1160", "0d1180", "0d1200", "0d1220", "0d1240", "0d1260", "0d1280", "0d1300"],
                                     lambda x: get_substs(settings={"CH1_TXAMPLITUDE": x}), empty_bitfile, False)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TXDEPRE", 4, lambda x: get_substs(settings={"CH0_TXDEPRE": todecstr(x, 4)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TXDEPRE", 4, lambda x: get_substs(settings={"CH1_TXDEPRE": todecstr(x, 4)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_TXDEPOST", 4, lambda x: get_substs(settings={"CH0_TXDEPOST": todecstr(x, 4)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_TXDEPOST", 4, lambda x: get_substs(settings={"CH1_TXDEPOST": todecstr(x, 4)}), empty_bitfile)
        nonrouting.fuzz_enum_setting(cfg, "DCU.CH0_PROTOCOL", ["PCIE", "GBE", "SGMII", "XAUI", "SDI", "CPRI", "JESD204", "G8B10B", "8BSER", "10BSER", "EDP"], lambda x: get_substs(settings={"CH0_PROTOCOL": x}), empty_bitfile, False)
        nonrouting.fuzz_enum_setting(cfg, "DCU.CH1_PROTOCOL", ["PCIE", "GBE", "SGMII", "XAUI", "SDI", "CPRI", "JESD204", "G8B10B", "8BSER", "10BSER", "EDP"], lambda x: get_substs(settings={"CH1_PROTOCOL": x}), empty_bitfile, False)

        nonrouting.fuzz_word_setting(cfg, "DCU.D_ISETLOS", 8, lambda x: get_substs(settings={"D_ISETLOS": todecstr(x, 8)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_SETIRPOLY_AUX", 2, lambda x: get_substs(settings={"D_SETIRPOLY_AUX": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_SETICONST_AUX", 2, lambda x: get_substs(settings={"D_SETICONST_AUX": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_SETIRPOLY_CH", 2, lambda x: get_substs(settings={"D_SETIRPOLY_CH": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_SETICONST_CH", 2, lambda x: get_substs(settings={"D_SETICONST_CH": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_REQ_ISET", 3, lambda x: get_substs(settings={"D_REQ_ISET": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_PD_ISET", 2, lambda x: get_substs(settings={"D_PD_ISET": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_DCO_CALIB_TIME_SEL", 2, lambda x: get_substs(settings={"D_DCO_CALIB_TIME_SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCOCTLGI", 3, lambda x: get_substs(settings={"CH0_DCOCTLGI": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCOCTLGI", 3, lambda x: get_substs(settings={"CH1_DCOCTLGI": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCOATDDLY", 2, lambda x: get_substs(settings={"CH0_DCOATDDLY": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCOATDDLY", 2, lambda x: get_substs(settings={"CH1_DCOATDDLY": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCOATDCFG", 2, lambda x: get_substs(settings={"CH0_DCOATDCFG": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCOATDCFG", 2, lambda x: get_substs(settings={"CH1_DCOATDCFG": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCOBYPSATD", 1, lambda x: get_substs(settings={"CH0_DCOBYPSATD": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCOBYPSATD", 1, lambda x: get_substs(settings={"CH1_DCOBYPSATD": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCOSCALEI", 2, lambda x: get_substs(settings={"CH0_DCOSCALEI": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCOSCALEI", 2, lambda x: get_substs(settings={"CH1_DCOSCALEI": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCOITUNE4LSB", 3, lambda x: get_substs(settings={"CH0_DCOITUNE4LSB": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCOITUNE4LSB", 3, lambda x: get_substs(settings={"CH1_DCOITUNE4LSB": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCOIOSTUNE", 3, lambda x: get_substs(settings={"CH0_DCOIOSTUNE": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCOIOSTUNE", 3, lambda x: get_substs(settings={"CH1_DCOIOSTUNE": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCODISBDAVOID", 1, lambda x: get_substs(settings={"CH0_DCODISBDAVOID": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCODISBDAVOID", 1, lambda x: get_substs(settings={"CH1_DCODISBDAVOID": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCOCALDIV", 3, lambda x: get_substs(settings={"CH0_DCOCALDIV": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCOCALDIV", 3, lambda x: get_substs(settings={"CH1_DCOCALDIV": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCONUOFLSB", 3, lambda x: get_substs(settings={"CH0_DCONUOFLSB": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCONUOFLSB", 3, lambda x: get_substs(settings={"CH1_DCONUOFLSB": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCOIUPDNX2", 1, lambda x: get_substs(settings={"CH0_DCOIUPDNX2": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCOIUPDNX2", 1, lambda x: get_substs(settings={"CH1_DCOIUPDNX2": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCOSTEP", 2, lambda x: get_substs(settings={"CH0_DCOSTEP": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCOSTEP", 2, lambda x: get_substs(settings={"CH1_DCOSTEP": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCOSTARTVAL", 3, lambda x: get_substs(settings={"CH0_DCOSTARTVAL": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCOSTARTVAL", 3, lambda x: get_substs(settings={"CH1_DCOSTARTVAL": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCOFLTDAC", 2, lambda x: get_substs(settings={"CH0_DCOFLTDAC": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCOFLTDAC", 2, lambda x: get_substs(settings={"CH1_DCOFLTDAC": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCOITUNE", 2, lambda x: get_substs(settings={"CH0_DCOITUNE": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCOITUNE", 2, lambda x: get_substs(settings={"CH1_DCOITUNE": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_DCOFTNRG", 3, lambda x: get_substs(settings={"CH0_DCOFTNRG": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_DCOFTNRG", 3, lambda x: get_substs(settings={"CH1_DCOFTNRG": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_CDR_CNT4SEL", 2, lambda x: get_substs(settings={"CH0_CDR_CNT4SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_CDR_CNT4SEL", 2, lambda x: get_substs(settings={"CH1_CDR_CNT4SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_CDR_CNT8SEL", 2, lambda x: get_substs(settings={"CH0_CDR_CNT8SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_CDR_CNT8SEL", 2, lambda x: get_substs(settings={"CH1_CDR_CNT8SEL": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_BAND_THRESHOLD", 6, lambda x: get_substs(settings={"CH0_BAND_THRESHOLD": todecstr(x, 6)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_BAND_THRESHOLD", 6, lambda x: get_substs(settings={"CH1_BAND_THRESHOLD": todecstr(x, 6)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_AUTO_FACQ_EN", 1, lambda x: get_substs(settings={"CH0_AUTO_FACQ_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_AUTO_FACQ_EN", 1, lambda x: get_substs(settings={"CH1_AUTO_FACQ_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_AUTO_CALIB_EN", 1, lambda x: get_substs(settings={"CH0_AUTO_CALIB_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_AUTO_CALIB_EN", 1, lambda x: get_substs(settings={"CH1_AUTO_CALIB_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_CALIB_CK_MODE", 1, lambda x: get_substs(settings={"CH0_CALIB_CK_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_CALIB_CK_MODE", 1, lambda x: get_substs(settings={"CH1_CALIB_CK_MODE": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_REG_BAND_OFFSET", 4, lambda x: get_substs(settings={"CH0_REG_BAND_OFFSET": todecstr(x, 4)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_REG_BAND_OFFSET", 4, lambda x: get_substs(settings={"CH1_REG_BAND_OFFSET": todecstr(x, 4)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_REG_BAND_SEL", 6, lambda x: get_substs(settings={"CH0_REG_BAND_SEL": todecstr(x, 6)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_REG_BAND_SEL", 6, lambda x: get_substs(settings={"CH1_REG_BAND_SEL": todecstr(x, 6)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_REG_IDAC_SEL", 10, lambda x: get_substs(settings={"CH0_REG_IDAC_SEL": todecstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_REG_IDAC_SEL", 10, lambda x: get_substs(settings={"CH1_REG_IDAC_SEL": todecstr(x, 10)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH0_REG_IDAC_EN", 1, lambda x: get_substs(settings={"CH0_REG_IDAC_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.CH1_REG_IDAC_EN", 1, lambda x: get_substs(settings={"CH1_REG_IDAC_EN": tobinstr(x, 1)}), empty_bitfile)

        nonrouting.fuzz_word_setting(cfg, "DCU.D_TXPLL_PWDNB", 1, lambda x: get_substs(settings={"D_TXPLL_PWDNB": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_SETPLLRC", 6, lambda x: get_substs(settings={"D_SETPLLRC": todecstr(x, 6)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_REFCK_MODE", 3, lambda x: get_substs(settings={"D_REFCK_MODE": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_TX_VCO_CK_DIV", 3, lambda x: get_substs(settings={"D_TX_VCO_CK_DIV": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_PLL_LOL_SET", 2, lambda x: get_substs(settings={"D_PLL_LOL_SET": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_RG_EN", 1, lambda x: get_substs(settings={"D_RG_EN": tobinstr(x, 1)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_RG_SET", 2, lambda x: get_substs(settings={"D_RG_SET": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_CMUSETISCL4VCO", 3, lambda x: get_substs(settings={"D_CMUSETISCL4VCO": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_CMUSETI4VCO", 2, lambda x: get_substs(settings={"D_CMUSETI4VCO": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_CMUSETINITVCT", 2, lambda x: get_substs(settings={"D_CMUSETINITVCT": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_CMUSETZGM", 3, lambda x: get_substs(settings={"D_CMUSETZGM": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_CMUSETP2AGM", 3, lambda x: get_substs(settings={"D_CMUSETP2AGM": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_CMUSETP1GM", 3, lambda x: get_substs(settings={"D_CMUSETP1GM": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_CMUSETI4CPZ", 4, lambda x: get_substs(settings={"D_CMUSETI4CPZ": todecstr(x, 4)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_CMUSETI4CPP", 4, lambda x: get_substs(settings={"D_CMUSETI4CPP": todecstr(x, 4)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_CMUSETICP4Z", 3, lambda x: get_substs(settings={"D_CMUSETICP4Z": tobinstr(x, 3)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_CMUSETICP4P", 2, lambda x: get_substs(settings={"D_CMUSETICP4P": tobinstr(x, 2)}), empty_bitfile)
        nonrouting.fuzz_word_setting(cfg, "DCU.D_CMUSETBIASI", 2, lambda x: get_substs(settings={"D_CMUSETBIASI": tobinstr(x, 2)}), empty_bitfile)

    fuzzloops.parallel_foreach(jobs, per_job)


if __name__ == "__main__":
    main()
