
#include <iostream>
#include <algorithm>
#include <iterator>
#include <cmath>
#include <sstream>
#include <iomanip>

#include <ossim/base/ossimConstants.h>
#include <ossim/base/ossimKeywordNames.h>
#include <ossim/base/ossimTrace.h>
#include <ossim/base/ossimFilename.h>
#include <ossim/init/ossimInit.h>
#include <ossim/base/ossimArgumentParser.h>
#include <ossim/base/ossimApplicationUsage.h>

#include "ossimBmvStager.h"

int main(int argc, char* argv[])
{
   std::string tempString;
   ossimString landDatabase;
   ossimArgumentParser::ossimParameter stringParam(tempString);
   ossimArgumentParser argumentParser(&argc, argv);
   ossimInit::instance()->addOptions(argumentParser);
   ossimInit::instance()->initialize(argumentParser);
   ossimBmvStager stager;
   
   argumentParser.getApplicationUsage()->setApplicationName(argumentParser.getApplicationName());
   argumentParser.getApplicationUsage()->setDescription(argumentParser.getApplicationName()+" stages input data for blue marble data base");
   argumentParser.getApplicationUsage()->setCommandLineUsage(argumentParser.getApplicationName()+" [options] <file list>");
   argumentParser.getApplicationUsage()->addCommandLineOption("-h or --help","Display this information");
   argumentParser.getApplicationUsage()->addCommandLineOption("--land-database","input file to add to port. Can appear more than once");


   if (argumentParser.read("-h") || argumentParser.read("--help"))
   {
      argumentParser.getApplicationUsage()->write(std::cout);
      exit(0);
   }
   
   while(argumentParser.read("--land-database", stringParam))
   {
      stager.setFilename(ossimFilename(tempString));
   }

   argumentParser.reportRemainingOptionsAsUnrecognized();
   
   // Three required args:  output_type, input file, and output file.
   if (argumentParser.errors())
   {
      argumentParser.writeErrorMessages(std::cout);
      exit(0);
   }

   if(argumentParser.argc() > 1)
   {
      ossim_uint32 idx = 1;
      ossim_uint32 upperBound = argumentParser.argc();
      for(idx = 1; idx < upperBound; ++idx)
      {
         ossimFilename file(argumentParser.argv()[idx]);
         if(file.exists())
         {
            stager.addFile(file);
         }
      }
      
      if(!stager.execute())
      {
         argumentParser.getApplicationUsage()->write(std::cout);
	 
         exit(1);
      }
   }
   else
   {
      argumentParser.getApplicationUsage()->write(std::cout);
   }
   
   exit(0);
}


