/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "OpenDRIM_OperatingSystemLoadAveragesAccess.h"

const string _Name = "LoadAverages";

int OS_OpenDRIM_OperatingSystemLoadAverages_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemLoadAverages_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemLoadAverages_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_OperatingSystemLoadAverages>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	OpenDRIM_OperatingSystemLoadAverages instance;
	instance.setName(_Name);
	if (discriminant == "ei") {
		vector<float> LoadAverages;
		CF_assert(OS_OpenDRIM_OperatingSystemLoadAverages_getLoadAverages(LoadAverages, errorMessage));
		instance.setLoadAverages(LoadAverages);
	}
	result.push_back(instance);
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemLoadAverages_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_OperatingSystemLoadAverages& instance, const char** properties, string& errorMessage) {
	_E_;
	string Name;
	instance.getName(Name);
	if (!CF_strCmpNoCase(Name, _Name))
		return NOT_FOUND;
	vector<float> LoadAverages;
	CF_assert(OS_OpenDRIM_OperatingSystemLoadAverages_getLoadAverages(LoadAverages, errorMessage));
	instance.setLoadAverages(LoadAverages);
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemLoadAverages_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemLoadAverages& newInstance, const OpenDRIM_OperatingSystemLoadAverages& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_OperatingSystemLoadAverages_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemLoadAverages& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_OperatingSystemLoadAverages_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystemLoadAverages& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int OS_OpenDRIM_OperatingSystemLoadAverages_populate(OpenDRIM_OperatingSystemLoadAverages& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystemLoadAverages_getLoadAverages(vector<float>& LoadAverages, string& errorMessage) {
	_E_;
	string loadavg;
	CF_assert(CF_readTextFile("/proc/loadavg", loadavg, errorMessage));
	vector<string> loadavg_elements;
	CF_splitTextBySpace(loadavg_elements, loadavg);
	if (loadavg_elements.size() < 5) {
		errorMessage = "Wrong format: /proc/loadavg";
		return FAILED;
	}
	LoadAverages.push_back(atof(loadavg_elements[0].c_str()));
	LoadAverages.push_back(atof(loadavg_elements[1].c_str()));
	LoadAverages.push_back(atof(loadavg_elements[2].c_str()));
	_L_;
	return OK;	
}
