/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.util.List;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.modules.Action;
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.service.PortalService;
import org.chefproject.service.PresenceService;
import org.chefproject.util.PresenceObservingCourier;

public class PresenceAction
extends Action {
    private static final String STATE_OBSERVER = "obsever";
    private static final String SCREEN_PRESENCE = "presence";
    private static final String FRAME_PRESENCE = "presence";
    private static final String ELEMENT_ID_PRESENCE = "presence";
    private static final String CONTEXT_USERS = "sessions";

    public void doPerform(RunData data) throws Exception {
        data.setScreenTemplate("presence");
        String location = PortalService.getCurrentLocationId();
        Context context = TurbineVelocity.getContext(data);
        SessionState state = ((JetspeedRunData)data).getPortletSessionState("presence");
        PresenceObservingCourier observer = (PresenceObservingCourier)state.getAttribute(STATE_OBSERVER);
        if (observer == null) {
            String deliveryId = PortalService.getCurrentClientWindowId();
            observer = new PresenceObservingCourier(deliveryId, "presence", location);
            state.setAttribute(STATE_OBSERVER, (Object)observer);
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ": observer: " + observer + " location: " + location + " deliveryAddress: " + deliveryId);
            }
        }
        List sessions = PresenceService.getPresence(location);
        context.put(CONTEXT_USERS, sessions);
    }

    static {
        STATE_OBSERVER = STATE_OBSERVER;
        SCREEN_PRESENCE = "presence";
        FRAME_PRESENCE = "presence";
        ELEMENT_ID_PRESENCE = "presence";
        CONTEXT_USERS = CONTEXT_USERS;
    }
}

