/*
 * Copyright 2013 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.0
import Ubuntu.Components 0.1

Item {
    clip: true

    UbuntuShape {
        id: shape
        anchors.top: parent.top
        anchors.left: parent.left
        height: units.gu(8)
        width: units.gu(8)
        anchors.margins: units.gu(1)

        image: Image {
            id: imageItem
            fillMode: Image.PreserveAspectCrop
        }

        visible: imageItem.status === Image.Ready
    }

    Label {
        id: label
        anchors.left: (shape.visible) ? shape.right : parent.left
        anchors.top: parent.top
        anchors.right: parent.right

        anchors.margins: units.gu(1)
        textFormat: Text.RichText
        wrapMode: TextEdit.Wrap
    }

    function fill(model) {
        var text = ""
        for (var i = 0; i < model.count; i++) {
            if (model.get(i).type == "image") {
                imageItem.source = model.get(i).content;
                break;
            }
        }
        for (i = 0; i < model.count; i++) {
            if (model.get(i).type == "text") {
                var richText = model.get(i).content.split("\n");
                if (text.length === 0) {
                    richText[0] = "<b>" + richText[0] + "</b>";
                    text = richText.join("<br>");
                }
                else text += "<br>" + richText.join("<br>")
            }
        }
        label.text = text;
    }
}
