/***************************************************************************
 *   Copyright (C) 2011-2013 by Tomasz Bojczuk                             *
 *   tomaszbojczuk@gmail.com                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include <QtGui>
#include "mainwindow.h"
#include "tglobals.h"

Tglobals *gl;

int main(int argc, char *argv[])
{
// #if defined(Q_OS_WIN32)
//     QApplication::setStyle("plastique");  
// #endif
    
  QApplication a(argc, argv);

  
  gl = new Tglobals();
  gl->path = Tglobals::getInstPath(qApp->applicationDirPath());
      
  QString ll = gl->lang;
  if (ll == "")
    ll = QLocale::system().name();
    QTranslator qtTranslator;
#if defined(Q_OS_LINUX)
    qtTranslator.load("qt_" + ll, QLibraryInfo::location(QLibraryInfo::TranslationsPath));
#else
    qtTranslator.load("qt_" + ll, gl->path + "lang");
#endif
    a.installTranslator(&qtTranslator);

    QTranslator nooTranslator;
    nooTranslator.load("nootka_" + ll, gl->path + "lang");
    a.installTranslator(&nooTranslator);
	
    MainWindow w;

    QFontDatabase fd;
#if defined(Q_OS_WIN32)
    int fid = fd.addApplicationFont(gl->path + "fonts/nootka.ttf");
#else
    int fid = fd.addApplicationFont(gl->path + "fonts/nootka.otf");
#endif
    if (fid == -1) {
        QMessageBox::critical(0, "", QCoreApplication::translate("main", "<center>Can not load a font.<br>Try to install nootka.otf manually.</center>"));
        return 111;
    }
#if defined (Q_OS_MAC)
    a.installEventFilter(&w);
#endif
    w.show();
    if (argc > 1)
        w.openFile(QString::fromLocal8Bit(argv[argc-1]));
    return a.exec();
}
