#ifndef NCrystal_hh
#define NCrystal_hh

////////////////////////////////////////////////////////////////////////////////
//                                                                            //
//  This file is part of NCrystal (see https://mctools.github.io/ncrystal/)   //
//                                                                            //
//  Copyright 2015-2022 NCrystal developers                                   //
//                                                                            //
//  Licensed under the Apache License, Version 2.0 (the "License");           //
//  you may not use this file except in compliance with the License.          //
//  You may obtain a copy of the License at                                   //
//                                                                            //
//      http://www.apache.org/licenses/LICENSE-2.0                            //
//                                                                            //
//  Unless required by applicable law or agreed to in writing, software       //
//  distributed under the License is distributed on an "AS IS" BASIS,         //
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  //
//  See the License for the specific language governing permissions and       //
//  limitations under the License.                                            //
//                                                                            //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////
// Convenience header for all NCrystal interfaces //
////////////////////////////////////////////////////

#ifndef NCrystal_Dump_hh
#  include "NCrystal/NCDump.hh"
#endif
#ifndef NCrystal_Defs_hh
#  include "NCrystal/NCDefs.hh"
#endif
#ifndef NCrystal_Exception_hh
#  include "NCrystal/NCException.hh"
#endif
#ifndef NCrystal_Mem_hh
#  include "NCrystal/NCMem.hh"
#endif
#ifndef NCrystal_SmallVector_hh
#  include "NCrystal/NCSmallVector.hh"
#endif
#ifndef NCrystal_Variant_hh
#  include "NCrystal/NCVariant.hh"
#endif
#ifndef NCrystal_Fmt_hh
#  include "NCrystal/NCFmt.hh"
#endif
#ifndef NCrystal_PluginMgmt_hh
#  include "NCrystal/NCPluginMgmt.hh"
#endif
#ifndef NCrystal_AtomData_hh
#  include "NCrystal/NCAtomData.hh"
#endif
#ifndef NCrystal_TextData_hh
#  include "NCrystal/NCTextData.hh"
#endif
#ifndef NCrystal_Info_hh
#  include "NCrystal/NCInfo.hh"
#endif
#ifndef NCrystal_InfoTypes_hh
#  include "NCrystal/NCInfoTypes.hh"
#endif
#ifndef NCrystal_InfoBuilder_hh
#  include "NCrystal/NCInfoBuilder.hh"
#endif
#ifndef NCrystal_SABData_hh
#  include "NCrystal/NCSABData.hh"
#endif
#ifndef NCrystal_MatCfg_hh
#  include "NCrystal/NCMatCfg.hh"
#endif
#ifndef NCrystal_RNG_hh
#  include "NCrystal/NCRNG.hh"
#endif
#ifndef NCrystal_SCOrientation_hh
#  include "NCrystal/NCSCOrientation.hh"
#endif
#ifndef NCrystal_LoadNCMAT_hh
#  include "NCrystal/NCLoadNCMAT.hh"
#endif
#ifndef NCrystal_NCMATData_hh
#  include "NCrystal/NCNCMATData.hh"
#endif
#ifndef NCrystal_ParseNCMAT_hh
#  include "NCrystal/NCParseNCMAT.hh"
#endif
#ifndef NCrystal_Version_hh
#  include "NCrystal/NCVersion.hh"
#endif
#ifndef NCrystal_CompositionUtils_hh
#  include "NCrystal/NCCompositionUtils.hh"
#endif
#ifndef NCrystal_ProcImpl_hh
#  include "NCrystal/NCProcImpl.hh"
#endif
#ifndef NCrystal_Proc_hh
#  include "NCrystal/NCProc.hh"
#endif
#ifndef NCrystal_FactTypes_hh
#  include "NCrystal/NCFactTypes.hh"
#endif
#ifndef NCrystal_FactImpl_hh
#  include "NCrystal/NCFactImpl.hh"
#endif
#ifndef NCrystal_FactRequests_hh
#  include "NCrystal/NCFactRequests.hh"
#endif
#ifndef NCrystal_DataSources_hh
#  include "NCrystal/NCDataSources.hh"
#endif
#ifndef NCrystal_Fact_hh
#  include "NCrystal/NCFact.hh"
#endif
#ifndef NCrystal_Types_hh
#  include "NCrystal/NCTypes.hh"
#endif
#ifndef NCrystal_ImmutBuf_hh
#  include "NCrystal/NCImmutBuf.hh"
#endif

#endif
