/*
 * Copyright (c) 2002 - 2004 Dmitry Dicky diwil@mail.ru
 * All rights reserved.
 *
 * Modifications Copyright (c) 2010 Diane Gagne diane@hartmantech.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS `AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Modified 2010 by Diane Gagne at Hartman Technica to include handling for 
 * overflow, underflow Nan and denormalized number handling
 *
 * $Id: divsf.c,v 1.8 2004/05/28 10:11:47 diwil Exp $
 */

#include "mathsf.h"

long __divsf3(long a1, long a2)
{
	register int  exp;	//asm("r11");
	register int  sign;	//asm("r10");
	register long mask;
	register long result;
	register int  tmp;
	
	/* sign = SIGN (fl1.l) ^ SIGN (fl2.l); */

	sign = ((a1^a2)>>SHORT_SHIFT)&SHORT_SIGNBIT_MASK;
	exp = SHORT_EXPONENT_MASK & (a1>>SHORT_SHIFT);
	tmp = SHORT_EXPONENT_MASK & (a2>>SHORT_SHIFT);

#if __MSP430LIBC_IEEE754_ERRORS__
	//check if the numerator is infinity or NaN
	//if so the exponent will be all 1
	if(exp == SHORT_EXPONENT_MASK)
	  {
	    //if the first number is NaN return a Nan taken from the operand
	    if((a1 & MANTISSA_MASK) != 0)
	      return a1;
	    //otherwise the number is infinity
	    else
	      {
		//if operand 2 is infinity or NaN return a NaN
		if(tmp == SHORT_EXPONENT_MASK)
		  return NAN;
		//Otherwise return a signed infinity
		return (POSITIVE_INFINITY)|(long)sign<<SHORT_SHIFT;
	      }
	  }
	
	//Check if operand 2 is infinity or NaN
	if(tmp == SHORT_EXPONENT_MASK)
	  {
	    //if the operand is NaN return a signed NaN
	    if((a2 & MANTISSA_MASK)!=0)
	      return a2;
	    //otherwise return a signed 0
	    else
	      return (long)sign<<SHORT_SHIFT;	    
	  }

	//normalize any denormalized numbers and look for numerator of 0
	if(exp == 0)
	  {
	    //get only the mantissa part of the first number
	    a1 = a1 & MANTISSA_MASK;
	    //if the number is 0 return a signed 0
	    if((a1 & NO_SIGN) == 0)
	      return (long)sign<<SHORT_SHIFT;
	    //otherwise denormalise the number
	    //do one shift to start
	    a1 = a1<<1;
	    //while the 24th bit is not filled repeatedly shift the 
	    //mantissa up by 1 and subtract 1 from the exponent
	    while((a1 & MANTISSA_BIT) != MANTISSA_BIT)
	      {
		a1 = a1<<1;
		exp = exp-(1<<EXPONENT_SHIFT);
	      }
	  }
	//if it is allready normalized get the mantissa with the hidden bit
	else
	  a1 = MANT(a1);
	
	//do the same thing for the second operand and look for a divide by 0
	if(tmp == 0)
	  {
	    if((a2 & NO_SIGN)==0)
	      return POSITIVE_INFINITY|(long)sign<<SHORT_SHIFT;
	    a2 = a2 & MANTISSA_MASK;
	    a2 = a2<<1;
	    while((a2 & MANTISSA_BIT) != MANTISSA_BIT)
	      {
		a2 = a2<<1;
		tmp = tmp-(1<<EXPONENT_SHIFT);
	      }
	  }
	else
	  a2 = MANT(a2);
#endif

	exp += EXCESS<<EXPONENT_SHIFT;
	exp -= tmp;

#if ! __MSP430LIBC_IEEE754_ERRORS__

	/* divide by zero??? */
	if(!a2)
	{
	  return(NAN);
	}
	
	/* numerator zero??? */
	if(!a1)
	  return a1;

	a1 = MANT(a1);
	a2 = MANT(a2);
#endif

	if(a1<a2)
	{
		a1 <<= 1;
		exp -= 1<<EXPONENT_SHIFT;
	}

	mask = 0x1000000ul;
	result = 0ul;
	__asm__ __volatile__ (";mask");
	while (mask)
	{
		if(a1>=a2)
		{
			result |= mask;
			a1 -= a2;
		}
		__asm__ __volatile__ (";nop");
		a1 <<= 1;
		mask >>= 1;
	}
	__asm__ __volatile__ (";round");

#if __MSP430LIBC_IEEE754_ERRORS__
	//look for overflow or underflow
	if(exp <= 0)
	  {
	    //if the second exponent is greater than 1 it is underflow
	    if(tmp >= MAX_EXPONENT<<EXPONENT_SHIFT)
	      {
		//if the total exponent is less that -143 return signed 0
		if(exp < MIN_EXPONENT<<EXPONENT_SHIFT)
		  return((long)sign<<SHORT_SHIFT);
		//otherwise denormalize the result
		else
		  {
		    // return exp;
		    result >>=1;
		    result = result|MANTISSA_BIT;
		    result = result>>((-exp)>>EXPONENT_SHIFT);
		    result += 1;
		    result = result>>1;
		    exp = 0x0000;
		  }
	      }
	    //if exponent 2 was posative return a signed infinity
	    else
	      return (POSITIVE_INFINITY|(long)sign<<SHORT_SHIFT);
	  }
	//the odd overflow will not appear negative so return infinity for them too
	else if(exp > EXPONENT_OVERFLOW<<EXPONENT_SHIFT)
	  return (long)sign<<SHORT_SHIFT | POSITIVE_INFINITY;
	//otherwise round
	else
#endif
	  {
	    /* round */
	    result += 1;
	    
	    /* normalize down */
	    /* exp++ */
	    exp += 1<<EXPONENT_SHIFT;
	    result >>=1;
	  }	
	result &= ~HIDDEN ;
	
	/* pack up and go home */
	result |= ((long)(sign | exp)<<SHORT_SHIFT);
#if 0
	__asm__ __volatile__ (
	";pack\n\t"
	"bis	%2, %1  \n\t" 
	"bis	%1, %B0 \n\t" 
		:
		: "r" (result),
		  "r" (sign),
		  "r" (exp)
	);
#endif	
	return result;
}
