# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class FFT(Object):
    r"""
    FFT - perform Discrete Fourier Transforms
    
    Superclass: Object
    
    FFT provides methods to perform Discrete Fourier Transforms (DFT).
    These include providing forward and reverse Fourier transforms. The
    current implementation uses the third-party library kissfft.
    
    The terminology tries to follow the Numpy terminology, that is :
    - Fft means the Fast Fourier Transform algorithm
    - Prefix `R` stands for Real (meaning optimized function for real
      inputs)
    - Prefix `I` stands for Inverse
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkFFT, obj, update, **traits)
    
    def bartlett_generator(self, *args):
        """
        bartlett_generator(x:int, size:int) -> float
        C++: static double bartlett_generator(const std::size_t x,
            const std::size_t size)
        Window generator functions. Implementation only needs to be valid
        for x E [0; size / 2] because kernels are symmetric by
        definitions. This point is very important for some kernels like
        Bartlett for example.
        
        @warning Hanning and Bartlett generators needs a size > 1 !
        
        Can be used with generate_kernel1d and generate_kernel2d for
        generating full kernels.
        """
        ret = self._wrap_call(self._vtk_obj.BartlettGenerator, *args)
        return ret

    def blackman_generator(self, *args):
        """
        blackman_generator(x:int, size:int) -> float
        C++: static double blackman_generator(const std::size_t x,
            const std::size_t size)
        Window generator functions. Implementation only needs to be valid
        for x E [0; size / 2] because kernels are symmetric by
        definitions. This point is very important for some kernels like
        Bartlett for example.
        
        @warning Hanning and Bartlett generators needs a size > 1 !
        
        Can be used with generate_kernel1d and generate_kernel2d for
        generating full kernels.
        """
        ret = self._wrap_call(self._vtk_obj.BlackmanGenerator, *args)
        return ret

    def fft_freq(self, *args):
        """
        fft_freq(windowLength:int, sampleSpacing:float) -> (float, ...)
        C++: static std::vector<double> fft_freq(int windowLength,
            double sampleSpacing)
        Return the DFT sample frequencies. Output has windowLength size.
        """
        ret = self._wrap_call(self._vtk_obj.FftFreq, *args)
        return ret

    def hanning_generator(self, *args):
        """
        hanning_generator(x:int, size:int) -> float
        C++: static double hanning_generator(const std::size_t x,
            const std::size_t size)
        Window generator functions. Implementation only needs to be valid
        for x E [0; size / 2] because kernels are symmetric by
        definitions. This point is very important for some kernels like
        Bartlett for example.
        
        @warning Hanning and Bartlett generators needs a size > 1 !
        
        Can be used with generate_kernel1d and generate_kernel2d for
        generating full kernels.
        """
        ret = self._wrap_call(self._vtk_obj.HanningGenerator, *args)
        return ret

    def r_fft_freq(self, *args):
        """
        r_fft_freq(windowLength:int, sampleSpacing:float) -> (float, ...)
        C++: static std::vector<double> r_fft_freq(int windowLength,
            double sampleSpacing)
        Return the DFT sample frequencies for the real version of the dft
        (see Rfft). Output has (windowLength / 2) + 1 size.
        """
        ret = self._wrap_call(self._vtk_obj.RFftFreq, *args)
        return ret

    def rectangular_generator(self, *args):
        """
        rectangular_generator(x:int, size:int) -> float
        C++: static double rectangular_generator(const std::size_t x,
            const std::size_t size)
        Window generator functions. Implementation only needs to be valid
        for x E [0; size / 2] because kernels are symmetric by
        definitions. This point is very important for some kernels like
        Bartlett for example.
        
        @warning Hanning and Bartlett generators needs a size > 1 !
        
        Can be used with generate_kernel1d and generate_kernel2d for
        generating full kernels.
        """
        ret = self._wrap_call(self._vtk_obj.RectangularGenerator, *args)
        return ret

    def sine_generator(self, *args):
        """
        sine_generator(x:int, size:int) -> float
        C++: static double sine_generator(const std::size_t x,
            const std::size_t size)
        Window generator functions. Implementation only needs to be valid
        for x E [0; size / 2] because kernels are symmetric by
        definitions. This point is very important for some kernels like
        Bartlett for example.
        
        @warning Hanning and Bartlett generators needs a size > 1 !
        
        Can be used with generate_kernel1d and generate_kernel2d for
        generating full kernels.
        """
        ret = self._wrap_call(self._vtk_obj.SineGenerator, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(FFT, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit FFT properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit FFT properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit FFT properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

