# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_volume_mapper import AbstractVolumeMapper


class AbstractHyperTreeGridMapper(AbstractVolumeMapper):
    r"""
    AbstractHyperTreeGridMapper - Abstract class for a hyper_tree_grid
    mapper
    
    Superclass: AbstractVolumeMapper
    
    AbstractHyperTreeGridMapper is the abstract definition of a
    hyper_tree_grid mapper. Several  basic types of volume mappers are
    supported.
    
    @sa
    HyperTreeGrid UniformHyperTreeGrid
    
    @par Thanks: This class was written by Philippe Pebay and Meriadeg
    Perrinel, nex_gen Analytics 2018 This worked was based on an idea of
    Guenole Harel and Jacques-Bernard Lekien This work was supported by
    Commissariat a l'Energie Atomique (CEA/DIF) CEA, DAM, DIF, F-91297
    Arpajon, France.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAbstractHyperTreeGridMapper, obj, update, **traits)
    
    def _get_color_map(self):
        return wrap_vtk(self._vtk_obj.GetColorMap())
    def _set_color_map(self, arg):
        old_val = self._get_color_map()
        self._wrap_call(self._vtk_obj.SetColorMap,
                        deref_vtk(arg))
        self.trait_property_changed('color_map', old_val, arg)
    color_map = traits.Property(_get_color_map, _set_color_map, desc=\
        r"""
        
        """
    )

    def _get_input_connection(self):
        if self._vtk_obj.GetTotalNumberOfInputConnections():
            return wrap_vtk(self._vtk_obj.GetInputConnection(0, 0))
        else:
            return None
    
    def _set_input_connection(self, obj):
        old_val = self._get_input_connection()
        self._wrap_call(self._vtk_obj.SetInputConnection, deref_vtk(obj))
        self.trait_property_changed('input_connection', old_val, obj)
    input_connection = traits.Property(_get_input_connection,
                                       _set_input_connection,
                                       desc="The first input connection for this object, i.e. the result of `get_input_connection(0, 0)`.")
    
    def get_input_connection(self, *args):
        """
        get_input_connection(self, port:int, index:int)
            -> AlgorithmOutput
        C++: AlgorithmOutput *get_input_connection(int port, int index)
        Get the algorithm output port connected to an input port.
        """
        ret = self._wrap_call(self._vtk_obj.GetInputConnection, *args)
        return wrap_vtk(ret)

    def set_input_connection(self, *args):
        """
        set_input_connection(self, __a:int, __b:AlgorithmOutput) -> None
        set_input_connection(self, input:AlgorithmOutput) -> None
        
        Set the connection for the given input port index.  Each input
        port of a filter has a specific purpose.  A port may have zero or
        more connections and the required number is specified by each
        filter.  Setting the connection with this method removes all
        other connections from the port.  To add more than one connection
        use add_input_connection().
        
        * The input for the connection is the output port of another
        * filter, which is obtained with get_output_port().  Typical usage
          is
        
        * filter2->set_input_connection(0, filter1->get_output_port(0)).
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputConnection, *my_args)
        return ret

    def _get_renderer(self):
        return wrap_vtk(self._vtk_obj.GetRenderer())
    def _set_renderer(self, arg):
        old_val = self._get_renderer()
        self._wrap_call(self._vtk_obj.SetRenderer,
                        deref_vtk(arg))
        self.trait_property_changed('renderer', old_val, arg)
    renderer = traits.Property(_get_renderer, _set_renderer, desc=\
        r"""
        
        """
    )

    scalar_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(0.0, 0.0), cols=2, desc=\
        r"""
        Specify range in terms of scalar minimum and maximum. These
        values are used to map scalars into lookup table Has no effect
        when dimension > 2 Used only when color_map is a lookup table
        instance
        """
    )

    def _scalar_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarRange,
                        self.scalar_range)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        
        """
    )

    def _get_viewport_size(self):
        return self._vtk_obj.GetViewportSize()
    viewport_size = traits.Property(_get_viewport_size, desc=\
        r"""
        Get image size
        """
    )

    def set_input_data(self, *args):
        """
        set_input_data(self, __a:UniformHyperTreeGrid) -> None
        C++: virtual void set_input_data(UniformHyperTreeGrid *)
        Set/Get the input data or connection
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetInputData, *my_args)
        return ret

    def set_scale(self, *args):
        """
        set_scale(self, _arg:float) -> None
        C++: virtual void set_scale(double _arg)
        Set the scale factor
        """
        ret = self._wrap_call(self._vtk_obj.SetScale, *args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('scalar_mode',
    'GetScalarMode'), ('scalar_range', 'GetScalarRange'),
    ('array_access_mode', 'GetArrayAccessMode'), ('progress_text',
    'GetProgressText'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'scalar_mode', 'array_access_mode',
    'object_name', 'progress_text', 'scalar_range'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AbstractHyperTreeGridMapper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AbstractHyperTreeGridMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], ['scalar_mode'], ['array_access_mode', 'object_name',
            'scalar_range']),
            title='Edit AbstractHyperTreeGridMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AbstractHyperTreeGridMapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

