#ifndef __MAINWIN_H
#define __MAINWIN_H
/*-------------------------------------------------------------------------
 * Copyright (c) 2000-2002 Kenneth W. Sodemann (stufflehead@bigfoot.com)
 *-------------------------------------------------------------------------
 * mainwin
 *
 * Synopsis:
 *    The main MathWars window
 *
 * $Id: mainwin.h,v 1.4 2002/05/25 22:12:31 stuffle Exp $
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to 
 * Free Software Foundation, Inc. 
 * 59 Temple Place, Suite 330 
 * Boston, MA  02111-1307  USA
 *
 *-------------------------------------------------------------------------
 */
/*! \file mainwin.h

  \brief Main MathWar window

  Create and manipulate the main window of the MathWar game.

  \author Kenneth W. Sodemann <stufflehead@bigfoot.com>
  $Revision: 1.4 $
  $Date: 2002/05/25 22:12:31 $
*/

#include <gtk/gtk.h>

#include "operators.h"

/*! \fn GtkWidget *create_mainwin (void)
 
  \brief Create the main window for the application

  \return
  A pointer to the created main widget.
*/
GtkWidget *create_mainwin (void);

/*! \fn void set_timer_pct (GtkWidget *mainwin,
                            gfloat     pct)

  \brief Set the timer dial percent.

  \param mainwin
  The widget that contains the dial

  \param pct
  The percent to set it to, between 0.0 and 1.0

  \return
  Nothing.
*/
void set_timer_pct (GtkWidget  *mainwin,
                    gfloat      pct);

/*! \fn void display_rounds_left (GtkWidget *mainwin, gint rounds)
 
  \brief Display the number of rounds left to play

  \param mainwin
  The topmost parent widget.

  \param rounds
  The number of rounds left to play.

  \return
  Nothing.
*/
void display_rounds_left (GtkWidget *mainwin,
                          gint       rounds);

/*
 * TODO:
 * Document me....
 */
GtkDrawingArea *get_main_drawing_area (void);

void disable_all_input_widgets (GtkWidget *mainwin);

void reset_input_widgets (GtkWidget *mainwin);

void yesno_activate (GtkWidget *mainwin);

#endif
