/* pieceStandIO.cc
 */
#include "osl/pieceStandIO.h"
#include "osl/pieceStand.h"
#include <boost/foreach.hpp>
#include <iostream>

std::ostream& osl::
PieceStandIO::writeNumbers(std::ostream& os, const PieceStand& stand)
{
  BOOST_FOREACH(Ptype ptype, PieceStand::order) {
    os << stand.get(ptype) << " ";
  }
  return os;
}
std::istream& osl::
PieceStandIO::readNumbers(std::istream& is, PieceStand& stand)
{
  stand  = PieceStand();
  BOOST_FOREACH(Ptype ptype, PieceStand::order) {
    int val;
    if (is >> val) 
      stand.add(ptype, val);
  }
  return is;
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
