/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.apisupport.project.ui.customizer;

import java.beans.PropertyChangeEvent;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.NbBundle;

/**
 * Represents <em>Compiling</em> panel in Netbeans Module customizer.
 *
 * @author Martin Krauskopf
 */
final class CustomizerCompiling extends NbPropertyPanel.Single {

    CustomizerCompiling(final SingleModuleProperties props, ProjectCustomizer.Category category) {
        super(props, CustomizerCompiling.class, category);
        initComponents();
        initAccessibility();
        refresh();
    }
    
    protected void refresh() {
        debug.setSelected(getBooleanProperty(SingleModuleProperties.BUILD_COMPILER_DEBUG));
        deprecation.setSelected(getBooleanProperty(SingleModuleProperties.BUILD_COMPILER_DEPRECATION));
        options.setText(getProperty(SingleModuleProperties.JAVAC_COMPILERARGS));
        NbPlatform platform = getProperties().getActivePlatform();
        options.setEnabled(platform == null || platform.getHarnessVersion().compareTo(HarnessVersion.V50u1) >= 0); // #71631
    }
    
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (SingleModuleProperties.JAVAC_COMPILERARGS.equals(evt.getPropertyName())) {
            options.setText(getProperty(SingleModuleProperties.JAVAC_COMPILERARGS));
        }
        if (SingleModuleProperties.NB_PLATFORM_PROPERTY.equals(evt.getPropertyName())) {
            NbPlatform platform = getProperties().getActivePlatform();
            options.setEnabled(platform == null || platform.getHarnessVersion().compareTo(HarnessVersion.V50u1) >= 0);
        }
    }
    
    @Override
    public void store() {
        setBooleanProperty(SingleModuleProperties.BUILD_COMPILER_DEBUG, debug.isSelected());
        setBooleanProperty(SingleModuleProperties.BUILD_COMPILER_DEPRECATION, deprecation.isSelected());
        setProperty(SingleModuleProperties.JAVAC_COMPILERARGS, options.getText());
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        deprecation = new javax.swing.JCheckBox();
        debug = new javax.swing.JCheckBox();
        optionsLabel = new javax.swing.JLabel();
        options = new javax.swing.JTextField();

        org.openide.awt.Mnemonics.setLocalizedText(deprecation, org.openide.util.NbBundle.getMessage(CustomizerCompiling.class, "CTL_ReportDeprecation")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(debug, org.openide.util.NbBundle.getMessage(CustomizerCompiling.class, "CTL_GenerateDebugInfo")); // NOI18N

        optionsLabel.setLabelFor(options);
        org.openide.awt.Mnemonics.setLocalizedText(optionsLabel, NbBundle.getMessage(CustomizerCompiling.class, "LBL_additional_compiler_options")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(debug)
                    .addComponent(deprecation)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(optionsLabel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(options, javax.swing.GroupLayout.DEFAULT_SIZE, 193, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(debug)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(deprecation)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(optionsLabel)
                    .addComponent(options, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(233, Short.MAX_VALUE))
        );

        options.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(CustomizerCompiling.class, "ACS_AdditionalCompilerOptions")); // NOI18N
        options.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(CustomizerCompiling.class, "ACSD_AdditionalCompilerOptions")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox debug;
    private javax.swing.JCheckBox deprecation;
    private javax.swing.JTextField options;
    private javax.swing.JLabel optionsLabel;
    // End of variables declaration//GEN-END:variables
    
    private static String getMessage(String key) {
        return NbBundle.getMessage(CustomizerCompiling.class, key);
    }
    
    private void initAccessibility() {
        debug.getAccessibleContext().setAccessibleDescription(getMessage("ACSD_Debug"));
        deprecation.getAccessibleContext().setAccessibleDescription(getMessage("ACSD_Deprecation"));
    }
    
}
