; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=future -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-ibm-aix \
; RUN:   -mcpu=future -ppc-asm-full-reg-names \
; RUN:   -ppc-vsr-nums-as-vr < %s | FileCheck %s --check-prefix=CHECK-BE

declare <1024 x i1> @llvm.ppc.mma.dmsha2hash(<1024 x i1>, <1024 x i1>, i32)

define dso_local void @test_dmsha2hash(ptr %vop, ptr %vinp, ptr %resp) {
; CHECK-LABEL: test_dmsha2hash:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxvp vsp34, 0(r3)
; CHECK-NEXT:    lxvp vsp36, 32(r3)
; CHECK-NEXT:    dmxxinstdmr512 wacc_hi0, vsp36, vsp34, 1
; CHECK-NEXT:    lxvp vsp34, 64(r3)
; CHECK-NEXT:    lxvp vsp36, 96(r3)
; CHECK-NEXT:    dmxxinstdmr512 wacc0, vsp36, vsp34, 0
; CHECK-NEXT:    lxvp vsp34, 0(r4)
; CHECK-NEXT:    lxvp vsp36, 32(r4)
; CHECK-NEXT:    dmxxinstdmr512 wacc_hi1, vsp36, vsp34, 1
; CHECK-NEXT:    lxvp vsp34, 64(r4)
; CHECK-NEXT:    lxvp vsp36, 96(r4)
; CHECK-NEXT:    dmxxinstdmr512 wacc1, vsp36, vsp34, 0
; CHECK-NEXT:    dmsha256hash dmr0, dmr1
; CHECK-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; CHECK-NEXT:    stxvp vsp34, 96(r5)
; CHECK-NEXT:    stxvp vsp36, 64(r5)
; CHECK-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc_hi0, 1
; CHECK-NEXT:    stxvp vsp34, 32(r5)
; CHECK-NEXT:    stxvp vsp36, 0(r5)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: test_dmsha2hash:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxvp vsp34, 96(r3)
; CHECK-BE-NEXT:    lxvp vsp36, 64(r3)
; CHECK-BE-NEXT:    dmxxinstdmr512 wacc_hi0, vsp36, vsp34, 1
; CHECK-BE-NEXT:    lxvp vsp34, 32(r3)
; CHECK-BE-NEXT:    lxvp vsp36, 0(r3)
; CHECK-BE-NEXT:    dmxxinstdmr512 wacc0, vsp36, vsp34, 0
; CHECK-BE-NEXT:    lxvp vsp34, 96(r4)
; CHECK-BE-NEXT:    lxvp vsp36, 64(r4)
; CHECK-BE-NEXT:    dmxxinstdmr512 wacc_hi1, vsp36, vsp34, 1
; CHECK-BE-NEXT:    lxvp vsp34, 32(r4)
; CHECK-BE-NEXT:    lxvp vsp36, 0(r4)
; CHECK-BE-NEXT:    dmxxinstdmr512 wacc1, vsp36, vsp34, 0
; CHECK-BE-NEXT:    dmsha256hash dmr0, dmr1
; CHECK-BE-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc_hi0, 1
; CHECK-BE-NEXT:    stxvp vsp36, 96(r5)
; CHECK-BE-NEXT:    stxvp vsp34, 64(r5)
; CHECK-BE-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; CHECK-BE-NEXT:    stxvp vsp36, 32(r5)
; CHECK-BE-NEXT:    stxvp vsp34, 0(r5)
; CHECK-BE-NEXT:    blr
entry:
  %0 = load <1024 x i1>, ptr %vop, align 64
  %1 = load <1024 x i1>, ptr %vinp, align 64
  %3 = tail call <1024 x i1> @llvm.ppc.mma.dmsha2hash(<1024 x i1> %0, <1024 x i1> %1, i32 0)
  store <1024 x i1> %3, ptr %resp, align 64
  ret void
}

declare <2048 x i1> @llvm.ppc.mma.dmsha3hash(<2048 x i1>, i32)

define dso_local void @test_dmsha3hash(ptr %vopp, ptr %resp) {
; CHECK-LABEL: test_dmsha3hash:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxvp vsp34, 0(r3)
; CHECK-NEXT:    lxvp vsp36, 32(r3)
; CHECK-NEXT:    dmxxinstdmr512 wacc_hi1, vsp36, vsp34, 1
; CHECK-NEXT:    lxvp vsp34, 64(r3)
; CHECK-NEXT:    lxvp vsp36, 96(r3)
; CHECK-NEXT:    dmxxinstdmr512 wacc1, vsp36, vsp34, 0
; CHECK-NEXT:    lxvp vsp34, 128(r3)
; CHECK-NEXT:    lxvp vsp36, 160(r3)
; CHECK-NEXT:    dmxxinstdmr512 wacc_hi0, vsp36, vsp34, 1
; CHECK-NEXT:    lxvp vsp34, 192(r3)
; CHECK-NEXT:    lxvp vsp36, 224(r3)
; CHECK-NEXT:    dmxxinstdmr512 wacc0, vsp36, vsp34, 0
; CHECK-NEXT:    dmsha3hash dmrp0, 5
; CHECK-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; CHECK-NEXT:    stxvp vsp34, 224(r4)
; CHECK-NEXT:    stxvp vsp36, 192(r4)
; CHECK-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc_hi0, 1
; CHECK-NEXT:    stxvp vsp34, 160(r4)
; CHECK-NEXT:    stxvp vsp36, 128(r4)
; CHECK-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc1, 0
; CHECK-NEXT:    stxvp vsp34, 96(r4)
; CHECK-NEXT:    stxvp vsp36, 64(r4)
; CHECK-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc_hi1, 1
; CHECK-NEXT:    stxvp vsp34, 32(r4)
; CHECK-NEXT:    stxvp vsp36, 0(r4)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: test_dmsha3hash:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxvp vsp34, 224(r3)
; CHECK-BE-NEXT:    lxvp vsp36, 192(r3)
; CHECK-BE-NEXT:    dmxxinstdmr512 wacc_hi1, vsp36, vsp34, 1
; CHECK-BE-NEXT:    lxvp vsp34, 160(r3)
; CHECK-BE-NEXT:    lxvp vsp36, 128(r3)
; CHECK-BE-NEXT:    dmxxinstdmr512 wacc1, vsp36, vsp34, 0
; CHECK-BE-NEXT:    lxvp vsp34, 96(r3)
; CHECK-BE-NEXT:    lxvp vsp36, 64(r3)
; CHECK-BE-NEXT:    dmxxinstdmr512 wacc_hi0, vsp36, vsp34, 1
; CHECK-BE-NEXT:    lxvp vsp34, 32(r3)
; CHECK-BE-NEXT:    lxvp vsp36, 0(r3)
; CHECK-BE-NEXT:    dmxxinstdmr512 wacc0, vsp36, vsp34, 0
; CHECK-BE-NEXT:    dmsha3hash dmrp0, 5
; CHECK-BE-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc_hi1, 1
; CHECK-BE-NEXT:    stxvp vsp36, 224(r4)
; CHECK-BE-NEXT:    stxvp vsp34, 192(r4)
; CHECK-BE-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc1, 0
; CHECK-BE-NEXT:    stxvp vsp36, 160(r4)
; CHECK-BE-NEXT:    stxvp vsp34, 128(r4)
; CHECK-BE-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc_hi0, 1
; CHECK-BE-NEXT:    stxvp vsp36, 96(r4)
; CHECK-BE-NEXT:    stxvp vsp34, 64(r4)
; CHECK-BE-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; CHECK-BE-NEXT:    stxvp vsp36, 32(r4)
; CHECK-BE-NEXT:    stxvp vsp34, 0(r4)
; CHECK-BE-NEXT:    blr
entry:
  %0 = load <2048 x i1>, ptr %vopp, align 64
  %2 = tail call <2048 x i1> @llvm.ppc.mma.dmsha3hash(<2048 x i1> %0, i32 5)
  store <2048 x i1> %2, ptr %resp, align 64
  ret void
}

declare <1024 x i1> @llvm.ppc.mma.dmxxshapad(<1024 x i1>, <16 x i8>, i32, i32, i32)

define dso_local void @test_dmxxshapad(ptr %vopp, ptr %vcp, ptr %resp) {
; CHECK-LABEL: test_dmxxshapad:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    lxvp vsp34, 0(r3)
; CHECK-NEXT:    lxvp vsp36, 32(r3)
; CHECK-NEXT:    dmxxinstdmr512 wacc_hi0, vsp36, vsp34, 1
; CHECK-NEXT:    lxvp vsp34, 64(r3)
; CHECK-NEXT:    lxvp vsp36, 96(r3)
; CHECK-NEXT:    dmxxinstdmr512 wacc0, vsp36, vsp34, 0
; CHECK-NEXT:    lxv vs0, 0(r4)
; CHECK-NEXT:    dmxxshapad dmr0, vs0, 2, 1, 3
; CHECK-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; CHECK-NEXT:    stxvp vsp34, 96(r5)
; CHECK-NEXT:    stxvp vsp36, 64(r5)
; CHECK-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc_hi0, 1
; CHECK-NEXT:    stxvp vsp34, 32(r5)
; CHECK-NEXT:    stxvp vsp36, 0(r5)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: test_dmxxshapad:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    lxvp vsp34, 96(r3)
; CHECK-BE-NEXT:    lxvp vsp36, 64(r3)
; CHECK-BE-NEXT:    dmxxinstdmr512 wacc_hi0, vsp36, vsp34, 1
; CHECK-BE-NEXT:    lxvp vsp34, 32(r3)
; CHECK-BE-NEXT:    lxvp vsp36, 0(r3)
; CHECK-BE-NEXT:    dmxxinstdmr512 wacc0, vsp36, vsp34, 0
; CHECK-BE-NEXT:    lxv vs0, 0(r4)
; CHECK-BE-NEXT:    dmxxshapad dmr0, vs0, 2, 1, 3
; CHECK-BE-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc_hi0, 1
; CHECK-BE-NEXT:    stxvp vsp36, 96(r5)
; CHECK-BE-NEXT:    stxvp vsp34, 64(r5)
; CHECK-BE-NEXT:    dmxxextfdmr512 vsp34, vsp36, wacc0, 0
; CHECK-BE-NEXT:    stxvp vsp36, 32(r5)
; CHECK-BE-NEXT:    stxvp vsp34, 0(r5)
; CHECK-BE-NEXT:    blr
entry:
  %0 = load <1024 x i1>, ptr %vopp, align 64
  %1 = load <16 x i8>, ptr %vcp, align 64
  %2 = tail call <1024 x i1> @llvm.ppc.mma.dmxxshapad(<1024 x i1> %0, <16 x i8> %1, i32 2, i32 1, i32 3)
  store <1024 x i1> %2, ptr %resp, align 64
  ret void
}
