/*
 *  Copyright 1994-2014 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "context.h"

#include <pulse/simple.h>
#include <pulse/error.h>


u_long id = 1228051674;
u_long options = BEQ_THREAD;

#define INSIZE	512
#define BUFF_SIZE INSIZE * 2 * sizeof(float)


static float pa_buff[BUFF_SIZE];
static pa_simple *pa_s;

void
create(Context_t *ctx)
{
  int error;
  pa_sample_spec ss;

  memset(pa_buff, 0, BUFF_SIZE);

  ss.format = PA_SAMPLE_FLOAT32LE;
  ss.channels = 2;
  ss.rate = 4410;
  
  pa_s = pa_simple_new(NULL,               /* PulseAudio server. */
                       "Biniou",           /* Application's name. */
                       PA_STREAM_RECORD,   /* Stream direction. */
                       NULL,               /* Sink Device. */
                       "Biniou-read",      /* Stream description. */
                       &ss,                /* Sample format. */
                       NULL,               /* Channel map */
                       NULL,               /* Buffering attributes. */
                       &error              /* Error code. */
                       );
  if (pa_s == NULL)
    xerror(__FILE__": pa_simple_new() failed: %s\n",
           pa_strerror(error));
  
#ifdef DEBUG
  char ss_a[PA_SAMPLE_SPEC_SNPRINT_MAX];
  pa_sample_spec_snprint(ss_a, sizeof(ss_a), &ss);
  fprintf(stderr,
          "Opening the recording stream with sample specification '%s'.\n",
          ss_a);
#endif

  ctx->input = Input_new(INSIZE);
  okdone("pulseaudio initialized");
}


void
destroy(Context_t *ctx)
{
  pa_simple_free(pa_s);
  Input_delete(ctx->input);
}


void *
jthread(void *args)
{
  Context_t *ctx = (Context_t *)args;

  while (ctx->running)
    {
      int n;
      int error;
    
      n = pa_simple_read(pa_s, (void *)pa_buff, BUFF_SIZE, &error);
      
      if (!ctx->input->mute && (n != -1))
        {
          int m, idx;
          
          for (m = 0, idx = 0; idx < INSIZE; idx++)
            {
              ctx->input->data[A_LEFT][idx] = pa_buff[m++];
              ctx->input->data[A_RIGHT][idx] = pa_buff[m++];
            }
          Input_set(ctx->input, A_STEREO);
        }
    }

  return NULL;
}
