/*
 * PSTricksConstantsTest.java
 */

package junit.test;


import junit.framework.TestCase;
import latexDraw.psTricks.PSTricksConstants;

import org.junit.*;



/** 
 * This class contains tests for the {@link PSTricksConstants} class.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * 
 * <br>
 * 06/20/07<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
@SuppressWarnings("nls")
public class TestPSTricksConstants extends TestCase
{

	@Test
	public void testIsValidDotStyle()
	{
		assertFalse(PSTricksConstants.isValidDotStyle(null));
		assertFalse(PSTricksConstants.isValidDotStyle("coucou!!"));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.DOT_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.DIAMOND_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.FDIAMOND_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.FPENTAGON_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.PENTAGON_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.FSQUARE_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.SQUARE_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.FTRIANGLE_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.TRIANGLE_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.O_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.OPLUS_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.OTIMES_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.X_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.PLUS_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.BAR_STYLE));
		assertTrue(PSTricksConstants.isValidDotStyle(PSTricksConstants.ASTERISK_STYLE));
	}





	@Test
	public void testIsValidFillStyle()
	{
		assertFalse(PSTricksConstants.isValidArrowStyle(null));
		assertFalse(PSTricksConstants.isValidArrowStyle("coucou!!"));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.NONEARROW_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.RARROW_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.RRBRACKET_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.RSBRACKET_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.LARROW_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.LRBRACKET_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.LSBRACKET_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.SQUAREEND_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.ROUNDIN_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.BARIN_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.CIRCLEIN_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.DISKIN_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.BAREND_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.DISKEND_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.CIRCLEEND_STYLE));
		assertTrue(PSTricksConstants.isValidArrowStyle(PSTricksConstants.ROUNDEND_STYLE));
	}

	

	
	@Test
	public void testIsValidArrowStyle()
	{
		assertFalse(PSTricksConstants.isValidFillStyle(null));
		assertFalse(PSTricksConstants.isValidFillStyle("coucou!!"));
		assertTrue(PSTricksConstants.isValidFillStyle(PSTricksConstants.TOKEN_FILL_CROSSHATCH));
		assertTrue(PSTricksConstants.isValidFillStyle(PSTricksConstants.TOKEN_FILL_CROSSHATCH_F));
		assertTrue(PSTricksConstants.isValidFillStyle(PSTricksConstants.TOKEN_FILL_GRADIENT));
		assertTrue(PSTricksConstants.isValidFillStyle(PSTricksConstants.TOKEN_FILL_HLINES));
		assertTrue(PSTricksConstants.isValidFillStyle(PSTricksConstants.TOKEN_FILL_HLINES_F));
		assertTrue(PSTricksConstants.isValidFillStyle(PSTricksConstants.TOKEN_FILL_NONE));
		assertTrue(PSTricksConstants.isValidFillStyle(PSTricksConstants.TOKEN_FILL_SOLID));
		assertTrue(PSTricksConstants.isValidFillStyle(PSTricksConstants.TOKEN_FILL_VLINES));
		assertTrue(PSTricksConstants.isValidFillStyle(PSTricksConstants.TOKEN_FILL_VLINES_F));
	}

}
