include	"../lib/parser.h"
include	"../lib/prdefs.h"


# PR_PARSE - Parser driver routine for the parser generated by xyacc. This
# procedure opens the configuration file, and call the parser generated by
# xyacc. It returns ERR if errors are found in the configuration file, and
# OK for no errors. All tables allocated by this procedure MUST be freed
# by the calling program if there are no errors. Otherwise they are freed
# before exiting the procedure.

int procedure pr_parse (fname)

char	fname[ARB]		# solution file name

int	fd			# input file descriptor

include	"lexer.com"

extern	pr_lexer()
int	open(), parse(), pr_geti()
#pointer pr_getp()

begin
	# Open the input file.
	if (fname[1] == EOS)
	    call error (0, "ERROR: The configuration file is undefined")
	else
	    fd = open (fname, READ_ONLY, TEXT_FILE)
 
	# Initialize the lexer common variables.
	nlines = 0
	pos = 1
	call strcpy ("\n", line, SZ_LINE)
	call strcpy ("", id, SZ_LINE)

	# Allocate space for parser symbol tables, and code generation table.
	call pr_alloc ()
	call pr_calloc ()

	# Initialize the counters.
	call pr_puti (NERRORS, 0)
	call pr_puti (NWARNINGS, 0)
	call pr_puti (NOBSVARS, 0)
	call pr_puti (NCATVARS, 0)
	call pr_puti (NFITPARS, 0)
	call pr_puti (NTOTPARS, 0)
	call pr_puti (NSETEQS, 0)
	call pr_puti (NEXTEQS, 0)
	call pr_puti (NTRNEQS, 0)

	# Initialize the flags.
	call pr_puti (FLAGERRORS, YES)

	# Initialize the minimum and maximum column values.
	call pr_puti (MINCOL, 1)
	call pr_puti (MINOBSCOL, INDEFI)
	call pr_puti (MINCATCOL, INDEFI)
	call pr_puti (MAXOBSCOL, INDEFI)
	call pr_puti (MAXCATCOL, INDEFI)
		 
	# Parse the input stream. Syntax errors are flaged by an ERR parse()
	# value. Semantic errors are not detected by the parser, but instead
	# by the symbol table procedures. The latter, do not raise an error
	# condition, but they send error messages to the standard output if
	# the FLAGERR flag is set to YES.

	if (parse (fd, false, pr_lexer) == ERR)
	    call pr_error ("Cannot continue parsing", PERR_SYNTAX)

	# Debug ?
	#call dg_prvdump ("From pr_parse before pr_exit")
	#call dg_prtdump ("From pr_parse before pr_exit", pr_getp (SYMTABLE))

	# Check consistency of the symbol table only if there
	# are no errors during the parse. This check may give
	# some errors undetected during the previous parse.

	if (pr_geti (NERRORS) == 0)
	    call pr_exit ()

	# Free code buffer and and close the input file.
	call pr_cfree ()
	call close (fd)

	# Debug ?
	#call dg_prvdump ("From pr_parse")
	#call dg_prtdump ("From pr_parse", pr_getp (SYMTABLE))

	# Return value. If there are errors free all the tables
	# allocated before. Otherwise, keep all tables for later
	# use. They MUST be freed by the calling program.

	# Return the appropriate error code.
	if (pr_geti (NERRORS) == 0) {
	    call pr_puti (FLAGERRORS, NO)
	    return (OK)
	} else {
	    call pr_free ()
	    return (ERR)
	}
end
