#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2008 Alessio Treglia
#
# This file is part of installation-report-generator.
#
# installation-report-generator is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# installation-report-generator is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with installation-report-generator.  If not, see <http://www.gnu.org/licenses/>.

from distutils.core import setup
import irgenerator, irgenerator.globals
from irgenerator.globals import *

import os

langs = ['it', 'es', 'fr']

def languages_path():
    result = []
    for i in langs:
        result.append(("/usr/share/locale/%s/LC_MESSAGES/"%i, ["po/%s/LC_MESSAGES/installation-report-generator.mo"%i]))
    return result

setup(name = SHORT_APPNAME,
      version = '.'.join(map(str,VERSION)),
      description = 'A simple application to help in the generation of the installation report of Ubuntu on laptops.',
      author = AUTHOR,
      author_email = AUTHOR_EMAIL,
      url = 'http://www.alessiotreglia.com/installation-report-generator',
      license = 'GNU GPL v3',
      requires = ['pygtk', 'gtk', 'gtkmvc'],
      platform = ['Platform independent'],
      #scripts = [''],
      packages = ['irgenerator', 'irgenerator.core', 'irgenerator.ui', 'irgenerator.util'],
      data_files = [('/usr/share/pixmaps', ['images/installation-report-generator.png']),
                    ('/usr/share/pixmaps/installation-report-generator',
                        ['images/header.png',
                        'images/installation-report-generator.png',
                        'images/installation-report-generator.svg']),
                    ('/usr/share/applications', ['misc/installation-report-generator.desktop']),
                    ('/usr/share/man/man1', ['misc/installation-report-generator.1.gz']),
                    ('/usr/share/installation-report-generator/glade',
                        ['glade/main_window.glade',
                        'glade/about_dialog.glade']),
                    ('/usr/share/installation-report-generator/plugins',
                        ['plugins/UbuntuItWiki.py',
                        'plugins/Hello.py']),
                    ('/usr/bin', ['scripts/installation-report-generator'])] + languages_path()
      )
