# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
FEDORA_RELEASES ?=
GARDEN_SYSTEMS += $(foreach r,$(FEDORA_RELEASES),$(foreach a,x86_64 aarch64,fedora-cloud-$r.$a))

$(foreach R,$(FEDORA_RELEASES),fedora-cloud-$R.x86_64.run): fedora-cloud-%.x86_64.run: $(MAKEFILE_LIST) | fedora-cloud-%.x86_64.qcow2 fedora-cloud-%.x86_64.efi-code.img fedora-cloud-%.x86_64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/fedora" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

$(foreach R,$(FEDORA_RELEASES),fedora-cloud-$R.aarch64.run): fedora-cloud-%.aarch64.run: $(MAKEFILE_LIST) | fedora-cloud-%.aarch64.qcow2 fedora-cloud-%.aarch64.efi-code.img fedora-cloud-%.aarch64.efi-vars.img
	echo "#!/bin/sh" >$@
	echo 'set -xeu' >>$@
	echo "# WARNING: The .qcow2 file refers to a file in $(GARDEN_DL_DIR)/fedora" >>$@
	echo '$(strip exec $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$(word 1,$|),$(word 2,$|),$(word 3,$|)) "$$@")' >>$@
	chmod +x $@

# Fedora cloud images do not contain a standalone installer that you only need
# during the setup process. Instead each image can be used as a read-only base
# for a read-write template.
$(foreach R,$(FEDORA_RELEASES),fedora-cloud-$R.x86_64.qcow2): fedora-cloud-%.x86_64.qcow2: $(GARDEN_DL_DIR)/fedora/fedora-cloud-base-%.x86_64.qcow2 fedora-cloud-%.seed.iso fedora-cloud-%.x86_64.efi-code.img fedora-cloud-%.x86_64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_X86_64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

# Replicated because we have more releases than architectures and architecture-specific quirks are easier to express.
$(foreach R,$(FEDORA_RELEASES),fedora-cloud-$R.aarch64.qcow2): fedora-cloud-%.aarch64.qcow2: $(GARDEN_DL_DIR)/fedora/fedora-cloud-base-%.aarch64.qcow2 fedora-cloud-%.seed.iso fedora-cloud-%.aarch64.efi-code.img fedora-cloud-%.aarch64.efi-vars.img
	$(strip $(QEMU_IMG) create -f qcow2 -b $< -F qcow2 $@ $(QEMU_IMG_SIZE))
	$(strip $(call QEMU_SYSTEM_AARCH64_EFI_CMDLINE,$@,$(word 3,$^),$(word 4,$^)) \
		-drive file=$(word 2,$^),format=raw,id=drive1,if=none,readonly=true,media=cdrom \
		-device virtio-blk,drive=drive1 \
		-no-reboot | tee $@.log)

# Fedora specific downloads.
$(GARDEN_DL_DIR)/fedora: | $(GARDEN_DL_DIR)
	mkdir -p $@

fedora-cloud-%.meta-data: export META_DATA = $(call CLOUD_INIT_META_DATA_TEMPLATE,fedora-$*)
fedora-cloud-%.meta-data: $(MAKEFILE_LIST)
	echo "$${META_DATA}" | tee $@

fedora-cloud-%.user-data: export USER_DATA = $(call $(call PICK_CLOUD_INIT_USER_DATA_TEMPLATE_FOR,FEDORA,$*),fedora-$*,fedora)
fedora-cloud-%.user-data: $(MAKEFILE_LIST) $(wildcard .image-garden.mk)
	echo "$${USER_DATA}" | tee $@

.PHONY: clean
clean::
	rm -f $(foreach R,$(FEDORA_RELEASES),$(foreach A,x86_64 aarch64,fedora-cloud-$R.$A.qcow2 fedora-cloud-$R.$A.run))
