// This file was generated by the Gtk# code generator.
// Any changes made will be lost if regenerated.

namespace GLib {

	using System;
	using System.Runtime.InteropServices;

#region Autogenerated code
	public partial class FileAdapter : GLib.GInterfaceAdapter, GLib.IFile {

		GLib.Object implementor;

		public FileAdapter (IntPtr handle)
		{
			if (!_gtype.IsInstance (handle))
				throw new ArgumentException ("The gobject doesn't implement the GInterface of this adapter", "handle");
			implementor = GLib.Object.GetObject (handle);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_get_type();

		private static GLib.GType _gtype = new GLib.GType (g_file_get_type ());

		public static GLib.GType GType {
			get {
				return _gtype;
			}
		}

		public override GLib.GType GInterfaceGType {
			get {
				return _gtype;
			}
		}

		public override IntPtr Handle {
			get {
				return implementor.Handle;
			}
		}

		public IntPtr OwnedHandle {
			get {
				return implementor.OwnedHandle;
			}
		}

		public static IFile GetObject (IntPtr handle, bool owned)
		{
			GLib.Object obj = GLib.Object.GetObject (handle, owned);
			return GetObject (obj);
		}

		public static IFile GetObject (GLib.Object obj)
		{
			if (obj == null)
				return null;
			else if (obj as IFile == null)
				return new FileAdapter (obj.Handle);
			else
				return obj as IFile;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_append_to(IntPtr raw, int flags, IntPtr cancellable, out IntPtr error);

		public GLib.FileOutputStream AppendTo(GLib.FileCreateFlags flags, GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_append_to(Handle, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.FileOutputStream ret = GLib.Object.GetObject(raw_ret) as GLib.FileOutputStream;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_append_to_async(IntPtr raw, int flags, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void AppendToAsync(GLib.FileCreateFlags flags, int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_append_to_async(Handle, (int) flags, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_append_to_finish(IntPtr raw, IntPtr res, out IntPtr error);

		public GLib.FileOutputStream AppendToFinish(GLib.IAsyncResult res) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_append_to_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), out error);
			GLib.FileOutputStream ret = GLib.Object.GetObject(raw_ret) as GLib.FileOutputStream;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_copy(IntPtr raw, IntPtr destination, int flags, IntPtr cancellable, GLibSharp.FileProgressCallbackNative progress_callback, IntPtr progress_callback_data, out IntPtr error);

		public bool Copy(GLib.IFile destination, GLib.FileCopyFlags flags, GLib.Cancellable cancellable, GLib.FileProgressCallback progress_callback) {
			GLibSharp.FileProgressCallbackWrapper progress_callback_wrapper = new GLibSharp.FileProgressCallbackWrapper (progress_callback);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_copy(Handle, destination == null ? IntPtr.Zero : ((destination is GLib.Object) ? (destination as GLib.Object).Handle : (destination as GLib.FileAdapter).Handle), (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, progress_callback_wrapper.NativeDelegate, IntPtr.Zero, out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_copy_async(IntPtr raw, IntPtr destination, int flags, int io_priority, IntPtr cancellable, GLibSharp.FileProgressCallbackNative progress_callback, IntPtr progress_callback_data, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void CopyAsync(GLib.IFile destination, GLib.FileCopyFlags flags, int io_priority, GLib.Cancellable cancellable, GLib.FileProgressCallback progress_callback, GLib.AsyncReadyCallback cb) {
			GLibSharp.FileProgressCallbackWrapper progress_callback_wrapper = new GLibSharp.FileProgressCallbackWrapper (progress_callback);
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_copy_async(Handle, destination == null ? IntPtr.Zero : ((destination is GLib.Object) ? (destination as GLib.Object).Handle : (destination as GLib.FileAdapter).Handle), (int) flags, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, progress_callback_wrapper.NativeDelegate, IntPtr.Zero, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_copy_attributes(IntPtr raw, IntPtr destination, int flags, IntPtr cancellable, out IntPtr error);

		public bool CopyAttributes(GLib.IFile destination, GLib.FileCopyFlags flags, GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_copy_attributes(Handle, destination == null ? IntPtr.Zero : ((destination is GLib.Object) ? (destination as GLib.Object).Handle : (destination as GLib.FileAdapter).Handle), (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_copy_finish(IntPtr raw, IntPtr res, out IntPtr error);

		public bool CopyFinish(GLib.IAsyncResult res) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_copy_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_create(IntPtr raw, int flags, IntPtr cancellable, out IntPtr error);

		public GLib.FileOutputStream Create(GLib.FileCreateFlags flags, GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_create(Handle, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.FileOutputStream ret = GLib.Object.GetObject(raw_ret) as GLib.FileOutputStream;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_create_async(IntPtr raw, int flags, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void CreateAsync(GLib.FileCreateFlags flags, int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_create_async(Handle, (int) flags, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_create_finish(IntPtr raw, IntPtr res, out IntPtr error);

		public GLib.FileOutputStream CreateFinish(GLib.IAsyncResult res) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_create_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), out error);
			GLib.FileOutputStream ret = GLib.Object.GetObject(raw_ret) as GLib.FileOutputStream;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_create_readwrite(IntPtr raw, int flags, IntPtr cancellable, out IntPtr error);

		public GLib.FileIOStream CreateReadwrite(GLib.FileCreateFlags flags, GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_create_readwrite(Handle, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.FileIOStream ret = GLib.Object.GetObject(raw_ret) as GLib.FileIOStream;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_create_readwrite_async(IntPtr raw, int flags, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void CreateReadwriteAsync(GLib.FileCreateFlags flags, int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_create_readwrite_async(Handle, (int) flags, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_create_readwrite_finish(IntPtr raw, IntPtr res, out IntPtr error);

		public GLib.FileIOStream CreateReadwriteFinish(GLib.IAsyncResult res) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_create_readwrite_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), out error);
			GLib.FileIOStream ret = GLib.Object.GetObject(raw_ret) as GLib.FileIOStream;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_delete(IntPtr raw, IntPtr cancellable, out IntPtr error);

		public bool Delete(GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_delete(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_delete_async(IntPtr raw, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void DeleteAsync(int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_delete_async(Handle, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_delete_finish(IntPtr raw, IntPtr result, out IntPtr error);

		public bool DeleteFinish(GLib.IAsyncResult result) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_delete_finish(Handle, result == null ? IntPtr.Zero : ((result is GLib.Object) ? (result as GLib.Object).Handle : (result as GLib.AsyncResultAdapter).Handle), out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_dup(IntPtr raw);

		public GLib.IFile Dup() {
			IntPtr raw_ret = g_file_dup(Handle);
			GLib.IFile ret = GLib.FileAdapter.GetObject (raw_ret, false);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_eject_mountable_with_operation(IntPtr raw, int flags, IntPtr mount_operation, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void EjectMountableWithOperation(GLib.MountUnmountFlags flags, GLib.MountOperation mount_operation, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_eject_mountable_with_operation(Handle, (int) flags, mount_operation == null ? IntPtr.Zero : mount_operation.Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_eject_mountable_with_operation_finish(IntPtr raw, IntPtr result, out IntPtr error);

		public bool EjectMountableWithOperationFinish(GLib.IAsyncResult result) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_eject_mountable_with_operation_finish(Handle, result == null ? IntPtr.Zero : ((result is GLib.Object) ? (result as GLib.Object).Handle : (result as GLib.AsyncResultAdapter).Handle), out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_enumerate_children(IntPtr raw, IntPtr attributes, int flags, IntPtr cancellable, out IntPtr error);

		public GLib.FileEnumerator EnumerateChildren(string attributes, GLib.FileQueryInfoFlags flags, GLib.Cancellable cancellable) {
			IntPtr native_attributes = GLib.Marshaller.StringToPtrGStrdup (attributes);
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_enumerate_children(Handle, native_attributes, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.FileEnumerator ret = GLib.Object.GetObject(raw_ret) as GLib.FileEnumerator;
			GLib.Marshaller.Free (native_attributes);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_enumerate_children_async(IntPtr raw, IntPtr attributes, int flags, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void EnumerateChildrenAsync(string attributes, GLib.FileQueryInfoFlags flags, int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			IntPtr native_attributes = GLib.Marshaller.StringToPtrGStrdup (attributes);
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_enumerate_children_async(Handle, native_attributes, (int) flags, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
			GLib.Marshaller.Free (native_attributes);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_enumerate_children_finish(IntPtr raw, IntPtr res, out IntPtr error);

		public GLib.FileEnumerator EnumerateChildrenFinish(GLib.IAsyncResult res) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_enumerate_children_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), out error);
			GLib.FileEnumerator ret = GLib.Object.GetObject(raw_ret) as GLib.FileEnumerator;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_equal(IntPtr raw, IntPtr file2);

		public bool Equal(GLib.IFile file2) {
			bool raw_ret = g_file_equal(Handle, file2 == null ? IntPtr.Zero : ((file2 is GLib.Object) ? (file2 as GLib.Object).Handle : (file2 as GLib.FileAdapter).Handle));
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_find_enclosing_mount(IntPtr raw, IntPtr cancellable, out IntPtr error);

		public GLib.IMount FindEnclosingMount(GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_find_enclosing_mount(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.IMount ret = GLib.MountAdapter.GetObject (raw_ret, false);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_find_enclosing_mount_async(IntPtr raw, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void FindEnclosingMountAsync(int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_find_enclosing_mount_async(Handle, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_find_enclosing_mount_finish(IntPtr raw, IntPtr res, out IntPtr error);

		public GLib.IMount FindEnclosingMountFinish(GLib.IAsyncResult res) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_find_enclosing_mount_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), out error);
			GLib.IMount ret = GLib.MountAdapter.GetObject (raw_ret, false);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_get_basename(IntPtr raw);

		public string Basename { 
			get {
				IntPtr raw_ret = g_file_get_basename(Handle);
				string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
				return ret;
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_get_child(IntPtr raw, IntPtr name);

		public GLib.IFile GetChild(string name) {
			IntPtr native_name = GLib.Marshaller.StringToPtrGStrdup (name);
			IntPtr raw_ret = g_file_get_child(Handle, native_name);
			GLib.IFile ret = GLib.FileAdapter.GetObject (raw_ret, false);
			GLib.Marshaller.Free (native_name);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_get_child_for_display_name(IntPtr raw, IntPtr display_name, out IntPtr error);

		public GLib.IFile GetChildForDisplayName(string display_name) {
			IntPtr native_display_name = GLib.Marshaller.StringToPtrGStrdup (display_name);
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_get_child_for_display_name(Handle, native_display_name, out error);
			GLib.IFile ret = GLib.FileAdapter.GetObject (raw_ret, false);
			GLib.Marshaller.Free (native_display_name);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_get_parent(IntPtr raw);

		public GLib.IFile Parent { 
			get {
				IntPtr raw_ret = g_file_get_parent(Handle);
				GLib.IFile ret = GLib.FileAdapter.GetObject (raw_ret, false);
				return ret;
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_get_parse_name(IntPtr raw);

		public string ParsedName { 
			get {
				IntPtr raw_ret = g_file_get_parse_name(Handle);
				string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
				return ret;
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_get_path(IntPtr raw);

		public string Path { 
			get {
				IntPtr raw_ret = g_file_get_path(Handle);
				string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
				return ret;
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_get_relative_path(IntPtr raw, IntPtr descendant);

		public string GetRelativePath(GLib.IFile descendant) {
			IntPtr raw_ret = g_file_get_relative_path(Handle, descendant == null ? IntPtr.Zero : ((descendant is GLib.Object) ? (descendant as GLib.Object).Handle : (descendant as GLib.FileAdapter).Handle));
			string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_get_uri_scheme(IntPtr raw);

		public string UriScheme { 
			get {
				IntPtr raw_ret = g_file_get_uri_scheme(Handle);
				string ret = GLib.Marshaller.PtrToStringGFree(raw_ret);
				return ret;
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_has_parent(IntPtr raw, IntPtr parent);

		public bool HasParent(GLib.IFile parent) {
			bool raw_ret = g_file_has_parent(Handle, parent == null ? IntPtr.Zero : ((parent is GLib.Object) ? (parent as GLib.Object).Handle : (parent as GLib.FileAdapter).Handle));
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_has_prefix(IntPtr raw, IntPtr prefix);

		public bool HasPrefix(GLib.IFile prefix) {
			bool raw_ret = g_file_has_prefix(Handle, prefix == null ? IntPtr.Zero : ((prefix is GLib.Object) ? (prefix as GLib.Object).Handle : (prefix as GLib.FileAdapter).Handle));
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_has_uri_scheme(IntPtr raw, IntPtr uri_scheme);

		public bool HasUriScheme(string uri_scheme) {
			IntPtr native_uri_scheme = GLib.Marshaller.StringToPtrGStrdup (uri_scheme);
			bool raw_ret = g_file_has_uri_scheme(Handle, native_uri_scheme);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_uri_scheme);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern uint g_file_hash(IntPtr file);

		public static uint Hash(IntPtr file) {
			uint raw_ret = g_file_hash(file);
			uint ret = raw_ret;
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_is_native(IntPtr raw);

		public bool IsNative { 
			get {
				bool raw_ret = g_file_is_native(Handle);
				bool ret = raw_ret;
				return ret;
			}
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_load_contents(IntPtr raw, IntPtr cancellable, IntPtr contents, out UIntPtr length, IntPtr etag_out, out IntPtr error);

		public bool LoadContents(GLib.Cancellable cancellable, string contents, out ulong length, string etag_out) {
			UIntPtr native_length;
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_load_contents(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, GLib.Marshaller.StringToPtrGStrdup(contents), out native_length, GLib.Marshaller.StringToPtrGStrdup(etag_out), out error);
			bool ret = raw_ret;
			length = (ulong) native_length;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_load_contents_async(IntPtr raw, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void LoadContentsAsync(GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_load_contents_async(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_load_contents_finish(IntPtr raw, IntPtr res, IntPtr contents, out UIntPtr length, IntPtr etag_out, out IntPtr error);

		public bool LoadContentsFinish(GLib.IAsyncResult res, string contents, out ulong length, string etag_out) {
			UIntPtr native_length;
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_load_contents_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), GLib.Marshaller.StringToPtrGStrdup(contents), out native_length, GLib.Marshaller.StringToPtrGStrdup(etag_out), out error);
			bool ret = raw_ret;
			length = (ulong) native_length;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_load_partial_contents_async(IntPtr raw, IntPtr cancellable, GLibSharp.FileReadMoreCallbackNative read_more_callback, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void LoadPartialContentsAsync(GLib.Cancellable cancellable, GLib.FileReadMoreCallback read_more_callback, GLib.AsyncReadyCallback cb) {
			GLibSharp.FileReadMoreCallbackWrapper read_more_callback_wrapper = new GLibSharp.FileReadMoreCallbackWrapper (read_more_callback);
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_load_partial_contents_async(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, read_more_callback_wrapper.NativeDelegate, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_load_partial_contents_finish(IntPtr raw, IntPtr res, IntPtr contents, out UIntPtr length, IntPtr etag_out, out IntPtr error);

		public bool LoadPartialContentsFinish(GLib.IAsyncResult res, string contents, out ulong length, string etag_out) {
			UIntPtr native_length;
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_load_partial_contents_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), GLib.Marshaller.StringToPtrGStrdup(contents), out native_length, GLib.Marshaller.StringToPtrGStrdup(etag_out), out error);
			bool ret = raw_ret;
			length = (ulong) native_length;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_make_directory(IntPtr raw, IntPtr cancellable, out IntPtr error);

		public bool MakeDirectory(GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_make_directory(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_make_directory_async(IntPtr raw, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void MakeDirectoryAsync(int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_make_directory_async(Handle, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_make_directory_finish(IntPtr raw, IntPtr result, out IntPtr error);

		public bool MakeDirectoryFinish(GLib.IAsyncResult result) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_make_directory_finish(Handle, result == null ? IntPtr.Zero : ((result is GLib.Object) ? (result as GLib.Object).Handle : (result as GLib.AsyncResultAdapter).Handle), out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_make_directory_with_parents(IntPtr raw, IntPtr cancellable, out IntPtr error);

		public bool MakeDirectoryWithParents(GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_make_directory_with_parents(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_make_symbolic_link(IntPtr raw, IntPtr symlink_value, IntPtr cancellable, out IntPtr error);

		public bool MakeSymbolicLink(string symlink_value, GLib.Cancellable cancellable) {
			IntPtr native_symlink_value = GLib.Marshaller.StringToPtrGStrdup (symlink_value);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_make_symbolic_link(Handle, native_symlink_value, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_symlink_value);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_measure_disk_usage(IntPtr raw, int flags, IntPtr cancellable, GLibSharp.FileMeasureProgressCallbackNative progress_callback, IntPtr progress_data, out ulong disk_usage, out ulong num_dirs, out ulong num_files, out IntPtr error);

		public bool MeasureDiskUsage(GLib.FileMeasureFlags flags, GLib.Cancellable cancellable, GLib.FileMeasureProgressCallback progress_callback, out ulong disk_usage, out ulong num_dirs, out ulong num_files) {
			GLibSharp.FileMeasureProgressCallbackWrapper progress_callback_wrapper = new GLibSharp.FileMeasureProgressCallbackWrapper (progress_callback);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_measure_disk_usage(Handle, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, progress_callback_wrapper.NativeDelegate, IntPtr.Zero, out disk_usage, out num_dirs, out num_files, out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_measure_disk_usage_async(IntPtr raw, int flags, int io_priority, IntPtr cancellable, GLibSharp.FileMeasureProgressCallbackNative progress_callback, IntPtr progress_data, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void MeasureDiskUsageAsync(GLib.FileMeasureFlags flags, int io_priority, GLib.Cancellable cancellable, GLib.FileMeasureProgressCallback progress_callback, GLib.AsyncReadyCallback cb) {
			GLibSharp.FileMeasureProgressCallbackWrapper progress_callback_wrapper = new GLibSharp.FileMeasureProgressCallbackWrapper (progress_callback);
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_measure_disk_usage_async(Handle, (int) flags, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, progress_callback_wrapper.NativeDelegate, IntPtr.Zero, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_measure_disk_usage_finish(IntPtr raw, IntPtr result, out ulong disk_usage, out ulong num_dirs, out ulong num_files, out IntPtr error);

		public bool MeasureDiskUsageFinish(GLib.IAsyncResult result, out ulong disk_usage, out ulong num_dirs, out ulong num_files) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_measure_disk_usage_finish(Handle, result == null ? IntPtr.Zero : ((result is GLib.Object) ? (result as GLib.Object).Handle : (result as GLib.AsyncResultAdapter).Handle), out disk_usage, out num_dirs, out num_files, out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_monitor(IntPtr raw, int flags, IntPtr cancellable, out IntPtr error);

		public GLib.FileMonitor Monitor(GLib.FileMonitorFlags flags, GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_monitor(Handle, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.FileMonitor ret = GLib.Object.GetObject(raw_ret) as GLib.FileMonitor;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_mount_enclosing_volume(IntPtr raw, int flags, IntPtr mount_operation, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void MountEnclosingVolume(GLib.MountMountFlags flags, GLib.MountOperation mount_operation, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_mount_enclosing_volume(Handle, (int) flags, mount_operation == null ? IntPtr.Zero : mount_operation.Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_mount_enclosing_volume_finish(IntPtr raw, IntPtr result, out IntPtr error);

		public bool MountEnclosingVolumeFinish(GLib.IAsyncResult result) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_mount_enclosing_volume_finish(Handle, result == null ? IntPtr.Zero : ((result is GLib.Object) ? (result as GLib.Object).Handle : (result as GLib.AsyncResultAdapter).Handle), out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_mount_mountable(IntPtr raw, int flags, IntPtr mount_operation, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void MountMountable(GLib.MountMountFlags flags, GLib.MountOperation mount_operation, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_mount_mountable(Handle, (int) flags, mount_operation == null ? IntPtr.Zero : mount_operation.Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_mount_mountable_finish(IntPtr raw, IntPtr result, out IntPtr error);

		public GLib.IFile MountMountableFinish(GLib.IAsyncResult result) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_mount_mountable_finish(Handle, result == null ? IntPtr.Zero : ((result is GLib.Object) ? (result as GLib.Object).Handle : (result as GLib.AsyncResultAdapter).Handle), out error);
			GLib.IFile ret = GLib.FileAdapter.GetObject (raw_ret, false);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_move(IntPtr raw, IntPtr destination, int flags, IntPtr cancellable, GLibSharp.FileProgressCallbackNative progress_callback, IntPtr progress_callback_data, out IntPtr error);

		public bool Move(GLib.IFile destination, GLib.FileCopyFlags flags, GLib.Cancellable cancellable, GLib.FileProgressCallback progress_callback) {
			GLibSharp.FileProgressCallbackWrapper progress_callback_wrapper = new GLibSharp.FileProgressCallbackWrapper (progress_callback);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_move(Handle, destination == null ? IntPtr.Zero : ((destination is GLib.Object) ? (destination as GLib.Object).Handle : (destination as GLib.FileAdapter).Handle), (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, progress_callback_wrapper.NativeDelegate, IntPtr.Zero, out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_open_readwrite(IntPtr raw, IntPtr cancellable, out IntPtr error);

		public GLib.FileIOStream OpenReadwrite(GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_open_readwrite(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.FileIOStream ret = GLib.Object.GetObject(raw_ret) as GLib.FileIOStream;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_open_readwrite_async(IntPtr raw, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void OpenReadwriteAsync(int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_open_readwrite_async(Handle, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_open_readwrite_finish(IntPtr raw, IntPtr res, out IntPtr error);

		public GLib.FileIOStream OpenReadwriteFinish(GLib.IAsyncResult res) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_open_readwrite_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), out error);
			GLib.FileIOStream ret = GLib.Object.GetObject(raw_ret) as GLib.FileIOStream;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_parse_name(IntPtr parse_name);

		public static GLib.IFile ParseName(string parse_name) {
			IntPtr native_parse_name = GLib.Marshaller.StringToPtrGStrdup (parse_name);
			IntPtr raw_ret = g_file_parse_name(native_parse_name);
			GLib.IFile ret = GLib.FileAdapter.GetObject (raw_ret, false);
			GLib.Marshaller.Free (native_parse_name);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_poll_mountable(IntPtr raw, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void PollMountable(GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_poll_mountable(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_poll_mountable_finish(IntPtr raw, IntPtr result, out IntPtr error);

		public bool PollMountableFinish(GLib.IAsyncResult result) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_poll_mountable_finish(Handle, result == null ? IntPtr.Zero : ((result is GLib.Object) ? (result as GLib.Object).Handle : (result as GLib.AsyncResultAdapter).Handle), out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_query_default_handler(IntPtr raw, IntPtr cancellable, out IntPtr error);

		public GLib.IAppInfo QueryDefaultHandler(GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_query_default_handler(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.IAppInfo ret = GLib.AppInfoAdapter.GetObject (raw_ret, false);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_query_exists(IntPtr raw, IntPtr cancellable);

		public bool QueryExists(GLib.Cancellable cancellable) {
			bool raw_ret = g_file_query_exists(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern int g_file_query_file_type(IntPtr raw, int flags, IntPtr cancellable);

		public GLib.FileType QueryFileType(GLib.FileQueryInfoFlags flags, GLib.Cancellable cancellable) {
			int raw_ret = g_file_query_file_type(Handle, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle);
			GLib.FileType ret = (GLib.FileType) raw_ret;
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_query_filesystem_info(IntPtr raw, IntPtr attributes, IntPtr cancellable, out IntPtr error);

		public GLib.FileInfo QueryFilesystemInfo(string attributes, GLib.Cancellable cancellable) {
			IntPtr native_attributes = GLib.Marshaller.StringToPtrGStrdup (attributes);
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_query_filesystem_info(Handle, native_attributes, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.FileInfo ret = GLib.Object.GetObject(raw_ret) as GLib.FileInfo;
			GLib.Marshaller.Free (native_attributes);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_query_filesystem_info_async(IntPtr raw, IntPtr attributes, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void QueryFilesystemInfoAsync(string attributes, int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			IntPtr native_attributes = GLib.Marshaller.StringToPtrGStrdup (attributes);
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_query_filesystem_info_async(Handle, native_attributes, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
			GLib.Marshaller.Free (native_attributes);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_query_filesystem_info_finish(IntPtr raw, IntPtr res, out IntPtr error);

		public GLib.FileInfo QueryFilesystemInfoFinish(GLib.IAsyncResult res) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_query_filesystem_info_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), out error);
			GLib.FileInfo ret = GLib.Object.GetObject(raw_ret) as GLib.FileInfo;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_query_info(IntPtr raw, IntPtr attributes, int flags, IntPtr cancellable, out IntPtr error);

		public GLib.FileInfo QueryInfo(string attributes, GLib.FileQueryInfoFlags flags, GLib.Cancellable cancellable) {
			IntPtr native_attributes = GLib.Marshaller.StringToPtrGStrdup (attributes);
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_query_info(Handle, native_attributes, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.FileInfo ret = GLib.Object.GetObject(raw_ret, true) as GLib.FileInfo;
			GLib.Marshaller.Free (native_attributes);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_query_info_async(IntPtr raw, IntPtr attributes, int flags, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void QueryInfoAsync(string attributes, GLib.FileQueryInfoFlags flags, int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			IntPtr native_attributes = GLib.Marshaller.StringToPtrGStrdup (attributes);
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_query_info_async(Handle, native_attributes, (int) flags, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
			GLib.Marshaller.Free (native_attributes);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_query_info_finish(IntPtr raw, IntPtr res, out IntPtr error);

		public GLib.FileInfo QueryInfoFinish(GLib.IAsyncResult res) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_query_info_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), out error);
			GLib.FileInfo ret = GLib.Object.GetObject(raw_ret, true) as GLib.FileInfo;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_query_settable_attributes(IntPtr raw, IntPtr cancellable, out IntPtr error);

		public GLib.FileAttributeInfoList QuerySettableAttributes(GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_query_settable_attributes(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.FileAttributeInfoList ret = raw_ret == IntPtr.Zero ? null : (GLib.FileAttributeInfoList) GLib.Opaque.GetOpaque (raw_ret, typeof (GLib.FileAttributeInfoList), false);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_query_writable_namespaces(IntPtr raw, IntPtr cancellable, out IntPtr error);

		public GLib.FileAttributeInfoList QueryWritableNamespaces(GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_query_writable_namespaces(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.FileAttributeInfoList ret = raw_ret == IntPtr.Zero ? null : (GLib.FileAttributeInfoList) GLib.Opaque.GetOpaque (raw_ret, typeof (GLib.FileAttributeInfoList), false);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_read(IntPtr raw, IntPtr cancellable, out IntPtr error);

		public GLib.FileInputStream Read(GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_read(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.FileInputStream ret = GLib.Object.GetObject(raw_ret) as GLib.FileInputStream;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_read_async(IntPtr raw, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void ReadAsync(int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_read_async(Handle, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_read_finish(IntPtr raw, IntPtr res, out IntPtr error);

		public GLib.FileInputStream ReadFinish(GLib.IAsyncResult res) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_read_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), out error);
			GLib.FileInputStream ret = GLib.Object.GetObject(raw_ret) as GLib.FileInputStream;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_replace(IntPtr raw, IntPtr etag, bool make_backup, int flags, IntPtr cancellable, out IntPtr error);

		public GLib.FileOutputStream Replace(string etag, bool make_backup, GLib.FileCreateFlags flags, GLib.Cancellable cancellable) {
			IntPtr native_etag = GLib.Marshaller.StringToPtrGStrdup (etag);
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_replace(Handle, native_etag, make_backup, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.FileOutputStream ret = GLib.Object.GetObject(raw_ret) as GLib.FileOutputStream;
			GLib.Marshaller.Free (native_etag);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_replace_async(IntPtr raw, IntPtr etag, bool make_backup, int flags, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void ReplaceAsync(string etag, bool make_backup, GLib.FileCreateFlags flags, int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			IntPtr native_etag = GLib.Marshaller.StringToPtrGStrdup (etag);
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_replace_async(Handle, native_etag, make_backup, (int) flags, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
			GLib.Marshaller.Free (native_etag);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_replace_contents(IntPtr raw, IntPtr contents, UIntPtr length, IntPtr etag, bool make_backup, int flags, IntPtr new_etag, IntPtr cancellable, out IntPtr error);

		public bool ReplaceContents(string contents, string etag, bool make_backup, GLib.FileCreateFlags flags, string new_etag, GLib.Cancellable cancellable) {
			IntPtr native_contents = GLib.Marshaller.StringToPtrGStrdup (contents);
			IntPtr native_etag = GLib.Marshaller.StringToPtrGStrdup (etag);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_replace_contents(Handle, native_contents, new UIntPtr ((ulong) System.Text.Encoding.UTF8.GetByteCount (contents)), native_etag, make_backup, (int) flags, GLib.Marshaller.StringToPtrGStrdup(new_etag), cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_contents);
			GLib.Marshaller.Free (native_etag);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_replace_contents_async(IntPtr raw, IntPtr contents, UIntPtr length, IntPtr etag, bool make_backup, int flags, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void ReplaceContentsAsync(string contents, string etag, bool make_backup, GLib.FileCreateFlags flags, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			IntPtr native_contents = GLib.Marshaller.StringToPtrGStrdup (contents);
			IntPtr native_etag = GLib.Marshaller.StringToPtrGStrdup (etag);
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_replace_contents_async(Handle, native_contents, new UIntPtr ((ulong) System.Text.Encoding.UTF8.GetByteCount (contents)), native_etag, make_backup, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
			GLib.Marshaller.Free (native_contents);
			GLib.Marshaller.Free (native_etag);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_replace_contents_bytes_async(IntPtr raw, IntPtr contents, IntPtr etag, bool make_backup, int flags, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void ReplaceContentsBytesAsync(GLib.Bytes contents, string etag, bool make_backup, GLib.FileCreateFlags flags, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			IntPtr native_etag = GLib.Marshaller.StringToPtrGStrdup (etag);
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_replace_contents_bytes_async(Handle, contents == null ? IntPtr.Zero : contents.Handle, native_etag, make_backup, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
			GLib.Marshaller.Free (native_etag);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_replace_contents_finish(IntPtr raw, IntPtr res, IntPtr new_etag, out IntPtr error);

		public bool ReplaceContentsFinish(GLib.IAsyncResult res, string new_etag) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_replace_contents_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), GLib.Marshaller.StringToPtrGStrdup(new_etag), out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_replace_finish(IntPtr raw, IntPtr res, out IntPtr error);

		public GLib.FileOutputStream ReplaceFinish(GLib.IAsyncResult res) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_replace_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), out error);
			GLib.FileOutputStream ret = GLib.Object.GetObject(raw_ret) as GLib.FileOutputStream;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_replace_readwrite(IntPtr raw, IntPtr etag, bool make_backup, int flags, IntPtr cancellable, out IntPtr error);

		public GLib.FileIOStream ReplaceReadwrite(string etag, bool make_backup, GLib.FileCreateFlags flags, GLib.Cancellable cancellable) {
			IntPtr native_etag = GLib.Marshaller.StringToPtrGStrdup (etag);
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_replace_readwrite(Handle, native_etag, make_backup, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.FileIOStream ret = GLib.Object.GetObject(raw_ret) as GLib.FileIOStream;
			GLib.Marshaller.Free (native_etag);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_replace_readwrite_async(IntPtr raw, IntPtr etag, bool make_backup, int flags, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void ReplaceReadwriteAsync(string etag, bool make_backup, GLib.FileCreateFlags flags, int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			IntPtr native_etag = GLib.Marshaller.StringToPtrGStrdup (etag);
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_replace_readwrite_async(Handle, native_etag, make_backup, (int) flags, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
			GLib.Marshaller.Free (native_etag);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_replace_readwrite_finish(IntPtr raw, IntPtr res, out IntPtr error);

		public GLib.FileIOStream ReplaceReadwriteFinish(GLib.IAsyncResult res) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_replace_readwrite_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), out error);
			GLib.FileIOStream ret = GLib.Object.GetObject(raw_ret) as GLib.FileIOStream;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_resolve_relative_path(IntPtr raw, IntPtr relative_path);

		public GLib.IFile ResolveRelativePath(string relative_path) {
			IntPtr native_relative_path = GLib.Marshaller.StringToPtrGStrdup (relative_path);
			IntPtr raw_ret = g_file_resolve_relative_path(Handle, native_relative_path);
			GLib.IFile ret = GLib.FileAdapter.GetObject (raw_ret, false);
			GLib.Marshaller.Free (native_relative_path);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_set_attribute(IntPtr raw, IntPtr attribute, int type, IntPtr value_p, int flags, IntPtr cancellable, out IntPtr error);

		public bool SetAttribute(string attribute, GLib.FileAttributeType type, IntPtr value_p, GLib.FileQueryInfoFlags flags, GLib.Cancellable cancellable) {
			IntPtr native_attribute = GLib.Marshaller.StringToPtrGStrdup (attribute);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_set_attribute(Handle, native_attribute, (int) type, value_p, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_attribute);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_set_attribute_byte_string(IntPtr raw, IntPtr attribute, IntPtr value, int flags, IntPtr cancellable, out IntPtr error);

		public bool SetAttributeByteString(string attribute, string value, GLib.FileQueryInfoFlags flags, GLib.Cancellable cancellable) {
			IntPtr native_attribute = GLib.Marshaller.StringToPtrGStrdup (attribute);
			IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_set_attribute_byte_string(Handle, native_attribute, native_value, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_attribute);
			GLib.Marshaller.Free (native_value);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_set_attribute_int32(IntPtr raw, IntPtr attribute, int value, int flags, IntPtr cancellable, out IntPtr error);

		public bool SetAttributeInt32(string attribute, int value, GLib.FileQueryInfoFlags flags, GLib.Cancellable cancellable) {
			IntPtr native_attribute = GLib.Marshaller.StringToPtrGStrdup (attribute);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_set_attribute_int32(Handle, native_attribute, value, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_attribute);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_set_attribute_int64(IntPtr raw, IntPtr attribute, long value, int flags, IntPtr cancellable, out IntPtr error);

		public bool SetAttributeInt64(string attribute, long value, GLib.FileQueryInfoFlags flags, GLib.Cancellable cancellable) {
			IntPtr native_attribute = GLib.Marshaller.StringToPtrGStrdup (attribute);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_set_attribute_int64(Handle, native_attribute, value, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_attribute);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_set_attribute_string(IntPtr raw, IntPtr attribute, IntPtr value, int flags, IntPtr cancellable, out IntPtr error);

		public bool SetAttributeString(string attribute, string value, GLib.FileQueryInfoFlags flags, GLib.Cancellable cancellable) {
			IntPtr native_attribute = GLib.Marshaller.StringToPtrGStrdup (attribute);
			IntPtr native_value = GLib.Marshaller.StringToPtrGStrdup (value);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_set_attribute_string(Handle, native_attribute, native_value, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_attribute);
			GLib.Marshaller.Free (native_value);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_set_attribute_uint32(IntPtr raw, IntPtr attribute, uint value, int flags, IntPtr cancellable, out IntPtr error);

		public bool SetAttributeUint32(string attribute, uint value, GLib.FileQueryInfoFlags flags, GLib.Cancellable cancellable) {
			IntPtr native_attribute = GLib.Marshaller.StringToPtrGStrdup (attribute);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_set_attribute_uint32(Handle, native_attribute, value, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_attribute);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_set_attribute_uint64(IntPtr raw, IntPtr attribute, ulong value, int flags, IntPtr cancellable, out IntPtr error);

		public bool SetAttributeUint64(string attribute, ulong value, GLib.FileQueryInfoFlags flags, GLib.Cancellable cancellable) {
			IntPtr native_attribute = GLib.Marshaller.StringToPtrGStrdup (attribute);
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_set_attribute_uint64(Handle, native_attribute, value, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			GLib.Marshaller.Free (native_attribute);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_set_attributes_async(IntPtr raw, IntPtr info, int flags, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void SetAttributesAsync(GLib.FileInfo info, GLib.FileQueryInfoFlags flags, int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_set_attributes_async(Handle, info == null ? IntPtr.Zero : info.Handle, (int) flags, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_set_attributes_finish(IntPtr raw, IntPtr result, IntPtr info, out IntPtr error);

		public bool SetAttributesFinish(GLib.IAsyncResult result, GLib.FileInfo info) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_set_attributes_finish(Handle, result == null ? IntPtr.Zero : ((result is GLib.Object) ? (result as GLib.Object).Handle : (result as GLib.AsyncResultAdapter).Handle), info == null ? IntPtr.Zero : info.Handle, out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_set_attributes_from_info(IntPtr raw, IntPtr info, int flags, IntPtr cancellable, out IntPtr error);

		public bool SetAttributesFromInfo(GLib.FileInfo info, GLib.FileQueryInfoFlags flags, GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_set_attributes_from_info(Handle, info == null ? IntPtr.Zero : info.Handle, (int) flags, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_set_display_name(IntPtr raw, IntPtr display_name, IntPtr cancellable, out IntPtr error);

		public GLib.IFile SetDisplayName(string display_name, GLib.Cancellable cancellable) {
			IntPtr native_display_name = GLib.Marshaller.StringToPtrGStrdup (display_name);
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_set_display_name(Handle, native_display_name, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			GLib.IFile ret = GLib.FileAdapter.GetObject (raw_ret, false);
			GLib.Marshaller.Free (native_display_name);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_set_display_name_async(IntPtr raw, IntPtr display_name, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void SetDisplayNameAsync(string display_name, int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			IntPtr native_display_name = GLib.Marshaller.StringToPtrGStrdup (display_name);
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_set_display_name_async(Handle, native_display_name, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
			GLib.Marshaller.Free (native_display_name);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern IntPtr g_file_set_display_name_finish(IntPtr raw, IntPtr res, out IntPtr error);

		public GLib.IFile SetDisplayNameFinish(GLib.IAsyncResult res) {
			IntPtr error = IntPtr.Zero;
			IntPtr raw_ret = g_file_set_display_name_finish(Handle, res == null ? IntPtr.Zero : ((res is GLib.Object) ? (res as GLib.Object).Handle : (res as GLib.AsyncResultAdapter).Handle), out error);
			GLib.IFile ret = GLib.FileAdapter.GetObject (raw_ret, false);
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_start_mountable(IntPtr raw, int flags, IntPtr start_operation, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void StartMountable(GLib.DriveStartFlags flags, GLib.MountOperation start_operation, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_start_mountable(Handle, (int) flags, start_operation == null ? IntPtr.Zero : start_operation.Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_start_mountable_finish(IntPtr raw, IntPtr result, out IntPtr error);

		public bool StartMountableFinish(GLib.IAsyncResult result) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_start_mountable_finish(Handle, result == null ? IntPtr.Zero : ((result is GLib.Object) ? (result as GLib.Object).Handle : (result as GLib.AsyncResultAdapter).Handle), out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_stop_mountable(IntPtr raw, int flags, IntPtr mount_operation, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void StopMountable(GLib.MountUnmountFlags flags, GLib.MountOperation mount_operation, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_stop_mountable(Handle, (int) flags, mount_operation == null ? IntPtr.Zero : mount_operation.Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_stop_mountable_finish(IntPtr raw, IntPtr result, out IntPtr error);

		public bool StopMountableFinish(GLib.IAsyncResult result) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_stop_mountable_finish(Handle, result == null ? IntPtr.Zero : ((result is GLib.Object) ? (result as GLib.Object).Handle : (result as GLib.AsyncResultAdapter).Handle), out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_supports_thread_contexts(IntPtr raw);

		public bool SupportsThreadContexts() {
			bool raw_ret = g_file_supports_thread_contexts(Handle);
			bool ret = raw_ret;
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_trash(IntPtr raw, IntPtr cancellable, out IntPtr error);

		public bool Trash(GLib.Cancellable cancellable) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_trash(Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_trash_async(IntPtr raw, int io_priority, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void TrashAsync(int io_priority, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_trash_async(Handle, io_priority, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_trash_finish(IntPtr raw, IntPtr result, out IntPtr error);

		public bool TrashFinish(GLib.IAsyncResult result) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_trash_finish(Handle, result == null ? IntPtr.Zero : ((result is GLib.Object) ? (result as GLib.Object).Handle : (result as GLib.AsyncResultAdapter).Handle), out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern void g_file_unmount_mountable_with_operation(IntPtr raw, int flags, IntPtr mount_operation, IntPtr cancellable, GLibSharp.AsyncReadyCallbackNative cb, IntPtr user_data);

		public void UnmountMountableWithOperation(GLib.MountUnmountFlags flags, GLib.MountOperation mount_operation, GLib.Cancellable cancellable, GLib.AsyncReadyCallback cb) {
			GLibSharp.AsyncReadyCallbackWrapper cb_wrapper = new GLibSharp.AsyncReadyCallbackWrapper (cb);
			cb_wrapper.PersistUntilCalled ();
			g_file_unmount_mountable_with_operation(Handle, (int) flags, mount_operation == null ? IntPtr.Zero : mount_operation.Handle, cancellable == null ? IntPtr.Zero : cancellable.Handle, cb_wrapper.NativeDelegate, IntPtr.Zero);
		}

		[DllImport("gio-2.0-0.dll", CallingConvention = CallingConvention.Cdecl)]
		static extern bool g_file_unmount_mountable_with_operation_finish(IntPtr raw, IntPtr result, out IntPtr error);

		public bool UnmountMountableWithOperationFinish(GLib.IAsyncResult result) {
			IntPtr error = IntPtr.Zero;
			bool raw_ret = g_file_unmount_mountable_with_operation_finish(Handle, result == null ? IntPtr.Zero : ((result is GLib.Object) ? (result as GLib.Object).Handle : (result as GLib.AsyncResultAdapter).Handle), out error);
			bool ret = raw_ret;
			if (error != IntPtr.Zero) throw new GLib.GException (error);
			return ret;
		}

#endregion
	}
}
