#ifndef GRELLTOP_H 
#define GRELLTOP_H

#define    GKRELLTOP_VERSION_MAJOR     2
#define    GKRELLTOP_VERSION_MINOR     2
#define    GKRELLTOP_VERSION_REV       1

#define STYLE_NAME              "gkrelltop"
#define GKRELLTOP_SERVE_NAME    STYLE_NAME
#define MAXITEMS                       3   /* items to show on the krell (3) */

#define CPU_THRESHHOLD   1  /* threshhold for the cpu diff to appear */
#include <stdlib.h>
#include <stdio.h>
#include <time.h>
#include <dirent.h>
#include <string.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <math.h>
#include <limits.h>
#include <errno.h>
#include <signal.h>

#if defined(PARANOID)
#include <assert.h>
#endif              /* defined(PARANOID) */

#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/time.h>

#include <regex.h>


/* process structure for use by gkrellm 
 * store processes in a linked list */
struct process {        
    struct process *next;
    struct process *previous;

    pid_t pid;
    char *name;
    float amount;
    int user_time;
    int kernel_time;
    int previous_user_time;
    int previous_kernel_time;
    int vsize;
    int rss;
    int time_stamp;
    int include;
    int changed;
#if defined(LINUX)
    int io_read;
    int io_write;
    int previous_io_read;
    int previous_io_write;
#endif              /* defined(PARANOID) */
};

enum modes {cpu, mem, io};
enum { KIL = 1<<10, MEG = 1<<20 }; 

/* functions defined */
int gkrelltop_process_find_top_three(struct process **);


#endif
