/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn client.
 * Copyright (C) 2008 - 2012 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>

/* Make sure we have enough of these or it will
   borrow from the next widget-type and fail */
#define NUM_ENTRIES 25
#define NUM_SPINBUTTONS 13
#define NUM_COMBOS 16


typedef struct w
{
  GtkWidget *main_window;
  GtkWidget *main_vbox;

  GtkWidget *main_notebook;
  GtkWidget *notebook_vbox1;
  GtkWidget *notebook_vbox2;
  GtkWidget *notebook_vbox3;

  GtkWidget *status_label;
  GtkWidget *version_label;

  /* The client tab's widgets */
  GtkWidget *connection_treeview;
  GtkListStore *connection_store;
  GtkWidget *connection_settings_vbox;
  GtkWidget *connection_settings_scrolled_window;

  /* The address treeview */
  GtkWidget *address_treeview;
  GtkListStore *address_store;

  GtkWidget *client_set_entry[NUM_ENTRIES];
  GtkWidget *client_set_spinbutton[NUM_SPINBUTTONS];
  GtkWidget *client_set_combo[NUM_COMBOS];

  GtkWidget *settings_table;

  /* Import widgets */
  GtkWidget *import_window;
  GtkWidget *import_treeview;
  GtkListStore *import_store;
  GtkWidget *import_package_file_entry;
  GtkWidget *import_config_file_entry;

  /* The log tabs widgets */
  GtkWidget *log_treeview;
  GtkListStore *log_store;

  /* The conf tabs textview */
  GtkWidget *conf_textview;

}wid;
