package conformancetests;

/* This file is part of the JFact DL reasoner
 Copyright 2011-2013 by Ignazio Palmisano, Dmitry Tsarkov, University of Manchester
 This library is free software; you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.
 This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 You should have received a copy of the GNU Lesser General Public License along with this library; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA*/
import org.junit.Test;

import testbase.TestBase;

@SuppressWarnings("javadoc")
public class WebOnt_description_logic_209 extends TestBase {

    @Test
    public void testWebOnt_description_logic_209() {
        String premise = "<rdf:RDF\n"
                + "    xml:base=\"http://www.w3.org/2002/03owlt/description-logic/premises209\" xmlns:oiled=\"http://oiled.man.example.net/test#\" xmlns:owl=\"http://www.w3.org/2002/07/owl#\" xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\" xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\">\n"
                + "    <owl:Ontology rdf:about=\"\"/>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C10\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C6\"/>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C8\"/></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C12\"/>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C14\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C10\"/>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C12\"/></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C16\"/>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C18\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C14\"/>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C16\"/></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C20\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C18\"/></owl:complementOf></owl:Class></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C22\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C20\"/></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C24\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C22\"/></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C26\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C24\"/></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C28\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C26\"/></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C30\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C2\"/>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C4\"/></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C32\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C2\"/></owl:complementOf></owl:Class>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C4\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C34\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C30\"/></owl:complementOf></owl:Class>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C32\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C36\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C34\"/></owl:complementOf></owl:Class></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C38\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#TOP\"/>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C36\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C40\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C38\"/></owl:complementOf></owl:Class></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C42\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C8\"/></owl:complementOf></owl:Class></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C44\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C40\"/></owl:complementOf></owl:Class>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C42\"/></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C46\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C4\"/>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C8\"/></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C48\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C4\"/></owl:complementOf></owl:Class>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C8\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C50\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C46\"/></owl:complementOf></owl:Class>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C48\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C52\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C50\"/></owl:complementOf></owl:Class></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C54\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C52\"/></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C56\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C44\"/>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C54\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C58\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C56\"/></owl:complementOf></owl:Class></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C60\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C12\"/></owl:complementOf></owl:Class></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C62\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C58\"/></owl:complementOf></owl:Class>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C60\"/></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C64\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C8\"/>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C12\"/></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C66\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C8\"/></owl:complementOf></owl:Class>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C12\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C68\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C64\"/></owl:complementOf></owl:Class>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C66\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C70\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C68\"/></owl:complementOf></owl:Class></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C72\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C70\"/></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C74\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C72\"/></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C76\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C62\"/>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C74\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C78\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C76\"/></owl:complementOf></owl:Class></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C80\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C16\"/></owl:complementOf></owl:Class></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C82\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C78\"/></owl:complementOf></owl:Class>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C80\"/></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C84\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C12\"/>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C2\"/></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C86\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C12\"/></owl:complementOf></owl:Class>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C2\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C88\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C84\"/></owl:complementOf></owl:Class>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C86\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C90\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C88\"/></owl:complementOf></owl:Class></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C92\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C90\"/></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C94\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C92\"/></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C96\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C94\"/></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C98\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C82\"/>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C96\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#TOP\"/>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C2\"/>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C4\"/>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C6\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C2\"/>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C4\"/></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C8\"/>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C100\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C98\"/></owl:complementOf></owl:Class></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C102\"/>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C104\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C102\"/></owl:complementOf></owl:Class></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C106\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C100\"/></owl:complementOf></owl:Class>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C104\"/></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C108\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C28\"/>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C106\"/></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C110\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C4\"/></owl:complementOf></owl:Class>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C12\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C112\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C110\"/>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C102\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C114\"/>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C116\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C112\"/>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C114\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C118\"/>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C120\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C116\"/>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C118\"/></owl:complementOf></owl:Class></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C122\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C120\"/></owl:complementOf></owl:Class></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C124\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C122\"/></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C126\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C124\"/></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C128\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C126\"/></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C130\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:someValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C128\"/></owl:someValuesFrom></owl:Restriction></owl:equivalentClass></owl:Class>\n"
                + "    <owl:Class rdf:about=\"http://oiled.man.example.net/test#TEST\">\n"
                + "        <owl:equivalentClass>\n"
                + "            <owl:Class>\n"
                + "                <owl:intersectionOf rdf:parseType=\"Collection\">\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C108\"/>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C130\"/></owl:intersectionOf></owl:Class></owl:equivalentClass></owl:Class>\n"
                + "    <owl:ObjectProperty rdf:about=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16439\">\n"
                + "        <rdf:type>\n"
                + "            <owl:Class rdf:about=\"http://oiled.man.example.net/test#TEST\"/></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C100\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C98\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <oiled:R1 rdf:resource=\"http://oiled.man.example.net/test#V16440\"/>\n"
                + "        <oiled:R1 rdf:resource=\"http://oiled.man.example.net/test#V16442\"/>\n"
                + "        <oiled:R1 rdf:resource=\"http://oiled.man.example.net/test#V16441\"/></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16440\">\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C102\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C96\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C78\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C94\"/></owl:complementOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C76\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <oiled:R1 rdf:resource=\"http://oiled.man.example.net/test#V16463\"/></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16441\">\n"
                + "        <rdf:type rdf:resource=\"http://www.w3.org/2002/07/owl#Thing\"/></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16442\">\n"
                + "        <rdf:type rdf:resource=\"http://www.w3.org/2002/07/owl#Thing\"/></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16448\">\n"
                + "        <rdf:type>\n"
                + "            <owl:Class rdf:about=\"http://oiled.man.example.net/test#TOP\"/></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C52\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C90\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C70\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C36\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C50\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C88\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C68\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C34\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <oiled:R1 rdf:resource=\"http://oiled.man.example.net/test#V16449\"/></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16449\">\n"
                + "        <rdf:type rdf:resource=\"http://www.w3.org/2002/07/owl#Thing\"/></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16453\">\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C94\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C16\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C74\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C58\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C92\"/></owl:complementOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C72\"/></owl:complementOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C56\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <oiled:R1 rdf:resource=\"http://oiled.man.example.net/test#V16461\"/></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16455\">\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C72\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C92\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C12\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C54\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C40\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C70\"/></owl:complementOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C90\"/></owl:complementOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C52\"/></owl:complementOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C38\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <oiled:R1 rdf:resource=\"http://oiled.man.example.net/test#V16460\"/></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16457\">\n"
                + "        <rdf:type>\n"
                + "            <owl:Class rdf:about=\"http://oiled.man.example.net/test#TOP\"/></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C52\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C90\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C70\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C8\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C36\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C50\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C88\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C68\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C34\"/></owl:allValuesFrom></owl:Restriction></rdf:type></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16459\">\n"
                + "        <rdf:type>\n"
                + "            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C12\"/></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C4\"/></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C6\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C10\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C14\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C8\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C2\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C18\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C48\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C86\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C84\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C66\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C64\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C46\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C32\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C30\"/></owl:complementOf></owl:Class></rdf:type></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16460\">\n"
                + "        <rdf:type>\n"
                + "            <owl:Class rdf:about=\"http://oiled.man.example.net/test#TOP\"/></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C52\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C90\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C70\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C8\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C36\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C50\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C88\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C68\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C34\"/></owl:allValuesFrom></owl:Restriction></rdf:type></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16461\">\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C72\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C92\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C12\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C54\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C40\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C70\"/></owl:complementOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C90\"/></owl:complementOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C52\"/></owl:complementOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C38\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <oiled:R1 rdf:resource=\"http://oiled.man.example.net/test#V16462\"/></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16462\">\n"
                + "        <rdf:type>\n"
                + "            <owl:Class rdf:about=\"http://oiled.man.example.net/test#TOP\"/></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C52\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C90\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C70\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C8\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C36\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C50\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C88\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C68\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C34\"/></owl:allValuesFrom></owl:Restriction></rdf:type></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16463\">\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C94\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C16\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C74\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C58\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C92\"/></owl:complementOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C72\"/></owl:complementOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C56\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <oiled:R1 rdf:resource=\"http://oiled.man.example.net/test#V16464\"/></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16464\">\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C72\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C92\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C12\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C54\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C40\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C70\"/></owl:complementOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C90\"/></owl:complementOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class>\n"
                + "                        <owl:complementOf>\n"
                + "                            <owl:Class rdf:about=\"http://oiled.man.example.net/test#C52\"/></owl:complementOf></owl:Class></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C38\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <oiled:R1 rdf:resource=\"http://oiled.man.example.net/test#V16465\"/></owl:Thing>\n"
                + "    <owl:Thing rdf:about=\"http://oiled.man.example.net/test#V16465\">\n"
                + "        <rdf:type>\n"
                + "            <owl:Class rdf:about=\"http://oiled.man.example.net/test#TOP\"/></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C52\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C90\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C70\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C8\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Class>\n"
                + "                <owl:complementOf>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C36\"/></owl:complementOf></owl:Class></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C50\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C88\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C68\"/></owl:allValuesFrom></owl:Restriction></rdf:type>\n"
                + "        <rdf:type>\n"
                + "            <owl:Restriction>\n"
                + "                <owl:onProperty rdf:resource=\"http://oiled.man.example.net/test#R1\"/>\n"
                + "                <owl:allValuesFrom>\n"
                + "                    <owl:Class rdf:about=\"http://oiled.man.example.net/test#C34\"/></owl:allValuesFrom></owl:Restriction></rdf:type></owl:Thing>\n"
                + "</rdf:RDF>";
        String conclusion = "Prefix(xsd:=<http://www.w3.org/2001/XMLSchema#>)\n"
                + "Prefix(owl:=<http://www.w3.org/2002/07/owl#>)\n"
                + "Prefix(xml:=<http://www.w3.org/XML/1998/namespace>)\n"
                + "Prefix(rdf:=<http://www.w3.org/1999/02/22-rdf-syntax-ns#>)\n"
                + "Prefix(rdfs:=<http://www.w3.org/2000/01/rdf-schema#>)\n"
                + "Ontology(\n"
                + "Declaration(Class(<http://oiled.man.example.net/test#C122>))\n"
                + "ClassAssertion(<http://oiled.man.example.net/test#C122> <http://oiled.man.example.net/test#V16448>)\n"
                +
                // ClassAssertion(owl:Thing
                // <http://oiled.man.example.net/test#V16448>)
                ')';
        String id = "WebOnt_description_logic_209";
        TestClasses tc = TestClasses.valueOf("NEGATIVE_IMPL");
        String d = "DL Test: k_poly\n"
                + "ABox test from DL98 systems comparison.\n"
                + "(Modified in light of implementation feedback, see test description-logic-208).";
        JUnitRunner r = new JUnitRunner(premise, conclusion, id, tc, d);
        r.setReasonerFactory(factory());
        r.run();
    }
}
