#!/usr/bin/perl

=pod

=head1 NAME

grip-single.pl - grip a single package for each architecture

=head1 Description

This script is a wrapper for grip_binary in Emdebian::Grip, needs
to be passed the suite, the version and the binary package name. It
will then grip the binary for each architecture and include it
into the relevant suite.

Currently only works for checks on stable which go into
stable-proposed-updates.

=cut

use strict;
use warnings;
use Data::Dumper;
use File::Basename;
use Emdebian::Grip;
use Debian::Packages::Compare;

use vars qw/ $filter_name $grip_name $suite $base
 $noskip @archlist @locroots @lines $line %pkg @filter $have
 %debianstable %gripstable %gripupdate $go $mirror @packages
 $our_version %debupdate %griptesting $pkgname $version /;

my $prog = basename($0);
$our_version = &scripts_version();

$mirror='http://ftp.uk.debian.org/debian'; # default
$filter_name = 'filter';
$grip_name = 'grip';
$suite = "stable";
$base = '/opt/reprepro/';
$go = 1; # define to make changes in repositories.

while( @ARGV ) {
	$_= shift( @ARGV );
	last if m/^--$/;
	if (!/^-/) {
		unshift(@ARGV,$_);
		last;
	} elsif (/^(-\?|-h|--help|--version)$/) {
		&usageversion();
		exit (0);
	} elsif (/^(-m|--mirror)$/) {
		$mirror = shift;
	} elsif (/^(-b|--base-path)$/) {
		$base = shift;
	} elsif (/^(-n|--dry-run)$/) {
		undef $go;
	} elsif (/^(-s|--suite)$/) {
		$suite = shift;
		warn ("Only tested with stable!") if ($suite !~ /^stable$/);
	} elsif (/^(-V|--version)$/) {
		$version = shift;
	} elsif (/^(-p|--package)$/) {
		push @packages, shift;
	} elsif (/^(--filter-name)$/) {
		$filter_name = shift;
	} elsif (/^(--grip-name)$/) {
		$grip_name = shift;
	} else {
		die "$prog: Unknown option $_.\n";
	}
}

$base .= '/' if ("$base" !~ m:/$:);
die "ERR: Please specify an existing directory for the base-path: $base\n"
	if (not -d $base);

&set_base($base);
&set_repo_names ($filter_name, $grip_name);
my $a = &get_archlist ($suite, $filter_name);
die ("ERR: unable to read architecture list.\n") if (not defined $a);
@archlist = @$a;
my $l = &get_locale_roots ($suite, 'locale');
die ("ERR: unable to read components list for locales.\n")
	if (not defined $l);
@locroots = @$l;

die("ERROR: No pkglist filter file.\n")
	if ( not -f "${base}${filter_name}/conf/pkglist" );

my $debf  = &read_packages ('stable', $filter_name);
my $gripf = &read_packages ('stable', $grip_name);
my $gript = &read_packages ('testing', $grip_name);
my $updatedeb = &read_packages ('stable-proposed-updates', $filter_name);
my $updategrip = &read_packages ('stable-proposed-updates', $grip_name);
%debianstable = %$debf   if (defined $debf);
%gripstable   = %$gripf  if (defined $gripf);
%gripupdate   = %$updategrip  if (defined $updategrip);
%griptesting  = %$gript  if (defined $gript);
%debupdate    = %$updatedeb if (defined $updatedeb);

use Data::Dumper;

foreach $pkgname (@packages) {
	foreach my $arch (sort @archlist) {
		next if ($arch eq 'source');
		next if ($arch eq 'arm');
		my $single = get_single_package ($suite, $filter_name, $pkgname, $arch);
		my $check = get_single_package ('stable-proposed-updates', $grip_name, $pkgname, $arch);
		if (defined $$check{'Version'}) {
			my $vv = $$check{'Version'};
			$vv =~ s/em1$//;
			next if ($vv eq $version);
		}
		if($version eq $$single{'Version'}) {
			&grip_binary ($pkgname, $version, 'stable-proposed-updates', $arch);
		}
	}
}
