# -*- coding: utf-8 -*-
from __future__ import unicode_literals

#: See the "Code officiel géographique" on the INSEE website <www.insee.fr>.
DEPARTMENT_CHOICES_PER_REGION = (
    # Metropolitan departments
    ('01', 'Ain', '82'),
    ('02', 'Aisne', '22'),
    ('03', 'Allier', '83'),
    ('04', 'Alpes-de-Haute-Provence', '93'),
    ('05', 'Hautes-Alpes', '93'),
    ('06', 'Alpes-Maritimes', '93'),
    ('07', 'Ardèche', '82'),
    ('08', 'Ardennes', '21'),
    ('09', 'Ariège', '73'),
    ('10', 'Aube', '21'),
    ('11', 'Aude', '91'),
    ('12', 'Aveyron', '73'),
    ('13', 'Bouches-du-Rhône', '93'),
    ('14', 'Calvados', '25'),
    ('15', 'Cantal', '83'),
    ('16', 'Charente', '54'),
    ('17', 'Charente-Maritime', '54'),
    ('18', 'Cher', '24'),
    ('19', 'Corrèze', '74'),
    ('2A', 'Corse-du-Sud', '94'),
    ('2B', 'Haute-Corse', '94'),
    ('21', 'Côte-d\'Or', '26'),
    ('22', 'Côtes-d\'Armor', '53'),
    ('23', 'Creuse', '74'),
    ('24', 'Dordogne', '72'),
    ('25', 'Doubs', '43'),
    ('26', 'Drôme', '82'),
    ('27', 'Eure', '23'),
    ('28', 'Eure-et-Loir', '24'),
    ('29', 'Finistère', '53'),
    ('30', 'Gard', '91'),
    ('31', 'Haute-Garonne', '73'),
    ('32', 'Gers', '73'),
    ('33', 'Gironde', '72'),
    ('34', 'Hérault', '91'),
    ('35', 'Ille-et-Vilaine', '53'),
    ('36', 'Indre', '24'),
    ('37', 'Indre-et-Loire', '24'),
    ('38', 'Isère', '82'),
    ('39', 'Jura', '43'),
    ('40', 'Landes', '72'),
    ('41', 'Loir-et-Cher', '24'),
    ('42', 'Loire', '82'),
    ('43', 'Haute-Loire', '83'),
    ('44', 'Loire-Atlantique', '52'),
    ('45', 'Loiret', '24'),
    ('46', 'Lot', '73'),
    ('47', 'Lot-et-Garonne', '72'),
    ('48', 'Lozère', '91'),
    ('49', 'Maine-et-Loire', '52'),
    ('50', 'Manche', '25'),
    ('51', 'Marne', '21'),
    ('52', 'Haute-Marne', '21'),
    ('53', 'Mayenne', '52'),
    ('54', 'Meurthe-et-Moselle', '41'),
    ('55', 'Meuse', '41'),
    ('56', 'Morbihan', '53'),
    ('57', 'Moselle', '41'),
    ('58', 'Nièvre', '26'),
    ('59', 'Nord', '31'),
    ('60', 'Oise', '22'),
    ('61', 'Orne', '25'),
    ('62', 'Pas-de-Calais', '31'),
    ('63', 'Puy-de-Dôme', '83'),
    ('64', 'Pyrénées-Atlantiques', '72'),
    ('65', 'Hautes-Pyrénées', '73'),
    ('66', 'Pyrénées-Orientales', '91'),
    ('67', 'Bas-Rhin', '42'),
    ('68', 'Haut-Rhin', '42'),
    ('69', 'Rhône', '82'),
    ('70', 'Haute-Saône', '43'),
    ('71', 'Saône-et-Loire', '26'),
    ('72', 'Sarthe', '52'),
    ('73', 'Savoie', '82'),
    ('74', 'Haute-Savoie', '82'),
    ('75', 'Paris', '11'),
    ('76', 'Seine-Maritime', '23'),
    ('77', 'Seine-et-Marne', '11'),
    ('78', 'Yvelines', '11'),
    ('79', 'Deux-Sèvres', '54'),
    ('80', 'Somme', '22'),
    ('81', 'Tarn', '73'),
    ('82', 'Tarn-et-Garonne', '73'),
    ('83', 'Var', '93'),
    ('84', 'Vaucluse', '93'),
    ('85', 'Vendée', '52'),
    ('86', 'Vienne', '54'),
    ('87', 'Haute-Vienne', '74'),
    ('88', 'Vosges', '41'),
    ('89', 'Yonne', '26'),
    ('90', 'Territoire de Belfort', '43'),
    ('91', 'Essonne', '11'),
    ('92', 'Hauts-de-Seine', '11'),
    ('93', 'Seine-Saint-Denis', '11'),
    ('94', 'Val-de-Marne', '11'),
    ('95', 'Val-d\'Oise', '11'),
    # Overseas departments, communities, and other territories
    ('971', 'Guadeloupe', '01'),
    ('972', 'Martinique', '02'),
    ('973', 'Guyane', '03'),
    ('974', 'La Réunion', '04'),
    ('975', 'Saint-Pierre-et-Miquelon', None),
    ('976', 'Mayotte', '05'),
    ('977', 'Saint-Barthélemy', None),
    ('978', 'Saint-Martin', None),
    ('984', 'Terres australes et antarctiques françaises', None),
    ('986', 'Wallis et Futuna', None),
    ('987', 'Polynésie française', None),
    ('988', 'Nouvelle-Calédonie', None),
    ('989', 'Île de Clipperton', None),
)

#: A list of departments
DEPARTMENT_CHOICES = tuple([
    (dep[0], '%s - %s' % (dep[0], dep[1]),)
    for dep in DEPARTMENT_CHOICES_PER_REGION
])
