/*
    Copyright (C) 2008-2010 Stefan Haller

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/**************************************************************************
 * A normal program can't change the MCS-Settings in Xfce. So we generate *
 * a list of all wallpapers. This list can be used by the MCS-plugin.     *
 *                                                                        *
 * See bzr-revison 53 for a solotion that manipulates the XML-file of     *
 * the MCS-settings-daemon directly. But this does NOT work at the moment *
 * because the daemon and the mcs-plugin ignore the changes.              *
 * Killing xfdesktop does also not help.                                  *
 **************************************************************************/

#include <config.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <glib.h>
#include <libintl.h>
#include "../misc/general.h"

#define _(message) dgettext(GETTEXT_PACKAGE_MODULE_XFCE, message)

void module_init()
{
	bindtextdomain(GETTEXT_PACKAGE_MODULE_XFCE, LOCALEDIR);
}

const gchar * module_get_gw_version()
{
	return VERSION;
}

const gchar * module_get_version()
{
	return VERSION_MODULE_XFCE;
}

const gchar * module_get_name()
{
	return _("Xfce");
}

const gchar * module_get_description()
{
	return _("This module enables Xfce-support. You must set up your desktop " \
	         "preferences, otherwise this module won't work!! Go to " \
	         "Applications > Settings > Settings Manager > Desktop. Select " \
	         "\"Show Image\" and click on \"New list...\". Set the path of " \
	         "the list file to \"/home/<username>/.config/desktopnova/" \
	         "xfce.list\" and click on \"Save\". Now the module should work " \
	         "correctly.");
}

const gchar * module_get_author()
{
	return "Stefan Haller <haliner@googlemail.com>";
}

const gchar * module_get_homepage()
{
	return "http://launchpad.net/desktopnova";
}

void module_change_wallpaper(const gchar * filename)
{
	//int result = system("killall -USR1 xfdesktop");
	int result = system("/bin/kill -s USR1 `pidof xfdesktop`");
	if (result == -1)
	{
		g_critical("xfce-module: Error: %s", g_strerror(errno));
	}
	if (result == 127)
	{
		g_critical("xfce-module: Error: /bin/sh could not be executed.");
	}
}

void module_hook_list_files(GPtrArray * files)
{
	guint i;
	FILE * file;
	const gchar * str;
	gchar * xfce_file = g_build_filename(g_get_user_config_dir(),
	                                     "desktopnova/",
	                                     "xfce.list",
	                                     NULL);

	file = fopen(xfce_file, "w");
	if (file == NULL)
	{
		g_critical("xfce-module: Cannot open \"%s\": %s", xfce_file, g_strerror(errno));
		return;
	}

	/* write header (this header is very important!) */
	str = "# xfce backdrop list\n";
	fwrite(str, strlen(str), 1, file);

	for (i = 0; i < files->len; i++)
	{
		str = (const gchar *)g_ptr_array_index(files,i);
		fwrite(str, strlen(str), 1, file);
		str = "\n";
		fwrite(str, strlen(str), 1, file);
	}

	fclose(file);

	g_free(xfce_file);
}

#undef _
