/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.DataBinder;
import android.databinding.tool.LayoutBinder;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.L;
import android.databinding.tool.writer.DataBinderWriter;
import android.databinding.tool.writer.JavaFileWriter;

public class CompilerChef {
    private JavaFileWriter mFileWriter;
    private ResourceBundle mResourceBundle;
    private DataBinder mDataBinder;

    private CompilerChef() {
    }

    public static CompilerChef createChef(ResourceBundle bundle, JavaFileWriter fileWriter) {
        CompilerChef chef = new CompilerChef();
        chef.mResourceBundle = bundle;
        chef.mFileWriter = fileWriter;
        chef.mResourceBundle.validateMultiResLayouts();
        return chef;
    }

    public ResourceBundle getResourceBundle() {
        return this.mResourceBundle;
    }

    public void ensureDataBinder() {
        if (this.mDataBinder == null) {
            this.mDataBinder = new DataBinder(this.mResourceBundle);
            this.mDataBinder.setFileWriter(this.mFileWriter);
        }
    }

    public boolean hasAnythingToGenerate() {
        L.d("checking if we have anything to generate. bundle size: %s", this.mResourceBundle == null ? -1 : this.mResourceBundle.getLayoutBundles().size());
        return this.mResourceBundle != null && this.mResourceBundle.getLayoutBundles().size() > 0;
    }

    public void writeDbrFile(int minSdk) {
        this.ensureDataBinder();
        String pkg = "android.databinding";
        DataBinderWriter dbr = new DataBinderWriter("android.databinding", this.mResourceBundle.getAppPackage(), "DataBinderMapper", this.mDataBinder.getLayoutBinders(), minSdk);
        this.mFileWriter.writeToFile("android.databinding." + dbr.getClassName(), dbr.write());
    }

    public void addBRVariables(BindableHolder bindables) {
        this.ensureDataBinder();
        for (LayoutBinder layoutBinder : this.mDataBinder.mLayoutBinders) {
            for (String variableName : layoutBinder.getUserDefinedVariables().keySet()) {
                bindables.addVariable(variableName, layoutBinder.getClassName());
            }
        }
    }

    public void writeViewBinderInterfaces(boolean isLibrary) {
        this.ensureDataBinder();
        this.mDataBinder.writerBaseClasses(isLibrary);
    }

    public void writeViewBinders(int minSdk) {
        this.ensureDataBinder();
        this.mDataBinder.writeBinders(minSdk);
    }

    public static interface BindableHolder {
        public void addVariable(String var1, String var2);
    }
}

