#ifndef CACHE_H
#define CACHE_H

#include "vt.h"
#include "misc.h"
#include "dllist.h"

#define HASH_SIZE	113

struct cache
{
    struct dl_head hash[HASH_SIZE];
    int erc;			// error reduction circuit on
    int npages;
    u16 hi_subno[0x9ff + 1];	// 0:pg not in cache, 1-3f80:highest subno + 1
    struct cache_ops *op;
};

struct cache_page
{
    struct dl_node node[1];
    struct vt_page page[1];
};

typedef void (*cache_close_t)(struct cache *ca);

typedef struct vt_page *(*cache_get_t)(struct cache *ca, int pgno, int subno);

typedef struct vt_page *(*cache_put_t)(struct cache *ca, struct vt_page *vtp);

typedef void (*cache_reset_t)(struct cache *ca);

typedef int (*cache_func_t)(void *user_data, struct vt_page *vtp);

typedef struct vt_page *(*cache_foreach_pg_t)(
    struct cache *ca, int pgno,
    int subno, int dir, cache_func_t func, void *user_data);

typedef int (*cache_mode_t)(struct cache *ca, int mode, int arg);

struct cache_ops {
    cache_close_t       close;
    cache_get_t         get;
    cache_put_t         put;
    cache_reset_t       reset;
    cache_foreach_pg_t  foreach_pg;
    cache_mode_t        mode;
};

struct cache *cache_open(void);

#define CACHE_MODE_ERC	1

#endif
