#!/bin/bash

################################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################

if test "$3" = pegasus
then
	if !( ps -C cimserver > /dev/null 2>&1 )
	then
		echo "ERROR: Pegasus CIM server is not running"
		exit 1
	fi
fi

if test "$3" = openwbem
then
	if !( ps -C owcimomd > /dev/null 2>&1 )
	then
		echo "ERROR: OpenWBEM CIM server is not running"
		exit 1
	fi
fi

if test "$3" = sfcb
then
	/etc/init.d/sfcb stop
fi

$6/registration/OpenDRIM_PhysicalComponent.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_ConnectedTo.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_PhysicalFrame.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_ComputerSystemPackage.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_Realizes.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_PhysicalPackageCapacity.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_ConfigurationCapacity.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_PhysicalPackage.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_PhysicalMemory.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_PhysicalAssetCapabilities.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_PhysicalElementInConnector.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_SystemPackaging.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_Chip.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_PhysicalAssetCapabilitiesToPhysicalElement.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_PhysicalAssetRegisteredProfile.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_Chassis.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_PhysicalAssetConformsToProfile.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_PhysicalElementPackage.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_PhysicalConnector.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_Rack.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_Card.sh $1 $2 $3 $4 $5 $6
$6/registration/OpenDRIM_Slot.sh $1 $2 $3 $4 $5 $6

if test "$3" = sfcb
then
	/etc/init.d/sfcb start
fi

