/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CollectionUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import picard.illumina.parser.BclData;
import picard.illumina.parser.CycleIlluminaFileMap;
import picard.illumina.parser.IlluminaDataType;
import picard.illumina.parser.OutputMapping;
import picard.illumina.parser.PerTileCycleParser;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.illumina.parser.readers.BclReader;

class BclParser
extends PerTileCycleParser<BclData> {
    private static final int EAMSS_M2_GE_THRESHOLD = 30;
    private static final int EAMSS_S1_LT_THRESHOLD = 15;
    public static final byte MASKING_QUALITY = 2;
    private static final Set<IlluminaDataType> SUPPORTED_TYPES = Collections.unmodifiableSet(CollectionUtil.makeSet((Object[])new IlluminaDataType[]{IlluminaDataType.BaseCalls, IlluminaDataType.QualityScores}));
    protected final BclQualityEvaluationStrategy bclQualityEvaluationStrategy;
    private final boolean applyEamssFilter;

    public BclParser(File directory, int lane, CycleIlluminaFileMap tilesToCycleFiles, OutputMapping outputMapping, BclQualityEvaluationStrategy bclQualityEvaluationStrategy) {
        this(directory, lane, tilesToCycleFiles, outputMapping, true, bclQualityEvaluationStrategy);
        this.initialize();
    }

    public BclParser(File directory, int lane, CycleIlluminaFileMap tilesToCycleFiles, OutputMapping outputMapping, boolean applyEamssFilter, BclQualityEvaluationStrategy bclQualityEvaluationStrategy) {
        super(directory, lane, tilesToCycleFiles, outputMapping);
        this.bclQualityEvaluationStrategy = bclQualityEvaluationStrategy;
        this.applyEamssFilter = applyEamssFilter;
        this.initialize();
    }

    @Override
    protected PerTileCycleParser.CycleFilesParser<BclData> makeCycleFileParser(List<File> files) {
        return new BclDataCycleFileParser(files);
    }

    @Override
    public void initialize() {
        this.seekToTile(this.currentTile);
    }

    @Override
    public Set<IlluminaDataType> supportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public BclData next() {
        BclData bclData = (BclData)super.next();
        byte[][] bases = bclData.getBases();
        byte[][] qualities = bclData.getQualities();
        if (this.applyEamssFilter) {
            for (int i = 0; i < bases.length; ++i) {
                BclParser.runEamssForReadInPlace(bases[i], qualities[i]);
            }
        }
        return bclData;
    }

    protected static void runEamssForReadInPlace(byte[] bases, byte[] qualities) {
        int eamssTally = 0;
        int maxTally = Integer.MIN_VALUE;
        int indexOfMax = -1;
        for (int i = bases.length - 1; i >= 0; --i) {
            int quality = 0xFF & qualities[i];
            if (quality >= 30) {
                eamssTally -= 2;
            } else if (quality < 15) {
                ++eamssTally;
            }
            if (eamssTally < maxTally) continue;
            indexOfMax = i;
            maxTally = eamssTally;
        }
        if (maxTally >= 1) {
            int i;
            int numGs = 0;
            int exceptions = 0;
            for (i = indexOfMax; i >= 0; --i) {
                if (bases[i] == 71) {
                    ++numGs;
                    continue;
                }
                Integer skip = BclParser.skipBy(i, numGs, exceptions, bases);
                if (skip == null) break;
                exceptions += skip.intValue();
                numGs += skip.intValue();
                i -= skip - 1;
            }
            if (numGs >= 10) {
                indexOfMax = indexOfMax + 1 - numGs;
            }
            for (i = indexOfMax; i < qualities.length; ++i) {
                qualities[i] = 2;
            }
        }
    }

    private static Integer skipBy(int index, int numGs, int prevExceptions, byte[] bases) {
        int exceptionLimit;
        Integer skip = null;
        for (int backup = 1; backup <= index && prevExceptions + backup <= (exceptionLimit = Math.max((numGs + backup) / 10, 1)); ++backup) {
            if (bases[index - backup] != 71) continue;
            skip = backup;
            break;
        }
        return skip;
    }

    private class BclDataCycleFileParser
    implements PerTileCycleParser.CycleFilesParser<BclData> {
        final CloseableIterator<BclData> reader;

        public BclDataCycleFileParser(List<File> files) {
            this.reader = new BclReader(files, BclParser.this.outputMapping.getOutputReadLengths(), BclParser.this.bclQualityEvaluationStrategy, false);
        }

        @Override
        public void close() {
            this.reader.close();
        }

        @Override
        public BclData next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return (BclData)this.reader.next();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.reader.hasNext();
            }
            catch (NullPointerException npe) {
                return false;
            }
        }
    }
}

