/*
 * Copyright 2010 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "sr_Latn" locale.
 */
public class LocalizedNamesImpl_sr_Latn extends LocalizedNamesImpl_sr {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "RS",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AX",
        "AL",
        "DZ",
        "AS",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AF",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "BE",
        "BZ",
        "BY",
        "BJ",
        "BM",
        "BW",
        "BO",
        "BA",
        "CX",
        "BR",
        "VG",
        "IO",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "BV",
        "TD",
        "CF",
        "CZ",
        "CL",
        "ME",
        "DK",
        "CD",
        "DG",
        "DM",
        "DO",
        "JE",
        "DJ",
        "EG",
        "EC",
        "GQ",
        "ER",
        "EE",
        "ET",
        "EU",
        "FO",
        "FJ",
        "PH",
        "FI",
        "FK",
        "FR",
        "GF",
        "PF",
        "TF",
        "GA",
        "GM",
        "GH",
        "GI",
        "GR",
        "GD",
        "GL",
        "GE",
        "GU",
        "GG",
        "GP",
        "GY",
        "GT",
        "GN",
        "GW",
        "HT",
        "HM",
        "NL",
        "AN",
        "HN",
        "HK",
        "HR",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "TL",
        "IT",
        "IL",
        "JM",
        "JP",
        "YE",
        "JO",
        "GS",
        "KR",
        "ZA",
        "KY",
        "KH",
        "CM",
        "CA",
        "IC",
        "CV",
        "QA",
        "KZ",
        "KE",
        "CN",
        "CY",
        "KG",
        "KI",
        "CC",
        "CO",
        "KM",
        "CG",
        "CR",
        "CU",
        "CK",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "YT",
        "MO",
        "MK",
        "MW",
        "MV",
        "MY",
        "ML",
        "MT",
        "UM",
        "MA",
        "MH",
        "MQ",
        "MU",
        "MR",
        "HU",
        "MX",
        "MM",
        "FM",
        "MD",
        "MC",
        "MN",
        "MS",
        "MZ",
        "NA",
        "NR",
        "DE",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NF",
        "NO",
        "NC",
        "NZ",
        "CI",
        "OM",
        "QO",
        "AC",
        "CP",
        "IM",
        "PK",
        "PW",
        "PS",
        "PA",
        "PG",
        "PY",
        "PE",
        "PN",
        "PL",
        "PR",
        "PT",
        "RE",
        "RW",
        "RO",
        "RU",
        "VI",
        "SV",
        "WS",
        "SM",
        "ST",
        "SA",
        "SC",
        "SN",
        "PM",
        "KN",
        "LC",
        "VC",
        "EA",
        "KP",
        "MP",
        "SL",
        "SG",
        "SY",
        "US",
        "SK",
        "SI",
        "SB",
        "SO",
        "ES",
        "RS",
        "CS",
        "LK",
        "SD",
        "SR",
        "BL",
        "MF",
        "CH",
        "SJ",
        "SZ",
        "SE",
        "SH",
        "TJ",
        "TH",
        "TW",
        "TZ",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TM",
        "TC",
        "TR",
        "TV",
        "UG",
        "AE",
        "UA",
        "UY",
        "UZ",
        "WF",
        "VU",
        "VA",
        "GB",
        "VE",
        "VN",
        "ZM",
        "EH",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Svet");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Severnoamerički kontinent");
    namesMap.put("005", "Južna Amerika");
    namesMap.put("009", "Okeanija");
    namesMap.put("011", "Zapadna Afrika");
    namesMap.put("013", "Centralna Amerika");
    namesMap.put("014", "Istočna Afrika");
    namesMap.put("015", "Severna Afrika");
    namesMap.put("017", "Centralna Afrika");
    namesMap.put("018", "Južna Afrika");
    namesMap.put("019", "Amerike");
    namesMap.put("021", "Severna Amerika");
    namesMap.put("029", "Karibi");
    namesMap.put("030", "Istočna Azija");
    namesMap.put("034", "Južna Azija");
    namesMap.put("035", "Jugoistočna Azija");
    namesMap.put("039", "Južna Evropa");
    namesMap.put("053", "Australija i Novi Zeland");
    namesMap.put("054", "Melanezija");
    namesMap.put("057", "Micronezija");
    namesMap.put("061", "Polinezija");
    namesMap.put("062", "Južno-centralna Azija");
    namesMap.put("142", "Azija");
    namesMap.put("143", "Centralna Azija");
    namesMap.put("145", "Zapadna Azija");
    namesMap.put("150", "Evropa");
    namesMap.put("151", "Istočna Evropa");
    namesMap.put("154", "Severna Evropa");
    namesMap.put("155", "Zapadna Evropa");
    namesMap.put("172", "Komonvelt nezavisnih država");
    namesMap.put("419", "Latinska Amerika i Karibi");
    namesMap.put("830", "Kanalska ostrva");
    namesMap.put("AC", "Ostrvo Asension");
    namesMap.put("AD", "Andora");
    namesMap.put("AE", "Ujedinjeni Arapski Emirati");
    namesMap.put("AF", "Avganistan");
    namesMap.put("AG", "Antigva i Barbuda");
    namesMap.put("AI", "Angvila");
    namesMap.put("AL", "Albanija");
    namesMap.put("AM", "Armenija");
    namesMap.put("AN", "Holandski Antili");
    namesMap.put("AO", "Angola");
    namesMap.put("AQ", "Antarktika");
    namesMap.put("AR", "Argentina");
    namesMap.put("AS", "Američka Samoa");
    namesMap.put("AT", "Austrija");
    namesMap.put("AU", "Australija");
    namesMap.put("AW", "Aruba");
    namesMap.put("AX", "Alandska ostrva");
    namesMap.put("AZ", "Azerbejdžan");
    namesMap.put("BA", "Bosna i Hercegovina");
    namesMap.put("BB", "Barbados");
    namesMap.put("BD", "Bangladeš");
    namesMap.put("BE", "Belgija");
    namesMap.put("BF", "Burkina Faso");
    namesMap.put("BG", "Bugarska");
    namesMap.put("BH", "Bahrein");
    namesMap.put("BI", "Burundi");
    namesMap.put("BJ", "Benin");
    namesMap.put("BL", "Sv. Bartolomej");
    namesMap.put("BM", "Bermuda");
    namesMap.put("BN", "Brunej");
    namesMap.put("BO", "Bolivija");
    namesMap.put("BR", "Brazil");
    namesMap.put("BS", "Bahami");
    namesMap.put("BT", "Butan");
    namesMap.put("BV", "Buve Ostrva");
    namesMap.put("BW", "Bocvana");
    namesMap.put("BY", "Belorusija");
    namesMap.put("BZ", "Belise");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kokos (Keling) Ostrva");
    namesMap.put("CD", "Demokratska Republika Kongo");
    namesMap.put("CF", "Centralno Afrička Republika");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Švajcarska");
    namesMap.put("CI", "Obala Slonovače");
    namesMap.put("CK", "Kukova Ostrva");
    namesMap.put("CL", "Čile");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Kina");
    namesMap.put("CO", "Kolumbija");
    namesMap.put("CP", "Ostrvo Kliperton");
    namesMap.put("CR", "Kostarika");
    namesMap.put("CS", "Srbija i Crna Gora");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Kape Verde");
    namesMap.put("CX", "Božićna Ostrva");
    namesMap.put("CY", "Kipar");
    namesMap.put("CZ", "Češka");
    namesMap.put("DE", "Nemačka");
    namesMap.put("DG", "Dijego Garsija");
    namesMap.put("DJ", "Džibuti");
    namesMap.put("DK", "Danska");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Dominikanska Republika");
    namesMap.put("DZ", "Alžir");
    namesMap.put("EA", "Seuta i Melilja");
    namesMap.put("EC", "Ekvador");
    namesMap.put("EE", "Estonija");
    namesMap.put("EG", "Egipat");
    namesMap.put("EH", "Zapadna Sahara");
    namesMap.put("ER", "Eritreja");
    namesMap.put("ES", "Španija");
    namesMap.put("ET", "Etiopija");
    namesMap.put("EU", "Evropska unija");
    namesMap.put("FI", "Finska");
    namesMap.put("FJ", "Fidži");
    namesMap.put("FK", "Folklandska Ostrva");
    namesMap.put("FM", "Mikronezija");
    namesMap.put("FO", "Farska Ostrva");
    namesMap.put("FR", "Francuska");
    namesMap.put("GA", "Gabon");
    namesMap.put("GB", "Velika Britanija");
    namesMap.put("GD", "Grenada");
    namesMap.put("GE", "Gruzija");
    namesMap.put("GF", "Francuska Gvajana");
    namesMap.put("GG", "Gurnsi");
    namesMap.put("GH", "Gana");
    namesMap.put("GI", "Gibraltar");
    namesMap.put("GL", "Grenland");
    namesMap.put("GM", "Gambija");
    namesMap.put("GN", "Gvineja");
    namesMap.put("GP", "Gvadelupe");
    namesMap.put("GQ", "Ekvatorijalna Gvineja");
    namesMap.put("GR", "Grčka");
    namesMap.put("GS", "Južna Džordžija i Južna Sendvič Ostrva");
    namesMap.put("GT", "Gvatemala");
    namesMap.put("GU", "Guam");
    namesMap.put("GW", "Gvineja-Bisao");
    namesMap.put("GY", "Gvajana");
    namesMap.put("HK", "Hong Kong");
    namesMap.put("HM", "Herd i Mekdonald Ostrva");
    namesMap.put("HN", "Honduras");
    namesMap.put("HR", "Hrvatska");
    namesMap.put("HT", "Haiti");
    namesMap.put("HU", "Mađarska");
    namesMap.put("IC", "Kanarska ostrva");
    namesMap.put("ID", "Indonezija");
    namesMap.put("IE", "Irska");
    namesMap.put("IL", "Izrael");
    namesMap.put("IM", "Ostrvo Man");
    namesMap.put("IN", "Indija");
    namesMap.put("IO", "Britansko Indijska Okeanska Teritorija");
    namesMap.put("IQ", "Irak");
    namesMap.put("IR", "Iran");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Italija");
    namesMap.put("JE", "Džersi");
    namesMap.put("JM", "Jamajka");
    namesMap.put("JO", "Jordan");
    namesMap.put("JP", "Japan");
    namesMap.put("KE", "Kenija");
    namesMap.put("KG", "Kirgizstan");
    namesMap.put("KH", "Kambodža");
    namesMap.put("KI", "Kiribati");
    namesMap.put("KM", "Komorska Ostrva");
    namesMap.put("KN", "Sent Kits i Nevis");
    namesMap.put("KP", "Severna Koreja");
    namesMap.put("KR", "Južna Koreja");
    namesMap.put("KW", "Kuvajt");
    namesMap.put("KY", "Kajmanska Ostrva");
    namesMap.put("KZ", "Kazahstan");
    namesMap.put("LA", "Laos");
    namesMap.put("LB", "Liban");
    namesMap.put("LC", "Sent Lucija");
    namesMap.put("LI", "Lihtenštajn");
    namesMap.put("LK", "Šri Lanka");
    namesMap.put("LR", "Liberija");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Litvanija");
    namesMap.put("LU", "Luksemburg");
    namesMap.put("LV", "Letonija");
    namesMap.put("LY", "Libija");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Moldavija");
    namesMap.put("ME", "Crna Gora");
    namesMap.put("MF", "Sv. Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Maršalska Ostrva");
    namesMap.put("MK", "Makedonija");
    namesMap.put("ML", "Mali");
    namesMap.put("MM", "Mijanmar");
    namesMap.put("MN", "Mongolija");
    namesMap.put("MO", "Makao");
    namesMap.put("MP", "Severna Marijanska Ostrva");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MR", "Mauritanija");
    namesMap.put("MS", "Monserat");
    namesMap.put("MT", "Malta");
    namesMap.put("MU", "Mauricius");
    namesMap.put("MV", "Maldivi");
    namesMap.put("MW", "Malavi");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MY", "Malezija");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NA", "Namibija");
    namesMap.put("NC", "Nova Kaledonija");
    namesMap.put("NE", "Niger");
    namesMap.put("NF", "Norfolk Ostrvo");
    namesMap.put("NG", "Nigerija");
    namesMap.put("NI", "Nikaragva");
    namesMap.put("NL", "Holandija");
    namesMap.put("NO", "Norveška");
    namesMap.put("NP", "Nepal");
    namesMap.put("NR", "Nauru");
    namesMap.put("NU", "Niue");
    namesMap.put("NZ", "Novi Zeland");
    namesMap.put("OM", "Oman");
    namesMap.put("PA", "Panama");
    namesMap.put("PE", "Peru");
    namesMap.put("PF", "Francuska Polinezija");
    namesMap.put("PG", "Papua Nova Gvineja");
    namesMap.put("PH", "Filipini");
    namesMap.put("PK", "Pakistan");
    namesMap.put("PL", "Poljska");
    namesMap.put("PM", "Sen Pjer i Mikelon");
    namesMap.put("PN", "Pitcairn");
    namesMap.put("PR", "Porto Riko");
    namesMap.put("PS", "Palestinska Teritorija");
    namesMap.put("PT", "Portugal");
    namesMap.put("PW", "Palau");
    namesMap.put("PY", "Paragvaj");
    namesMap.put("QA", "Katar");
    namesMap.put("QO", "Ostala okeanija");
    namesMap.put("RE", "Rejunion");
    namesMap.put("RO", "Rumunija");
    namesMap.put("RS", "Srbija");
    namesMap.put("RU", "Rusija");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Saudijska Arabija");
    namesMap.put("SB", "Solomonska Ostrva");
    namesMap.put("SC", "Sejšeli");
    namesMap.put("SD", "Sudan");
    namesMap.put("SE", "Švedska");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Sveta Jelena");
    namesMap.put("SI", "Slovenija");
    namesMap.put("SJ", "Svalbard i Janmajen Ostrva");
    namesMap.put("SK", "Slovačka");
    namesMap.put("SL", "Sijera Leone");
    namesMap.put("SM", "San Marino");
    namesMap.put("SN", "Senegal");
    namesMap.put("SO", "Somalija");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Sao Tome i Principe");
    namesMap.put("SV", "Salvador");
    namesMap.put("SY", "Sirija");
    namesMap.put("SZ", "Svazilend");
    namesMap.put("TA", "Tristan da Kunja");
    namesMap.put("TC", "Turks i Kajkos Ostrva");
    namesMap.put("TD", "Čad");
    namesMap.put("TF", "Francuske Južne Teritorije");
    namesMap.put("TG", "Togo");
    namesMap.put("TH", "Tajland");
    namesMap.put("TJ", "Tadžikistan");
    namesMap.put("TK", "Tokelau");
    namesMap.put("TL", "Istočni Timor");
    namesMap.put("TM", "Turkmenistan");
    namesMap.put("TN", "Tunis");
    namesMap.put("TO", "Tonga");
    namesMap.put("TR", "Turska");
    namesMap.put("TT", "Trinidad i Tobago");
    namesMap.put("TV", "Tuvalu");
    namesMap.put("TW", "Tajvan");
    namesMap.put("TZ", "Tanzanija");
    namesMap.put("UA", "Ukrajina");
    namesMap.put("UG", "Uganda");
    namesMap.put("UM", "Manja Udaljena Ostrva SAD");
    namesMap.put("US", "Sjedinjene Američke Države");
    namesMap.put("UY", "Urugvaj");
    namesMap.put("UZ", "Uzbekistan");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "Sent Vinsent i Grenadini");
    namesMap.put("VE", "Venecuela");
    namesMap.put("VG", "Britanska Devičanska Ostrva");
    namesMap.put("VI", "S.A.D. Devičanska Ostrva");
    namesMap.put("VN", "Vijetnam");
    namesMap.put("VU", "Vanuatu");
    namesMap.put("WF", "Valis i Futuna Ostrva");
    namesMap.put("WS", "Samoa");
    namesMap.put("YE", "Jemen");
    namesMap.put("YT", "Majote");
    namesMap.put("ZA", "Južnoafrička Republika");
    namesMap.put("ZM", "Zambija");
    namesMap.put("ZW", "Zimbabve");
    namesMap.put("ZZ", "Nepoznat ili nevažeći region");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Svet",
        "002": "Afrika",
        "003": "Severnoamerički kontinent",
        "005": "Južna Amerika",
        "009": "Okeanija",
        "011": "Zapadna Afrika",
        "013": "Centralna Amerika",
        "014": "Istočna Afrika",
        "015": "Severna Afrika",
        "017": "Centralna Afrika",
        "018": "Južna Afrika",
        "019": "Amerike",
        "021": "Severna Amerika",
        "029": "Karibi",
        "030": "Istočna Azija",
        "034": "Južna Azija",
        "035": "Jugoistočna Azija",
        "039": "Južna Evropa",
        "053": "Australija i Novi Zeland",
        "054": "Melanezija",
        "057": "Micronezija",
        "061": "Polinezija",
        "062": "Južno-centralna Azija",
        "142": "Azija",
        "143": "Centralna Azija",
        "145": "Zapadna Azija",
        "150": "Evropa",
        "151": "Istočna Evropa",
        "154": "Severna Evropa",
        "155": "Zapadna Evropa",
        "172": "Komonvelt nezavisnih država",
        "419": "Latinska Amerika i Karibi",
        "830": "Kanalska ostrva",
        "AC": "Ostrvo Asension",
        "AD": "Andora",
        "AE": "Ujedinjeni Arapski Emirati",
        "AF": "Avganistan",
        "AG": "Antigva i Barbuda",
        "AI": "Angvila",
        "AL": "Albanija",
        "AM": "Armenija",
        "AN": "Holandski Antili",
        "AO": "Angola",
        "AQ": "Antarktika",
        "AR": "Argentina",
        "AS": "Američka Samoa",
        "AT": "Austrija",
        "AU": "Australija",
        "AW": "Aruba",
        "AX": "Alandska ostrva",
        "AZ": "Azerbejdžan",
        "BA": "Bosna i Hercegovina",
        "BB": "Barbados",
        "BD": "Bangladeš",
        "BE": "Belgija",
        "BF": "Burkina Faso",
        "BG": "Bugarska",
        "BH": "Bahrein",
        "BI": "Burundi",
        "BJ": "Benin",
        "BL": "Sv. Bartolomej",
        "BM": "Bermuda",
        "BN": "Brunej",
        "BO": "Bolivija",
        "BR": "Brazil",
        "BS": "Bahami",
        "BT": "Butan",
        "BV": "Buve Ostrva",
        "BW": "Bocvana",
        "BY": "Belorusija",
        "BZ": "Belise",
        "CA": "Kanada",
        "CC": "Kokos (Keling) Ostrva",
        "CD": "Demokratska Republika Kongo",
        "CF": "Centralno Afrička Republika",
        "CG": "Kongo",
        "CH": "Švajcarska",
        "CI": "Obala Slonovače",
        "CK": "Kukova Ostrva",
        "CL": "Čile",
        "CM": "Kamerun",
        "CN": "Kina",
        "CO": "Kolumbija",
        "CP": "Ostrvo Kliperton",
        "CR": "Kostarika",
        "CS": "Srbija i Crna Gora",
        "CU": "Kuba",
        "CV": "Kape Verde",
        "CX": "Božićna Ostrva",
        "CY": "Kipar",
        "CZ": "Češka",
        "DE": "Nemačka",
        "DG": "Dijego Garsija",
        "DJ": "Džibuti",
        "DK": "Danska",
        "DM": "Dominika",
        "DO": "Dominikanska Republika",
        "DZ": "Alžir",
        "EA": "Seuta i Melilja",
        "EC": "Ekvador",
        "EE": "Estonija",
        "EG": "Egipat",
        "EH": "Zapadna Sahara",
        "ER": "Eritreja",
        "ES": "Španija",
        "ET": "Etiopija",
        "EU": "Evropska unija",
        "FI": "Finska",
        "FJ": "Fidži",
        "FK": "Folklandska Ostrva",
        "FM": "Mikronezija",
        "FO": "Farska Ostrva",
        "FR": "Francuska",
        "GA": "Gabon",
        "GB": "Velika Britanija",
        "GD": "Grenada",
        "GE": "Gruzija",
        "GF": "Francuska Gvajana",
        "GG": "Gurnsi",
        "GH": "Gana",
        "GI": "Gibraltar",
        "GL": "Grenland",
        "GM": "Gambija",
        "GN": "Gvineja",
        "GP": "Gvadelupe",
        "GQ": "Ekvatorijalna Gvineja",
        "GR": "Grčka",
        "GS": "Južna Džordžija i Južna Sendvič Ostrva",
        "GT": "Gvatemala",
        "GU": "Guam",
        "GW": "Gvineja-Bisao",
        "GY": "Gvajana",
        "HK": "Hong Kong",
        "HM": "Herd i Mekdonald Ostrva",
        "HN": "Honduras",
        "HR": "Hrvatska",
        "HT": "Haiti",
        "HU": "Mađarska",
        "IC": "Kanarska ostrva",
        "ID": "Indonezija",
        "IE": "Irska",
        "IL": "Izrael",
        "IM": "Ostrvo Man",
        "IN": "Indija",
        "IO": "Britansko Indijska Okeanska Teritorija",
        "IQ": "Irak",
        "IR": "Iran",
        "IS": "Island",
        "IT": "Italija",
        "JE": "Džersi",
        "JM": "Jamajka",
        "JO": "Jordan",
        "JP": "Japan",
        "KE": "Kenija",
        "KG": "Kirgizstan",
        "KH": "Kambodža",
        "KI": "Kiribati",
        "KM": "Komorska Ostrva",
        "KN": "Sent Kits i Nevis",
        "KP": "Severna Koreja",
        "KR": "Južna Koreja",
        "KW": "Kuvajt",
        "KY": "Kajmanska Ostrva",
        "KZ": "Kazahstan",
        "LA": "Laos",
        "LB": "Liban",
        "LC": "Sent Lucija",
        "LI": "Lihtenštajn",
        "LK": "Šri Lanka",
        "LR": "Liberija",
        "LS": "Lesoto",
        "LT": "Litvanija",
        "LU": "Luksemburg",
        "LV": "Letonija",
        "LY": "Libija",
        "MA": "Maroko",
        "MC": "Monako",
        "MD": "Moldavija",
        "ME": "Crna Gora",
        "MF": "Sv. Martin",
        "MG": "Madagaskar",
        "MH": "Maršalska Ostrva",
        "MK": "Makedonija",
        "ML": "Mali",
        "MM": "Mijanmar",
        "MN": "Mongolija",
        "MO": "Makao",
        "MP": "Severna Marijanska Ostrva",
        "MQ": "Martinik",
        "MR": "Mauritanija",
        "MS": "Monserat",
        "MT": "Malta",
        "MU": "Mauricius",
        "MV": "Maldivi",
        "MW": "Malavi",
        "MX": "Meksiko",
        "MY": "Malezija",
        "MZ": "Mozambik",
        "NA": "Namibija",
        "NC": "Nova Kaledonija",
        "NE": "Niger",
        "NF": "Norfolk Ostrvo",
        "NG": "Nigerija",
        "NI": "Nikaragva",
        "NL": "Holandija",
        "NO": "Norveška",
        "NP": "Nepal",
        "NR": "Nauru",
        "NU": "Niue",
        "NZ": "Novi Zeland",
        "OM": "Oman",
        "PA": "Panama",
        "PE": "Peru",
        "PF": "Francuska Polinezija",
        "PG": "Papua Nova Gvineja",
        "PH": "Filipini",
        "PK": "Pakistan",
        "PL": "Poljska",
        "PM": "Sen Pjer i Mikelon",
        "PN": "Pitcairn",
        "PR": "Porto Riko",
        "PS": "Palestinska Teritorija",
        "PT": "Portugal",
        "PW": "Palau",
        "PY": "Paragvaj",
        "QA": "Katar",
        "QO": "Ostala okeanija",
        "RE": "Rejunion",
        "RO": "Rumunija",
        "RS": "Srbija",
        "RU": "Rusija",
        "RW": "Ruanda",
        "SA": "Saudijska Arabija",
        "SB": "Solomonska Ostrva",
        "SC": "Sejšeli",
        "SD": "Sudan",
        "SE": "Švedska",
        "SG": "Singapur",
        "SH": "Sveta Jelena",
        "SI": "Slovenija",
        "SJ": "Svalbard i Janmajen Ostrva",
        "SK": "Slovačka",
        "SL": "Sijera Leone",
        "SM": "San Marino",
        "SN": "Senegal",
        "SO": "Somalija",
        "SR": "Surinam",
        "ST": "Sao Tome i Principe",
        "SV": "Salvador",
        "SY": "Sirija",
        "SZ": "Svazilend",
        "TA": "Tristan da Kunja",
        "TC": "Turks i Kajkos Ostrva",
        "TD": "Čad",
        "TF": "Francuske Južne Teritorije",
        "TG": "Togo",
        "TH": "Tajland",
        "TJ": "Tadžikistan",
        "TK": "Tokelau",
        "TL": "Istočni Timor",
        "TM": "Turkmenistan",
        "TN": "Tunis",
        "TO": "Tonga",
        "TR": "Turska",
        "TT": "Trinidad i Tobago",
        "TV": "Tuvalu",
        "TW": "Tajvan",
        "TZ": "Tanzanija",
        "UA": "Ukrajina",
        "UG": "Uganda",
        "UM": "Manja Udaljena Ostrva SAD",
        "US": "Sjedinjene Američke Države",
        "UY": "Urugvaj",
        "UZ": "Uzbekistan",
        "VA": "Vatikan",
        "VC": "Sent Vinsent i Grenadini",
        "VE": "Venecuela",
        "VG": "Britanska Devičanska Ostrva",
        "VI": "S.A.D. Devičanska Ostrva",
        "VN": "Vijetnam",
        "VU": "Vanuatu",
        "WF": "Valis i Futuna Ostrva",
        "WS": "Samoa",
        "YE": "Jemen",
        "YT": "Majote",
        "ZA": "Južnoafrička Republika",
        "ZM": "Zambija",
        "ZW": "Zimbabve",
        "ZZ": "Nepoznat ili nevažeći region"
    };
  }-*/;
}
