/*
 * Copyright (C) 2012, Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1.  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "config.h"
#if ENABLE(WEB_AUDIO)
#include "V8OscillatorNode.h"

#include "bindings/v8/ExceptionState.h"
#include "bindings/v8/V8Binding.h"
#include "modules/webaudio/OscillatorNode.h"

namespace WebCore {

void V8OscillatorNode::typeAttributeSetterCustom(v8::Local<v8::Value> value, const v8::PropertyCallbackInfo<void>& info)
{
    ExceptionState exceptionState(ExceptionState::SetterContext, "type", "OscillatorNode", info.Holder(), info.GetIsolate());
    v8::Handle<v8::Object> holder = info.Holder();
    OscillatorNode* impl = V8OscillatorNode::toNative(holder);

    if (value->IsNumber()) {
        uint32_t type = toUInt32(value, exceptionState);
        if (exceptionState.throwIfNeeded())
            return;
        if (!impl->setType(type)) {
            exceptionState.throwTypeError("Illegal OscillatorNode type");
            exceptionState.throwIfNeeded();
        }
        return;
    }

    if (value->IsString()) {
        String type = toCoreString(value.As<v8::String>());
        if (type == "sine" || type == "square" || type == "sawtooth" || type == "triangle") {
            impl->setType(type);
            return;
        }
    }

    exceptionState.throwTypeError("Illegal OscillatorNode type");
    exceptionState.throwIfNeeded();
}

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
