/* This file is generated by venus-protocol.  See vn_protocol_driver.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_DRIVER_DEVICE_H
#define VN_PROTOCOL_DRIVER_DEVICE_H

#include "vn_ring.h"
#include "vn_protocol_driver_structs.h"

/*
 * These structs/unions/commands are not included
 *
 *   vkGetDeviceProcAddr
 */

/* struct VkPhysicalDeviceLimits */

static inline size_t
vn_sizeof_VkPhysicalDeviceLimits(const VkPhysicalDeviceLimits *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->maxImageDimension1D);
    size += vn_sizeof_uint32_t(&val->maxImageDimension2D);
    size += vn_sizeof_uint32_t(&val->maxImageDimension3D);
    size += vn_sizeof_uint32_t(&val->maxImageDimensionCube);
    size += vn_sizeof_uint32_t(&val->maxImageArrayLayers);
    size += vn_sizeof_uint32_t(&val->maxTexelBufferElements);
    size += vn_sizeof_uint32_t(&val->maxUniformBufferRange);
    size += vn_sizeof_uint32_t(&val->maxStorageBufferRange);
    size += vn_sizeof_uint32_t(&val->maxPushConstantsSize);
    size += vn_sizeof_uint32_t(&val->maxMemoryAllocationCount);
    size += vn_sizeof_uint32_t(&val->maxSamplerAllocationCount);
    size += vn_sizeof_VkDeviceSize(&val->bufferImageGranularity);
    size += vn_sizeof_VkDeviceSize(&val->sparseAddressSpaceSize);
    size += vn_sizeof_uint32_t(&val->maxBoundDescriptorSets);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorSamplers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUniformBuffers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorStorageBuffers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorSampledImages);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorStorageImages);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorInputAttachments);
    size += vn_sizeof_uint32_t(&val->maxPerStageResources);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetSamplers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUniformBuffers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUniformBuffersDynamic);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetStorageBuffers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetStorageBuffersDynamic);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetSampledImages);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetStorageImages);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetInputAttachments);
    size += vn_sizeof_uint32_t(&val->maxVertexInputAttributes);
    size += vn_sizeof_uint32_t(&val->maxVertexInputBindings);
    size += vn_sizeof_uint32_t(&val->maxVertexInputAttributeOffset);
    size += vn_sizeof_uint32_t(&val->maxVertexInputBindingStride);
    size += vn_sizeof_uint32_t(&val->maxVertexOutputComponents);
    size += vn_sizeof_uint32_t(&val->maxTessellationGenerationLevel);
    size += vn_sizeof_uint32_t(&val->maxTessellationPatchSize);
    size += vn_sizeof_uint32_t(&val->maxTessellationControlPerVertexInputComponents);
    size += vn_sizeof_uint32_t(&val->maxTessellationControlPerVertexOutputComponents);
    size += vn_sizeof_uint32_t(&val->maxTessellationControlPerPatchOutputComponents);
    size += vn_sizeof_uint32_t(&val->maxTessellationControlTotalOutputComponents);
    size += vn_sizeof_uint32_t(&val->maxTessellationEvaluationInputComponents);
    size += vn_sizeof_uint32_t(&val->maxTessellationEvaluationOutputComponents);
    size += vn_sizeof_uint32_t(&val->maxGeometryShaderInvocations);
    size += vn_sizeof_uint32_t(&val->maxGeometryInputComponents);
    size += vn_sizeof_uint32_t(&val->maxGeometryOutputComponents);
    size += vn_sizeof_uint32_t(&val->maxGeometryOutputVertices);
    size += vn_sizeof_uint32_t(&val->maxGeometryTotalOutputComponents);
    size += vn_sizeof_uint32_t(&val->maxFragmentInputComponents);
    size += vn_sizeof_uint32_t(&val->maxFragmentOutputAttachments);
    size += vn_sizeof_uint32_t(&val->maxFragmentDualSrcAttachments);
    size += vn_sizeof_uint32_t(&val->maxFragmentCombinedOutputResources);
    size += vn_sizeof_uint32_t(&val->maxComputeSharedMemorySize);
    size += vn_sizeof_array_size(3);
    size += vn_sizeof_uint32_t_array(val->maxComputeWorkGroupCount, 3);
    size += vn_sizeof_uint32_t(&val->maxComputeWorkGroupInvocations);
    size += vn_sizeof_array_size(3);
    size += vn_sizeof_uint32_t_array(val->maxComputeWorkGroupSize, 3);
    size += vn_sizeof_uint32_t(&val->subPixelPrecisionBits);
    size += vn_sizeof_uint32_t(&val->subTexelPrecisionBits);
    size += vn_sizeof_uint32_t(&val->mipmapPrecisionBits);
    size += vn_sizeof_uint32_t(&val->maxDrawIndexedIndexValue);
    size += vn_sizeof_uint32_t(&val->maxDrawIndirectCount);
    size += vn_sizeof_float(&val->maxSamplerLodBias);
    size += vn_sizeof_float(&val->maxSamplerAnisotropy);
    size += vn_sizeof_uint32_t(&val->maxViewports);
    size += vn_sizeof_array_size(2);
    size += vn_sizeof_uint32_t_array(val->maxViewportDimensions, 2);
    size += vn_sizeof_array_size(2);
    size += vn_sizeof_float_array(val->viewportBoundsRange, 2);
    size += vn_sizeof_uint32_t(&val->viewportSubPixelBits);
    size += vn_sizeof_size_t(&val->minMemoryMapAlignment);
    size += vn_sizeof_VkDeviceSize(&val->minTexelBufferOffsetAlignment);
    size += vn_sizeof_VkDeviceSize(&val->minUniformBufferOffsetAlignment);
    size += vn_sizeof_VkDeviceSize(&val->minStorageBufferOffsetAlignment);
    size += vn_sizeof_int32_t(&val->minTexelOffset);
    size += vn_sizeof_uint32_t(&val->maxTexelOffset);
    size += vn_sizeof_int32_t(&val->minTexelGatherOffset);
    size += vn_sizeof_uint32_t(&val->maxTexelGatherOffset);
    size += vn_sizeof_float(&val->minInterpolationOffset);
    size += vn_sizeof_float(&val->maxInterpolationOffset);
    size += vn_sizeof_uint32_t(&val->subPixelInterpolationOffsetBits);
    size += vn_sizeof_uint32_t(&val->maxFramebufferWidth);
    size += vn_sizeof_uint32_t(&val->maxFramebufferHeight);
    size += vn_sizeof_uint32_t(&val->maxFramebufferLayers);
    size += vn_sizeof_VkFlags(&val->framebufferColorSampleCounts);
    size += vn_sizeof_VkFlags(&val->framebufferDepthSampleCounts);
    size += vn_sizeof_VkFlags(&val->framebufferStencilSampleCounts);
    size += vn_sizeof_VkFlags(&val->framebufferNoAttachmentsSampleCounts);
    size += vn_sizeof_uint32_t(&val->maxColorAttachments);
    size += vn_sizeof_VkFlags(&val->sampledImageColorSampleCounts);
    size += vn_sizeof_VkFlags(&val->sampledImageIntegerSampleCounts);
    size += vn_sizeof_VkFlags(&val->sampledImageDepthSampleCounts);
    size += vn_sizeof_VkFlags(&val->sampledImageStencilSampleCounts);
    size += vn_sizeof_VkFlags(&val->storageImageSampleCounts);
    size += vn_sizeof_uint32_t(&val->maxSampleMaskWords);
    size += vn_sizeof_VkBool32(&val->timestampComputeAndGraphics);
    size += vn_sizeof_float(&val->timestampPeriod);
    size += vn_sizeof_uint32_t(&val->maxClipDistances);
    size += vn_sizeof_uint32_t(&val->maxCullDistances);
    size += vn_sizeof_uint32_t(&val->maxCombinedClipAndCullDistances);
    size += vn_sizeof_uint32_t(&val->discreteQueuePriorities);
    size += vn_sizeof_array_size(2);
    size += vn_sizeof_float_array(val->pointSizeRange, 2);
    size += vn_sizeof_array_size(2);
    size += vn_sizeof_float_array(val->lineWidthRange, 2);
    size += vn_sizeof_float(&val->pointSizeGranularity);
    size += vn_sizeof_float(&val->lineWidthGranularity);
    size += vn_sizeof_VkBool32(&val->strictLines);
    size += vn_sizeof_VkBool32(&val->standardSampleLocations);
    size += vn_sizeof_VkDeviceSize(&val->optimalBufferCopyOffsetAlignment);
    size += vn_sizeof_VkDeviceSize(&val->optimalBufferCopyRowPitchAlignment);
    size += vn_sizeof_VkDeviceSize(&val->nonCoherentAtomSize);
    return size;
}

static inline void
vn_decode_VkPhysicalDeviceLimits(struct vn_cs_decoder *dec, VkPhysicalDeviceLimits *val)
{
    vn_decode_uint32_t(dec, &val->maxImageDimension1D);
    vn_decode_uint32_t(dec, &val->maxImageDimension2D);
    vn_decode_uint32_t(dec, &val->maxImageDimension3D);
    vn_decode_uint32_t(dec, &val->maxImageDimensionCube);
    vn_decode_uint32_t(dec, &val->maxImageArrayLayers);
    vn_decode_uint32_t(dec, &val->maxTexelBufferElements);
    vn_decode_uint32_t(dec, &val->maxUniformBufferRange);
    vn_decode_uint32_t(dec, &val->maxStorageBufferRange);
    vn_decode_uint32_t(dec, &val->maxPushConstantsSize);
    vn_decode_uint32_t(dec, &val->maxMemoryAllocationCount);
    vn_decode_uint32_t(dec, &val->maxSamplerAllocationCount);
    vn_decode_VkDeviceSize(dec, &val->bufferImageGranularity);
    vn_decode_VkDeviceSize(dec, &val->sparseAddressSpaceSize);
    vn_decode_uint32_t(dec, &val->maxBoundDescriptorSets);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorSamplers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUniformBuffers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorStorageBuffers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorSampledImages);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorStorageImages);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorInputAttachments);
    vn_decode_uint32_t(dec, &val->maxPerStageResources);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetSamplers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUniformBuffers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUniformBuffersDynamic);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetStorageBuffers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetStorageBuffersDynamic);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetSampledImages);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetStorageImages);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetInputAttachments);
    vn_decode_uint32_t(dec, &val->maxVertexInputAttributes);
    vn_decode_uint32_t(dec, &val->maxVertexInputBindings);
    vn_decode_uint32_t(dec, &val->maxVertexInputAttributeOffset);
    vn_decode_uint32_t(dec, &val->maxVertexInputBindingStride);
    vn_decode_uint32_t(dec, &val->maxVertexOutputComponents);
    vn_decode_uint32_t(dec, &val->maxTessellationGenerationLevel);
    vn_decode_uint32_t(dec, &val->maxTessellationPatchSize);
    vn_decode_uint32_t(dec, &val->maxTessellationControlPerVertexInputComponents);
    vn_decode_uint32_t(dec, &val->maxTessellationControlPerVertexOutputComponents);
    vn_decode_uint32_t(dec, &val->maxTessellationControlPerPatchOutputComponents);
    vn_decode_uint32_t(dec, &val->maxTessellationControlTotalOutputComponents);
    vn_decode_uint32_t(dec, &val->maxTessellationEvaluationInputComponents);
    vn_decode_uint32_t(dec, &val->maxTessellationEvaluationOutputComponents);
    vn_decode_uint32_t(dec, &val->maxGeometryShaderInvocations);
    vn_decode_uint32_t(dec, &val->maxGeometryInputComponents);
    vn_decode_uint32_t(dec, &val->maxGeometryOutputComponents);
    vn_decode_uint32_t(dec, &val->maxGeometryOutputVertices);
    vn_decode_uint32_t(dec, &val->maxGeometryTotalOutputComponents);
    vn_decode_uint32_t(dec, &val->maxFragmentInputComponents);
    vn_decode_uint32_t(dec, &val->maxFragmentOutputAttachments);
    vn_decode_uint32_t(dec, &val->maxFragmentDualSrcAttachments);
    vn_decode_uint32_t(dec, &val->maxFragmentCombinedOutputResources);
    vn_decode_uint32_t(dec, &val->maxComputeSharedMemorySize);
    {
        const size_t array_size = vn_decode_array_size(dec, 3);
        vn_decode_uint32_t_array(dec, val->maxComputeWorkGroupCount, array_size);
    }
    vn_decode_uint32_t(dec, &val->maxComputeWorkGroupInvocations);
    {
        const size_t array_size = vn_decode_array_size(dec, 3);
        vn_decode_uint32_t_array(dec, val->maxComputeWorkGroupSize, array_size);
    }
    vn_decode_uint32_t(dec, &val->subPixelPrecisionBits);
    vn_decode_uint32_t(dec, &val->subTexelPrecisionBits);
    vn_decode_uint32_t(dec, &val->mipmapPrecisionBits);
    vn_decode_uint32_t(dec, &val->maxDrawIndexedIndexValue);
    vn_decode_uint32_t(dec, &val->maxDrawIndirectCount);
    vn_decode_float(dec, &val->maxSamplerLodBias);
    vn_decode_float(dec, &val->maxSamplerAnisotropy);
    vn_decode_uint32_t(dec, &val->maxViewports);
    {
        const size_t array_size = vn_decode_array_size(dec, 2);
        vn_decode_uint32_t_array(dec, val->maxViewportDimensions, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, 2);
        vn_decode_float_array(dec, val->viewportBoundsRange, array_size);
    }
    vn_decode_uint32_t(dec, &val->viewportSubPixelBits);
    vn_decode_size_t(dec, &val->minMemoryMapAlignment);
    vn_decode_VkDeviceSize(dec, &val->minTexelBufferOffsetAlignment);
    vn_decode_VkDeviceSize(dec, &val->minUniformBufferOffsetAlignment);
    vn_decode_VkDeviceSize(dec, &val->minStorageBufferOffsetAlignment);
    vn_decode_int32_t(dec, &val->minTexelOffset);
    vn_decode_uint32_t(dec, &val->maxTexelOffset);
    vn_decode_int32_t(dec, &val->minTexelGatherOffset);
    vn_decode_uint32_t(dec, &val->maxTexelGatherOffset);
    vn_decode_float(dec, &val->minInterpolationOffset);
    vn_decode_float(dec, &val->maxInterpolationOffset);
    vn_decode_uint32_t(dec, &val->subPixelInterpolationOffsetBits);
    vn_decode_uint32_t(dec, &val->maxFramebufferWidth);
    vn_decode_uint32_t(dec, &val->maxFramebufferHeight);
    vn_decode_uint32_t(dec, &val->maxFramebufferLayers);
    vn_decode_VkFlags(dec, &val->framebufferColorSampleCounts);
    vn_decode_VkFlags(dec, &val->framebufferDepthSampleCounts);
    vn_decode_VkFlags(dec, &val->framebufferStencilSampleCounts);
    vn_decode_VkFlags(dec, &val->framebufferNoAttachmentsSampleCounts);
    vn_decode_uint32_t(dec, &val->maxColorAttachments);
    vn_decode_VkFlags(dec, &val->sampledImageColorSampleCounts);
    vn_decode_VkFlags(dec, &val->sampledImageIntegerSampleCounts);
    vn_decode_VkFlags(dec, &val->sampledImageDepthSampleCounts);
    vn_decode_VkFlags(dec, &val->sampledImageStencilSampleCounts);
    vn_decode_VkFlags(dec, &val->storageImageSampleCounts);
    vn_decode_uint32_t(dec, &val->maxSampleMaskWords);
    vn_decode_VkBool32(dec, &val->timestampComputeAndGraphics);
    vn_decode_float(dec, &val->timestampPeriod);
    vn_decode_uint32_t(dec, &val->maxClipDistances);
    vn_decode_uint32_t(dec, &val->maxCullDistances);
    vn_decode_uint32_t(dec, &val->maxCombinedClipAndCullDistances);
    vn_decode_uint32_t(dec, &val->discreteQueuePriorities);
    {
        const size_t array_size = vn_decode_array_size(dec, 2);
        vn_decode_float_array(dec, val->pointSizeRange, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, 2);
        vn_decode_float_array(dec, val->lineWidthRange, array_size);
    }
    vn_decode_float(dec, &val->pointSizeGranularity);
    vn_decode_float(dec, &val->lineWidthGranularity);
    vn_decode_VkBool32(dec, &val->strictLines);
    vn_decode_VkBool32(dec, &val->standardSampleLocations);
    vn_decode_VkDeviceSize(dec, &val->optimalBufferCopyOffsetAlignment);
    vn_decode_VkDeviceSize(dec, &val->optimalBufferCopyRowPitchAlignment);
    vn_decode_VkDeviceSize(dec, &val->nonCoherentAtomSize);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceLimits_partial(const VkPhysicalDeviceLimits *val)
{
    size_t size = 0;
    /* skip val->maxImageDimension1D */
    /* skip val->maxImageDimension2D */
    /* skip val->maxImageDimension3D */
    /* skip val->maxImageDimensionCube */
    /* skip val->maxImageArrayLayers */
    /* skip val->maxTexelBufferElements */
    /* skip val->maxUniformBufferRange */
    /* skip val->maxStorageBufferRange */
    /* skip val->maxPushConstantsSize */
    /* skip val->maxMemoryAllocationCount */
    /* skip val->maxSamplerAllocationCount */
    /* skip val->bufferImageGranularity */
    /* skip val->sparseAddressSpaceSize */
    /* skip val->maxBoundDescriptorSets */
    /* skip val->maxPerStageDescriptorSamplers */
    /* skip val->maxPerStageDescriptorUniformBuffers */
    /* skip val->maxPerStageDescriptorStorageBuffers */
    /* skip val->maxPerStageDescriptorSampledImages */
    /* skip val->maxPerStageDescriptorStorageImages */
    /* skip val->maxPerStageDescriptorInputAttachments */
    /* skip val->maxPerStageResources */
    /* skip val->maxDescriptorSetSamplers */
    /* skip val->maxDescriptorSetUniformBuffers */
    /* skip val->maxDescriptorSetUniformBuffersDynamic */
    /* skip val->maxDescriptorSetStorageBuffers */
    /* skip val->maxDescriptorSetStorageBuffersDynamic */
    /* skip val->maxDescriptorSetSampledImages */
    /* skip val->maxDescriptorSetStorageImages */
    /* skip val->maxDescriptorSetInputAttachments */
    /* skip val->maxVertexInputAttributes */
    /* skip val->maxVertexInputBindings */
    /* skip val->maxVertexInputAttributeOffset */
    /* skip val->maxVertexInputBindingStride */
    /* skip val->maxVertexOutputComponents */
    /* skip val->maxTessellationGenerationLevel */
    /* skip val->maxTessellationPatchSize */
    /* skip val->maxTessellationControlPerVertexInputComponents */
    /* skip val->maxTessellationControlPerVertexOutputComponents */
    /* skip val->maxTessellationControlPerPatchOutputComponents */
    /* skip val->maxTessellationControlTotalOutputComponents */
    /* skip val->maxTessellationEvaluationInputComponents */
    /* skip val->maxTessellationEvaluationOutputComponents */
    /* skip val->maxGeometryShaderInvocations */
    /* skip val->maxGeometryInputComponents */
    /* skip val->maxGeometryOutputComponents */
    /* skip val->maxGeometryOutputVertices */
    /* skip val->maxGeometryTotalOutputComponents */
    /* skip val->maxFragmentInputComponents */
    /* skip val->maxFragmentOutputAttachments */
    /* skip val->maxFragmentDualSrcAttachments */
    /* skip val->maxFragmentCombinedOutputResources */
    /* skip val->maxComputeSharedMemorySize */
    /* skip val->maxComputeWorkGroupCount */
    /* skip val->maxComputeWorkGroupInvocations */
    /* skip val->maxComputeWorkGroupSize */
    /* skip val->subPixelPrecisionBits */
    /* skip val->subTexelPrecisionBits */
    /* skip val->mipmapPrecisionBits */
    /* skip val->maxDrawIndexedIndexValue */
    /* skip val->maxDrawIndirectCount */
    /* skip val->maxSamplerLodBias */
    /* skip val->maxSamplerAnisotropy */
    /* skip val->maxViewports */
    /* skip val->maxViewportDimensions */
    /* skip val->viewportBoundsRange */
    /* skip val->viewportSubPixelBits */
    /* skip val->minMemoryMapAlignment */
    /* skip val->minTexelBufferOffsetAlignment */
    /* skip val->minUniformBufferOffsetAlignment */
    /* skip val->minStorageBufferOffsetAlignment */
    /* skip val->minTexelOffset */
    /* skip val->maxTexelOffset */
    /* skip val->minTexelGatherOffset */
    /* skip val->maxTexelGatherOffset */
    /* skip val->minInterpolationOffset */
    /* skip val->maxInterpolationOffset */
    /* skip val->subPixelInterpolationOffsetBits */
    /* skip val->maxFramebufferWidth */
    /* skip val->maxFramebufferHeight */
    /* skip val->maxFramebufferLayers */
    /* skip val->framebufferColorSampleCounts */
    /* skip val->framebufferDepthSampleCounts */
    /* skip val->framebufferStencilSampleCounts */
    /* skip val->framebufferNoAttachmentsSampleCounts */
    /* skip val->maxColorAttachments */
    /* skip val->sampledImageColorSampleCounts */
    /* skip val->sampledImageIntegerSampleCounts */
    /* skip val->sampledImageDepthSampleCounts */
    /* skip val->sampledImageStencilSampleCounts */
    /* skip val->storageImageSampleCounts */
    /* skip val->maxSampleMaskWords */
    /* skip val->timestampComputeAndGraphics */
    /* skip val->timestampPeriod */
    /* skip val->maxClipDistances */
    /* skip val->maxCullDistances */
    /* skip val->maxCombinedClipAndCullDistances */
    /* skip val->discreteQueuePriorities */
    /* skip val->pointSizeRange */
    /* skip val->lineWidthRange */
    /* skip val->pointSizeGranularity */
    /* skip val->lineWidthGranularity */
    /* skip val->strictLines */
    /* skip val->standardSampleLocations */
    /* skip val->optimalBufferCopyOffsetAlignment */
    /* skip val->optimalBufferCopyRowPitchAlignment */
    /* skip val->nonCoherentAtomSize */
    return size;
}

static inline void
vn_encode_VkPhysicalDeviceLimits_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceLimits *val)
{
    /* skip val->maxImageDimension1D */
    /* skip val->maxImageDimension2D */
    /* skip val->maxImageDimension3D */
    /* skip val->maxImageDimensionCube */
    /* skip val->maxImageArrayLayers */
    /* skip val->maxTexelBufferElements */
    /* skip val->maxUniformBufferRange */
    /* skip val->maxStorageBufferRange */
    /* skip val->maxPushConstantsSize */
    /* skip val->maxMemoryAllocationCount */
    /* skip val->maxSamplerAllocationCount */
    /* skip val->bufferImageGranularity */
    /* skip val->sparseAddressSpaceSize */
    /* skip val->maxBoundDescriptorSets */
    /* skip val->maxPerStageDescriptorSamplers */
    /* skip val->maxPerStageDescriptorUniformBuffers */
    /* skip val->maxPerStageDescriptorStorageBuffers */
    /* skip val->maxPerStageDescriptorSampledImages */
    /* skip val->maxPerStageDescriptorStorageImages */
    /* skip val->maxPerStageDescriptorInputAttachments */
    /* skip val->maxPerStageResources */
    /* skip val->maxDescriptorSetSamplers */
    /* skip val->maxDescriptorSetUniformBuffers */
    /* skip val->maxDescriptorSetUniformBuffersDynamic */
    /* skip val->maxDescriptorSetStorageBuffers */
    /* skip val->maxDescriptorSetStorageBuffersDynamic */
    /* skip val->maxDescriptorSetSampledImages */
    /* skip val->maxDescriptorSetStorageImages */
    /* skip val->maxDescriptorSetInputAttachments */
    /* skip val->maxVertexInputAttributes */
    /* skip val->maxVertexInputBindings */
    /* skip val->maxVertexInputAttributeOffset */
    /* skip val->maxVertexInputBindingStride */
    /* skip val->maxVertexOutputComponents */
    /* skip val->maxTessellationGenerationLevel */
    /* skip val->maxTessellationPatchSize */
    /* skip val->maxTessellationControlPerVertexInputComponents */
    /* skip val->maxTessellationControlPerVertexOutputComponents */
    /* skip val->maxTessellationControlPerPatchOutputComponents */
    /* skip val->maxTessellationControlTotalOutputComponents */
    /* skip val->maxTessellationEvaluationInputComponents */
    /* skip val->maxTessellationEvaluationOutputComponents */
    /* skip val->maxGeometryShaderInvocations */
    /* skip val->maxGeometryInputComponents */
    /* skip val->maxGeometryOutputComponents */
    /* skip val->maxGeometryOutputVertices */
    /* skip val->maxGeometryTotalOutputComponents */
    /* skip val->maxFragmentInputComponents */
    /* skip val->maxFragmentOutputAttachments */
    /* skip val->maxFragmentDualSrcAttachments */
    /* skip val->maxFragmentCombinedOutputResources */
    /* skip val->maxComputeSharedMemorySize */
    /* skip val->maxComputeWorkGroupCount */
    /* skip val->maxComputeWorkGroupInvocations */
    /* skip val->maxComputeWorkGroupSize */
    /* skip val->subPixelPrecisionBits */
    /* skip val->subTexelPrecisionBits */
    /* skip val->mipmapPrecisionBits */
    /* skip val->maxDrawIndexedIndexValue */
    /* skip val->maxDrawIndirectCount */
    /* skip val->maxSamplerLodBias */
    /* skip val->maxSamplerAnisotropy */
    /* skip val->maxViewports */
    /* skip val->maxViewportDimensions */
    /* skip val->viewportBoundsRange */
    /* skip val->viewportSubPixelBits */
    /* skip val->minMemoryMapAlignment */
    /* skip val->minTexelBufferOffsetAlignment */
    /* skip val->minUniformBufferOffsetAlignment */
    /* skip val->minStorageBufferOffsetAlignment */
    /* skip val->minTexelOffset */
    /* skip val->maxTexelOffset */
    /* skip val->minTexelGatherOffset */
    /* skip val->maxTexelGatherOffset */
    /* skip val->minInterpolationOffset */
    /* skip val->maxInterpolationOffset */
    /* skip val->subPixelInterpolationOffsetBits */
    /* skip val->maxFramebufferWidth */
    /* skip val->maxFramebufferHeight */
    /* skip val->maxFramebufferLayers */
    /* skip val->framebufferColorSampleCounts */
    /* skip val->framebufferDepthSampleCounts */
    /* skip val->framebufferStencilSampleCounts */
    /* skip val->framebufferNoAttachmentsSampleCounts */
    /* skip val->maxColorAttachments */
    /* skip val->sampledImageColorSampleCounts */
    /* skip val->sampledImageIntegerSampleCounts */
    /* skip val->sampledImageDepthSampleCounts */
    /* skip val->sampledImageStencilSampleCounts */
    /* skip val->storageImageSampleCounts */
    /* skip val->maxSampleMaskWords */
    /* skip val->timestampComputeAndGraphics */
    /* skip val->timestampPeriod */
    /* skip val->maxClipDistances */
    /* skip val->maxCullDistances */
    /* skip val->maxCombinedClipAndCullDistances */
    /* skip val->discreteQueuePriorities */
    /* skip val->pointSizeRange */
    /* skip val->lineWidthRange */
    /* skip val->pointSizeGranularity */
    /* skip val->lineWidthGranularity */
    /* skip val->strictLines */
    /* skip val->standardSampleLocations */
    /* skip val->optimalBufferCopyOffsetAlignment */
    /* skip val->optimalBufferCopyRowPitchAlignment */
    /* skip val->nonCoherentAtomSize */
}

/* struct VkPhysicalDeviceSparseProperties */

static inline size_t
vn_sizeof_VkPhysicalDeviceSparseProperties(const VkPhysicalDeviceSparseProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_VkBool32(&val->residencyStandard2DBlockShape);
    size += vn_sizeof_VkBool32(&val->residencyStandard2DMultisampleBlockShape);
    size += vn_sizeof_VkBool32(&val->residencyStandard3DBlockShape);
    size += vn_sizeof_VkBool32(&val->residencyAlignedMipSize);
    size += vn_sizeof_VkBool32(&val->residencyNonResidentStrict);
    return size;
}

static inline void
vn_decode_VkPhysicalDeviceSparseProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceSparseProperties *val)
{
    vn_decode_VkBool32(dec, &val->residencyStandard2DBlockShape);
    vn_decode_VkBool32(dec, &val->residencyStandard2DMultisampleBlockShape);
    vn_decode_VkBool32(dec, &val->residencyStandard3DBlockShape);
    vn_decode_VkBool32(dec, &val->residencyAlignedMipSize);
    vn_decode_VkBool32(dec, &val->residencyNonResidentStrict);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSparseProperties_partial(const VkPhysicalDeviceSparseProperties *val)
{
    size_t size = 0;
    /* skip val->residencyStandard2DBlockShape */
    /* skip val->residencyStandard2DMultisampleBlockShape */
    /* skip val->residencyStandard3DBlockShape */
    /* skip val->residencyAlignedMipSize */
    /* skip val->residencyNonResidentStrict */
    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSparseProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSparseProperties *val)
{
    /* skip val->residencyStandard2DBlockShape */
    /* skip val->residencyStandard2DMultisampleBlockShape */
    /* skip val->residencyStandard3DBlockShape */
    /* skip val->residencyAlignedMipSize */
    /* skip val->residencyNonResidentStrict */
}

/* struct VkPhysicalDeviceProperties */

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties(const VkPhysicalDeviceProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->apiVersion);
    size += vn_sizeof_uint32_t(&val->driverVersion);
    size += vn_sizeof_uint32_t(&val->vendorID);
    size += vn_sizeof_uint32_t(&val->deviceID);
    size += vn_sizeof_VkPhysicalDeviceType(&val->deviceType);
    size += vn_sizeof_array_size(VK_MAX_PHYSICAL_DEVICE_NAME_SIZE);
    size += vn_sizeof_char_array(val->deviceName, VK_MAX_PHYSICAL_DEVICE_NAME_SIZE);
    size += vn_sizeof_array_size(VK_UUID_SIZE);
    size += vn_sizeof_uint8_t_array(val->pipelineCacheUUID, VK_UUID_SIZE);
    size += vn_sizeof_VkPhysicalDeviceLimits(&val->limits);
    size += vn_sizeof_VkPhysicalDeviceSparseProperties(&val->sparseProperties);
    return size;
}

static inline void
vn_decode_VkPhysicalDeviceProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceProperties *val)
{
    vn_decode_uint32_t(dec, &val->apiVersion);
    vn_decode_uint32_t(dec, &val->driverVersion);
    vn_decode_uint32_t(dec, &val->vendorID);
    vn_decode_uint32_t(dec, &val->deviceID);
    vn_decode_VkPhysicalDeviceType(dec, &val->deviceType);
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_PHYSICAL_DEVICE_NAME_SIZE);
        vn_decode_char_array(dec, val->deviceName, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_UUID_SIZE);
        vn_decode_uint8_t_array(dec, val->pipelineCacheUUID, array_size);
    }
    vn_decode_VkPhysicalDeviceLimits(dec, &val->limits);
    vn_decode_VkPhysicalDeviceSparseProperties(dec, &val->sparseProperties);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties_partial(const VkPhysicalDeviceProperties *val)
{
    size_t size = 0;
    /* skip val->apiVersion */
    /* skip val->driverVersion */
    /* skip val->vendorID */
    /* skip val->deviceID */
    /* skip val->deviceType */
    /* skip val->deviceName */
    /* skip val->pipelineCacheUUID */
    size += vn_sizeof_VkPhysicalDeviceLimits_partial(&val->limits);
    size += vn_sizeof_VkPhysicalDeviceSparseProperties_partial(&val->sparseProperties);
    return size;
}

static inline void
vn_encode_VkPhysicalDeviceProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties *val)
{
    /* skip val->apiVersion */
    /* skip val->driverVersion */
    /* skip val->vendorID */
    /* skip val->deviceID */
    /* skip val->deviceType */
    /* skip val->deviceName */
    /* skip val->pipelineCacheUUID */
    vn_encode_VkPhysicalDeviceLimits_partial(enc, &val->limits);
    vn_encode_VkPhysicalDeviceSparseProperties_partial(enc, &val->sparseProperties);
}

/* struct VkQueueFamilyProperties */

static inline size_t
vn_sizeof_VkQueueFamilyProperties(const VkQueueFamilyProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->queueFlags);
    size += vn_sizeof_uint32_t(&val->queueCount);
    size += vn_sizeof_uint32_t(&val->timestampValidBits);
    size += vn_sizeof_VkExtent3D(&val->minImageTransferGranularity);
    return size;
}

static inline void
vn_decode_VkQueueFamilyProperties(struct vn_cs_decoder *dec, VkQueueFamilyProperties *val)
{
    vn_decode_VkFlags(dec, &val->queueFlags);
    vn_decode_uint32_t(dec, &val->queueCount);
    vn_decode_uint32_t(dec, &val->timestampValidBits);
    vn_decode_VkExtent3D(dec, &val->minImageTransferGranularity);
}

static inline size_t
vn_sizeof_VkQueueFamilyProperties_partial(const VkQueueFamilyProperties *val)
{
    size_t size = 0;
    /* skip val->queueFlags */
    /* skip val->queueCount */
    /* skip val->timestampValidBits */
    size += vn_sizeof_VkExtent3D_partial(&val->minImageTransferGranularity);
    return size;
}

static inline void
vn_encode_VkQueueFamilyProperties_partial(struct vn_cs_encoder *enc, const VkQueueFamilyProperties *val)
{
    /* skip val->queueFlags */
    /* skip val->queueCount */
    /* skip val->timestampValidBits */
    vn_encode_VkExtent3D_partial(enc, &val->minImageTransferGranularity);
}

/* struct VkMemoryType */

static inline size_t
vn_sizeof_VkMemoryType(const VkMemoryType *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->propertyFlags);
    size += vn_sizeof_uint32_t(&val->heapIndex);
    return size;
}

static inline void
vn_decode_VkMemoryType(struct vn_cs_decoder *dec, VkMemoryType *val)
{
    vn_decode_VkFlags(dec, &val->propertyFlags);
    vn_decode_uint32_t(dec, &val->heapIndex);
}

static inline size_t
vn_sizeof_VkMemoryType_partial(const VkMemoryType *val)
{
    size_t size = 0;
    /* skip val->propertyFlags */
    /* skip val->heapIndex */
    return size;
}

static inline void
vn_encode_VkMemoryType_partial(struct vn_cs_encoder *enc, const VkMemoryType *val)
{
    /* skip val->propertyFlags */
    /* skip val->heapIndex */
}

/* struct VkMemoryHeap */

static inline size_t
vn_sizeof_VkMemoryHeap(const VkMemoryHeap *val)
{
    size_t size = 0;
    size += vn_sizeof_VkDeviceSize(&val->size);
    size += vn_sizeof_VkFlags(&val->flags);
    return size;
}

static inline void
vn_decode_VkMemoryHeap(struct vn_cs_decoder *dec, VkMemoryHeap *val)
{
    vn_decode_VkDeviceSize(dec, &val->size);
    vn_decode_VkFlags(dec, &val->flags);
}

static inline size_t
vn_sizeof_VkMemoryHeap_partial(const VkMemoryHeap *val)
{
    size_t size = 0;
    /* skip val->size */
    /* skip val->flags */
    return size;
}

static inline void
vn_encode_VkMemoryHeap_partial(struct vn_cs_encoder *enc, const VkMemoryHeap *val)
{
    /* skip val->size */
    /* skip val->flags */
}

/* struct VkPhysicalDeviceMemoryProperties */

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties(const VkPhysicalDeviceMemoryProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_uint32_t(&val->memoryTypeCount);
    size += vn_sizeof_array_size(VK_MAX_MEMORY_TYPES);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_TYPES; i++)
        size += vn_sizeof_VkMemoryType(&val->memoryTypes[i]);
    size += vn_sizeof_uint32_t(&val->memoryHeapCount);
    size += vn_sizeof_array_size(VK_MAX_MEMORY_HEAPS);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; i++)
        size += vn_sizeof_VkMemoryHeap(&val->memoryHeaps[i]);
    return size;
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryProperties *val)
{
    vn_decode_uint32_t(dec, &val->memoryTypeCount);
    {
        const uint32_t iter_count = vn_decode_array_size(dec, VK_MAX_MEMORY_TYPES);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkMemoryType(dec, &val->memoryTypes[i]);
    }
    vn_decode_uint32_t(dec, &val->memoryHeapCount);
    {
        const uint32_t iter_count = vn_decode_array_size(dec, VK_MAX_MEMORY_HEAPS);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkMemoryHeap(dec, &val->memoryHeaps[i]);
    }
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties_partial(const VkPhysicalDeviceMemoryProperties *val)
{
    size_t size = 0;
    /* skip val->memoryTypeCount */
    size += vn_sizeof_array_size(VK_MAX_MEMORY_TYPES);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_TYPES; i++)
        size += vn_sizeof_VkMemoryType_partial(&val->memoryTypes[i]);
    /* skip val->memoryHeapCount */
    size += vn_sizeof_array_size(VK_MAX_MEMORY_HEAPS);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; i++)
        size += vn_sizeof_VkMemoryHeap_partial(&val->memoryHeaps[i]);
    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryProperties *val)
{
    /* skip val->memoryTypeCount */
    vn_encode_array_size(enc, VK_MAX_MEMORY_TYPES);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_TYPES; i++)
        vn_encode_VkMemoryType_partial(enc, &val->memoryTypes[i]);
    /* skip val->memoryHeapCount */
    vn_encode_array_size(enc, VK_MAX_MEMORY_HEAPS);
    for (uint32_t i = 0; i < VK_MAX_MEMORY_HEAPS; i++)
        vn_encode_VkMemoryHeap_partial(enc, &val->memoryHeaps[i]);
}

/* struct VkPhysicalDeviceFeatures */

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures(const VkPhysicalDeviceFeatures *val)
{
    size_t size = 0;
    size += vn_sizeof_VkBool32(&val->robustBufferAccess);
    size += vn_sizeof_VkBool32(&val->fullDrawIndexUint32);
    size += vn_sizeof_VkBool32(&val->imageCubeArray);
    size += vn_sizeof_VkBool32(&val->independentBlend);
    size += vn_sizeof_VkBool32(&val->geometryShader);
    size += vn_sizeof_VkBool32(&val->tessellationShader);
    size += vn_sizeof_VkBool32(&val->sampleRateShading);
    size += vn_sizeof_VkBool32(&val->dualSrcBlend);
    size += vn_sizeof_VkBool32(&val->logicOp);
    size += vn_sizeof_VkBool32(&val->multiDrawIndirect);
    size += vn_sizeof_VkBool32(&val->drawIndirectFirstInstance);
    size += vn_sizeof_VkBool32(&val->depthClamp);
    size += vn_sizeof_VkBool32(&val->depthBiasClamp);
    size += vn_sizeof_VkBool32(&val->fillModeNonSolid);
    size += vn_sizeof_VkBool32(&val->depthBounds);
    size += vn_sizeof_VkBool32(&val->wideLines);
    size += vn_sizeof_VkBool32(&val->largePoints);
    size += vn_sizeof_VkBool32(&val->alphaToOne);
    size += vn_sizeof_VkBool32(&val->multiViewport);
    size += vn_sizeof_VkBool32(&val->samplerAnisotropy);
    size += vn_sizeof_VkBool32(&val->textureCompressionETC2);
    size += vn_sizeof_VkBool32(&val->textureCompressionASTC_LDR);
    size += vn_sizeof_VkBool32(&val->textureCompressionBC);
    size += vn_sizeof_VkBool32(&val->occlusionQueryPrecise);
    size += vn_sizeof_VkBool32(&val->pipelineStatisticsQuery);
    size += vn_sizeof_VkBool32(&val->vertexPipelineStoresAndAtomics);
    size += vn_sizeof_VkBool32(&val->fragmentStoresAndAtomics);
    size += vn_sizeof_VkBool32(&val->shaderTessellationAndGeometryPointSize);
    size += vn_sizeof_VkBool32(&val->shaderImageGatherExtended);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageExtendedFormats);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageMultisample);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageReadWithoutFormat);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageWriteWithoutFormat);
    size += vn_sizeof_VkBool32(&val->shaderUniformBufferArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderSampledImageArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageBufferArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderClipDistance);
    size += vn_sizeof_VkBool32(&val->shaderCullDistance);
    size += vn_sizeof_VkBool32(&val->shaderFloat64);
    size += vn_sizeof_VkBool32(&val->shaderInt64);
    size += vn_sizeof_VkBool32(&val->shaderInt16);
    size += vn_sizeof_VkBool32(&val->shaderResourceResidency);
    size += vn_sizeof_VkBool32(&val->shaderResourceMinLod);
    size += vn_sizeof_VkBool32(&val->sparseBinding);
    size += vn_sizeof_VkBool32(&val->sparseResidencyBuffer);
    size += vn_sizeof_VkBool32(&val->sparseResidencyImage2D);
    size += vn_sizeof_VkBool32(&val->sparseResidencyImage3D);
    size += vn_sizeof_VkBool32(&val->sparseResidency2Samples);
    size += vn_sizeof_VkBool32(&val->sparseResidency4Samples);
    size += vn_sizeof_VkBool32(&val->sparseResidency8Samples);
    size += vn_sizeof_VkBool32(&val->sparseResidency16Samples);
    size += vn_sizeof_VkBool32(&val->sparseResidencyAliased);
    size += vn_sizeof_VkBool32(&val->variableMultisampleRate);
    size += vn_sizeof_VkBool32(&val->inheritedQueries);
    return size;
}

static inline void
vn_encode_VkPhysicalDeviceFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures *val)
{
    vn_encode_VkBool32(enc, &val->robustBufferAccess);
    vn_encode_VkBool32(enc, &val->fullDrawIndexUint32);
    vn_encode_VkBool32(enc, &val->imageCubeArray);
    vn_encode_VkBool32(enc, &val->independentBlend);
    vn_encode_VkBool32(enc, &val->geometryShader);
    vn_encode_VkBool32(enc, &val->tessellationShader);
    vn_encode_VkBool32(enc, &val->sampleRateShading);
    vn_encode_VkBool32(enc, &val->dualSrcBlend);
    vn_encode_VkBool32(enc, &val->logicOp);
    vn_encode_VkBool32(enc, &val->multiDrawIndirect);
    vn_encode_VkBool32(enc, &val->drawIndirectFirstInstance);
    vn_encode_VkBool32(enc, &val->depthClamp);
    vn_encode_VkBool32(enc, &val->depthBiasClamp);
    vn_encode_VkBool32(enc, &val->fillModeNonSolid);
    vn_encode_VkBool32(enc, &val->depthBounds);
    vn_encode_VkBool32(enc, &val->wideLines);
    vn_encode_VkBool32(enc, &val->largePoints);
    vn_encode_VkBool32(enc, &val->alphaToOne);
    vn_encode_VkBool32(enc, &val->multiViewport);
    vn_encode_VkBool32(enc, &val->samplerAnisotropy);
    vn_encode_VkBool32(enc, &val->textureCompressionETC2);
    vn_encode_VkBool32(enc, &val->textureCompressionASTC_LDR);
    vn_encode_VkBool32(enc, &val->textureCompressionBC);
    vn_encode_VkBool32(enc, &val->occlusionQueryPrecise);
    vn_encode_VkBool32(enc, &val->pipelineStatisticsQuery);
    vn_encode_VkBool32(enc, &val->vertexPipelineStoresAndAtomics);
    vn_encode_VkBool32(enc, &val->fragmentStoresAndAtomics);
    vn_encode_VkBool32(enc, &val->shaderTessellationAndGeometryPointSize);
    vn_encode_VkBool32(enc, &val->shaderImageGatherExtended);
    vn_encode_VkBool32(enc, &val->shaderStorageImageExtendedFormats);
    vn_encode_VkBool32(enc, &val->shaderStorageImageMultisample);
    vn_encode_VkBool32(enc, &val->shaderStorageImageReadWithoutFormat);
    vn_encode_VkBool32(enc, &val->shaderStorageImageWriteWithoutFormat);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderClipDistance);
    vn_encode_VkBool32(enc, &val->shaderCullDistance);
    vn_encode_VkBool32(enc, &val->shaderFloat64);
    vn_encode_VkBool32(enc, &val->shaderInt64);
    vn_encode_VkBool32(enc, &val->shaderInt16);
    vn_encode_VkBool32(enc, &val->shaderResourceResidency);
    vn_encode_VkBool32(enc, &val->shaderResourceMinLod);
    vn_encode_VkBool32(enc, &val->sparseBinding);
    vn_encode_VkBool32(enc, &val->sparseResidencyBuffer);
    vn_encode_VkBool32(enc, &val->sparseResidencyImage2D);
    vn_encode_VkBool32(enc, &val->sparseResidencyImage3D);
    vn_encode_VkBool32(enc, &val->sparseResidency2Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency4Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency8Samples);
    vn_encode_VkBool32(enc, &val->sparseResidency16Samples);
    vn_encode_VkBool32(enc, &val->sparseResidencyAliased);
    vn_encode_VkBool32(enc, &val->variableMultisampleRate);
    vn_encode_VkBool32(enc, &val->inheritedQueries);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures *val)
{
    vn_decode_VkBool32(dec, &val->robustBufferAccess);
    vn_decode_VkBool32(dec, &val->fullDrawIndexUint32);
    vn_decode_VkBool32(dec, &val->imageCubeArray);
    vn_decode_VkBool32(dec, &val->independentBlend);
    vn_decode_VkBool32(dec, &val->geometryShader);
    vn_decode_VkBool32(dec, &val->tessellationShader);
    vn_decode_VkBool32(dec, &val->sampleRateShading);
    vn_decode_VkBool32(dec, &val->dualSrcBlend);
    vn_decode_VkBool32(dec, &val->logicOp);
    vn_decode_VkBool32(dec, &val->multiDrawIndirect);
    vn_decode_VkBool32(dec, &val->drawIndirectFirstInstance);
    vn_decode_VkBool32(dec, &val->depthClamp);
    vn_decode_VkBool32(dec, &val->depthBiasClamp);
    vn_decode_VkBool32(dec, &val->fillModeNonSolid);
    vn_decode_VkBool32(dec, &val->depthBounds);
    vn_decode_VkBool32(dec, &val->wideLines);
    vn_decode_VkBool32(dec, &val->largePoints);
    vn_decode_VkBool32(dec, &val->alphaToOne);
    vn_decode_VkBool32(dec, &val->multiViewport);
    vn_decode_VkBool32(dec, &val->samplerAnisotropy);
    vn_decode_VkBool32(dec, &val->textureCompressionETC2);
    vn_decode_VkBool32(dec, &val->textureCompressionASTC_LDR);
    vn_decode_VkBool32(dec, &val->textureCompressionBC);
    vn_decode_VkBool32(dec, &val->occlusionQueryPrecise);
    vn_decode_VkBool32(dec, &val->pipelineStatisticsQuery);
    vn_decode_VkBool32(dec, &val->vertexPipelineStoresAndAtomics);
    vn_decode_VkBool32(dec, &val->fragmentStoresAndAtomics);
    vn_decode_VkBool32(dec, &val->shaderTessellationAndGeometryPointSize);
    vn_decode_VkBool32(dec, &val->shaderImageGatherExtended);
    vn_decode_VkBool32(dec, &val->shaderStorageImageExtendedFormats);
    vn_decode_VkBool32(dec, &val->shaderStorageImageMultisample);
    vn_decode_VkBool32(dec, &val->shaderStorageImageReadWithoutFormat);
    vn_decode_VkBool32(dec, &val->shaderStorageImageWriteWithoutFormat);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderClipDistance);
    vn_decode_VkBool32(dec, &val->shaderCullDistance);
    vn_decode_VkBool32(dec, &val->shaderFloat64);
    vn_decode_VkBool32(dec, &val->shaderInt64);
    vn_decode_VkBool32(dec, &val->shaderInt16);
    vn_decode_VkBool32(dec, &val->shaderResourceResidency);
    vn_decode_VkBool32(dec, &val->shaderResourceMinLod);
    vn_decode_VkBool32(dec, &val->sparseBinding);
    vn_decode_VkBool32(dec, &val->sparseResidencyBuffer);
    vn_decode_VkBool32(dec, &val->sparseResidencyImage2D);
    vn_decode_VkBool32(dec, &val->sparseResidencyImage3D);
    vn_decode_VkBool32(dec, &val->sparseResidency2Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency4Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency8Samples);
    vn_decode_VkBool32(dec, &val->sparseResidency16Samples);
    vn_decode_VkBool32(dec, &val->sparseResidencyAliased);
    vn_decode_VkBool32(dec, &val->variableMultisampleRate);
    vn_decode_VkBool32(dec, &val->inheritedQueries);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures_partial(const VkPhysicalDeviceFeatures *val)
{
    size_t size = 0;
    /* skip val->robustBufferAccess */
    /* skip val->fullDrawIndexUint32 */
    /* skip val->imageCubeArray */
    /* skip val->independentBlend */
    /* skip val->geometryShader */
    /* skip val->tessellationShader */
    /* skip val->sampleRateShading */
    /* skip val->dualSrcBlend */
    /* skip val->logicOp */
    /* skip val->multiDrawIndirect */
    /* skip val->drawIndirectFirstInstance */
    /* skip val->depthClamp */
    /* skip val->depthBiasClamp */
    /* skip val->fillModeNonSolid */
    /* skip val->depthBounds */
    /* skip val->wideLines */
    /* skip val->largePoints */
    /* skip val->alphaToOne */
    /* skip val->multiViewport */
    /* skip val->samplerAnisotropy */
    /* skip val->textureCompressionETC2 */
    /* skip val->textureCompressionASTC_LDR */
    /* skip val->textureCompressionBC */
    /* skip val->occlusionQueryPrecise */
    /* skip val->pipelineStatisticsQuery */
    /* skip val->vertexPipelineStoresAndAtomics */
    /* skip val->fragmentStoresAndAtomics */
    /* skip val->shaderTessellationAndGeometryPointSize */
    /* skip val->shaderImageGatherExtended */
    /* skip val->shaderStorageImageExtendedFormats */
    /* skip val->shaderStorageImageMultisample */
    /* skip val->shaderStorageImageReadWithoutFormat */
    /* skip val->shaderStorageImageWriteWithoutFormat */
    /* skip val->shaderUniformBufferArrayDynamicIndexing */
    /* skip val->shaderSampledImageArrayDynamicIndexing */
    /* skip val->shaderStorageBufferArrayDynamicIndexing */
    /* skip val->shaderStorageImageArrayDynamicIndexing */
    /* skip val->shaderClipDistance */
    /* skip val->shaderCullDistance */
    /* skip val->shaderFloat64 */
    /* skip val->shaderInt64 */
    /* skip val->shaderInt16 */
    /* skip val->shaderResourceResidency */
    /* skip val->shaderResourceMinLod */
    /* skip val->sparseBinding */
    /* skip val->sparseResidencyBuffer */
    /* skip val->sparseResidencyImage2D */
    /* skip val->sparseResidencyImage3D */
    /* skip val->sparseResidency2Samples */
    /* skip val->sparseResidency4Samples */
    /* skip val->sparseResidency8Samples */
    /* skip val->sparseResidency16Samples */
    /* skip val->sparseResidencyAliased */
    /* skip val->variableMultisampleRate */
    /* skip val->inheritedQueries */
    return size;
}

static inline void
vn_encode_VkPhysicalDeviceFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures *val)
{
    /* skip val->robustBufferAccess */
    /* skip val->fullDrawIndexUint32 */
    /* skip val->imageCubeArray */
    /* skip val->independentBlend */
    /* skip val->geometryShader */
    /* skip val->tessellationShader */
    /* skip val->sampleRateShading */
    /* skip val->dualSrcBlend */
    /* skip val->logicOp */
    /* skip val->multiDrawIndirect */
    /* skip val->drawIndirectFirstInstance */
    /* skip val->depthClamp */
    /* skip val->depthBiasClamp */
    /* skip val->fillModeNonSolid */
    /* skip val->depthBounds */
    /* skip val->wideLines */
    /* skip val->largePoints */
    /* skip val->alphaToOne */
    /* skip val->multiViewport */
    /* skip val->samplerAnisotropy */
    /* skip val->textureCompressionETC2 */
    /* skip val->textureCompressionASTC_LDR */
    /* skip val->textureCompressionBC */
    /* skip val->occlusionQueryPrecise */
    /* skip val->pipelineStatisticsQuery */
    /* skip val->vertexPipelineStoresAndAtomics */
    /* skip val->fragmentStoresAndAtomics */
    /* skip val->shaderTessellationAndGeometryPointSize */
    /* skip val->shaderImageGatherExtended */
    /* skip val->shaderStorageImageExtendedFormats */
    /* skip val->shaderStorageImageMultisample */
    /* skip val->shaderStorageImageReadWithoutFormat */
    /* skip val->shaderStorageImageWriteWithoutFormat */
    /* skip val->shaderUniformBufferArrayDynamicIndexing */
    /* skip val->shaderSampledImageArrayDynamicIndexing */
    /* skip val->shaderStorageBufferArrayDynamicIndexing */
    /* skip val->shaderStorageImageArrayDynamicIndexing */
    /* skip val->shaderClipDistance */
    /* skip val->shaderCullDistance */
    /* skip val->shaderFloat64 */
    /* skip val->shaderInt64 */
    /* skip val->shaderInt16 */
    /* skip val->shaderResourceResidency */
    /* skip val->shaderResourceMinLod */
    /* skip val->sparseBinding */
    /* skip val->sparseResidencyBuffer */
    /* skip val->sparseResidencyImage2D */
    /* skip val->sparseResidencyImage3D */
    /* skip val->sparseResidency2Samples */
    /* skip val->sparseResidency4Samples */
    /* skip val->sparseResidency8Samples */
    /* skip val->sparseResidency16Samples */
    /* skip val->sparseResidencyAliased */
    /* skip val->variableMultisampleRate */
    /* skip val->inheritedQueries */
}

/* struct VkFormatProperties */

static inline size_t
vn_sizeof_VkFormatProperties(const VkFormatProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->linearTilingFeatures);
    size += vn_sizeof_VkFlags(&val->optimalTilingFeatures);
    size += vn_sizeof_VkFlags(&val->bufferFeatures);
    return size;
}

static inline void
vn_decode_VkFormatProperties(struct vn_cs_decoder *dec, VkFormatProperties *val)
{
    vn_decode_VkFlags(dec, &val->linearTilingFeatures);
    vn_decode_VkFlags(dec, &val->optimalTilingFeatures);
    vn_decode_VkFlags(dec, &val->bufferFeatures);
}

static inline size_t
vn_sizeof_VkFormatProperties_partial(const VkFormatProperties *val)
{
    size_t size = 0;
    /* skip val->linearTilingFeatures */
    /* skip val->optimalTilingFeatures */
    /* skip val->bufferFeatures */
    return size;
}

static inline void
vn_encode_VkFormatProperties_partial(struct vn_cs_encoder *enc, const VkFormatProperties *val)
{
    /* skip val->linearTilingFeatures */
    /* skip val->optimalTilingFeatures */
    /* skip val->bufferFeatures */
}

/* struct VkImageFormatProperties */

static inline size_t
vn_sizeof_VkImageFormatProperties(const VkImageFormatProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_VkExtent3D(&val->maxExtent);
    size += vn_sizeof_uint32_t(&val->maxMipLevels);
    size += vn_sizeof_uint32_t(&val->maxArrayLayers);
    size += vn_sizeof_VkFlags(&val->sampleCounts);
    size += vn_sizeof_VkDeviceSize(&val->maxResourceSize);
    return size;
}

static inline void
vn_decode_VkImageFormatProperties(struct vn_cs_decoder *dec, VkImageFormatProperties *val)
{
    vn_decode_VkExtent3D(dec, &val->maxExtent);
    vn_decode_uint32_t(dec, &val->maxMipLevels);
    vn_decode_uint32_t(dec, &val->maxArrayLayers);
    vn_decode_VkFlags(dec, &val->sampleCounts);
    vn_decode_VkDeviceSize(dec, &val->maxResourceSize);
}

static inline size_t
vn_sizeof_VkImageFormatProperties_partial(const VkImageFormatProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_VkExtent3D_partial(&val->maxExtent);
    /* skip val->maxMipLevels */
    /* skip val->maxArrayLayers */
    /* skip val->sampleCounts */
    /* skip val->maxResourceSize */
    return size;
}

static inline void
vn_encode_VkImageFormatProperties_partial(struct vn_cs_encoder *enc, const VkImageFormatProperties *val)
{
    vn_encode_VkExtent3D_partial(enc, &val->maxExtent);
    /* skip val->maxMipLevels */
    /* skip val->maxArrayLayers */
    /* skip val->sampleCounts */
    /* skip val->maxResourceSize */
}

/* struct VkDeviceQueueCreateInfo chain */

static inline size_t
vn_sizeof_VkDeviceQueueCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDeviceQueueCreateInfo_self(const VkDeviceQueueCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->queueFamilyIndex);
    size += vn_sizeof_uint32_t(&val->queueCount);
    if (val->pQueuePriorities) {
        size += vn_sizeof_array_size(val->queueCount);
        size += vn_sizeof_float_array(val->pQueuePriorities, val->queueCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDeviceQueueCreateInfo(const VkDeviceQueueCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDeviceQueueCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkDeviceQueueCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDeviceQueueCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceQueueCreateInfo_self(struct vn_cs_encoder *enc, const VkDeviceQueueCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->queueFamilyIndex);
    vn_encode_uint32_t(enc, &val->queueCount);
    if (val->pQueuePriorities) {
        vn_encode_array_size(enc, val->queueCount);
        vn_encode_float_array(enc, val->pQueuePriorities, val->queueCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkDeviceQueueCreateInfo(struct vn_cs_encoder *enc, const VkDeviceQueueCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO });
    vn_encode_VkDeviceQueueCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkDeviceQueueCreateInfo_self(enc, val);
}

/* struct VkDevicePrivateDataCreateInfo chain */

static inline size_t
vn_sizeof_VkDevicePrivateDataCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDevicePrivateDataCreateInfo_self(const VkDevicePrivateDataCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->privateDataSlotRequestCount);
    return size;
}

static inline size_t
vn_sizeof_VkDevicePrivateDataCreateInfo(const VkDevicePrivateDataCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDevicePrivateDataCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkDevicePrivateDataCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDevicePrivateDataCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDevicePrivateDataCreateInfo_self(struct vn_cs_encoder *enc, const VkDevicePrivateDataCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->privateDataSlotRequestCount);
}

static inline void
vn_encode_VkDevicePrivateDataCreateInfo(struct vn_cs_encoder *enc, const VkDevicePrivateDataCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO });
    vn_encode_VkDevicePrivateDataCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkDevicePrivateDataCreateInfo_self(enc, val);
}

/* struct VkPhysicalDevicePrivateDataFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDevicePrivateDataFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrivateDataFeatures_self(const VkPhysicalDevicePrivateDataFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->privateData);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrivateDataFeatures(const VkPhysicalDevicePrivateDataFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePrivateDataFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePrivateDataFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePrivateDataFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->privateData);
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevicePrivateDataFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES });
    vn_encode_VkPhysicalDevicePrivateDataFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePrivateDataFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDevicePrivateDataFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevicePrivateDataFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDevicePrivateDataFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->privateData);
}

static inline void
vn_decode_VkPhysicalDevicePrivateDataFeatures(struct vn_cs_decoder *dec, VkPhysicalDevicePrivateDataFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevicePrivateDataFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevicePrivateDataFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrivateDataFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrivateDataFeatures_self_partial(const VkPhysicalDevicePrivateDataFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->privateData */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrivateDataFeatures_partial(const VkPhysicalDevicePrivateDataFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePrivateDataFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePrivateDataFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePrivateDataFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->privateData */
}

static inline void
vn_encode_VkPhysicalDevicePrivateDataFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePrivateDataFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES });
    vn_encode_VkPhysicalDevicePrivateDataFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevicePrivateDataFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVariablePointersFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_self(const VkPhysicalDeviceVariablePointersFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->variablePointersStorageBuffer);
    size += vn_sizeof_VkBool32(&val->variablePointers);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVariablePointersFeatures(const VkPhysicalDeviceVariablePointersFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->variablePointersStorageBuffer);
    vn_encode_VkBool32(enc, &val->variablePointers);
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceVariablePointersFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES });
    vn_encode_VkPhysicalDeviceVariablePointersFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->variablePointersStorageBuffer);
    vn_decode_VkBool32(dec, &val->variablePointers);
}

static inline void
vn_decode_VkPhysicalDeviceVariablePointersFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceVariablePointersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVariablePointersFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVariablePointersFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_self_partial(const VkPhysicalDeviceVariablePointersFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_partial(const VkPhysicalDeviceVariablePointersFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVariablePointersFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
}

static inline void
vn_encode_VkPhysicalDeviceVariablePointersFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVariablePointersFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES });
    vn_encode_VkPhysicalDeviceVariablePointersFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVariablePointersFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMultiviewFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewFeatures_self(const VkPhysicalDeviceMultiviewFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->multiview);
    size += vn_sizeof_VkBool32(&val->multiviewGeometryShader);
    size += vn_sizeof_VkBool32(&val->multiviewTessellationShader);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewFeatures(const VkPhysicalDeviceMultiviewFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMultiviewFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMultiviewFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->multiview);
    vn_encode_VkBool32(enc, &val->multiviewGeometryShader);
    vn_encode_VkBool32(enc, &val->multiviewTessellationShader);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES });
    vn_encode_VkPhysicalDeviceMultiviewFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiviewFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->multiview);
    vn_decode_VkBool32(dec, &val->multiviewGeometryShader);
    vn_decode_VkBool32(dec, &val->multiviewTessellationShader);
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMultiviewFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMultiviewFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewFeatures_self_partial(const VkPhysicalDeviceMultiviewFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewFeatures_partial(const VkPhysicalDeviceMultiviewFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMultiviewFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMultiviewFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES });
    vn_encode_VkPhysicalDeviceMultiviewFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiviewFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDevice16BitStorageFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDevice16BitStorageFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevice16BitStorageFeatures_self(const VkPhysicalDevice16BitStorageFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->storageBuffer16BitAccess);
    size += vn_sizeof_VkBool32(&val->uniformAndStorageBuffer16BitAccess);
    size += vn_sizeof_VkBool32(&val->storagePushConstant16);
    size += vn_sizeof_VkBool32(&val->storageInputOutput16);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevice16BitStorageFeatures(const VkPhysicalDevice16BitStorageFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevice16BitStorageFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevice16BitStorageFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant16);
    vn_encode_VkBool32(enc, &val->storageInputOutput16);
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevice16BitStorageFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES });
    vn_encode_VkPhysicalDevice16BitStorageFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevice16BitStorageFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant16);
    vn_decode_VkBool32(dec, &val->storageInputOutput16);
}

static inline void
vn_decode_VkPhysicalDevice16BitStorageFeatures(struct vn_cs_decoder *dec, VkPhysicalDevice16BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevice16BitStorageFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevice16BitStorageFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevice16BitStorageFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevice16BitStorageFeatures_self_partial(const VkPhysicalDevice16BitStorageFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevice16BitStorageFeatures_partial(const VkPhysicalDevice16BitStorageFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevice16BitStorageFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevice16BitStorageFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevice16BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
}

static inline void
vn_encode_VkPhysicalDevice16BitStorageFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDevice16BitStorageFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES });
    vn_encode_VkPhysicalDevice16BitStorageFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevice16BitStorageFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderSubgroupExtendedTypes);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderSubgroupExtendedTypes);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES });
    vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderSubgroupExtendedTypes);
}

static inline void
vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderSubgroupExtendedTypes */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_partial(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderSubgroupExtendedTypes */
}

static inline void
vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES });
    vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSamplerYcbcrConversionFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->samplerYcbcrConversion);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures(const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->samplerYcbcrConversion);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES });
    vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->samplerYcbcrConversion);
}

static inline void
vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial(const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->samplerYcbcrConversion */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_partial(const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->samplerYcbcrConversion */
}

static inline void
vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerYcbcrConversionFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES });
    vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceProtectedMemoryFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_self(const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->protectedMemory);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures(const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->protectedMemory);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES });
    vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->protectedMemory);
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_self_partial(const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->protectedMemory */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_partial(const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->protectedMemory */
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES });
    vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMultiDrawFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiDrawFeaturesEXT_self(const VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->multiDraw);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiDrawFeaturesEXT(const VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMultiDrawFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->multiDraw);
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->multiDraw);
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiDrawFeaturesEXT_self_partial(const VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->multiDraw */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiDrawFeaturesEXT_partial(const VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMultiDrawFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->multiDraw */
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiDrawFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceInlineUniformBlockFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_self(const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->inlineUniformBlock);
    size += vn_sizeof_VkBool32(&val->descriptorBindingInlineUniformBlockUpdateAfterBind);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures(const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->inlineUniformBlock);
    vn_encode_VkBool32(enc, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES });
    vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->inlineUniformBlock);
    vn_decode_VkBool32(dec, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial(const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_partial(const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES });
    vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMaintenance4Features chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Features_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Features_self(const VkPhysicalDeviceMaintenance4Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->maintenance4);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Features(const VkPhysicalDeviceMaintenance4Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Features_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Features_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->maintenance4);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES });
    vn_encode_VkPhysicalDeviceMaintenance4Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance4Features_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Features_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Features_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->maintenance4);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Features(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMaintenance4Features_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMaintenance4Features_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Features_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Features_self_partial(const VkPhysicalDeviceMaintenance4Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maintenance4 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Features_partial(const VkPhysicalDeviceMaintenance4Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Features_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Features_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maintenance4 */
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Features_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES });
    vn_encode_VkPhysicalDeviceMaintenance4Features_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance4Features_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderDrawParametersFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_self(const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderDrawParameters);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures(const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderDrawParameters);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES });
    vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderDrawParameters);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial(const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderDrawParameters */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_partial(const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDrawParametersFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES });
    vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderFloat16Int8Features chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_self(const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderFloat16);
    size += vn_sizeof_VkBool32(&val->shaderInt8);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features(const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderFloat16);
    vn_encode_VkBool32(enc, &val->shaderInt8);
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES });
    vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderFloat16);
    vn_decode_VkBool32(dec, &val->shaderInt8);
}

static inline void
vn_decode_VkPhysicalDeviceShaderFloat16Int8Features(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_self_partial(const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_partial(const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
}

static inline void
vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderFloat16Int8Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES });
    vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial(enc, val);
}

/* struct VkPhysicalDeviceHostQueryResetFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_self(const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->hostQueryReset);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures(const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->hostQueryReset);
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES });
    vn_encode_VkPhysicalDeviceHostQueryResetFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->hostQueryReset);
}

static inline void
vn_decode_VkPhysicalDeviceHostQueryResetFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceHostQueryResetFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceHostQueryResetFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_self_partial(const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->hostQueryReset */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_partial(const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->hostQueryReset */
}

static inline void
vn_encode_VkPhysicalDeviceHostQueryResetFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceHostQueryResetFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES });
    vn_encode_VkPhysicalDeviceHostQueryResetFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceDescriptorIndexingFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_self(const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderInputAttachmentArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderUniformTexelBufferArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageTexelBufferArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderUniformBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderSampledImageArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderInputAttachmentArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderUniformTexelBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageTexelBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->descriptorBindingUniformBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingSampledImageUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingStorageImageUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingStorageBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingUpdateUnusedWhilePending);
    size += vn_sizeof_VkBool32(&val->descriptorBindingPartiallyBound);
    size += vn_sizeof_VkBool32(&val->descriptorBindingVariableDescriptorCount);
    size += vn_sizeof_VkBool32(&val->runtimeDescriptorArray);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures(const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_encode_VkBool32(enc, &val->descriptorBindingPartiallyBound);
    vn_encode_VkBool32(enc, &val->descriptorBindingVariableDescriptorCount);
    vn_encode_VkBool32(enc, &val->runtimeDescriptorArray);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES });
    vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_decode_VkBool32(dec, &val->descriptorBindingPartiallyBound);
    vn_decode_VkBool32(dec, &val->descriptorBindingVariableDescriptorCount);
    vn_decode_VkBool32(dec, &val->runtimeDescriptorArray);
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial(const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_partial(const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES });
    vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceTimelineSemaphoreFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_self(const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->timelineSemaphore);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures(const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->timelineSemaphore);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES });
    vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->timelineSemaphore);
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial(const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->timelineSemaphore */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_partial(const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->timelineSemaphore */
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES });
    vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDevice8BitStorageFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDevice8BitStorageFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevice8BitStorageFeatures_self(const VkPhysicalDevice8BitStorageFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->storageBuffer8BitAccess);
    size += vn_sizeof_VkBool32(&val->uniformAndStorageBuffer8BitAccess);
    size += vn_sizeof_VkBool32(&val->storagePushConstant8);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevice8BitStorageFeatures(const VkPhysicalDevice8BitStorageFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevice8BitStorageFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevice8BitStorageFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant8);
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevice8BitStorageFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES });
    vn_encode_VkPhysicalDevice8BitStorageFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevice8BitStorageFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant8);
}

static inline void
vn_decode_VkPhysicalDevice8BitStorageFeatures(struct vn_cs_decoder *dec, VkPhysicalDevice8BitStorageFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevice8BitStorageFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevice8BitStorageFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevice8BitStorageFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevice8BitStorageFeatures_self_partial(const VkPhysicalDevice8BitStorageFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevice8BitStorageFeatures_partial(const VkPhysicalDevice8BitStorageFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevice8BitStorageFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevice8BitStorageFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevice8BitStorageFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
}

static inline void
vn_encode_VkPhysicalDevice8BitStorageFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDevice8BitStorageFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES });
    vn_encode_VkPhysicalDevice8BitStorageFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevice8BitStorageFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceConditionalRenderingFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(const VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->conditionalRendering);
    size += vn_sizeof_VkBool32(&val->inheritedConditionalRendering);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceConditionalRenderingFeaturesEXT(const VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->conditionalRendering);
    vn_encode_VkBool32(enc, &val->inheritedConditionalRendering);
}

static inline void
vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->conditionalRendering);
    vn_decode_VkBool32(dec, &val->inheritedConditionalRendering);
}

static inline void
vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_partial(const VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->conditionalRendering */
    /* skip val->inheritedConditionalRendering */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceConditionalRenderingFeaturesEXT_partial(const VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->conditionalRendering */
    /* skip val->inheritedConditionalRendering */
}

static inline void
vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceConditionalRenderingFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVulkanMemoryModelFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_self(const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->vulkanMemoryModel);
    size += vn_sizeof_VkBool32(&val->vulkanMemoryModelDeviceScope);
    size += vn_sizeof_VkBool32(&val->vulkanMemoryModelAvailabilityVisibilityChains);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures(const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->vulkanMemoryModel);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelDeviceScope);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelAvailabilityVisibilityChains);
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES });
    vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->vulkanMemoryModel);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelDeviceScope);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelAvailabilityVisibilityChains);
}

static inline void
vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial(const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_partial(const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
}

static inline void
vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkanMemoryModelFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES });
    vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderAtomicInt64Features chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_self(const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderBufferInt64Atomics);
    size += vn_sizeof_VkBool32(&val->shaderSharedInt64Atomics);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features(const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderBufferInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderSharedInt64Atomics);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES });
    vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderBufferInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderSharedInt64Atomics);
}

static inline void
vn_decode_VkPhysicalDeviceShaderAtomicInt64Features(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_self_partial(const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_partial(const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
}

static inline void
vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderAtomicInt64Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES });
    vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self(const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->vertexAttributeInstanceRateDivisor);
    size += vn_sizeof_VkBool32(&val->vertexAttributeInstanceRateZeroDivisor);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT(const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->vertexAttributeInstanceRateDivisor);
    vn_encode_VkBool32(enc, &val->vertexAttributeInstanceRateZeroDivisor);
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->vertexAttributeInstanceRateDivisor);
    vn_decode_VkBool32(dec, &val->vertexAttributeInstanceRateZeroDivisor);
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self_partial(const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->vertexAttributeInstanceRateDivisor */
    /* skip val->vertexAttributeInstanceRateZeroDivisor */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_partial(const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->vertexAttributeInstanceRateDivisor */
    /* skip val->vertexAttributeInstanceRateZeroDivisor */
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceTransformFeedbackFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->transformFeedback);
    size += vn_sizeof_VkBool32(&val->geometryStreams);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT(const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->transformFeedback);
    vn_encode_VkBool32(enc, &val->geometryStreams);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->transformFeedback);
    vn_decode_VkBool32(dec, &val->geometryStreams);
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial(const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->transformFeedback */
    /* skip val->geometryStreams */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_partial(const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->transformFeedback */
    /* skip val->geometryStreams */
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceScalarBlockLayoutFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_self(const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->scalarBlockLayout);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures(const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->scalarBlockLayout);
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES });
    vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->scalarBlockLayout);
}

static inline void
vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial(const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->scalarBlockLayout */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_partial(const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->scalarBlockLayout */
}

static inline void
vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceScalarBlockLayoutFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES });
    vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceUniformBufferStandardLayoutFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->uniformBufferStandardLayout);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->uniformBufferStandardLayout);
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES });
    vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->uniformBufferStandardLayout);
}

static inline void
vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial(const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->uniformBufferStandardLayout */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_partial(const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->uniformBufferStandardLayout */
}

static inline void
vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES });
    vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceDepthClipEnableFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(const VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->depthClipEnable);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthClipEnableFeaturesEXT(const VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->depthClipEnable);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->depthClipEnable);
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_partial(const VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->depthClipEnable */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthClipEnableFeaturesEXT_partial(const VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->depthClipEnable */
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipEnableFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceBufferDeviceAddressFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_self(const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->bufferDeviceAddress);
    size += vn_sizeof_VkBool32(&val->bufferDeviceAddressCaptureReplay);
    size += vn_sizeof_VkBool32(&val->bufferDeviceAddressMultiDevice);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures(const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->bufferDeviceAddress);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressCaptureReplay);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressMultiDevice);
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES });
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->bufferDeviceAddress);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressCaptureReplay);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressMultiDevice);
}

static inline void
vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial(const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_partial(const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
}

static inline void
vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceBufferDeviceAddressFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES });
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceImagelessFramebufferFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_self(const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->imagelessFramebuffer);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures(const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->imagelessFramebuffer);
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES });
    vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->imagelessFramebuffer);
}

static inline void
vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial(const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->imagelessFramebuffer */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_partial(const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->imagelessFramebuffer */
}

static inline void
vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceImagelessFramebufferFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES });
    vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceTextureCompressionASTCHDRFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->textureCompressionASTC_HDR);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->textureCompressionASTC_HDR);
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES });
    vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->textureCompressionASTC_HDR);
}

static inline void
vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial(const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->textureCompressionASTC_HDR */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_partial(const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->textureCompressionASTC_HDR */
}

static inline void
vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES });
    vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderClockFeaturesKHR chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderClockFeaturesKHR_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderClockFeaturesKHR_self(const VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderSubgroupClock);
    size += vn_sizeof_VkBool32(&val->shaderDeviceClock);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderClockFeaturesKHR(const VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderClockFeaturesKHR_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderClockFeaturesKHR_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderSubgroupClock);
    vn_encode_VkBool32(enc, &val->shaderDeviceClock);
}

static inline void
vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderSubgroupClock);
    vn_decode_VkBool32(dec, &val->shaderDeviceClock);
}

static inline void
vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderClockFeaturesKHR_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderClockFeaturesKHR_self_partial(const VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderSubgroupClock */
    /* skip val->shaderDeviceClock */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderClockFeaturesKHR_partial(const VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderClockFeaturesKHR_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderClockFeaturesKHR_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderSubgroupClock */
    /* skip val->shaderDeviceClock */
}

static inline void
vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderClockFeaturesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR });
    vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_self_partial(enc, val);
}

/* struct VkPhysicalDeviceIndexTypeUint8FeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self(const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->indexTypeUint8);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIndexTypeUint8FeaturesEXT(const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->indexTypeUint8);
}

static inline void
vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->indexTypeUint8);
}

static inline void
vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self_partial(const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->indexTypeUint8 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_partial(const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->indexTypeUint8 */
}

static inline void
vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->fragmentShaderSampleInterlock);
    size += vn_sizeof_VkBool32(&val->fragmentShaderPixelInterlock);
    size += vn_sizeof_VkBool32(&val->fragmentShaderShadingRateInterlock);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT(const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->fragmentShaderSampleInterlock);
    vn_encode_VkBool32(enc, &val->fragmentShaderPixelInterlock);
    vn_encode_VkBool32(enc, &val->fragmentShaderShadingRateInterlock);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->fragmentShaderSampleInterlock);
    vn_decode_VkBool32(dec, &val->fragmentShaderPixelInterlock);
    vn_decode_VkBool32(dec, &val->fragmentShaderShadingRateInterlock);
}

static inline void
vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_partial(const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->fragmentShaderSampleInterlock */
    /* skip val->fragmentShaderPixelInterlock */
    /* skip val->fragmentShaderShadingRateInterlock */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_partial(const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->fragmentShaderSampleInterlock */
    /* skip val->fragmentShaderPixelInterlock */
    /* skip val->fragmentShaderShadingRateInterlock */
}

static inline void
vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->separateDepthStencilLayouts);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->separateDepthStencilLayouts);
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES });
    vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->separateDepthStencilLayouts);
}

static inline void
vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial(const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->separateDepthStencilLayouts */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_partial(const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->separateDepthStencilLayouts */
}

static inline void
vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES });
    vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->primitiveTopologyListRestart);
    size += vn_sizeof_VkBool32(&val->primitiveTopologyPatchListRestart);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->primitiveTopologyListRestart);
    vn_encode_VkBool32(enc, &val->primitiveTopologyPatchListRestart);
}

static inline void
vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT });
    vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->primitiveTopologyListRestart);
    vn_decode_VkBool32(dec, &val->primitiveTopologyPatchListRestart);
}

static inline void
vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_partial(const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->primitiveTopologyListRestart */
    /* skip val->primitiveTopologyPatchListRestart */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_partial(const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->primitiveTopologyListRestart */
    /* skip val->primitiveTopologyPatchListRestart */
}

static inline void
vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT });
    vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderDemoteToHelperInvocation);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderDemoteToHelperInvocation);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES });
    vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderDemoteToHelperInvocation);
}

static inline void
vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial(const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderDemoteToHelperInvocation */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_partial(const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderDemoteToHelperInvocation */
}

static inline void
vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES });
    vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->texelBufferAlignment);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->texelBufferAlignment);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->texelBufferAlignment);
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial(const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->texelBufferAlignment */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_partial(const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->texelBufferAlignment */
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSubgroupSizeControlFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_self(const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->subgroupSizeControl);
    size += vn_sizeof_VkBool32(&val->computeFullSubgroups);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures(const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->subgroupSizeControl);
    vn_encode_VkBool32(enc, &val->computeFullSubgroups);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES });
    vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->subgroupSizeControl);
    vn_decode_VkBool32(dec, &val->computeFullSubgroups);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial(const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_partial(const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES });
    vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceLineRasterizationFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceLineRasterizationFeaturesEXT_self(const VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->rectangularLines);
    size += vn_sizeof_VkBool32(&val->bresenhamLines);
    size += vn_sizeof_VkBool32(&val->smoothLines);
    size += vn_sizeof_VkBool32(&val->stippledRectangularLines);
    size += vn_sizeof_VkBool32(&val->stippledBresenhamLines);
    size += vn_sizeof_VkBool32(&val->stippledSmoothLines);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceLineRasterizationFeaturesEXT(const VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceLineRasterizationFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->rectangularLines);
    vn_encode_VkBool32(enc, &val->bresenhamLines);
    vn_encode_VkBool32(enc, &val->smoothLines);
    vn_encode_VkBool32(enc, &val->stippledRectangularLines);
    vn_encode_VkBool32(enc, &val->stippledBresenhamLines);
    vn_encode_VkBool32(enc, &val->stippledSmoothLines);
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->rectangularLines);
    vn_decode_VkBool32(dec, &val->bresenhamLines);
    vn_decode_VkBool32(dec, &val->smoothLines);
    vn_decode_VkBool32(dec, &val->stippledRectangularLines);
    vn_decode_VkBool32(dec, &val->stippledBresenhamLines);
    vn_decode_VkBool32(dec, &val->stippledSmoothLines);
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceLineRasterizationFeaturesEXT_self_partial(const VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->rectangularLines */
    /* skip val->bresenhamLines */
    /* skip val->smoothLines */
    /* skip val->stippledRectangularLines */
    /* skip val->stippledBresenhamLines */
    /* skip val->stippledSmoothLines */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceLineRasterizationFeaturesEXT_partial(const VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceLineRasterizationFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->rectangularLines */
    /* skip val->bresenhamLines */
    /* skip val->smoothLines */
    /* skip val->stippledRectangularLines */
    /* skip val->stippledBresenhamLines */
    /* skip val->stippledSmoothLines */
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceLineRasterizationFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDevicePipelineCreationCacheControlFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->pipelineCreationCacheControl);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures(const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->pipelineCreationCacheControl);
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES });
    vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->pipelineCreationCacheControl);
}

static inline void
vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures(struct vn_cs_decoder *dec, VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial(const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->pipelineCreationCacheControl */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_partial(const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pipelineCreationCacheControl */
}

static inline void
vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePipelineCreationCacheControlFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES });
    vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVulkan11Features chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Features_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Features_self(const VkPhysicalDeviceVulkan11Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->storageBuffer16BitAccess);
    size += vn_sizeof_VkBool32(&val->uniformAndStorageBuffer16BitAccess);
    size += vn_sizeof_VkBool32(&val->storagePushConstant16);
    size += vn_sizeof_VkBool32(&val->storageInputOutput16);
    size += vn_sizeof_VkBool32(&val->multiview);
    size += vn_sizeof_VkBool32(&val->multiviewGeometryShader);
    size += vn_sizeof_VkBool32(&val->multiviewTessellationShader);
    size += vn_sizeof_VkBool32(&val->variablePointersStorageBuffer);
    size += vn_sizeof_VkBool32(&val->variablePointers);
    size += vn_sizeof_VkBool32(&val->protectedMemory);
    size += vn_sizeof_VkBool32(&val->samplerYcbcrConversion);
    size += vn_sizeof_VkBool32(&val->shaderDrawParameters);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Features(const VkPhysicalDeviceVulkan11Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Features_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Features_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->storageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer16BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant16);
    vn_encode_VkBool32(enc, &val->storageInputOutput16);
    vn_encode_VkBool32(enc, &val->multiview);
    vn_encode_VkBool32(enc, &val->multiviewGeometryShader);
    vn_encode_VkBool32(enc, &val->multiviewTessellationShader);
    vn_encode_VkBool32(enc, &val->variablePointersStorageBuffer);
    vn_encode_VkBool32(enc, &val->variablePointers);
    vn_encode_VkBool32(enc, &val->protectedMemory);
    vn_encode_VkBool32(enc, &val->samplerYcbcrConversion);
    vn_encode_VkBool32(enc, &val->shaderDrawParameters);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan11Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan11Features_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->storageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer16BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant16);
    vn_decode_VkBool32(dec, &val->storageInputOutput16);
    vn_decode_VkBool32(dec, &val->multiview);
    vn_decode_VkBool32(dec, &val->multiviewGeometryShader);
    vn_decode_VkBool32(dec, &val->multiviewTessellationShader);
    vn_decode_VkBool32(dec, &val->variablePointersStorageBuffer);
    vn_decode_VkBool32(dec, &val->variablePointers);
    vn_decode_VkBool32(dec, &val->protectedMemory);
    vn_decode_VkBool32(dec, &val->samplerYcbcrConversion);
    vn_decode_VkBool32(dec, &val->shaderDrawParameters);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Features(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVulkan11Features_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVulkan11Features_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Features_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Features_self_partial(const VkPhysicalDeviceVulkan11Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
    /* skip val->protectedMemory */
    /* skip val->samplerYcbcrConversion */
    /* skip val->shaderDrawParameters */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Features_partial(const VkPhysicalDeviceVulkan11Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Features_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Features_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageBuffer16BitAccess */
    /* skip val->uniformAndStorageBuffer16BitAccess */
    /* skip val->storagePushConstant16 */
    /* skip val->storageInputOutput16 */
    /* skip val->multiview */
    /* skip val->multiviewGeometryShader */
    /* skip val->multiviewTessellationShader */
    /* skip val->variablePointersStorageBuffer */
    /* skip val->variablePointers */
    /* skip val->protectedMemory */
    /* skip val->samplerYcbcrConversion */
    /* skip val->shaderDrawParameters */
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Features_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan11Features_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan11Features_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVulkan12Features chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Features_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Features_self(const VkPhysicalDeviceVulkan12Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->samplerMirrorClampToEdge);
    size += vn_sizeof_VkBool32(&val->drawIndirectCount);
    size += vn_sizeof_VkBool32(&val->storageBuffer8BitAccess);
    size += vn_sizeof_VkBool32(&val->uniformAndStorageBuffer8BitAccess);
    size += vn_sizeof_VkBool32(&val->storagePushConstant8);
    size += vn_sizeof_VkBool32(&val->shaderBufferInt64Atomics);
    size += vn_sizeof_VkBool32(&val->shaderSharedInt64Atomics);
    size += vn_sizeof_VkBool32(&val->shaderFloat16);
    size += vn_sizeof_VkBool32(&val->shaderInt8);
    size += vn_sizeof_VkBool32(&val->descriptorIndexing);
    size += vn_sizeof_VkBool32(&val->shaderInputAttachmentArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderUniformTexelBufferArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageTexelBufferArrayDynamicIndexing);
    size += vn_sizeof_VkBool32(&val->shaderUniformBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderSampledImageArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderInputAttachmentArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderUniformTexelBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->shaderStorageTexelBufferArrayNonUniformIndexing);
    size += vn_sizeof_VkBool32(&val->descriptorBindingUniformBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingSampledImageUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingStorageImageUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingStorageBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->descriptorBindingUpdateUnusedWhilePending);
    size += vn_sizeof_VkBool32(&val->descriptorBindingPartiallyBound);
    size += vn_sizeof_VkBool32(&val->descriptorBindingVariableDescriptorCount);
    size += vn_sizeof_VkBool32(&val->runtimeDescriptorArray);
    size += vn_sizeof_VkBool32(&val->samplerFilterMinmax);
    size += vn_sizeof_VkBool32(&val->scalarBlockLayout);
    size += vn_sizeof_VkBool32(&val->imagelessFramebuffer);
    size += vn_sizeof_VkBool32(&val->uniformBufferStandardLayout);
    size += vn_sizeof_VkBool32(&val->shaderSubgroupExtendedTypes);
    size += vn_sizeof_VkBool32(&val->separateDepthStencilLayouts);
    size += vn_sizeof_VkBool32(&val->hostQueryReset);
    size += vn_sizeof_VkBool32(&val->timelineSemaphore);
    size += vn_sizeof_VkBool32(&val->bufferDeviceAddress);
    size += vn_sizeof_VkBool32(&val->bufferDeviceAddressCaptureReplay);
    size += vn_sizeof_VkBool32(&val->bufferDeviceAddressMultiDevice);
    size += vn_sizeof_VkBool32(&val->vulkanMemoryModel);
    size += vn_sizeof_VkBool32(&val->vulkanMemoryModelDeviceScope);
    size += vn_sizeof_VkBool32(&val->vulkanMemoryModelAvailabilityVisibilityChains);
    size += vn_sizeof_VkBool32(&val->shaderOutputViewportIndex);
    size += vn_sizeof_VkBool32(&val->shaderOutputLayer);
    size += vn_sizeof_VkBool32(&val->subgroupBroadcastDynamicId);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Features(const VkPhysicalDeviceVulkan12Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Features_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Features_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->samplerMirrorClampToEdge);
    vn_encode_VkBool32(enc, &val->drawIndirectCount);
    vn_encode_VkBool32(enc, &val->storageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->uniformAndStorageBuffer8BitAccess);
    vn_encode_VkBool32(enc, &val->storagePushConstant8);
    vn_encode_VkBool32(enc, &val->shaderBufferInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderSharedInt64Atomics);
    vn_encode_VkBool32(enc, &val->shaderFloat16);
    vn_encode_VkBool32(enc, &val->shaderInt8);
    vn_encode_VkBool32(enc, &val->descriptorIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_encode_VkBool32(enc, &val->descriptorBindingPartiallyBound);
    vn_encode_VkBool32(enc, &val->descriptorBindingVariableDescriptorCount);
    vn_encode_VkBool32(enc, &val->runtimeDescriptorArray);
    vn_encode_VkBool32(enc, &val->samplerFilterMinmax);
    vn_encode_VkBool32(enc, &val->scalarBlockLayout);
    vn_encode_VkBool32(enc, &val->imagelessFramebuffer);
    vn_encode_VkBool32(enc, &val->uniformBufferStandardLayout);
    vn_encode_VkBool32(enc, &val->shaderSubgroupExtendedTypes);
    vn_encode_VkBool32(enc, &val->separateDepthStencilLayouts);
    vn_encode_VkBool32(enc, &val->hostQueryReset);
    vn_encode_VkBool32(enc, &val->timelineSemaphore);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddress);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressCaptureReplay);
    vn_encode_VkBool32(enc, &val->bufferDeviceAddressMultiDevice);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModel);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelDeviceScope);
    vn_encode_VkBool32(enc, &val->vulkanMemoryModelAvailabilityVisibilityChains);
    vn_encode_VkBool32(enc, &val->shaderOutputViewportIndex);
    vn_encode_VkBool32(enc, &val->shaderOutputLayer);
    vn_encode_VkBool32(enc, &val->subgroupBroadcastDynamicId);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan12Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan12Features_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->samplerMirrorClampToEdge);
    vn_decode_VkBool32(dec, &val->drawIndirectCount);
    vn_decode_VkBool32(dec, &val->storageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->uniformAndStorageBuffer8BitAccess);
    vn_decode_VkBool32(dec, &val->storagePushConstant8);
    vn_decode_VkBool32(dec, &val->shaderBufferInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderSharedInt64Atomics);
    vn_decode_VkBool32(dec, &val->shaderFloat16);
    vn_decode_VkBool32(dec, &val->shaderInt8);
    vn_decode_VkBool32(dec, &val->descriptorIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayDynamicIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderUniformTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->shaderStorageTexelBufferArrayNonUniformIndexing);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingSampledImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageImageUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUniformTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingStorageTexelBufferUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->descriptorBindingUpdateUnusedWhilePending);
    vn_decode_VkBool32(dec, &val->descriptorBindingPartiallyBound);
    vn_decode_VkBool32(dec, &val->descriptorBindingVariableDescriptorCount);
    vn_decode_VkBool32(dec, &val->runtimeDescriptorArray);
    vn_decode_VkBool32(dec, &val->samplerFilterMinmax);
    vn_decode_VkBool32(dec, &val->scalarBlockLayout);
    vn_decode_VkBool32(dec, &val->imagelessFramebuffer);
    vn_decode_VkBool32(dec, &val->uniformBufferStandardLayout);
    vn_decode_VkBool32(dec, &val->shaderSubgroupExtendedTypes);
    vn_decode_VkBool32(dec, &val->separateDepthStencilLayouts);
    vn_decode_VkBool32(dec, &val->hostQueryReset);
    vn_decode_VkBool32(dec, &val->timelineSemaphore);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddress);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressCaptureReplay);
    vn_decode_VkBool32(dec, &val->bufferDeviceAddressMultiDevice);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModel);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelDeviceScope);
    vn_decode_VkBool32(dec, &val->vulkanMemoryModelAvailabilityVisibilityChains);
    vn_decode_VkBool32(dec, &val->shaderOutputViewportIndex);
    vn_decode_VkBool32(dec, &val->shaderOutputLayer);
    vn_decode_VkBool32(dec, &val->subgroupBroadcastDynamicId);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Features(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVulkan12Features_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVulkan12Features_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Features_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Features_self_partial(const VkPhysicalDeviceVulkan12Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->samplerMirrorClampToEdge */
    /* skip val->drawIndirectCount */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
    /* skip val->descriptorIndexing */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
    /* skip val->samplerFilterMinmax */
    /* skip val->scalarBlockLayout */
    /* skip val->imagelessFramebuffer */
    /* skip val->uniformBufferStandardLayout */
    /* skip val->shaderSubgroupExtendedTypes */
    /* skip val->separateDepthStencilLayouts */
    /* skip val->hostQueryReset */
    /* skip val->timelineSemaphore */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
    /* skip val->shaderOutputViewportIndex */
    /* skip val->shaderOutputLayer */
    /* skip val->subgroupBroadcastDynamicId */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Features_partial(const VkPhysicalDeviceVulkan12Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Features_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Features_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->samplerMirrorClampToEdge */
    /* skip val->drawIndirectCount */
    /* skip val->storageBuffer8BitAccess */
    /* skip val->uniformAndStorageBuffer8BitAccess */
    /* skip val->storagePushConstant8 */
    /* skip val->shaderBufferInt64Atomics */
    /* skip val->shaderSharedInt64Atomics */
    /* skip val->shaderFloat16 */
    /* skip val->shaderInt8 */
    /* skip val->descriptorIndexing */
    /* skip val->shaderInputAttachmentArrayDynamicIndexing */
    /* skip val->shaderUniformTexelBufferArrayDynamicIndexing */
    /* skip val->shaderStorageTexelBufferArrayDynamicIndexing */
    /* skip val->shaderUniformBufferArrayNonUniformIndexing */
    /* skip val->shaderSampledImageArrayNonUniformIndexing */
    /* skip val->shaderStorageBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageImageArrayNonUniformIndexing */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexing */
    /* skip val->shaderUniformTexelBufferArrayNonUniformIndexing */
    /* skip val->shaderStorageTexelBufferArrayNonUniformIndexing */
    /* skip val->descriptorBindingUniformBufferUpdateAfterBind */
    /* skip val->descriptorBindingSampledImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageImageUpdateAfterBind */
    /* skip val->descriptorBindingStorageBufferUpdateAfterBind */
    /* skip val->descriptorBindingUniformTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingStorageTexelBufferUpdateAfterBind */
    /* skip val->descriptorBindingUpdateUnusedWhilePending */
    /* skip val->descriptorBindingPartiallyBound */
    /* skip val->descriptorBindingVariableDescriptorCount */
    /* skip val->runtimeDescriptorArray */
    /* skip val->samplerFilterMinmax */
    /* skip val->scalarBlockLayout */
    /* skip val->imagelessFramebuffer */
    /* skip val->uniformBufferStandardLayout */
    /* skip val->shaderSubgroupExtendedTypes */
    /* skip val->separateDepthStencilLayouts */
    /* skip val->hostQueryReset */
    /* skip val->timelineSemaphore */
    /* skip val->bufferDeviceAddress */
    /* skip val->bufferDeviceAddressCaptureReplay */
    /* skip val->bufferDeviceAddressMultiDevice */
    /* skip val->vulkanMemoryModel */
    /* skip val->vulkanMemoryModelDeviceScope */
    /* skip val->vulkanMemoryModelAvailabilityVisibilityChains */
    /* skip val->shaderOutputViewportIndex */
    /* skip val->shaderOutputLayer */
    /* skip val->subgroupBroadcastDynamicId */
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Features_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan12Features_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan12Features_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVulkan13Features chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Features_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Features_self(const VkPhysicalDeviceVulkan13Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->robustImageAccess);
    size += vn_sizeof_VkBool32(&val->inlineUniformBlock);
    size += vn_sizeof_VkBool32(&val->descriptorBindingInlineUniformBlockUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->pipelineCreationCacheControl);
    size += vn_sizeof_VkBool32(&val->privateData);
    size += vn_sizeof_VkBool32(&val->shaderDemoteToHelperInvocation);
    size += vn_sizeof_VkBool32(&val->shaderTerminateInvocation);
    size += vn_sizeof_VkBool32(&val->subgroupSizeControl);
    size += vn_sizeof_VkBool32(&val->computeFullSubgroups);
    size += vn_sizeof_VkBool32(&val->synchronization2);
    size += vn_sizeof_VkBool32(&val->textureCompressionASTC_HDR);
    size += vn_sizeof_VkBool32(&val->shaderZeroInitializeWorkgroupMemory);
    size += vn_sizeof_VkBool32(&val->dynamicRendering);
    size += vn_sizeof_VkBool32(&val->shaderIntegerDotProduct);
    size += vn_sizeof_VkBool32(&val->maintenance4);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Features(const VkPhysicalDeviceVulkan13Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Features_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Features_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->robustImageAccess);
    vn_encode_VkBool32(enc, &val->inlineUniformBlock);
    vn_encode_VkBool32(enc, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
    vn_encode_VkBool32(enc, &val->pipelineCreationCacheControl);
    vn_encode_VkBool32(enc, &val->privateData);
    vn_encode_VkBool32(enc, &val->shaderDemoteToHelperInvocation);
    vn_encode_VkBool32(enc, &val->shaderTerminateInvocation);
    vn_encode_VkBool32(enc, &val->subgroupSizeControl);
    vn_encode_VkBool32(enc, &val->computeFullSubgroups);
    vn_encode_VkBool32(enc, &val->synchronization2);
    vn_encode_VkBool32(enc, &val->textureCompressionASTC_HDR);
    vn_encode_VkBool32(enc, &val->shaderZeroInitializeWorkgroupMemory);
    vn_encode_VkBool32(enc, &val->dynamicRendering);
    vn_encode_VkBool32(enc, &val->shaderIntegerDotProduct);
    vn_encode_VkBool32(enc, &val->maintenance4);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan13Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan13Features_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Features_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Features_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->robustImageAccess);
    vn_decode_VkBool32(dec, &val->inlineUniformBlock);
    vn_decode_VkBool32(dec, &val->descriptorBindingInlineUniformBlockUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->pipelineCreationCacheControl);
    vn_decode_VkBool32(dec, &val->privateData);
    vn_decode_VkBool32(dec, &val->shaderDemoteToHelperInvocation);
    vn_decode_VkBool32(dec, &val->shaderTerminateInvocation);
    vn_decode_VkBool32(dec, &val->subgroupSizeControl);
    vn_decode_VkBool32(dec, &val->computeFullSubgroups);
    vn_decode_VkBool32(dec, &val->synchronization2);
    vn_decode_VkBool32(dec, &val->textureCompressionASTC_HDR);
    vn_decode_VkBool32(dec, &val->shaderZeroInitializeWorkgroupMemory);
    vn_decode_VkBool32(dec, &val->dynamicRendering);
    vn_decode_VkBool32(dec, &val->shaderIntegerDotProduct);
    vn_decode_VkBool32(dec, &val->maintenance4);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Features(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVulkan13Features_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVulkan13Features_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Features_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Features_self_partial(const VkPhysicalDeviceVulkan13Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->robustImageAccess */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
    /* skip val->pipelineCreationCacheControl */
    /* skip val->privateData */
    /* skip val->shaderDemoteToHelperInvocation */
    /* skip val->shaderTerminateInvocation */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
    /* skip val->synchronization2 */
    /* skip val->textureCompressionASTC_HDR */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
    /* skip val->dynamicRendering */
    /* skip val->shaderIntegerDotProduct */
    /* skip val->maintenance4 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Features_partial(const VkPhysicalDeviceVulkan13Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Features_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Features_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustImageAccess */
    /* skip val->inlineUniformBlock */
    /* skip val->descriptorBindingInlineUniformBlockUpdateAfterBind */
    /* skip val->pipelineCreationCacheControl */
    /* skip val->privateData */
    /* skip val->shaderDemoteToHelperInvocation */
    /* skip val->shaderTerminateInvocation */
    /* skip val->subgroupSizeControl */
    /* skip val->computeFullSubgroups */
    /* skip val->synchronization2 */
    /* skip val->textureCompressionASTC_HDR */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
    /* skip val->dynamicRendering */
    /* skip val->shaderIntegerDotProduct */
    /* skip val->maintenance4 */
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Features_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES });
    vn_encode_VkPhysicalDeviceVulkan13Features_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan13Features_self_partial(enc, val);
}

/* struct VkPhysicalDeviceCustomBorderColorFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(const VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->customBorderColors);
    size += vn_sizeof_VkBool32(&val->customBorderColorWithoutFormat);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceCustomBorderColorFeaturesEXT(const VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->customBorderColors);
    vn_encode_VkBool32(enc, &val->customBorderColorWithoutFormat);
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->customBorderColors);
    vn_decode_VkBool32(dec, &val->customBorderColorWithoutFormat);
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_partial(const VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->customBorderColors */
    /* skip val->customBorderColorWithoutFormat */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceCustomBorderColorFeaturesEXT_partial(const VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->customBorderColors */
    /* skip val->customBorderColorWithoutFormat */
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceCustomBorderColorFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceBorderColorSwizzleFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->borderColorSwizzle);
    size += vn_sizeof_VkBool32(&val->borderColorSwizzleFromImage);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT(const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->borderColorSwizzle);
    vn_encode_VkBool32(enc, &val->borderColorSwizzleFromImage);
}

static inline void
vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->borderColorSwizzle);
    vn_decode_VkBool32(dec, &val->borderColorSwizzleFromImage);
}

static inline void
vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_partial(const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->borderColorSwizzle */
    /* skip val->borderColorSwizzleFromImage */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_partial(const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->borderColorSwizzle */
    /* skip val->borderColorSwizzleFromImage */
}

static inline void
vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceExtendedDynamicStateFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->extendedDynamicState);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->extendedDynamicState);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->extendedDynamicState);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial(const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_partial(const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState */
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceExtendedDynamicState2FeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->extendedDynamicState2);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState2LogicOp);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState2PatchControlPoints);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->extendedDynamicState2);
    vn_encode_VkBool32(enc, &val->extendedDynamicState2LogicOp);
    vn_encode_VkBool32(enc, &val->extendedDynamicState2PatchControlPoints);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->extendedDynamicState2);
    vn_decode_VkBool32(dec, &val->extendedDynamicState2LogicOp);
    vn_decode_VkBool32(dec, &val->extendedDynamicState2PatchControlPoints);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial(const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState2 */
    /* skip val->extendedDynamicState2LogicOp */
    /* skip val->extendedDynamicState2PatchControlPoints */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_partial(const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState2 */
    /* skip val->extendedDynamicState2LogicOp */
    /* skip val->extendedDynamicState2PatchControlPoints */
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceExtendedDynamicState3FeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self(const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3TessellationDomainOrigin);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3DepthClampEnable);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3PolygonMode);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3RasterizationSamples);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3SampleMask);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3AlphaToCoverageEnable);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3AlphaToOneEnable);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3LogicOpEnable);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3ColorBlendEnable);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3ColorBlendEquation);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3ColorWriteMask);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3RasterizationStream);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3ConservativeRasterizationMode);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3ExtraPrimitiveOverestimationSize);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3DepthClipEnable);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3SampleLocationsEnable);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3ColorBlendAdvanced);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3ProvokingVertexMode);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3LineRasterizationMode);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3LineStippleEnable);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3DepthClipNegativeOneToOne);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3ViewportWScalingEnable);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3ViewportSwizzle);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3CoverageToColorEnable);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3CoverageToColorLocation);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3CoverageModulationMode);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3CoverageModulationTableEnable);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3CoverageModulationTable);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3CoverageReductionMode);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3RepresentativeFragmentTestEnable);
    size += vn_sizeof_VkBool32(&val->extendedDynamicState3ShadingRateImageEnable);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT(const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->extendedDynamicState3TessellationDomainOrigin);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3DepthClampEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3PolygonMode);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3RasterizationSamples);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3SampleMask);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3AlphaToCoverageEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3AlphaToOneEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3LogicOpEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ColorBlendEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ColorBlendEquation);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ColorWriteMask);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3RasterizationStream);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ConservativeRasterizationMode);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ExtraPrimitiveOverestimationSize);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3DepthClipEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3SampleLocationsEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ColorBlendAdvanced);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ProvokingVertexMode);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3LineRasterizationMode);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3LineStippleEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3DepthClipNegativeOneToOne);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ViewportWScalingEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ViewportSwizzle);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3CoverageToColorEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3CoverageToColorLocation);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3CoverageModulationMode);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3CoverageModulationTableEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3CoverageModulationTable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3CoverageReductionMode);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3RepresentativeFragmentTestEnable);
    vn_encode_VkBool32(enc, &val->extendedDynamicState3ShadingRateImageEnable);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->extendedDynamicState3TessellationDomainOrigin);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3DepthClampEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3PolygonMode);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3RasterizationSamples);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3SampleMask);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3AlphaToCoverageEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3AlphaToOneEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3LogicOpEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ColorBlendEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ColorBlendEquation);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ColorWriteMask);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3RasterizationStream);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ConservativeRasterizationMode);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ExtraPrimitiveOverestimationSize);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3DepthClipEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3SampleLocationsEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ColorBlendAdvanced);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ProvokingVertexMode);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3LineRasterizationMode);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3LineStippleEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3DepthClipNegativeOneToOne);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ViewportWScalingEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ViewportSwizzle);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3CoverageToColorEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3CoverageToColorLocation);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3CoverageModulationMode);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3CoverageModulationTableEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3CoverageModulationTable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3CoverageReductionMode);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3RepresentativeFragmentTestEnable);
    vn_decode_VkBool32(dec, &val->extendedDynamicState3ShadingRateImageEnable);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self_partial(const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState3TessellationDomainOrigin */
    /* skip val->extendedDynamicState3DepthClampEnable */
    /* skip val->extendedDynamicState3PolygonMode */
    /* skip val->extendedDynamicState3RasterizationSamples */
    /* skip val->extendedDynamicState3SampleMask */
    /* skip val->extendedDynamicState3AlphaToCoverageEnable */
    /* skip val->extendedDynamicState3AlphaToOneEnable */
    /* skip val->extendedDynamicState3LogicOpEnable */
    /* skip val->extendedDynamicState3ColorBlendEnable */
    /* skip val->extendedDynamicState3ColorBlendEquation */
    /* skip val->extendedDynamicState3ColorWriteMask */
    /* skip val->extendedDynamicState3RasterizationStream */
    /* skip val->extendedDynamicState3ConservativeRasterizationMode */
    /* skip val->extendedDynamicState3ExtraPrimitiveOverestimationSize */
    /* skip val->extendedDynamicState3DepthClipEnable */
    /* skip val->extendedDynamicState3SampleLocationsEnable */
    /* skip val->extendedDynamicState3ColorBlendAdvanced */
    /* skip val->extendedDynamicState3ProvokingVertexMode */
    /* skip val->extendedDynamicState3LineRasterizationMode */
    /* skip val->extendedDynamicState3LineStippleEnable */
    /* skip val->extendedDynamicState3DepthClipNegativeOneToOne */
    /* skip val->extendedDynamicState3ViewportWScalingEnable */
    /* skip val->extendedDynamicState3ViewportSwizzle */
    /* skip val->extendedDynamicState3CoverageToColorEnable */
    /* skip val->extendedDynamicState3CoverageToColorLocation */
    /* skip val->extendedDynamicState3CoverageModulationMode */
    /* skip val->extendedDynamicState3CoverageModulationTableEnable */
    /* skip val->extendedDynamicState3CoverageModulationTable */
    /* skip val->extendedDynamicState3CoverageReductionMode */
    /* skip val->extendedDynamicState3RepresentativeFragmentTestEnable */
    /* skip val->extendedDynamicState3ShadingRateImageEnable */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_partial(const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->extendedDynamicState3TessellationDomainOrigin */
    /* skip val->extendedDynamicState3DepthClampEnable */
    /* skip val->extendedDynamicState3PolygonMode */
    /* skip val->extendedDynamicState3RasterizationSamples */
    /* skip val->extendedDynamicState3SampleMask */
    /* skip val->extendedDynamicState3AlphaToCoverageEnable */
    /* skip val->extendedDynamicState3AlphaToOneEnable */
    /* skip val->extendedDynamicState3LogicOpEnable */
    /* skip val->extendedDynamicState3ColorBlendEnable */
    /* skip val->extendedDynamicState3ColorBlendEquation */
    /* skip val->extendedDynamicState3ColorWriteMask */
    /* skip val->extendedDynamicState3RasterizationStream */
    /* skip val->extendedDynamicState3ConservativeRasterizationMode */
    /* skip val->extendedDynamicState3ExtraPrimitiveOverestimationSize */
    /* skip val->extendedDynamicState3DepthClipEnable */
    /* skip val->extendedDynamicState3SampleLocationsEnable */
    /* skip val->extendedDynamicState3ColorBlendAdvanced */
    /* skip val->extendedDynamicState3ProvokingVertexMode */
    /* skip val->extendedDynamicState3LineRasterizationMode */
    /* skip val->extendedDynamicState3LineStippleEnable */
    /* skip val->extendedDynamicState3DepthClipNegativeOneToOne */
    /* skip val->extendedDynamicState3ViewportWScalingEnable */
    /* skip val->extendedDynamicState3ViewportSwizzle */
    /* skip val->extendedDynamicState3CoverageToColorEnable */
    /* skip val->extendedDynamicState3CoverageToColorLocation */
    /* skip val->extendedDynamicState3CoverageModulationMode */
    /* skip val->extendedDynamicState3CoverageModulationTableEnable */
    /* skip val->extendedDynamicState3CoverageModulationTable */
    /* skip val->extendedDynamicState3CoverageReductionMode */
    /* skip val->extendedDynamicState3RepresentativeFragmentTestEnable */
    /* skip val->extendedDynamicState3ShadingRateImageEnable */
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderZeroInitializeWorkgroupMemory);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderZeroInitializeWorkgroupMemory);
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES });
    vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderZeroInitializeWorkgroupMemory);
}

static inline void
vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial(const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_partial(const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderZeroInitializeWorkgroupMemory */
}

static inline void
vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES });
    vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceRobustness2FeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceRobustness2FeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRobustness2FeaturesEXT_self(const VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->robustBufferAccess2);
    size += vn_sizeof_VkBool32(&val->robustImageAccess2);
    size += vn_sizeof_VkBool32(&val->nullDescriptor);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRobustness2FeaturesEXT(const VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceRobustness2FeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceRobustness2FeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->robustBufferAccess2);
    vn_encode_VkBool32(enc, &val->robustImageAccess2);
    vn_encode_VkBool32(enc, &val->nullDescriptor);
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->robustBufferAccess2);
    vn_decode_VkBool32(dec, &val->robustImageAccess2);
    vn_decode_VkBool32(dec, &val->nullDescriptor);
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRobustness2FeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRobustness2FeaturesEXT_self_partial(const VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->robustBufferAccess2 */
    /* skip val->robustImageAccess2 */
    /* skip val->nullDescriptor */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRobustness2FeaturesEXT_partial(const VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceRobustness2FeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceRobustness2FeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustBufferAccess2 */
    /* skip val->robustImageAccess2 */
    /* skip val->nullDescriptor */
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceRobustness2FeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceImageRobustnessFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_self(const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->robustImageAccess);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures(const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->robustImageAccess);
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES });
    vn_encode_VkPhysicalDeviceImageRobustnessFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceImageRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->robustImageAccess);
}

static inline void
vn_decode_VkPhysicalDeviceImageRobustnessFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceImageRobustnessFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceImageRobustnessFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_self_partial(const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->robustImageAccess */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_partial(const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustImageAccess */
}

static inline void
vn_encode_VkPhysicalDeviceImageRobustnessFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageRobustnessFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES });
    vn_encode_VkPhysicalDeviceImageRobustnessFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDevice4444FormatsFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_self(const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->formatA4R4G4B4);
    size += vn_sizeof_VkBool32(&val->formatA4B4G4R4);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT(const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->formatA4R4G4B4);
    vn_encode_VkBool32(enc, &val->formatA4B4G4R4);
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT });
    vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->formatA4R4G4B4);
    vn_decode_VkBool32(dec, &val->formatA4B4G4R4);
}

static inline void
vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial(const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->formatA4R4G4B4 */
    /* skip val->formatA4B4G4R4 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_partial(const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->formatA4R4G4B4 */
    /* skip val->formatA4B4G4R4 */
}

static inline void
vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDevice4444FormatsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT });
    vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderTerminateInvocationFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderTerminateInvocation);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures(const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderTerminateInvocation);
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES });
    vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderTerminateInvocation);
}

static inline void
vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial(const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderTerminateInvocation */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_partial(const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderTerminateInvocation */
}

static inline void
vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderTerminateInvocationFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES });
    vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceImage2DViewOf3DFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->image2DViewOf3D);
    size += vn_sizeof_VkBool32(&val->sampler2DViewOf3D);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT(const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->image2DViewOf3D);
    vn_encode_VkBool32(enc, &val->sampler2DViewOf3D);
}

static inline void
vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->image2DViewOf3D);
    vn_decode_VkBool32(dec, &val->sampler2DViewOf3D);
}

static inline void
vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_partial(const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->image2DViewOf3D */
    /* skip val->sampler2DViewOf3D */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_partial(const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->image2DViewOf3D */
    /* skip val->sampler2DViewOf3D */
}

static inline void
vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->mutableDescriptorType);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT(const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->mutableDescriptorType);
}

static inline void
vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->mutableDescriptorType);
}

static inline void
vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_partial(const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->mutableDescriptorType */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_partial(const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->mutableDescriptorType */
}

static inline void
vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceDepthClipControlFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(const VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->depthClipControl);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthClipControlFeaturesEXT(const VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->depthClipControl);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->depthClipControl);
}

static inline void
vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_partial(const VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->depthClipControl */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthClipControlFeaturesEXT_partial(const VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->depthClipControl */
}

static inline void
vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthClipControlFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self(const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->vertexInputDynamicState);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT(const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->vertexInputDynamicState);
}

static inline void
vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->vertexInputDynamicState);
}

static inline void
vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self_partial(const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->vertexInputDynamicState */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_partial(const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->vertexInputDynamicState */
}

static inline void
vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceColorWriteEnableFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(const VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->colorWriteEnable);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceColorWriteEnableFeaturesEXT(const VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->colorWriteEnable);
}

static inline void
vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->colorWriteEnable);
}

static inline void
vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_partial(const VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->colorWriteEnable */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceColorWriteEnableFeaturesEXT_partial(const VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->colorWriteEnable */
}

static inline void
vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceColorWriteEnableFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSynchronization2Features chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSynchronization2Features_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSynchronization2Features_self(const VkPhysicalDeviceSynchronization2Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->synchronization2);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSynchronization2Features(const VkPhysicalDeviceSynchronization2Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSynchronization2Features_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSynchronization2Features_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSynchronization2Features *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->synchronization2);
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features(struct vn_cs_encoder *enc, const VkPhysicalDeviceSynchronization2Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES });
    vn_encode_VkPhysicalDeviceSynchronization2Features_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSynchronization2Features_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceSynchronization2Features_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceSynchronization2Features_self(struct vn_cs_decoder *dec, VkPhysicalDeviceSynchronization2Features *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->synchronization2);
}

static inline void
vn_decode_VkPhysicalDeviceSynchronization2Features(struct vn_cs_decoder *dec, VkPhysicalDeviceSynchronization2Features *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceSynchronization2Features_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceSynchronization2Features_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSynchronization2Features_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSynchronization2Features_self_partial(const VkPhysicalDeviceSynchronization2Features *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->synchronization2 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSynchronization2Features_partial(const VkPhysicalDeviceSynchronization2Features *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSynchronization2Features_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSynchronization2Features_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSynchronization2Features *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->synchronization2 */
}

static inline void
vn_encode_VkPhysicalDeviceSynchronization2Features_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSynchronization2Features *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES });
    vn_encode_VkPhysicalDeviceSynchronization2Features_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSynchronization2Features_self_partial(enc, val);
}

/* struct VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->primitivesGeneratedQuery);
    size += vn_sizeof_VkBool32(&val->primitivesGeneratedQueryWithRasterizerDiscard);
    size += vn_sizeof_VkBool32(&val->primitivesGeneratedQueryWithNonZeroStreams);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT(const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->primitivesGeneratedQuery);
    vn_encode_VkBool32(enc, &val->primitivesGeneratedQueryWithRasterizerDiscard);
    vn_encode_VkBool32(enc, &val->primitivesGeneratedQueryWithNonZeroStreams);
}

static inline void
vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT });
    vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->primitivesGeneratedQuery);
    vn_decode_VkBool32(dec, &val->primitivesGeneratedQueryWithRasterizerDiscard);
    vn_decode_VkBool32(dec, &val->primitivesGeneratedQueryWithNonZeroStreams);
}

static inline void
vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_partial(const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->primitivesGeneratedQuery */
    /* skip val->primitivesGeneratedQueryWithRasterizerDiscard */
    /* skip val->primitivesGeneratedQueryWithNonZeroStreams */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_partial(const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->primitivesGeneratedQuery */
    /* skip val->primitivesGeneratedQueryWithRasterizerDiscard */
    /* skip val->primitivesGeneratedQueryWithNonZeroStreams */
}

static inline void
vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT });
    vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->ycbcr2plane444Formats);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->ycbcr2plane444Formats);
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->ycbcr2plane444Formats);
}

static inline void
vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial(const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->ycbcr2plane444Formats */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_partial(const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->ycbcr2plane444Formats */
}

static inline void
vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceProvokingVertexFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(const VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->provokingVertexLast);
    size += vn_sizeof_VkBool32(&val->transformFeedbackPreservesProvokingVertex);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProvokingVertexFeaturesEXT(const VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->provokingVertexLast);
    vn_encode_VkBool32(enc, &val->transformFeedbackPreservesProvokingVertex);
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->provokingVertexLast);
    vn_decode_VkBool32(dec, &val->transformFeedbackPreservesProvokingVertex);
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_partial(const VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->provokingVertexLast */
    /* skip val->transformFeedbackPreservesProvokingVertex */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProvokingVertexFeaturesEXT_partial(const VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->provokingVertexLast */
    /* skip val->transformFeedbackPreservesProvokingVertex */
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProvokingVertexFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderIntegerDotProductFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->shaderIntegerDotProduct);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures(const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->shaderIntegerDotProduct);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES });
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->shaderIntegerDotProduct);
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial(const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->shaderIntegerDotProduct */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_partial(const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->shaderIntegerDotProduct */
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES });
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceDynamicRenderingFeatures chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_self(const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->dynamicRendering);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures(const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->dynamicRendering);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES });
    vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->dynamicRendering);
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingFeatures(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_self_partial(const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->dynamicRendering */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_partial(const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->dynamicRendering */
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingFeatures *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES });
    vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self_partial(enc, val);
}

/* struct VkPhysicalDeviceImageViewMinLodFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(const VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->minLod);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageViewMinLodFeaturesEXT(const VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->minLod);
}

static inline void
vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->minLod);
}

static inline void
vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_partial(const VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->minLod */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageViewMinLodFeaturesEXT_partial(const VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->minLod */
}

static inline void
vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageViewMinLodFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->rasterizationOrderColorAttachmentAccess);
    size += vn_sizeof_VkBool32(&val->rasterizationOrderDepthAttachmentAccess);
    size += vn_sizeof_VkBool32(&val->rasterizationOrderStencilAttachmentAccess);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT(const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->rasterizationOrderColorAttachmentAccess);
    vn_encode_VkBool32(enc, &val->rasterizationOrderDepthAttachmentAccess);
    vn_encode_VkBool32(enc, &val->rasterizationOrderStencilAttachmentAccess);
}

static inline void
vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->rasterizationOrderColorAttachmentAccess);
    vn_decode_VkBool32(dec, &val->rasterizationOrderDepthAttachmentAccess);
    vn_decode_VkBool32(dec, &val->rasterizationOrderStencilAttachmentAccess);
}

static inline void
vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_partial(const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->rasterizationOrderColorAttachmentAccess */
    /* skip val->rasterizationOrderDepthAttachmentAccess */
    /* skip val->rasterizationOrderStencilAttachmentAccess */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_partial(const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->rasterizationOrderColorAttachmentAccess */
    /* skip val->rasterizationOrderDepthAttachmentAccess */
    /* skip val->rasterizationOrderStencilAttachmentAccess */
}

static inline void
vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self(const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->graphicsPipelineLibrary);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->graphicsPipelineLibrary);
}

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->graphicsPipelineLibrary);
}

static inline void
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self_partial(const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->graphicsPipelineLibrary */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_partial(const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->graphicsPipelineLibrary */
}

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->nonSeamlessCubeMap);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT(const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->nonSeamlessCubeMap);
}

static inline void
vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->nonSeamlessCubeMap);
}

static inline void
vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_partial(const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->nonSeamlessCubeMap */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_partial(const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->nonSeamlessCubeMap */
}

static inline void
vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->dynamicRenderingUnusedAttachments);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT(const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkBool32(enc, &val->dynamicRenderingUnusedAttachments);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->dynamicRenderingUnusedAttachments);
}

static inline void
vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_partial(const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->dynamicRenderingUnusedAttachments */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_partial(const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->dynamicRenderingUnusedAttachments */
}

static inline void
vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT });
    vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceFeatures2 chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(296 /* VK_EXT_private_data */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePrivateDataFeatures_self((const VkPhysicalDevicePrivateDataFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_self((const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiviewFeatures_self((const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice16BitStorageFeatures_self((const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self((const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self((const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_self((const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(393 /* VK_EXT_multi_draw */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiDrawFeaturesEXT_self((const VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(139 /* VK_EXT_inline_uniform_block */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_self((const VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(414 /* VK_KHR_maintenance4 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMaintenance4Features_self((const VkPhysicalDeviceMaintenance4Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_self((const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_self((const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_self((const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_self((const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_self((const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice8BitStorageFeatures_self((const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(82 /* VK_EXT_conditional_rendering */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self((const VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_self((const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_self((const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(191 /* VK_EXT_vertex_attribute_divisor */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self((const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(29 /* VK_EXT_transform_feedback */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self((const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_self((const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self((const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(103 /* VK_EXT_depth_clip_enable */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self((const VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_self((const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_self((const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(67 /* VK_EXT_texture_compression_astc_hdr */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self((const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            if (!vn_cs_renderer_protocol_has_extension(182 /* VK_KHR_shader_clock */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderClockFeaturesKHR_self((const VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(266 /* VK_EXT_index_type_uint8 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self((const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(252 /* VK_EXT_fragment_shader_interlock */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self((const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self((const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(357 /* VK_EXT_primitive_topology_list_restart */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self((const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(277 /* VK_EXT_shader_demote_to_helper_invocation */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self((const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(282 /* VK_EXT_texel_buffer_alignment */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self((const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(226 /* VK_EXT_subgroup_size_control */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_self((const VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(260 /* VK_EXT_line_rasterization */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceLineRasterizationFeaturesEXT_self((const VkPhysicalDeviceLineRasterizationFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(298 /* VK_EXT_pipeline_creation_cache_control */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_self((const VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan11Features_self((const VkPhysicalDeviceVulkan11Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan12Features_self((const VkPhysicalDeviceVulkan12Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            if (!vn_cs_renderer_protocol_has_api_version(VK_API_VERSION_1_3))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan13Features_self((const VkPhysicalDeviceVulkan13Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(288 /* VK_EXT_custom_border_color */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self((const VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(412 /* VK_EXT_border_color_swizzle */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self((const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(268 /* VK_EXT_extended_dynamic_state */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self((const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(378 /* VK_EXT_extended_dynamic_state2 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self((const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(456 /* VK_EXT_extended_dynamic_state3 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self((const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(326 /* VK_KHR_zero_initialize_workgroup_memory */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self((const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(287 /* VK_EXT_robustness2 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceRobustness2FeaturesEXT_self((const VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(336 /* VK_EXT_image_robustness */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_self((const VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(341 /* VK_EXT_4444_formats */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_self((const VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(216 /* VK_KHR_shader_terminate_invocation */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_self((const VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(394 /* VK_EXT_image_2d_view_of_3d */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self((const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(352 /* VK_VALVE_mutable_descriptor_type */) && !vn_cs_renderer_protocol_has_extension(495 /* VK_EXT_mutable_descriptor_type */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self((const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(356 /* VK_EXT_depth_clip_control */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDepthClipControlFeaturesEXT_self((const VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(353 /* VK_EXT_vertex_input_dynamic_state */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self((const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(382 /* VK_EXT_color_write_enable */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self((const VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(315 /* VK_KHR_synchronization2 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSynchronization2Features_self((const VkPhysicalDeviceSynchronization2Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(383 /* VK_EXT_primitives_generated_query */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self((const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(331 /* VK_EXT_ycbcr_2plane_444_formats */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self((const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(255 /* VK_EXT_provoking_vertex */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProvokingVertexFeaturesEXT_self((const VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(281 /* VK_KHR_shader_integer_dot_product */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_self((const VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(45 /* VK_KHR_dynamic_rendering */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_self((const VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(392 /* VK_EXT_image_view_min_lod */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self((const VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(464 /* VK_EXT_rasterization_order_attachment_access */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self((const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(321 /* VK_EXT_graphics_pipeline_library */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self((const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(423 /* VK_EXT_non_seamless_cube_map */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self((const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(500 /* VK_EXT_dynamic_rendering_unused_attachments */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self((const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures2_self(const VkPhysicalDeviceFeatures2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPhysicalDeviceFeatures(&val->features);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures2(const VkPhysicalDeviceFeatures2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceFeatures2_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(296 /* VK_EXT_private_data */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrivateDataFeatures_self(enc, (const VkPhysicalDevicePrivateDataFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(enc, (const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiviewFeatures_self(enc, (const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice16BitStorageFeatures_self(enc, (const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(enc, (const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(enc, (const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(enc, (const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(393 /* VK_EXT_multi_draw */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_self(enc, (const VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(139 /* VK_EXT_inline_uniform_block */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self(enc, (const VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(414 /* VK_KHR_maintenance4 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance4Features_self(enc, (const VkPhysicalDeviceMaintenance4Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(enc, (const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(enc, (const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(enc, (const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(enc, (const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(enc, (const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice8BitStorageFeatures_self(enc, (const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(82 /* VK_EXT_conditional_rendering */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(enc, (const VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(enc, (const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(enc, (const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(191 /* VK_EXT_vertex_attribute_divisor */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self(enc, (const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(29 /* VK_EXT_transform_feedback */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(enc, (const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(enc, (const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(enc, (const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(103 /* VK_EXT_depth_clip_enable */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(enc, (const VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(enc, (const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(enc, (const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(67 /* VK_EXT_texture_compression_astc_hdr */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(enc, (const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            if (!vn_cs_renderer_protocol_has_extension(182 /* VK_KHR_shader_clock */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_self(enc, (const VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(266 /* VK_EXT_index_type_uint8 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self(enc, (const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(252 /* VK_EXT_fragment_shader_interlock */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(enc, (const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(enc, (const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(357 /* VK_EXT_primitive_topology_list_restart */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(enc, (const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(277 /* VK_EXT_shader_demote_to_helper_invocation */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(enc, (const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(282 /* VK_EXT_texel_buffer_alignment */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(enc, (const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(226 /* VK_EXT_subgroup_size_control */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(enc, (const VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(260 /* VK_EXT_line_rasterization */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self(enc, (const VkPhysicalDeviceLineRasterizationFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(298 /* VK_EXT_pipeline_creation_cache_control */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(enc, (const VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan11Features_self(enc, (const VkPhysicalDeviceVulkan11Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan12Features_self(enc, (const VkPhysicalDeviceVulkan12Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            if (!vn_cs_renderer_protocol_has_api_version(VK_API_VERSION_1_3))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan13Features_self(enc, (const VkPhysicalDeviceVulkan13Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(288 /* VK_EXT_custom_border_color */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(enc, (const VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(412 /* VK_EXT_border_color_swizzle */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(enc, (const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(268 /* VK_EXT_extended_dynamic_state */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(378 /* VK_EXT_extended_dynamic_state2 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(456 /* VK_EXT_extended_dynamic_state3 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(326 /* VK_KHR_zero_initialize_workgroup_memory */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(enc, (const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(287 /* VK_EXT_robustness2 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_self(enc, (const VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(336 /* VK_EXT_image_robustness */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self(enc, (const VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(341 /* VK_EXT_4444_formats */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self(enc, (const VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(216 /* VK_KHR_shader_terminate_invocation */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(enc, (const VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(394 /* VK_EXT_image_2d_view_of_3d */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(enc, (const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(352 /* VK_VALVE_mutable_descriptor_type */) && !vn_cs_renderer_protocol_has_extension(495 /* VK_EXT_mutable_descriptor_type */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(enc, (const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(356 /* VK_EXT_depth_clip_control */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(enc, (const VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(353 /* VK_EXT_vertex_input_dynamic_state */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self(enc, (const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(382 /* VK_EXT_color_write_enable */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(enc, (const VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(315 /* VK_KHR_synchronization2 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSynchronization2Features_self(enc, (const VkPhysicalDeviceSynchronization2Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(383 /* VK_EXT_primitives_generated_query */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(enc, (const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(331 /* VK_EXT_ycbcr_2plane_444_formats */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(enc, (const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(255 /* VK_EXT_provoking_vertex */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(enc, (const VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(281 /* VK_KHR_shader_integer_dot_product */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(enc, (const VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(45 /* VK_KHR_dynamic_rendering */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self(enc, (const VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(392 /* VK_EXT_image_view_min_lod */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(enc, (const VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(464 /* VK_EXT_rasterization_order_attachment_access */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(enc, (const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(321 /* VK_EXT_graphics_pipeline_library */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self(enc, (const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(423 /* VK_EXT_non_seamless_cube_map */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(enc, (const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(500 /* VK_EXT_dynamic_rendering_unused_attachments */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(enc, (const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceFeatures(enc, &val->features);
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2 });
    vn_encode_VkPhysicalDeviceFeatures2_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFeatures2_self(enc, val);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    VkBaseOutStructure *pnext = (VkBaseOutStructure *)val;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return;

    vn_decode_VkStructureType(dec, &stype);
    while (true) {
        assert(pnext);
        if (pnext->sType == stype)
            break;

        pnext = pnext->pNext;
    }

    switch ((int32_t)pnext->sType) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevicePrivateDataFeatures_self(dec, (VkPhysicalDevicePrivateDataFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVariablePointersFeatures_self(dec, (VkPhysicalDeviceVariablePointersFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceMultiviewFeatures_self(dec, (VkPhysicalDeviceMultiviewFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevice16BitStorageFeatures_self(dec, (VkPhysicalDevice16BitStorageFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(dec, (VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(dec, (VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceProtectedMemoryFeatures_self(dec, (VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceMultiDrawFeaturesEXT_self(dec, (VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceInlineUniformBlockFeatures_self(dec, (VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceMaintenance4Features_self(dec, (VkPhysicalDeviceMaintenance4Features *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderDrawParametersFeatures_self(dec, (VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderFloat16Int8Features_self(dec, (VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceHostQueryResetFeatures_self(dec, (VkPhysicalDeviceHostQueryResetFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceDescriptorIndexingFeatures_self(dec, (VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(dec, (VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevice8BitStorageFeatures_self(dec, (VkPhysicalDevice8BitStorageFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(dec, (VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(dec, (VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderAtomicInt64Features_self(dec, (VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self(dec, (VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(dec, (VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(dec, (VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(dec, (VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(dec, (VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(dec, (VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceImagelessFramebufferFeatures_self(dec, (VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(dec, (VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderClockFeaturesKHR_self(dec, (VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self(dec, (VkPhysicalDeviceIndexTypeUint8FeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(dec, (VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(dec, (VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(dec, (VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(dec, (VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(dec, (VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(dec, (VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self(dec, (VkPhysicalDeviceLineRasterizationFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(dec, (VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVulkan11Features_self(dec, (VkPhysicalDeviceVulkan11Features *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVulkan12Features_self(dec, (VkPhysicalDeviceVulkan12Features *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVulkan13Features_self(dec, (VkPhysicalDeviceVulkan13Features *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(dec, (VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(dec, (VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(dec, (VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(dec, (VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self(dec, (VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(dec, (VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceRobustness2FeaturesEXT_self(dec, (VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceImageRobustnessFeatures_self(dec, (VkPhysicalDeviceImageRobustnessFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevice4444FormatsFeaturesEXT_self(dec, (VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(dec, (VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(dec, (VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(dec, (VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(dec, (VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self(dec, (VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(dec, (VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceSynchronization2Features_self(dec, (VkPhysicalDeviceSynchronization2Features *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(dec, (VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(dec, (VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(dec, (VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(dec, (VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceDynamicRenderingFeatures_self(dec, (VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(dec, (VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(dec, (VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self(dec, (VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(dec, (VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
        vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(dec, (VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2_self(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceFeatures(dec, &val->features);
}

static inline void
vn_decode_VkPhysicalDeviceFeatures2(struct vn_cs_decoder *dec, VkPhysicalDeviceFeatures2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceFeatures2_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceFeatures2_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(296 /* VK_EXT_private_data */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePrivateDataFeatures_self_partial((const VkPhysicalDevicePrivateDataFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_self_partial((const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiviewFeatures_self_partial((const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice16BitStorageFeatures_self_partial((const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial((const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial((const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_self_partial((const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(393 /* VK_EXT_multi_draw */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiDrawFeaturesEXT_self_partial((const VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(139 /* VK_EXT_inline_uniform_block */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial((const VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(414 /* VK_KHR_maintenance4 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMaintenance4Features_self_partial((const VkPhysicalDeviceMaintenance4Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial((const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_self_partial((const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_self_partial((const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial((const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial((const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice8BitStorageFeatures_self_partial((const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(82 /* VK_EXT_conditional_rendering */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_partial((const VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial((const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_self_partial((const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(191 /* VK_EXT_vertex_attribute_divisor */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self_partial((const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(29 /* VK_EXT_transform_feedback */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial((const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial((const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial((const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(103 /* VK_EXT_depth_clip_enable */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_partial((const VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial((const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial((const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(67 /* VK_EXT_texture_compression_astc_hdr */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial((const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            if (!vn_cs_renderer_protocol_has_extension(182 /* VK_KHR_shader_clock */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderClockFeaturesKHR_self_partial((const VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(266 /* VK_EXT_index_type_uint8 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self_partial((const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(252 /* VK_EXT_fragment_shader_interlock */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_partial((const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial((const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(357 /* VK_EXT_primitive_topology_list_restart */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_partial((const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(277 /* VK_EXT_shader_demote_to_helper_invocation */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial((const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(282 /* VK_EXT_texel_buffer_alignment */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial((const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(226 /* VK_EXT_subgroup_size_control */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial((const VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(260 /* VK_EXT_line_rasterization */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceLineRasterizationFeaturesEXT_self_partial((const VkPhysicalDeviceLineRasterizationFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(298 /* VK_EXT_pipeline_creation_cache_control */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial((const VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan11Features_self_partial((const VkPhysicalDeviceVulkan11Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan12Features_self_partial((const VkPhysicalDeviceVulkan12Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            if (!vn_cs_renderer_protocol_has_api_version(VK_API_VERSION_1_3))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan13Features_self_partial((const VkPhysicalDeviceVulkan13Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(288 /* VK_EXT_custom_border_color */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_partial((const VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(412 /* VK_EXT_border_color_swizzle */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_partial((const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(268 /* VK_EXT_extended_dynamic_state */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial((const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(378 /* VK_EXT_extended_dynamic_state2 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial((const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(456 /* VK_EXT_extended_dynamic_state3 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self_partial((const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(326 /* VK_KHR_zero_initialize_workgroup_memory */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial((const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(287 /* VK_EXT_robustness2 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceRobustness2FeaturesEXT_self_partial((const VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(336 /* VK_EXT_image_robustness */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_self_partial((const VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(341 /* VK_EXT_4444_formats */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial((const VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(216 /* VK_KHR_shader_terminate_invocation */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial((const VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(394 /* VK_EXT_image_2d_view_of_3d */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_partial((const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(352 /* VK_VALVE_mutable_descriptor_type */) && !vn_cs_renderer_protocol_has_extension(495 /* VK_EXT_mutable_descriptor_type */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_partial((const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(356 /* VK_EXT_depth_clip_control */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_partial((const VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(353 /* VK_EXT_vertex_input_dynamic_state */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self_partial((const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(382 /* VK_EXT_color_write_enable */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_partial((const VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(315 /* VK_KHR_synchronization2 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSynchronization2Features_self_partial((const VkPhysicalDeviceSynchronization2Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(383 /* VK_EXT_primitives_generated_query */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_partial((const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(331 /* VK_EXT_ycbcr_2plane_444_formats */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial((const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(255 /* VK_EXT_provoking_vertex */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_partial((const VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(281 /* VK_KHR_shader_integer_dot_product */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial((const VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(45 /* VK_KHR_dynamic_rendering */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_self_partial((const VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(392 /* VK_EXT_image_view_min_lod */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_partial((const VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(464 /* VK_EXT_rasterization_order_attachment_access */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_partial((const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(321 /* VK_EXT_graphics_pipeline_library */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self_partial((const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(423 /* VK_EXT_non_seamless_cube_map */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_partial((const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(500 /* VK_EXT_dynamic_rendering_unused_attachments */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_partial((const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures2_self_partial(const VkPhysicalDeviceFeatures2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPhysicalDeviceFeatures_partial(&val->features);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFeatures2_partial(const VkPhysicalDeviceFeatures2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceFeatures2_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceFeatures2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(296 /* VK_EXT_private_data */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrivateDataFeatures_self_partial(enc, (const VkPhysicalDevicePrivateDataFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVariablePointersFeatures_self_partial(enc, (const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiviewFeatures_self_partial(enc, (const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice16BitStorageFeatures_self_partial(enc, (const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self_partial(enc, (const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self_partial(enc, (const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self_partial(enc, (const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(393 /* VK_EXT_multi_draw */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(139 /* VK_EXT_inline_uniform_block */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self_partial(enc, (const VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(414 /* VK_KHR_maintenance4 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance4Features_self_partial(enc, (const VkPhysicalDeviceMaintenance4Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self_partial(enc, (const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self_partial(enc, (const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self_partial(enc, (const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self_partial(enc, (const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self_partial(enc, (const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice8BitStorageFeatures_self_partial(enc, (const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(82 /* VK_EXT_conditional_rendering */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self_partial(enc, (const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self_partial(enc, (const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(191 /* VK_EXT_vertex_attribute_divisor */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(29 /* VK_EXT_transform_feedback */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self_partial(enc, (const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self_partial(enc, (const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(103 /* VK_EXT_depth_clip_enable */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self_partial(enc, (const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self_partial(enc, (const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(67 /* VK_EXT_texture_compression_astc_hdr */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self_partial(enc, (const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            if (!vn_cs_renderer_protocol_has_extension(182 /* VK_KHR_shader_clock */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_self_partial(enc, (const VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(266 /* VK_EXT_index_type_uint8 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self_partial(enc, (const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(252 /* VK_EXT_fragment_shader_interlock */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self_partial(enc, (const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(357 /* VK_EXT_primitive_topology_list_restart */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self_partial(enc, (const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(277 /* VK_EXT_shader_demote_to_helper_invocation */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self_partial(enc, (const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(282 /* VK_EXT_texel_buffer_alignment */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(226 /* VK_EXT_subgroup_size_control */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self_partial(enc, (const VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(260 /* VK_EXT_line_rasterization */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceLineRasterizationFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(298 /* VK_EXT_pipeline_creation_cache_control */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self_partial(enc, (const VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan11Features_self_partial(enc, (const VkPhysicalDeviceVulkan11Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan12Features_self_partial(enc, (const VkPhysicalDeviceVulkan12Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            if (!vn_cs_renderer_protocol_has_api_version(VK_API_VERSION_1_3))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan13Features_self_partial(enc, (const VkPhysicalDeviceVulkan13Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(288 /* VK_EXT_custom_border_color */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(412 /* VK_EXT_border_color_swizzle */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(268 /* VK_EXT_extended_dynamic_state */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(378 /* VK_EXT_extended_dynamic_state2 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self_partial(enc, (const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(456 /* VK_EXT_extended_dynamic_state3 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self_partial(enc, (const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(326 /* VK_KHR_zero_initialize_workgroup_memory */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self_partial(enc, (const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(287 /* VK_EXT_robustness2 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_self_partial(enc, (const VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(336 /* VK_EXT_image_robustness */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self_partial(enc, (const VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(341 /* VK_EXT_4444_formats */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self_partial(enc, (const VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(216 /* VK_KHR_shader_terminate_invocation */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self_partial(enc, (const VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(394 /* VK_EXT_image_2d_view_of_3d */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(352 /* VK_VALVE_mutable_descriptor_type */) && !vn_cs_renderer_protocol_has_extension(495 /* VK_EXT_mutable_descriptor_type */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(356 /* VK_EXT_depth_clip_control */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(353 /* VK_EXT_vertex_input_dynamic_state */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(382 /* VK_EXT_color_write_enable */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(315 /* VK_KHR_synchronization2 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSynchronization2Features_self_partial(enc, (const VkPhysicalDeviceSynchronization2Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(383 /* VK_EXT_primitives_generated_query */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self_partial(enc, (const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(331 /* VK_EXT_ycbcr_2plane_444_formats */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(255 /* VK_EXT_provoking_vertex */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(281 /* VK_KHR_shader_integer_dot_product */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self_partial(enc, (const VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(45 /* VK_KHR_dynamic_rendering */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self_partial(enc, (const VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(392 /* VK_EXT_image_view_min_lod */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(464 /* VK_EXT_rasterization_order_attachment_access */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(321 /* VK_EXT_graphics_pipeline_library */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(423 /* VK_EXT_non_seamless_cube_map */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(500 /* VK_EXT_dynamic_rendering_unused_attachments */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self_partial(enc, (const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceFeatures_partial(enc, &val->features);
}

static inline void
vn_encode_VkPhysicalDeviceFeatures2_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceFeatures2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2 });
    vn_encode_VkPhysicalDeviceFeatures2_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFeatures2_self_partial(enc, val);
}

/* struct VkDeviceGroupDeviceCreateInfo chain */

static inline size_t
vn_sizeof_VkDeviceGroupDeviceCreateInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDeviceGroupDeviceCreateInfo_self(const VkDeviceGroupDeviceCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->physicalDeviceCount);
    if (val->pPhysicalDevices) {
        size += vn_sizeof_array_size(val->physicalDeviceCount);
        for (uint32_t i = 0; i < val->physicalDeviceCount; i++)
            size += vn_sizeof_VkPhysicalDevice(&val->pPhysicalDevices[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDeviceGroupDeviceCreateInfo(const VkDeviceGroupDeviceCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDeviceGroupDeviceCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkDeviceGroupDeviceCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDeviceGroupDeviceCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceGroupDeviceCreateInfo_self(struct vn_cs_encoder *enc, const VkDeviceGroupDeviceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->physicalDeviceCount);
    if (val->pPhysicalDevices) {
        vn_encode_array_size(enc, val->physicalDeviceCount);
        for (uint32_t i = 0; i < val->physicalDeviceCount; i++)
            vn_encode_VkPhysicalDevice(enc, &val->pPhysicalDevices[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkDeviceGroupDeviceCreateInfo(struct vn_cs_encoder *enc, const VkDeviceGroupDeviceCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO });
    vn_encode_VkDeviceGroupDeviceCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkDeviceGroupDeviceCreateInfo_self(enc, val);
}

/* struct VkDeviceCreateInfo chain */

static inline size_t
vn_sizeof_VkDeviceCreateInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
            if (!vn_cs_renderer_protocol_has_extension(296 /* VK_EXT_private_data */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkDevicePrivateDataCreateInfo_self((const VkDevicePrivateDataCreateInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(296 /* VK_EXT_private_data */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePrivateDataFeatures_self((const VkPhysicalDevicePrivateDataFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceFeatures2_self((const VkPhysicalDeviceFeatures2 *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVariablePointersFeatures_self((const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiviewFeatures_self((const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkDeviceGroupDeviceCreateInfo_self((const VkDeviceGroupDeviceCreateInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice16BitStorageFeatures_self((const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self((const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self((const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProtectedMemoryFeatures_self((const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(393 /* VK_EXT_multi_draw */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiDrawFeaturesEXT_self((const VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(139 /* VK_EXT_inline_uniform_block */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockFeatures_self((const VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(414 /* VK_KHR_maintenance4 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMaintenance4Features_self((const VkPhysicalDeviceMaintenance4Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderDrawParametersFeatures_self((const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderFloat16Int8Features_self((const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceHostQueryResetFeatures_self((const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingFeatures_self((const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreFeatures_self((const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice8BitStorageFeatures_self((const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(82 /* VK_EXT_conditional_rendering */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self((const VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkanMemoryModelFeatures_self((const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderAtomicInt64Features_self((const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(191 /* VK_EXT_vertex_attribute_divisor */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self((const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(29 /* VK_EXT_transform_feedback */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self((const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceScalarBlockLayoutFeatures_self((const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self((const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(103 /* VK_EXT_depth_clip_enable */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self((const VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceBufferDeviceAddressFeatures_self((const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImagelessFramebufferFeatures_self((const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(67 /* VK_EXT_texture_compression_astc_hdr */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self((const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            if (!vn_cs_renderer_protocol_has_extension(182 /* VK_KHR_shader_clock */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderClockFeaturesKHR_self((const VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(266 /* VK_EXT_index_type_uint8 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self((const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(252 /* VK_EXT_fragment_shader_interlock */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self((const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self((const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(357 /* VK_EXT_primitive_topology_list_restart */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self((const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(277 /* VK_EXT_shader_demote_to_helper_invocation */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self((const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(282 /* VK_EXT_texel_buffer_alignment */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self((const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(226 /* VK_EXT_subgroup_size_control */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlFeatures_self((const VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(260 /* VK_EXT_line_rasterization */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceLineRasterizationFeaturesEXT_self((const VkPhysicalDeviceLineRasterizationFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(298 /* VK_EXT_pipeline_creation_cache_control */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePipelineCreationCacheControlFeatures_self((const VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan11Features_self((const VkPhysicalDeviceVulkan11Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan12Features_self((const VkPhysicalDeviceVulkan12Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            if (!vn_cs_renderer_protocol_has_api_version(VK_API_VERSION_1_3))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan13Features_self((const VkPhysicalDeviceVulkan13Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(288 /* VK_EXT_custom_border_color */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self((const VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(412 /* VK_EXT_border_color_swizzle */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self((const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(268 /* VK_EXT_extended_dynamic_state */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self((const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(378 /* VK_EXT_extended_dynamic_state2 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self((const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(456 /* VK_EXT_extended_dynamic_state3 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self((const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(326 /* VK_KHR_zero_initialize_workgroup_memory */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self((const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(287 /* VK_EXT_robustness2 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceRobustness2FeaturesEXT_self((const VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(336 /* VK_EXT_image_robustness */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImageRobustnessFeatures_self((const VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(341 /* VK_EXT_4444_formats */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevice4444FormatsFeaturesEXT_self((const VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(216 /* VK_KHR_shader_terminate_invocation */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderTerminateInvocationFeatures_self((const VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(394 /* VK_EXT_image_2d_view_of_3d */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self((const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(352 /* VK_VALVE_mutable_descriptor_type */) && !vn_cs_renderer_protocol_has_extension(495 /* VK_EXT_mutable_descriptor_type */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self((const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(356 /* VK_EXT_depth_clip_control */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDepthClipControlFeaturesEXT_self((const VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(353 /* VK_EXT_vertex_input_dynamic_state */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self((const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(382 /* VK_EXT_color_write_enable */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self((const VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(315 /* VK_KHR_synchronization2 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSynchronization2Features_self((const VkPhysicalDeviceSynchronization2Features *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(383 /* VK_EXT_primitives_generated_query */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self((const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(331 /* VK_EXT_ycbcr_2plane_444_formats */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self((const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(255 /* VK_EXT_provoking_vertex */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProvokingVertexFeaturesEXT_self((const VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(281 /* VK_KHR_shader_integer_dot_product */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductFeatures_self((const VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(45 /* VK_KHR_dynamic_rendering */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDynamicRenderingFeatures_self((const VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(392 /* VK_EXT_image_view_min_lod */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self((const VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(464 /* VK_EXT_rasterization_order_attachment_access */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self((const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(321 /* VK_EXT_graphics_pipeline_library */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self((const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(423 /* VK_EXT_non_seamless_cube_map */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self((const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(500 /* VK_EXT_dynamic_rendering_unused_attachments */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkDeviceCreateInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self((const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDeviceCreateInfo_self(const VkDeviceCreateInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_uint32_t(&val->queueCreateInfoCount);
    if (val->pQueueCreateInfos) {
        size += vn_sizeof_array_size(val->queueCreateInfoCount);
        for (uint32_t i = 0; i < val->queueCreateInfoCount; i++)
            size += vn_sizeof_VkDeviceQueueCreateInfo(&val->pQueueCreateInfos[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->enabledLayerCount);
    if (val->ppEnabledLayerNames) {
        size += vn_sizeof_array_size(val->enabledLayerCount);
        for (uint32_t i = 0; i < val->enabledLayerCount; i++) {
            const size_t string_size = strlen(val->ppEnabledLayerNames[i]) + 1;
            size += vn_sizeof_array_size(string_size);
            size += vn_sizeof_char_array(val->ppEnabledLayerNames[i], string_size);
        }
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_uint32_t(&val->enabledExtensionCount);
    if (val->ppEnabledExtensionNames) {
        size += vn_sizeof_array_size(val->enabledExtensionCount);
        for (uint32_t i = 0; i < val->enabledExtensionCount; i++) {
            const size_t string_size = strlen(val->ppEnabledExtensionNames[i]) + 1;
            size += vn_sizeof_array_size(string_size);
            size += vn_sizeof_char_array(val->ppEnabledExtensionNames[i], string_size);
        }
    } else {
        size += vn_sizeof_array_size(0);
    }
    size += vn_sizeof_simple_pointer(val->pEnabledFeatures);
    if (val->pEnabledFeatures)
        size += vn_sizeof_VkPhysicalDeviceFeatures(val->pEnabledFeatures);
    return size;
}

static inline size_t
vn_sizeof_VkDeviceCreateInfo(const VkDeviceCreateInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDeviceCreateInfo_pnext(val->pNext);
    size += vn_sizeof_VkDeviceCreateInfo_self(val);

    return size;
}

static inline void
vn_encode_VkDeviceCreateInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO:
            if (!vn_cs_renderer_protocol_has_extension(296 /* VK_EXT_private_data */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkDevicePrivateDataCreateInfo_self(enc, (const VkDevicePrivateDataCreateInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(296 /* VK_EXT_private_data */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrivateDataFeatures_self(enc, (const VkPhysicalDevicePrivateDataFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFeatures2_self(enc, (const VkPhysicalDeviceFeatures2 *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVariablePointersFeatures_self(enc, (const VkPhysicalDeviceVariablePointersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiviewFeatures_self(enc, (const VkPhysicalDeviceMultiviewFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkDeviceGroupDeviceCreateInfo_self(enc, (const VkDeviceGroupDeviceCreateInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice16BitStorageFeatures_self(enc, (const VkPhysicalDevice16BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures_self(enc, (const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSamplerYcbcrConversionFeatures_self(enc, (const VkPhysicalDeviceSamplerYcbcrConversionFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProtectedMemoryFeatures_self(enc, (const VkPhysicalDeviceProtectedMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(393 /* VK_EXT_multi_draw */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiDrawFeaturesEXT_self(enc, (const VkPhysicalDeviceMultiDrawFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(139 /* VK_EXT_inline_uniform_block */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceInlineUniformBlockFeatures_self(enc, (const VkPhysicalDeviceInlineUniformBlockFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(414 /* VK_KHR_maintenance4 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance4Features_self(enc, (const VkPhysicalDeviceMaintenance4Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDrawParametersFeatures_self(enc, (const VkPhysicalDeviceShaderDrawParametersFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderFloat16Int8Features_self(enc, (const VkPhysicalDeviceShaderFloat16Int8Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceHostQueryResetFeatures_self(enc, (const VkPhysicalDeviceHostQueryResetFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDescriptorIndexingFeatures_self(enc, (const VkPhysicalDeviceDescriptorIndexingFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTimelineSemaphoreFeatures_self(enc, (const VkPhysicalDeviceTimelineSemaphoreFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice8BitStorageFeatures_self(enc, (const VkPhysicalDevice8BitStorageFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(82 /* VK_EXT_conditional_rendering */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceConditionalRenderingFeaturesEXT_self(enc, (const VkPhysicalDeviceConditionalRenderingFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkanMemoryModelFeatures_self(enc, (const VkPhysicalDeviceVulkanMemoryModelFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderAtomicInt64Features_self(enc, (const VkPhysicalDeviceShaderAtomicInt64Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(191 /* VK_EXT_vertex_attribute_divisor */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT_self(enc, (const VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(29 /* VK_EXT_transform_feedback */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTransformFeedbackFeaturesEXT_self(enc, (const VkPhysicalDeviceTransformFeedbackFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceScalarBlockLayoutFeatures_self(enc, (const VkPhysicalDeviceScalarBlockLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceUniformBufferStandardLayoutFeatures_self(enc, (const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(103 /* VK_EXT_depth_clip_enable */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthClipEnableFeaturesEXT_self(enc, (const VkPhysicalDeviceDepthClipEnableFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBufferDeviceAddressFeatures_self(enc, (const VkPhysicalDeviceBufferDeviceAddressFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImagelessFramebufferFeatures_self(enc, (const VkPhysicalDeviceImagelessFramebufferFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(67 /* VK_EXT_texture_compression_astc_hdr */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTextureCompressionASTCHDRFeatures_self(enc, (const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR:
            if (!vn_cs_renderer_protocol_has_extension(182 /* VK_KHR_shader_clock */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderClockFeaturesKHR_self(enc, (const VkPhysicalDeviceShaderClockFeaturesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(266 /* VK_EXT_index_type_uint8 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceIndexTypeUint8FeaturesEXT_self(enc, (const VkPhysicalDeviceIndexTypeUint8FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(252 /* VK_EXT_fragment_shader_interlock */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT_self(enc, (const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures_self(enc, (const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(357 /* VK_EXT_primitive_topology_list_restart */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT_self(enc, (const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(277 /* VK_EXT_shader_demote_to_helper_invocation */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures_self(enc, (const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(282 /* VK_EXT_texel_buffer_alignment */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT_self(enc, (const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(226 /* VK_EXT_subgroup_size_control */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupSizeControlFeatures_self(enc, (const VkPhysicalDeviceSubgroupSizeControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(260 /* VK_EXT_line_rasterization */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceLineRasterizationFeaturesEXT_self(enc, (const VkPhysicalDeviceLineRasterizationFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(298 /* VK_EXT_pipeline_creation_cache_control */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePipelineCreationCacheControlFeatures_self(enc, (const VkPhysicalDevicePipelineCreationCacheControlFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan11Features_self(enc, (const VkPhysicalDeviceVulkan11Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan12Features_self(enc, (const VkPhysicalDeviceVulkan12Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES:
            if (!vn_cs_renderer_protocol_has_api_version(VK_API_VERSION_1_3))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan13Features_self(enc, (const VkPhysicalDeviceVulkan13Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(288 /* VK_EXT_custom_border_color */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceCustomBorderColorFeaturesEXT_self(enc, (const VkPhysicalDeviceCustomBorderColorFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(412 /* VK_EXT_border_color_swizzle */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceBorderColorSwizzleFeaturesEXT_self(enc, (const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(268 /* VK_EXT_extended_dynamic_state */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(378 /* VK_EXT_extended_dynamic_state2 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(456 /* VK_EXT_extended_dynamic_state3 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicState3FeaturesEXT_self(enc, (const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(326 /* VK_KHR_zero_initialize_workgroup_memory */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures_self(enc, (const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(287 /* VK_EXT_robustness2 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRobustness2FeaturesEXT_self(enc, (const VkPhysicalDeviceRobustness2FeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(336 /* VK_EXT_image_robustness */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageRobustnessFeatures_self(enc, (const VkPhysicalDeviceImageRobustnessFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(341 /* VK_EXT_4444_formats */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevice4444FormatsFeaturesEXT_self(enc, (const VkPhysicalDevice4444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(216 /* VK_KHR_shader_terminate_invocation */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderTerminateInvocationFeatures_self(enc, (const VkPhysicalDeviceShaderTerminateInvocationFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(394 /* VK_EXT_image_2d_view_of_3d */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImage2DViewOf3DFeaturesEXT_self(enc, (const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(352 /* VK_VALVE_mutable_descriptor_type */) && !vn_cs_renderer_protocol_has_extension(495 /* VK_EXT_mutable_descriptor_type */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT_self(enc, (const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(356 /* VK_EXT_depth_clip_control */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthClipControlFeaturesEXT_self(enc, (const VkPhysicalDeviceDepthClipControlFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(353 /* VK_EXT_vertex_input_dynamic_state */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT_self(enc, (const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(382 /* VK_EXT_color_write_enable */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceColorWriteEnableFeaturesEXT_self(enc, (const VkPhysicalDeviceColorWriteEnableFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(315 /* VK_KHR_synchronization2 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSynchronization2Features_self(enc, (const VkPhysicalDeviceSynchronization2Features *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(383 /* VK_EXT_primitives_generated_query */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT_self(enc, (const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(331 /* VK_EXT_ycbcr_2plane_444_formats */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT_self(enc, (const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(255 /* VK_EXT_provoking_vertex */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProvokingVertexFeaturesEXT_self(enc, (const VkPhysicalDeviceProvokingVertexFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(281 /* VK_KHR_shader_integer_dot_product */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderIntegerDotProductFeatures_self(enc, (const VkPhysicalDeviceShaderIntegerDotProductFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES:
            if (!vn_cs_renderer_protocol_has_extension(45 /* VK_KHR_dynamic_rendering */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDynamicRenderingFeatures_self(enc, (const VkPhysicalDeviceDynamicRenderingFeatures *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(392 /* VK_EXT_image_view_min_lod */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageViewMinLodFeaturesEXT_self(enc, (const VkPhysicalDeviceImageViewMinLodFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(464 /* VK_EXT_rasterization_order_attachment_access */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT_self(enc, (const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(321 /* VK_EXT_graphics_pipeline_library */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT_self(enc, (const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(423 /* VK_EXT_non_seamless_cube_map */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT_self(enc, (const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(500 /* VK_EXT_dynamic_rendering_unused_attachments */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkDeviceCreateInfo_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT_self(enc, (const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDeviceCreateInfo_self(struct vn_cs_encoder *enc, const VkDeviceCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_uint32_t(enc, &val->queueCreateInfoCount);
    if (val->pQueueCreateInfos) {
        vn_encode_array_size(enc, val->queueCreateInfoCount);
        for (uint32_t i = 0; i < val->queueCreateInfoCount; i++)
            vn_encode_VkDeviceQueueCreateInfo(enc, &val->pQueueCreateInfos[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->enabledLayerCount);
    if (val->ppEnabledLayerNames) {
        vn_encode_array_size(enc, val->enabledLayerCount);
        for (uint32_t i = 0; i < val->enabledLayerCount; i++) {
            const size_t string_size = strlen(val->ppEnabledLayerNames[i]) + 1;
            vn_encode_array_size(enc, string_size);
            vn_encode_char_array(enc, val->ppEnabledLayerNames[i], string_size);
        }
    } else {
        vn_encode_array_size(enc, 0);
    }
    vn_encode_uint32_t(enc, &val->enabledExtensionCount);
    if (val->ppEnabledExtensionNames) {
        vn_encode_array_size(enc, val->enabledExtensionCount);
        for (uint32_t i = 0; i < val->enabledExtensionCount; i++) {
            const size_t string_size = strlen(val->ppEnabledExtensionNames[i]) + 1;
            vn_encode_array_size(enc, string_size);
            vn_encode_char_array(enc, val->ppEnabledExtensionNames[i], string_size);
        }
    } else {
        vn_encode_array_size(enc, 0);
    }
    if (vn_encode_simple_pointer(enc, val->pEnabledFeatures))
        vn_encode_VkPhysicalDeviceFeatures(enc, val->pEnabledFeatures);
}

static inline void
vn_encode_VkDeviceCreateInfo(struct vn_cs_encoder *enc, const VkDeviceCreateInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO });
    vn_encode_VkDeviceCreateInfo_pnext(enc, val->pNext);
    vn_encode_VkDeviceCreateInfo_self(enc, val);
}

/* struct VkPhysicalDeviceMultiDrawPropertiesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiDrawPropertiesEXT_self(const VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->maxMultiDrawCount);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiDrawPropertiesEXT(const VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMultiDrawPropertiesEXT_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->maxMultiDrawCount);
}

static inline void
vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiDrawPropertiesEXT_self_partial(const VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxMultiDrawCount */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiDrawPropertiesEXT_partial(const VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMultiDrawPropertiesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxMultiDrawCount */
}

static inline void
vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiDrawPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDevicePushDescriptorPropertiesKHR chain */

static inline size_t
vn_sizeof_VkPhysicalDevicePushDescriptorPropertiesKHR_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePushDescriptorPropertiesKHR_self(const VkPhysicalDevicePushDescriptorPropertiesKHR *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->maxPushDescriptors);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePushDescriptorPropertiesKHR(const VkPhysicalDevicePushDescriptorPropertiesKHR *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePushDescriptorPropertiesKHR_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePushDescriptorPropertiesKHR_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDevicePushDescriptorPropertiesKHR_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevicePushDescriptorPropertiesKHR_self(struct vn_cs_decoder *dec, VkPhysicalDevicePushDescriptorPropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->maxPushDescriptors);
}

static inline void
vn_decode_VkPhysicalDevicePushDescriptorPropertiesKHR(struct vn_cs_decoder *dec, VkPhysicalDevicePushDescriptorPropertiesKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevicePushDescriptorPropertiesKHR_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevicePushDescriptorPropertiesKHR_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePushDescriptorPropertiesKHR_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePushDescriptorPropertiesKHR_self_partial(const VkPhysicalDevicePushDescriptorPropertiesKHR *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxPushDescriptors */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePushDescriptorPropertiesKHR_partial(const VkPhysicalDevicePushDescriptorPropertiesKHR *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePushDescriptorPropertiesKHR_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePushDescriptorPropertiesKHR_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePushDescriptorPropertiesKHR_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePushDescriptorPropertiesKHR_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePushDescriptorPropertiesKHR *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxPushDescriptors */
}

static inline void
vn_encode_VkPhysicalDevicePushDescriptorPropertiesKHR_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePushDescriptorPropertiesKHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR });
    vn_encode_VkPhysicalDevicePushDescriptorPropertiesKHR_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevicePushDescriptorPropertiesKHR_self_partial(enc, val);
}

/* struct VkConformanceVersion */

static inline size_t
vn_sizeof_VkConformanceVersion(const VkConformanceVersion *val)
{
    size_t size = 0;
    size += vn_sizeof_uint8_t(&val->major);
    size += vn_sizeof_uint8_t(&val->minor);
    size += vn_sizeof_uint8_t(&val->subminor);
    size += vn_sizeof_uint8_t(&val->patch);
    return size;
}

static inline void
vn_decode_VkConformanceVersion(struct vn_cs_decoder *dec, VkConformanceVersion *val)
{
    vn_decode_uint8_t(dec, &val->major);
    vn_decode_uint8_t(dec, &val->minor);
    vn_decode_uint8_t(dec, &val->subminor);
    vn_decode_uint8_t(dec, &val->patch);
}

static inline size_t
vn_sizeof_VkConformanceVersion_partial(const VkConformanceVersion *val)
{
    size_t size = 0;
    /* skip val->major */
    /* skip val->minor */
    /* skip val->subminor */
    /* skip val->patch */
    return size;
}

static inline void
vn_encode_VkConformanceVersion_partial(struct vn_cs_encoder *enc, const VkConformanceVersion *val)
{
    /* skip val->major */
    /* skip val->minor */
    /* skip val->subminor */
    /* skip val->patch */
}

/* struct VkPhysicalDeviceDriverProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceDriverProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDriverProperties_self(const VkPhysicalDeviceDriverProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDriverId(&val->driverID);
    size += vn_sizeof_array_size(VK_MAX_DRIVER_NAME_SIZE);
    size += vn_sizeof_char_array(val->driverName, VK_MAX_DRIVER_NAME_SIZE);
    size += vn_sizeof_array_size(VK_MAX_DRIVER_INFO_SIZE);
    size += vn_sizeof_char_array(val->driverInfo, VK_MAX_DRIVER_INFO_SIZE);
    size += vn_sizeof_VkConformanceVersion(&val->conformanceVersion);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDriverProperties(const VkPhysicalDeviceDriverProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDriverProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDriverProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceDriverProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceDriverProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceDriverProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDriverId(dec, &val->driverID);
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_DRIVER_NAME_SIZE);
        vn_decode_char_array(dec, val->driverName, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_DRIVER_INFO_SIZE);
        vn_decode_char_array(dec, val->driverInfo, array_size);
    }
    vn_decode_VkConformanceVersion(dec, &val->conformanceVersion);
}

static inline void
vn_decode_VkPhysicalDeviceDriverProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceDriverProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceDriverProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceDriverProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDriverProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDriverProperties_self_partial(const VkPhysicalDeviceDriverProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->driverID */
    /* skip val->driverName */
    /* skip val->driverInfo */
    size += vn_sizeof_VkConformanceVersion_partial(&val->conformanceVersion);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDriverProperties_partial(const VkPhysicalDeviceDriverProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDriverProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDriverProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDriverProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDriverProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDriverProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->driverID */
    /* skip val->driverName */
    /* skip val->driverInfo */
    vn_encode_VkConformanceVersion_partial(enc, &val->conformanceVersion);
}

static inline void
vn_encode_VkPhysicalDeviceDriverProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDriverProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES });
    vn_encode_VkPhysicalDeviceDriverProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDriverProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceIDProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceIDProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIDProperties_self(const VkPhysicalDeviceIDProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_array_size(VK_UUID_SIZE);
    size += vn_sizeof_uint8_t_array(val->deviceUUID, VK_UUID_SIZE);
    size += vn_sizeof_array_size(VK_UUID_SIZE);
    size += vn_sizeof_uint8_t_array(val->driverUUID, VK_UUID_SIZE);
    size += vn_sizeof_array_size(VK_LUID_SIZE);
    size += vn_sizeof_uint8_t_array(val->deviceLUID, VK_LUID_SIZE);
    size += vn_sizeof_uint32_t(&val->deviceNodeMask);
    size += vn_sizeof_VkBool32(&val->deviceLUIDValid);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIDProperties(const VkPhysicalDeviceIDProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceIDProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceIDProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceIDProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceIDProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceIDProperties *val)
{
    /* skip val->{sType,pNext} */
    {
        const size_t array_size = vn_decode_array_size(dec, VK_UUID_SIZE);
        vn_decode_uint8_t_array(dec, val->deviceUUID, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_UUID_SIZE);
        vn_decode_uint8_t_array(dec, val->driverUUID, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_LUID_SIZE);
        vn_decode_uint8_t_array(dec, val->deviceLUID, array_size);
    }
    vn_decode_uint32_t(dec, &val->deviceNodeMask);
    vn_decode_VkBool32(dec, &val->deviceLUIDValid);
}

static inline void
vn_decode_VkPhysicalDeviceIDProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceIDProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceIDProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceIDProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIDProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIDProperties_self_partial(const VkPhysicalDeviceIDProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->deviceUUID */
    /* skip val->driverUUID */
    /* skip val->deviceLUID */
    /* skip val->deviceNodeMask */
    /* skip val->deviceLUIDValid */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceIDProperties_partial(const VkPhysicalDeviceIDProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceIDProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceIDProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceIDProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceIDProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceIDProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->deviceUUID */
    /* skip val->driverUUID */
    /* skip val->deviceLUID */
    /* skip val->deviceNodeMask */
    /* skip val->deviceLUIDValid */
}

static inline void
vn_encode_VkPhysicalDeviceIDProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceIDProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES });
    vn_encode_VkPhysicalDeviceIDProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceIDProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMultiviewProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewProperties_self(const VkPhysicalDeviceMultiviewProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->maxMultiviewViewCount);
    size += vn_sizeof_uint32_t(&val->maxMultiviewInstanceIndex);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewProperties(const VkPhysicalDeviceMultiviewProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMultiviewProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMultiviewProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->maxMultiviewViewCount);
    vn_decode_uint32_t(dec, &val->maxMultiviewInstanceIndex);
}

static inline void
vn_decode_VkPhysicalDeviceMultiviewProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceMultiviewProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMultiviewProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMultiviewProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewProperties_self_partial(const VkPhysicalDeviceMultiviewProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxMultiviewViewCount */
    /* skip val->maxMultiviewInstanceIndex */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMultiviewProperties_partial(const VkPhysicalDeviceMultiviewProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMultiviewProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMultiviewProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxMultiviewViewCount */
    /* skip val->maxMultiviewInstanceIndex */
}

static inline void
vn_encode_VkPhysicalDeviceMultiviewProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMultiviewProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES });
    vn_encode_VkPhysicalDeviceMultiviewProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMultiviewProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSubgroupProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupProperties_self(const VkPhysicalDeviceSubgroupProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->subgroupSize);
    size += vn_sizeof_VkFlags(&val->supportedStages);
    size += vn_sizeof_VkFlags(&val->supportedOperations);
    size += vn_sizeof_VkBool32(&val->quadOperationsInAllStages);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupProperties(const VkPhysicalDeviceSubgroupProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSubgroupProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSubgroupProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->subgroupSize);
    vn_decode_VkFlags(dec, &val->supportedStages);
    vn_decode_VkFlags(dec, &val->supportedOperations);
    vn_decode_VkBool32(dec, &val->quadOperationsInAllStages);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceSubgroupProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceSubgroupProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupProperties_self_partial(const VkPhysicalDeviceSubgroupProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->subgroupSize */
    /* skip val->supportedStages */
    /* skip val->supportedOperations */
    /* skip val->quadOperationsInAllStages */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupProperties_partial(const VkPhysicalDeviceSubgroupProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSubgroupProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSubgroupProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->subgroupSize */
    /* skip val->supportedStages */
    /* skip val->supportedOperations */
    /* skip val->quadOperationsInAllStages */
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES });
    vn_encode_VkPhysicalDeviceSubgroupProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupProperties_self_partial(enc, val);
}

/* struct VkPhysicalDevicePointClippingProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDevicePointClippingProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePointClippingProperties_self(const VkPhysicalDevicePointClippingProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPointClippingBehavior(&val->pointClippingBehavior);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePointClippingProperties(const VkPhysicalDevicePointClippingProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePointClippingProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePointClippingProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDevicePointClippingProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevicePointClippingProperties_self(struct vn_cs_decoder *dec, VkPhysicalDevicePointClippingProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPointClippingBehavior(dec, &val->pointClippingBehavior);
}

static inline void
vn_decode_VkPhysicalDevicePointClippingProperties(struct vn_cs_decoder *dec, VkPhysicalDevicePointClippingProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevicePointClippingProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevicePointClippingProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePointClippingProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePointClippingProperties_self_partial(const VkPhysicalDevicePointClippingProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->pointClippingBehavior */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePointClippingProperties_partial(const VkPhysicalDevicePointClippingProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePointClippingProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePointClippingProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePointClippingProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pointClippingBehavior */
}

static inline void
vn_encode_VkPhysicalDevicePointClippingProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePointClippingProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES });
    vn_encode_VkPhysicalDevicePointClippingProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevicePointClippingProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceProtectedMemoryProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_self(const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->protectedNoFault);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties(const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->protectedNoFault);
}

static inline void
vn_decode_VkPhysicalDeviceProtectedMemoryProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceProtectedMemoryProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceProtectedMemoryProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_self_partial(const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->protectedNoFault */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_partial(const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->protectedNoFault */
}

static inline void
vn_encode_VkPhysicalDeviceProtectedMemoryProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProtectedMemoryProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES });
    vn_encode_VkPhysicalDeviceProtectedMemoryProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSamplerFilterMinmaxProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->filterMinmaxSingleComponentFormats);
    size += vn_sizeof_VkBool32(&val->filterMinmaxImageComponentMapping);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties(const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->filterMinmaxSingleComponentFormats);
    vn_decode_VkBool32(dec, &val->filterMinmaxImageComponentMapping);
}

static inline void
vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial(const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->filterMinmaxSingleComponentFormats */
    /* skip val->filterMinmaxImageComponentMapping */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_partial(const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->filterMinmaxSingleComponentFormats */
    /* skip val->filterMinmaxImageComponentMapping */
}

static inline void
vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSamplerFilterMinmaxProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES });
    vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceInlineUniformBlockProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_self(const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->maxInlineUniformBlockSize);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorInlineUniformBlocks);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetInlineUniformBlocks);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties(const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->maxInlineUniformBlockSize);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorInlineUniformBlocks);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetInlineUniformBlocks);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks);
}

static inline void
vn_decode_VkPhysicalDeviceInlineUniformBlockProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_self_partial(const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxInlineUniformBlockSize */
    /* skip val->maxPerStageDescriptorInlineUniformBlocks */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxDescriptorSetInlineUniformBlocks */
    /* skip val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_partial(const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxInlineUniformBlockSize */
    /* skip val->maxPerStageDescriptorInlineUniformBlocks */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxDescriptorSetInlineUniformBlocks */
    /* skip val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks */
}

static inline void
vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceInlineUniformBlockProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES });
    vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMaintenance3Properties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance3Properties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance3Properties_self(const VkPhysicalDeviceMaintenance3Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->maxPerSetDescriptors);
    size += vn_sizeof_VkDeviceSize(&val->maxMemoryAllocationSize);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance3Properties(const VkPhysicalDeviceMaintenance3Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMaintenance3Properties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMaintenance3Properties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance3Properties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance3Properties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance3Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->maxPerSetDescriptors);
    vn_decode_VkDeviceSize(dec, &val->maxMemoryAllocationSize);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance3Properties(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance3Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMaintenance3Properties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMaintenance3Properties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance3Properties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance3Properties_self_partial(const VkPhysicalDeviceMaintenance3Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxPerSetDescriptors */
    /* skip val->maxMemoryAllocationSize */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance3Properties_partial(const VkPhysicalDeviceMaintenance3Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMaintenance3Properties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMaintenance3Properties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance3Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxPerSetDescriptors */
    /* skip val->maxMemoryAllocationSize */
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance3Properties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance3Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES });
    vn_encode_VkPhysicalDeviceMaintenance3Properties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance3Properties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMaintenance4Properties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Properties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Properties_self(const VkPhysicalDeviceMaintenance4Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDeviceSize(&val->maxBufferSize);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Properties(const VkPhysicalDeviceMaintenance4Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Properties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Properties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Properties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Properties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDeviceSize(dec, &val->maxBufferSize);
}

static inline void
vn_decode_VkPhysicalDeviceMaintenance4Properties(struct vn_cs_decoder *dec, VkPhysicalDeviceMaintenance4Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMaintenance4Properties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMaintenance4Properties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Properties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Properties_self_partial(const VkPhysicalDeviceMaintenance4Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxBufferSize */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMaintenance4Properties_partial(const VkPhysicalDeviceMaintenance4Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Properties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMaintenance4Properties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Properties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Properties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxBufferSize */
}

static inline void
vn_encode_VkPhysicalDeviceMaintenance4Properties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMaintenance4Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES });
    vn_encode_VkPhysicalDeviceMaintenance4Properties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMaintenance4Properties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceFloatControlsProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceFloatControlsProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFloatControlsProperties_self(const VkPhysicalDeviceFloatControlsProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkShaderFloatControlsIndependence(&val->denormBehaviorIndependence);
    size += vn_sizeof_VkShaderFloatControlsIndependence(&val->roundingModeIndependence);
    size += vn_sizeof_VkBool32(&val->shaderSignedZeroInfNanPreserveFloat16);
    size += vn_sizeof_VkBool32(&val->shaderSignedZeroInfNanPreserveFloat32);
    size += vn_sizeof_VkBool32(&val->shaderSignedZeroInfNanPreserveFloat64);
    size += vn_sizeof_VkBool32(&val->shaderDenormPreserveFloat16);
    size += vn_sizeof_VkBool32(&val->shaderDenormPreserveFloat32);
    size += vn_sizeof_VkBool32(&val->shaderDenormPreserveFloat64);
    size += vn_sizeof_VkBool32(&val->shaderDenormFlushToZeroFloat16);
    size += vn_sizeof_VkBool32(&val->shaderDenormFlushToZeroFloat32);
    size += vn_sizeof_VkBool32(&val->shaderDenormFlushToZeroFloat64);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTEFloat16);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTEFloat32);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTEFloat64);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTZFloat16);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTZFloat32);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTZFloat64);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFloatControlsProperties(const VkPhysicalDeviceFloatControlsProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceFloatControlsProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceFloatControlsProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceFloatControlsProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceFloatControlsProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceFloatControlsProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkShaderFloatControlsIndependence(dec, &val->denormBehaviorIndependence);
    vn_decode_VkShaderFloatControlsIndependence(dec, &val->roundingModeIndependence);
    vn_decode_VkBool32(dec, &val->shaderSignedZeroInfNanPreserveFloat16);
    vn_decode_VkBool32(dec, &val->shaderSignedZeroInfNanPreserveFloat32);
    vn_decode_VkBool32(dec, &val->shaderSignedZeroInfNanPreserveFloat64);
    vn_decode_VkBool32(dec, &val->shaderDenormPreserveFloat16);
    vn_decode_VkBool32(dec, &val->shaderDenormPreserveFloat32);
    vn_decode_VkBool32(dec, &val->shaderDenormPreserveFloat64);
    vn_decode_VkBool32(dec, &val->shaderDenormFlushToZeroFloat16);
    vn_decode_VkBool32(dec, &val->shaderDenormFlushToZeroFloat32);
    vn_decode_VkBool32(dec, &val->shaderDenormFlushToZeroFloat64);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTEFloat16);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTEFloat32);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTEFloat64);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTZFloat16);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTZFloat32);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTZFloat64);
}

static inline void
vn_decode_VkPhysicalDeviceFloatControlsProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceFloatControlsProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceFloatControlsProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceFloatControlsProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFloatControlsProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFloatControlsProperties_self_partial(const VkPhysicalDeviceFloatControlsProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->denormBehaviorIndependence */
    /* skip val->roundingModeIndependence */
    /* skip val->shaderSignedZeroInfNanPreserveFloat16 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat32 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat64 */
    /* skip val->shaderDenormPreserveFloat16 */
    /* skip val->shaderDenormPreserveFloat32 */
    /* skip val->shaderDenormPreserveFloat64 */
    /* skip val->shaderDenormFlushToZeroFloat16 */
    /* skip val->shaderDenormFlushToZeroFloat32 */
    /* skip val->shaderDenormFlushToZeroFloat64 */
    /* skip val->shaderRoundingModeRTEFloat16 */
    /* skip val->shaderRoundingModeRTEFloat32 */
    /* skip val->shaderRoundingModeRTEFloat64 */
    /* skip val->shaderRoundingModeRTZFloat16 */
    /* skip val->shaderRoundingModeRTZFloat32 */
    /* skip val->shaderRoundingModeRTZFloat64 */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceFloatControlsProperties_partial(const VkPhysicalDeviceFloatControlsProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceFloatControlsProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceFloatControlsProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceFloatControlsProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->denormBehaviorIndependence */
    /* skip val->roundingModeIndependence */
    /* skip val->shaderSignedZeroInfNanPreserveFloat16 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat32 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat64 */
    /* skip val->shaderDenormPreserveFloat16 */
    /* skip val->shaderDenormPreserveFloat32 */
    /* skip val->shaderDenormPreserveFloat64 */
    /* skip val->shaderDenormFlushToZeroFloat16 */
    /* skip val->shaderDenormFlushToZeroFloat32 */
    /* skip val->shaderDenormFlushToZeroFloat64 */
    /* skip val->shaderRoundingModeRTEFloat16 */
    /* skip val->shaderRoundingModeRTEFloat32 */
    /* skip val->shaderRoundingModeRTEFloat64 */
    /* skip val->shaderRoundingModeRTZFloat16 */
    /* skip val->shaderRoundingModeRTZFloat32 */
    /* skip val->shaderRoundingModeRTZFloat64 */
}

static inline void
vn_encode_VkPhysicalDeviceFloatControlsProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceFloatControlsProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES });
    vn_encode_VkPhysicalDeviceFloatControlsProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceFloatControlsProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceConservativeRasterizationPropertiesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self(const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_float(&val->primitiveOverestimationSize);
    size += vn_sizeof_float(&val->maxExtraPrimitiveOverestimationSize);
    size += vn_sizeof_float(&val->extraPrimitiveOverestimationSizeGranularity);
    size += vn_sizeof_VkBool32(&val->primitiveUnderestimation);
    size += vn_sizeof_VkBool32(&val->conservativePointAndLineRasterization);
    size += vn_sizeof_VkBool32(&val->degenerateTrianglesRasterized);
    size += vn_sizeof_VkBool32(&val->degenerateLinesRasterized);
    size += vn_sizeof_VkBool32(&val->fullyCoveredFragmentShaderInputVariable);
    size += vn_sizeof_VkBool32(&val->conservativeRasterizationPostDepthCoverage);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceConservativeRasterizationPropertiesEXT(const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_float(dec, &val->primitiveOverestimationSize);
    vn_decode_float(dec, &val->maxExtraPrimitiveOverestimationSize);
    vn_decode_float(dec, &val->extraPrimitiveOverestimationSizeGranularity);
    vn_decode_VkBool32(dec, &val->primitiveUnderestimation);
    vn_decode_VkBool32(dec, &val->conservativePointAndLineRasterization);
    vn_decode_VkBool32(dec, &val->degenerateTrianglesRasterized);
    vn_decode_VkBool32(dec, &val->degenerateLinesRasterized);
    vn_decode_VkBool32(dec, &val->fullyCoveredFragmentShaderInputVariable);
    vn_decode_VkBool32(dec, &val->conservativeRasterizationPostDepthCoverage);
}

static inline void
vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self_partial(const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->primitiveOverestimationSize */
    /* skip val->maxExtraPrimitiveOverestimationSize */
    /* skip val->extraPrimitiveOverestimationSizeGranularity */
    /* skip val->primitiveUnderestimation */
    /* skip val->conservativePointAndLineRasterization */
    /* skip val->degenerateTrianglesRasterized */
    /* skip val->degenerateLinesRasterized */
    /* skip val->fullyCoveredFragmentShaderInputVariable */
    /* skip val->conservativeRasterizationPostDepthCoverage */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_partial(const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->primitiveOverestimationSize */
    /* skip val->maxExtraPrimitiveOverestimationSize */
    /* skip val->extraPrimitiveOverestimationSizeGranularity */
    /* skip val->primitiveUnderestimation */
    /* skip val->conservativePointAndLineRasterization */
    /* skip val->degenerateTrianglesRasterized */
    /* skip val->degenerateLinesRasterized */
    /* skip val->fullyCoveredFragmentShaderInputVariable */
    /* skip val->conservativeRasterizationPostDepthCoverage */
}

static inline void
vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceDescriptorIndexingProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_self(const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->maxUpdateAfterBindDescriptorsInAllPools);
    size += vn_sizeof_VkBool32(&val->shaderUniformBufferArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderSampledImageArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderStorageBufferArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderInputAttachmentArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->robustBufferAccessUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->quadDivergentImplicitLod);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindSamplers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindUniformBuffers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindStorageBuffers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindSampledImages);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindStorageImages);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindInputAttachments);
    size += vn_sizeof_uint32_t(&val->maxPerStageUpdateAfterBindResources);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindSamplers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindUniformBuffers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindStorageBuffers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindSampledImages);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindStorageImages);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindInputAttachments);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties(const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->maxUpdateAfterBindDescriptorsInAllPools);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->robustBufferAccessUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->quadDivergentImplicitLod);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindSamplers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindUniformBuffers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindStorageBuffers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindSampledImages);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindStorageImages);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindInputAttachments);
    vn_decode_uint32_t(dec, &val->maxPerStageUpdateAfterBindResources);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindSamplers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindUniformBuffers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindStorageBuffers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindSampledImages);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindStorageImages);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindInputAttachments);
}

static inline void
vn_decode_VkPhysicalDeviceDescriptorIndexingProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_self_partial(const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxUpdateAfterBindDescriptorsInAllPools */
    /* skip val->shaderUniformBufferArrayNonUniformIndexingNative */
    /* skip val->shaderSampledImageArrayNonUniformIndexingNative */
    /* skip val->shaderStorageBufferArrayNonUniformIndexingNative */
    /* skip val->shaderStorageImageArrayNonUniformIndexingNative */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexingNative */
    /* skip val->robustBufferAccessUpdateAfterBind */
    /* skip val->quadDivergentImplicitLod */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSamplers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindUniformBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSampledImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInputAttachments */
    /* skip val->maxPerStageUpdateAfterBindResources */
    /* skip val->maxDescriptorSetUpdateAfterBindSamplers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindSampledImages */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageImages */
    /* skip val->maxDescriptorSetUpdateAfterBindInputAttachments */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_partial(const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxUpdateAfterBindDescriptorsInAllPools */
    /* skip val->shaderUniformBufferArrayNonUniformIndexingNative */
    /* skip val->shaderSampledImageArrayNonUniformIndexingNative */
    /* skip val->shaderStorageBufferArrayNonUniformIndexingNative */
    /* skip val->shaderStorageImageArrayNonUniformIndexingNative */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexingNative */
    /* skip val->robustBufferAccessUpdateAfterBind */
    /* skip val->quadDivergentImplicitLod */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSamplers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindUniformBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSampledImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInputAttachments */
    /* skip val->maxPerStageUpdateAfterBindResources */
    /* skip val->maxDescriptorSetUpdateAfterBindSamplers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindSampledImages */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageImages */
    /* skip val->maxDescriptorSetUpdateAfterBindInputAttachments */
}

static inline void
vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDescriptorIndexingProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES });
    vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceTimelineSemaphoreProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_self(const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint64_t(&val->maxTimelineSemaphoreValueDifference);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties(const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint64_t(dec, &val->maxTimelineSemaphoreValueDifference);
}

static inline void
vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial(const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxTimelineSemaphoreValueDifference */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_partial(const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxTimelineSemaphoreValueDifference */
}

static inline void
vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTimelineSemaphoreProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES });
    vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self(const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->maxVertexAttribDivisor);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->maxVertexAttribDivisor);
}

static inline void
vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self_partial(const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxVertexAttribDivisor */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_partial(const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxVertexAttribDivisor */
}

static inline void
vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDevicePCIBusInfoPropertiesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePCIBusInfoPropertiesEXT_self(const VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->pciDomain);
    size += vn_sizeof_uint32_t(&val->pciBus);
    size += vn_sizeof_uint32_t(&val->pciDevice);
    size += vn_sizeof_uint32_t(&val->pciFunction);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePCIBusInfoPropertiesEXT(const VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePCIBusInfoPropertiesEXT_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->pciDomain);
    vn_decode_uint32_t(dec, &val->pciBus);
    vn_decode_uint32_t(dec, &val->pciDevice);
    vn_decode_uint32_t(dec, &val->pciFunction);
}

static inline void
vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT(struct vn_cs_decoder *dec, VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDevicePCIBusInfoPropertiesEXT_self_partial(const VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->pciDomain */
    /* skip val->pciBus */
    /* skip val->pciDevice */
    /* skip val->pciFunction */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDevicePCIBusInfoPropertiesEXT_partial(const VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDevicePCIBusInfoPropertiesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->pciDomain */
    /* skip val->pciBus */
    /* skip val->pciDevice */
    /* skip val->pciFunction */
}

static inline void
vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDevicePCIBusInfoPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT });
    vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceDepthStencilResolveProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_self(const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->supportedDepthResolveModes);
    size += vn_sizeof_VkFlags(&val->supportedStencilResolveModes);
    size += vn_sizeof_VkBool32(&val->independentResolveNone);
    size += vn_sizeof_VkBool32(&val->independentResolve);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties(const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->supportedDepthResolveModes);
    vn_decode_VkFlags(dec, &val->supportedStencilResolveModes);
    vn_decode_VkBool32(dec, &val->independentResolveNone);
    vn_decode_VkBool32(dec, &val->independentResolve);
}

static inline void
vn_decode_VkPhysicalDeviceDepthStencilResolveProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_self_partial(const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->supportedDepthResolveModes */
    /* skip val->supportedStencilResolveModes */
    /* skip val->independentResolveNone */
    /* skip val->independentResolve */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_partial(const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->supportedDepthResolveModes */
    /* skip val->supportedStencilResolveModes */
    /* skip val->independentResolveNone */
    /* skip val->independentResolve */
}

static inline void
vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceDepthStencilResolveProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES });
    vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceTransformFeedbackPropertiesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->maxTransformFeedbackStreams);
    size += vn_sizeof_uint32_t(&val->maxTransformFeedbackBuffers);
    size += vn_sizeof_VkDeviceSize(&val->maxTransformFeedbackBufferSize);
    size += vn_sizeof_uint32_t(&val->maxTransformFeedbackStreamDataSize);
    size += vn_sizeof_uint32_t(&val->maxTransformFeedbackBufferDataSize);
    size += vn_sizeof_uint32_t(&val->maxTransformFeedbackBufferDataStride);
    size += vn_sizeof_VkBool32(&val->transformFeedbackQueries);
    size += vn_sizeof_VkBool32(&val->transformFeedbackStreamsLinesTriangles);
    size += vn_sizeof_VkBool32(&val->transformFeedbackRasterizationStreamSelect);
    size += vn_sizeof_VkBool32(&val->transformFeedbackDraw);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT(const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->maxTransformFeedbackStreams);
    vn_decode_uint32_t(dec, &val->maxTransformFeedbackBuffers);
    vn_decode_VkDeviceSize(dec, &val->maxTransformFeedbackBufferSize);
    vn_decode_uint32_t(dec, &val->maxTransformFeedbackStreamDataSize);
    vn_decode_uint32_t(dec, &val->maxTransformFeedbackBufferDataSize);
    vn_decode_uint32_t(dec, &val->maxTransformFeedbackBufferDataStride);
    vn_decode_VkBool32(dec, &val->transformFeedbackQueries);
    vn_decode_VkBool32(dec, &val->transformFeedbackStreamsLinesTriangles);
    vn_decode_VkBool32(dec, &val->transformFeedbackRasterizationStreamSelect);
    vn_decode_VkBool32(dec, &val->transformFeedbackDraw);
}

static inline void
vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial(const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxTransformFeedbackStreams */
    /* skip val->maxTransformFeedbackBuffers */
    /* skip val->maxTransformFeedbackBufferSize */
    /* skip val->maxTransformFeedbackStreamDataSize */
    /* skip val->maxTransformFeedbackBufferDataSize */
    /* skip val->maxTransformFeedbackBufferDataStride */
    /* skip val->transformFeedbackQueries */
    /* skip val->transformFeedbackStreamsLinesTriangles */
    /* skip val->transformFeedbackRasterizationStreamSelect */
    /* skip val->transformFeedbackDraw */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_partial(const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxTransformFeedbackStreams */
    /* skip val->maxTransformFeedbackBuffers */
    /* skip val->maxTransformFeedbackBufferSize */
    /* skip val->maxTransformFeedbackStreamDataSize */
    /* skip val->maxTransformFeedbackBufferDataSize */
    /* skip val->maxTransformFeedbackBufferDataStride */
    /* skip val->transformFeedbackQueries */
    /* skip val->transformFeedbackStreamsLinesTriangles */
    /* skip val->transformFeedbackRasterizationStreamSelect */
    /* skip val->transformFeedbackDraw */
}

static inline void
vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTransformFeedbackPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceTexelBufferAlignmentProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_self(const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDeviceSize(&val->storageTexelBufferOffsetAlignmentBytes);
    size += vn_sizeof_VkBool32(&val->storageTexelBufferOffsetSingleTexelAlignment);
    size += vn_sizeof_VkDeviceSize(&val->uniformTexelBufferOffsetAlignmentBytes);
    size += vn_sizeof_VkBool32(&val->uniformTexelBufferOffsetSingleTexelAlignment);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties(const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDeviceSize(dec, &val->storageTexelBufferOffsetAlignmentBytes);
    vn_decode_VkBool32(dec, &val->storageTexelBufferOffsetSingleTexelAlignment);
    vn_decode_VkDeviceSize(dec, &val->uniformTexelBufferOffsetAlignmentBytes);
    vn_decode_VkBool32(dec, &val->uniformTexelBufferOffsetSingleTexelAlignment);
}

static inline void
vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial(const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->storageTexelBufferOffsetAlignmentBytes */
    /* skip val->storageTexelBufferOffsetSingleTexelAlignment */
    /* skip val->uniformTexelBufferOffsetAlignmentBytes */
    /* skip val->uniformTexelBufferOffsetSingleTexelAlignment */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_partial(const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->storageTexelBufferOffsetAlignmentBytes */
    /* skip val->storageTexelBufferOffsetSingleTexelAlignment */
    /* skip val->uniformTexelBufferOffsetAlignmentBytes */
    /* skip val->uniformTexelBufferOffsetSingleTexelAlignment */
}

static inline void
vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceTexelBufferAlignmentProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES });
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSubgroupSizeControlProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_self(const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->minSubgroupSize);
    size += vn_sizeof_uint32_t(&val->maxSubgroupSize);
    size += vn_sizeof_uint32_t(&val->maxComputeWorkgroupSubgroups);
    size += vn_sizeof_VkFlags(&val->requiredSubgroupSizeStages);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties(const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->minSubgroupSize);
    vn_decode_uint32_t(dec, &val->maxSubgroupSize);
    vn_decode_uint32_t(dec, &val->maxComputeWorkgroupSubgroups);
    vn_decode_VkFlags(dec, &val->requiredSubgroupSizeStages);
}

static inline void
vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial(const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->minSubgroupSize */
    /* skip val->maxSubgroupSize */
    /* skip val->maxComputeWorkgroupSubgroups */
    /* skip val->requiredSubgroupSizeStages */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_partial(const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->minSubgroupSize */
    /* skip val->maxSubgroupSize */
    /* skip val->maxComputeWorkgroupSubgroups */
    /* skip val->requiredSubgroupSizeStages */
}

static inline void
vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceSubgroupSizeControlProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES });
    vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceLineRasterizationPropertiesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceLineRasterizationPropertiesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceLineRasterizationPropertiesEXT_self(const VkPhysicalDeviceLineRasterizationPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->lineSubPixelPrecisionBits);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceLineRasterizationPropertiesEXT(const VkPhysicalDeviceLineRasterizationPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceLineRasterizationPropertiesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceLineRasterizationPropertiesEXT_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationPropertiesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationPropertiesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->lineSubPixelPrecisionBits);
}

static inline void
vn_decode_VkPhysicalDeviceLineRasterizationPropertiesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceLineRasterizationPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceLineRasterizationPropertiesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceLineRasterizationPropertiesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceLineRasterizationPropertiesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceLineRasterizationPropertiesEXT_self_partial(const VkPhysicalDeviceLineRasterizationPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->lineSubPixelPrecisionBits */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceLineRasterizationPropertiesEXT_partial(const VkPhysicalDeviceLineRasterizationPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceLineRasterizationPropertiesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceLineRasterizationPropertiesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationPropertiesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationPropertiesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceLineRasterizationPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->lineSubPixelPrecisionBits */
}

static inline void
vn_encode_VkPhysicalDeviceLineRasterizationPropertiesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceLineRasterizationPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceLineRasterizationPropertiesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceLineRasterizationPropertiesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVulkan11Properties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Properties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Properties_self(const VkPhysicalDeviceVulkan11Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_array_size(VK_UUID_SIZE);
    size += vn_sizeof_uint8_t_array(val->deviceUUID, VK_UUID_SIZE);
    size += vn_sizeof_array_size(VK_UUID_SIZE);
    size += vn_sizeof_uint8_t_array(val->driverUUID, VK_UUID_SIZE);
    size += vn_sizeof_array_size(VK_LUID_SIZE);
    size += vn_sizeof_uint8_t_array(val->deviceLUID, VK_LUID_SIZE);
    size += vn_sizeof_uint32_t(&val->deviceNodeMask);
    size += vn_sizeof_VkBool32(&val->deviceLUIDValid);
    size += vn_sizeof_uint32_t(&val->subgroupSize);
    size += vn_sizeof_VkFlags(&val->subgroupSupportedStages);
    size += vn_sizeof_VkFlags(&val->subgroupSupportedOperations);
    size += vn_sizeof_VkBool32(&val->subgroupQuadOperationsInAllStages);
    size += vn_sizeof_VkPointClippingBehavior(&val->pointClippingBehavior);
    size += vn_sizeof_uint32_t(&val->maxMultiviewViewCount);
    size += vn_sizeof_uint32_t(&val->maxMultiviewInstanceIndex);
    size += vn_sizeof_VkBool32(&val->protectedNoFault);
    size += vn_sizeof_uint32_t(&val->maxPerSetDescriptors);
    size += vn_sizeof_VkDeviceSize(&val->maxMemoryAllocationSize);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Properties(const VkPhysicalDeviceVulkan11Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Properties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Properties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Properties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Properties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Properties *val)
{
    /* skip val->{sType,pNext} */
    {
        const size_t array_size = vn_decode_array_size(dec, VK_UUID_SIZE);
        vn_decode_uint8_t_array(dec, val->deviceUUID, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_UUID_SIZE);
        vn_decode_uint8_t_array(dec, val->driverUUID, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_LUID_SIZE);
        vn_decode_uint8_t_array(dec, val->deviceLUID, array_size);
    }
    vn_decode_uint32_t(dec, &val->deviceNodeMask);
    vn_decode_VkBool32(dec, &val->deviceLUIDValid);
    vn_decode_uint32_t(dec, &val->subgroupSize);
    vn_decode_VkFlags(dec, &val->subgroupSupportedStages);
    vn_decode_VkFlags(dec, &val->subgroupSupportedOperations);
    vn_decode_VkBool32(dec, &val->subgroupQuadOperationsInAllStages);
    vn_decode_VkPointClippingBehavior(dec, &val->pointClippingBehavior);
    vn_decode_uint32_t(dec, &val->maxMultiviewViewCount);
    vn_decode_uint32_t(dec, &val->maxMultiviewInstanceIndex);
    vn_decode_VkBool32(dec, &val->protectedNoFault);
    vn_decode_uint32_t(dec, &val->maxPerSetDescriptors);
    vn_decode_VkDeviceSize(dec, &val->maxMemoryAllocationSize);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan11Properties(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan11Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVulkan11Properties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVulkan11Properties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Properties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Properties_self_partial(const VkPhysicalDeviceVulkan11Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->deviceUUID */
    /* skip val->driverUUID */
    /* skip val->deviceLUID */
    /* skip val->deviceNodeMask */
    /* skip val->deviceLUIDValid */
    /* skip val->subgroupSize */
    /* skip val->subgroupSupportedStages */
    /* skip val->subgroupSupportedOperations */
    /* skip val->subgroupQuadOperationsInAllStages */
    /* skip val->pointClippingBehavior */
    /* skip val->maxMultiviewViewCount */
    /* skip val->maxMultiviewInstanceIndex */
    /* skip val->protectedNoFault */
    /* skip val->maxPerSetDescriptors */
    /* skip val->maxMemoryAllocationSize */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan11Properties_partial(const VkPhysicalDeviceVulkan11Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Properties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan11Properties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->deviceUUID */
    /* skip val->driverUUID */
    /* skip val->deviceLUID */
    /* skip val->deviceNodeMask */
    /* skip val->deviceLUIDValid */
    /* skip val->subgroupSize */
    /* skip val->subgroupSupportedStages */
    /* skip val->subgroupSupportedOperations */
    /* skip val->subgroupQuadOperationsInAllStages */
    /* skip val->pointClippingBehavior */
    /* skip val->maxMultiviewViewCount */
    /* skip val->maxMultiviewInstanceIndex */
    /* skip val->protectedNoFault */
    /* skip val->maxPerSetDescriptors */
    /* skip val->maxMemoryAllocationSize */
}

static inline void
vn_encode_VkPhysicalDeviceVulkan11Properties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan11Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan11Properties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan11Properties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVulkan12Properties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Properties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Properties_self(const VkPhysicalDeviceVulkan12Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDriverId(&val->driverID);
    size += vn_sizeof_array_size(VK_MAX_DRIVER_NAME_SIZE);
    size += vn_sizeof_char_array(val->driverName, VK_MAX_DRIVER_NAME_SIZE);
    size += vn_sizeof_array_size(VK_MAX_DRIVER_INFO_SIZE);
    size += vn_sizeof_char_array(val->driverInfo, VK_MAX_DRIVER_INFO_SIZE);
    size += vn_sizeof_VkConformanceVersion(&val->conformanceVersion);
    size += vn_sizeof_VkShaderFloatControlsIndependence(&val->denormBehaviorIndependence);
    size += vn_sizeof_VkShaderFloatControlsIndependence(&val->roundingModeIndependence);
    size += vn_sizeof_VkBool32(&val->shaderSignedZeroInfNanPreserveFloat16);
    size += vn_sizeof_VkBool32(&val->shaderSignedZeroInfNanPreserveFloat32);
    size += vn_sizeof_VkBool32(&val->shaderSignedZeroInfNanPreserveFloat64);
    size += vn_sizeof_VkBool32(&val->shaderDenormPreserveFloat16);
    size += vn_sizeof_VkBool32(&val->shaderDenormPreserveFloat32);
    size += vn_sizeof_VkBool32(&val->shaderDenormPreserveFloat64);
    size += vn_sizeof_VkBool32(&val->shaderDenormFlushToZeroFloat16);
    size += vn_sizeof_VkBool32(&val->shaderDenormFlushToZeroFloat32);
    size += vn_sizeof_VkBool32(&val->shaderDenormFlushToZeroFloat64);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTEFloat16);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTEFloat32);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTEFloat64);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTZFloat16);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTZFloat32);
    size += vn_sizeof_VkBool32(&val->shaderRoundingModeRTZFloat64);
    size += vn_sizeof_uint32_t(&val->maxUpdateAfterBindDescriptorsInAllPools);
    size += vn_sizeof_VkBool32(&val->shaderUniformBufferArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderSampledImageArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderStorageBufferArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderStorageImageArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->shaderInputAttachmentArrayNonUniformIndexingNative);
    size += vn_sizeof_VkBool32(&val->robustBufferAccessUpdateAfterBind);
    size += vn_sizeof_VkBool32(&val->quadDivergentImplicitLod);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindSamplers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindUniformBuffers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindStorageBuffers);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindSampledImages);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindStorageImages);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindInputAttachments);
    size += vn_sizeof_uint32_t(&val->maxPerStageUpdateAfterBindResources);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindSamplers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindUniformBuffers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindStorageBuffers);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindSampledImages);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindStorageImages);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindInputAttachments);
    size += vn_sizeof_VkFlags(&val->supportedDepthResolveModes);
    size += vn_sizeof_VkFlags(&val->supportedStencilResolveModes);
    size += vn_sizeof_VkBool32(&val->independentResolveNone);
    size += vn_sizeof_VkBool32(&val->independentResolve);
    size += vn_sizeof_VkBool32(&val->filterMinmaxSingleComponentFormats);
    size += vn_sizeof_VkBool32(&val->filterMinmaxImageComponentMapping);
    size += vn_sizeof_uint64_t(&val->maxTimelineSemaphoreValueDifference);
    size += vn_sizeof_VkFlags(&val->framebufferIntegerColorSampleCounts);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Properties(const VkPhysicalDeviceVulkan12Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Properties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Properties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Properties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Properties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDriverId(dec, &val->driverID);
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_DRIVER_NAME_SIZE);
        vn_decode_char_array(dec, val->driverName, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_DRIVER_INFO_SIZE);
        vn_decode_char_array(dec, val->driverInfo, array_size);
    }
    vn_decode_VkConformanceVersion(dec, &val->conformanceVersion);
    vn_decode_VkShaderFloatControlsIndependence(dec, &val->denormBehaviorIndependence);
    vn_decode_VkShaderFloatControlsIndependence(dec, &val->roundingModeIndependence);
    vn_decode_VkBool32(dec, &val->shaderSignedZeroInfNanPreserveFloat16);
    vn_decode_VkBool32(dec, &val->shaderSignedZeroInfNanPreserveFloat32);
    vn_decode_VkBool32(dec, &val->shaderSignedZeroInfNanPreserveFloat64);
    vn_decode_VkBool32(dec, &val->shaderDenormPreserveFloat16);
    vn_decode_VkBool32(dec, &val->shaderDenormPreserveFloat32);
    vn_decode_VkBool32(dec, &val->shaderDenormPreserveFloat64);
    vn_decode_VkBool32(dec, &val->shaderDenormFlushToZeroFloat16);
    vn_decode_VkBool32(dec, &val->shaderDenormFlushToZeroFloat32);
    vn_decode_VkBool32(dec, &val->shaderDenormFlushToZeroFloat64);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTEFloat16);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTEFloat32);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTEFloat64);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTZFloat16);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTZFloat32);
    vn_decode_VkBool32(dec, &val->shaderRoundingModeRTZFloat64);
    vn_decode_uint32_t(dec, &val->maxUpdateAfterBindDescriptorsInAllPools);
    vn_decode_VkBool32(dec, &val->shaderUniformBufferArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderSampledImageArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderStorageBufferArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderStorageImageArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->shaderInputAttachmentArrayNonUniformIndexingNative);
    vn_decode_VkBool32(dec, &val->robustBufferAccessUpdateAfterBind);
    vn_decode_VkBool32(dec, &val->quadDivergentImplicitLod);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindSamplers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindUniformBuffers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindStorageBuffers);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindSampledImages);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindStorageImages);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindInputAttachments);
    vn_decode_uint32_t(dec, &val->maxPerStageUpdateAfterBindResources);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindSamplers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindUniformBuffers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindStorageBuffers);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindSampledImages);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindStorageImages);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindInputAttachments);
    vn_decode_VkFlags(dec, &val->supportedDepthResolveModes);
    vn_decode_VkFlags(dec, &val->supportedStencilResolveModes);
    vn_decode_VkBool32(dec, &val->independentResolveNone);
    vn_decode_VkBool32(dec, &val->independentResolve);
    vn_decode_VkBool32(dec, &val->filterMinmaxSingleComponentFormats);
    vn_decode_VkBool32(dec, &val->filterMinmaxImageComponentMapping);
    vn_decode_uint64_t(dec, &val->maxTimelineSemaphoreValueDifference);
    vn_decode_VkFlags(dec, &val->framebufferIntegerColorSampleCounts);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan12Properties(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan12Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVulkan12Properties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVulkan12Properties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Properties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Properties_self_partial(const VkPhysicalDeviceVulkan12Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->driverID */
    /* skip val->driverName */
    /* skip val->driverInfo */
    size += vn_sizeof_VkConformanceVersion_partial(&val->conformanceVersion);
    /* skip val->denormBehaviorIndependence */
    /* skip val->roundingModeIndependence */
    /* skip val->shaderSignedZeroInfNanPreserveFloat16 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat32 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat64 */
    /* skip val->shaderDenormPreserveFloat16 */
    /* skip val->shaderDenormPreserveFloat32 */
    /* skip val->shaderDenormPreserveFloat64 */
    /* skip val->shaderDenormFlushToZeroFloat16 */
    /* skip val->shaderDenormFlushToZeroFloat32 */
    /* skip val->shaderDenormFlushToZeroFloat64 */
    /* skip val->shaderRoundingModeRTEFloat16 */
    /* skip val->shaderRoundingModeRTEFloat32 */
    /* skip val->shaderRoundingModeRTEFloat64 */
    /* skip val->shaderRoundingModeRTZFloat16 */
    /* skip val->shaderRoundingModeRTZFloat32 */
    /* skip val->shaderRoundingModeRTZFloat64 */
    /* skip val->maxUpdateAfterBindDescriptorsInAllPools */
    /* skip val->shaderUniformBufferArrayNonUniformIndexingNative */
    /* skip val->shaderSampledImageArrayNonUniformIndexingNative */
    /* skip val->shaderStorageBufferArrayNonUniformIndexingNative */
    /* skip val->shaderStorageImageArrayNonUniformIndexingNative */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexingNative */
    /* skip val->robustBufferAccessUpdateAfterBind */
    /* skip val->quadDivergentImplicitLod */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSamplers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindUniformBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSampledImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInputAttachments */
    /* skip val->maxPerStageUpdateAfterBindResources */
    /* skip val->maxDescriptorSetUpdateAfterBindSamplers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindSampledImages */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageImages */
    /* skip val->maxDescriptorSetUpdateAfterBindInputAttachments */
    /* skip val->supportedDepthResolveModes */
    /* skip val->supportedStencilResolveModes */
    /* skip val->independentResolveNone */
    /* skip val->independentResolve */
    /* skip val->filterMinmaxSingleComponentFormats */
    /* skip val->filterMinmaxImageComponentMapping */
    /* skip val->maxTimelineSemaphoreValueDifference */
    /* skip val->framebufferIntegerColorSampleCounts */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan12Properties_partial(const VkPhysicalDeviceVulkan12Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Properties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan12Properties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->driverID */
    /* skip val->driverName */
    /* skip val->driverInfo */
    vn_encode_VkConformanceVersion_partial(enc, &val->conformanceVersion);
    /* skip val->denormBehaviorIndependence */
    /* skip val->roundingModeIndependence */
    /* skip val->shaderSignedZeroInfNanPreserveFloat16 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat32 */
    /* skip val->shaderSignedZeroInfNanPreserveFloat64 */
    /* skip val->shaderDenormPreserveFloat16 */
    /* skip val->shaderDenormPreserveFloat32 */
    /* skip val->shaderDenormPreserveFloat64 */
    /* skip val->shaderDenormFlushToZeroFloat16 */
    /* skip val->shaderDenormFlushToZeroFloat32 */
    /* skip val->shaderDenormFlushToZeroFloat64 */
    /* skip val->shaderRoundingModeRTEFloat16 */
    /* skip val->shaderRoundingModeRTEFloat32 */
    /* skip val->shaderRoundingModeRTEFloat64 */
    /* skip val->shaderRoundingModeRTZFloat16 */
    /* skip val->shaderRoundingModeRTZFloat32 */
    /* skip val->shaderRoundingModeRTZFloat64 */
    /* skip val->maxUpdateAfterBindDescriptorsInAllPools */
    /* skip val->shaderUniformBufferArrayNonUniformIndexingNative */
    /* skip val->shaderSampledImageArrayNonUniformIndexingNative */
    /* skip val->shaderStorageBufferArrayNonUniformIndexingNative */
    /* skip val->shaderStorageImageArrayNonUniformIndexingNative */
    /* skip val->shaderInputAttachmentArrayNonUniformIndexingNative */
    /* skip val->robustBufferAccessUpdateAfterBind */
    /* skip val->quadDivergentImplicitLod */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSamplers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindUniformBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageBuffers */
    /* skip val->maxPerStageDescriptorUpdateAfterBindSampledImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindStorageImages */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInputAttachments */
    /* skip val->maxPerStageUpdateAfterBindResources */
    /* skip val->maxDescriptorSetUpdateAfterBindSamplers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffers */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic */
    /* skip val->maxDescriptorSetUpdateAfterBindSampledImages */
    /* skip val->maxDescriptorSetUpdateAfterBindStorageImages */
    /* skip val->maxDescriptorSetUpdateAfterBindInputAttachments */
    /* skip val->supportedDepthResolveModes */
    /* skip val->supportedStencilResolveModes */
    /* skip val->independentResolveNone */
    /* skip val->independentResolve */
    /* skip val->filterMinmaxSingleComponentFormats */
    /* skip val->filterMinmaxImageComponentMapping */
    /* skip val->maxTimelineSemaphoreValueDifference */
    /* skip val->framebufferIntegerColorSampleCounts */
}

static inline void
vn_encode_VkPhysicalDeviceVulkan12Properties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan12Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan12Properties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan12Properties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceVulkan13Properties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Properties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Properties_self(const VkPhysicalDeviceVulkan13Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->minSubgroupSize);
    size += vn_sizeof_uint32_t(&val->maxSubgroupSize);
    size += vn_sizeof_uint32_t(&val->maxComputeWorkgroupSubgroups);
    size += vn_sizeof_VkFlags(&val->requiredSubgroupSizeStages);
    size += vn_sizeof_uint32_t(&val->maxInlineUniformBlockSize);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorInlineUniformBlocks);
    size += vn_sizeof_uint32_t(&val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetInlineUniformBlocks);
    size += vn_sizeof_uint32_t(&val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks);
    size += vn_sizeof_uint32_t(&val->maxInlineUniformTotalSize);
    size += vn_sizeof_VkBool32(&val->integerDotProduct8BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct8BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct8BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct4x8BitPackedUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct4x8BitPackedSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct4x8BitPackedMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct16BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct16BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct16BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct32BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct32BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct32BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct64BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct64BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct64BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating8BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating16BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating32BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating64BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated);
    size += vn_sizeof_VkDeviceSize(&val->storageTexelBufferOffsetAlignmentBytes);
    size += vn_sizeof_VkBool32(&val->storageTexelBufferOffsetSingleTexelAlignment);
    size += vn_sizeof_VkDeviceSize(&val->uniformTexelBufferOffsetAlignmentBytes);
    size += vn_sizeof_VkBool32(&val->uniformTexelBufferOffsetSingleTexelAlignment);
    size += vn_sizeof_VkDeviceSize(&val->maxBufferSize);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Properties(const VkPhysicalDeviceVulkan13Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Properties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Properties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Properties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Properties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Properties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->minSubgroupSize);
    vn_decode_uint32_t(dec, &val->maxSubgroupSize);
    vn_decode_uint32_t(dec, &val->maxComputeWorkgroupSubgroups);
    vn_decode_VkFlags(dec, &val->requiredSubgroupSizeStages);
    vn_decode_uint32_t(dec, &val->maxInlineUniformBlockSize);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorInlineUniformBlocks);
    vn_decode_uint32_t(dec, &val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetInlineUniformBlocks);
    vn_decode_uint32_t(dec, &val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks);
    vn_decode_uint32_t(dec, &val->maxInlineUniformTotalSize);
    vn_decode_VkBool32(dec, &val->integerDotProduct8BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct8BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct8BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct4x8BitPackedUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct4x8BitPackedSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct4x8BitPackedMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct16BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct16BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct16BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct32BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct32BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct32BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct64BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct64BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct64BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating8BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating16BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating32BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating64BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated);
    vn_decode_VkDeviceSize(dec, &val->storageTexelBufferOffsetAlignmentBytes);
    vn_decode_VkBool32(dec, &val->storageTexelBufferOffsetSingleTexelAlignment);
    vn_decode_VkDeviceSize(dec, &val->uniformTexelBufferOffsetAlignmentBytes);
    vn_decode_VkBool32(dec, &val->uniformTexelBufferOffsetSingleTexelAlignment);
    vn_decode_VkDeviceSize(dec, &val->maxBufferSize);
}

static inline void
vn_decode_VkPhysicalDeviceVulkan13Properties(struct vn_cs_decoder *dec, VkPhysicalDeviceVulkan13Properties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceVulkan13Properties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceVulkan13Properties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Properties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Properties_self_partial(const VkPhysicalDeviceVulkan13Properties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->minSubgroupSize */
    /* skip val->maxSubgroupSize */
    /* skip val->maxComputeWorkgroupSubgroups */
    /* skip val->requiredSubgroupSizeStages */
    /* skip val->maxInlineUniformBlockSize */
    /* skip val->maxPerStageDescriptorInlineUniformBlocks */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxDescriptorSetInlineUniformBlocks */
    /* skip val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxInlineUniformTotalSize */
    /* skip val->integerDotProduct8BitUnsignedAccelerated */
    /* skip val->integerDotProduct8BitSignedAccelerated */
    /* skip val->integerDotProduct8BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProduct16BitUnsignedAccelerated */
    /* skip val->integerDotProduct16BitSignedAccelerated */
    /* skip val->integerDotProduct16BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct32BitUnsignedAccelerated */
    /* skip val->integerDotProduct32BitSignedAccelerated */
    /* skip val->integerDotProduct32BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct64BitUnsignedAccelerated */
    /* skip val->integerDotProduct64BitSignedAccelerated */
    /* skip val->integerDotProduct64BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated */
    /* skip val->storageTexelBufferOffsetAlignmentBytes */
    /* skip val->storageTexelBufferOffsetSingleTexelAlignment */
    /* skip val->uniformTexelBufferOffsetAlignmentBytes */
    /* skip val->uniformTexelBufferOffsetSingleTexelAlignment */
    /* skip val->maxBufferSize */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceVulkan13Properties_partial(const VkPhysicalDeviceVulkan13Properties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Properties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceVulkan13Properties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Properties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Properties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Properties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->minSubgroupSize */
    /* skip val->maxSubgroupSize */
    /* skip val->maxComputeWorkgroupSubgroups */
    /* skip val->requiredSubgroupSizeStages */
    /* skip val->maxInlineUniformBlockSize */
    /* skip val->maxPerStageDescriptorInlineUniformBlocks */
    /* skip val->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxDescriptorSetInlineUniformBlocks */
    /* skip val->maxDescriptorSetUpdateAfterBindInlineUniformBlocks */
    /* skip val->maxInlineUniformTotalSize */
    /* skip val->integerDotProduct8BitUnsignedAccelerated */
    /* skip val->integerDotProduct8BitSignedAccelerated */
    /* skip val->integerDotProduct8BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProduct16BitUnsignedAccelerated */
    /* skip val->integerDotProduct16BitSignedAccelerated */
    /* skip val->integerDotProduct16BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct32BitUnsignedAccelerated */
    /* skip val->integerDotProduct32BitSignedAccelerated */
    /* skip val->integerDotProduct32BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct64BitUnsignedAccelerated */
    /* skip val->integerDotProduct64BitSignedAccelerated */
    /* skip val->integerDotProduct64BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated */
    /* skip val->storageTexelBufferOffsetAlignmentBytes */
    /* skip val->storageTexelBufferOffsetSingleTexelAlignment */
    /* skip val->uniformTexelBufferOffsetAlignmentBytes */
    /* skip val->uniformTexelBufferOffsetSingleTexelAlignment */
    /* skip val->maxBufferSize */
}

static inline void
vn_encode_VkPhysicalDeviceVulkan13Properties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceVulkan13Properties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES });
    vn_encode_VkPhysicalDeviceVulkan13Properties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceVulkan13Properties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceCustomBorderColorPropertiesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self(const VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->maxCustomBorderColorSamplers);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceCustomBorderColorPropertiesEXT(const VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->maxCustomBorderColorSamplers);
}

static inline void
vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self_partial(const VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->maxCustomBorderColorSamplers */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceCustomBorderColorPropertiesEXT_partial(const VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->maxCustomBorderColorSamplers */
}

static inline void
vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceCustomBorderColorPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceExtendedDynamicState3PropertiesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self(const VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->dynamicPrimitiveTopologyUnrestricted);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT(const VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->dynamicPrimitiveTopologyUnrestricted);
}

static inline void
vn_decode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self_partial(const VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->dynamicPrimitiveTopologyUnrestricted */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_partial(const VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->dynamicPrimitiveTopologyUnrestricted */
}

static inline void
vn_encode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceRobustness2PropertiesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceRobustness2PropertiesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRobustness2PropertiesEXT_self(const VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkDeviceSize(&val->robustStorageBufferAccessSizeAlignment);
    size += vn_sizeof_VkDeviceSize(&val->robustUniformBufferAccessSizeAlignment);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRobustness2PropertiesEXT(const VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceRobustness2PropertiesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceRobustness2PropertiesEXT_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkDeviceSize(dec, &val->robustStorageBufferAccessSizeAlignment);
    vn_decode_VkDeviceSize(dec, &val->robustUniformBufferAccessSizeAlignment);
}

static inline void
vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRobustness2PropertiesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRobustness2PropertiesEXT_self_partial(const VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->robustStorageBufferAccessSizeAlignment */
    /* skip val->robustUniformBufferAccessSizeAlignment */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceRobustness2PropertiesEXT_partial(const VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceRobustness2PropertiesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceRobustness2PropertiesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->robustStorageBufferAccessSizeAlignment */
    /* skip val->robustUniformBufferAccessSizeAlignment */
}

static inline void
vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceRobustness2PropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceProvokingVertexPropertiesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProvokingVertexPropertiesEXT_self(const VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->provokingVertexModePerPipeline);
    size += vn_sizeof_VkBool32(&val->transformFeedbackPreservesTriangleFanProvokingVertex);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProvokingVertexPropertiesEXT(const VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProvokingVertexPropertiesEXT_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->provokingVertexModePerPipeline);
    vn_decode_VkBool32(dec, &val->transformFeedbackPreservesTriangleFanProvokingVertex);
}

static inline void
vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProvokingVertexPropertiesEXT_self_partial(const VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->provokingVertexModePerPipeline */
    /* skip val->transformFeedbackPreservesTriangleFanProvokingVertex */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProvokingVertexPropertiesEXT_partial(const VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProvokingVertexPropertiesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->provokingVertexModePerPipeline */
    /* skip val->transformFeedbackPreservesTriangleFanProvokingVertex */
}

static inline void
vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProvokingVertexPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceShaderIntegerDotProductProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_self(const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->integerDotProduct8BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct8BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct8BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct4x8BitPackedUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct4x8BitPackedSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct4x8BitPackedMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct16BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct16BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct16BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct32BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct32BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct32BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct64BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct64BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProduct64BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating8BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating16BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating32BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating64BitSignedAccelerated);
    size += vn_sizeof_VkBool32(&val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties(const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_self(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->integerDotProduct8BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct8BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct8BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct4x8BitPackedUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct4x8BitPackedSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct4x8BitPackedMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct16BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct16BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct16BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct32BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct32BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct32BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct64BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct64BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProduct64BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating8BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating16BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating32BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating64BitSignedAccelerated);
    vn_decode_VkBool32(dec, &val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated);
}

static inline void
vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties(struct vn_cs_decoder *dec, VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial(const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->integerDotProduct8BitUnsignedAccelerated */
    /* skip val->integerDotProduct8BitSignedAccelerated */
    /* skip val->integerDotProduct8BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProduct16BitUnsignedAccelerated */
    /* skip val->integerDotProduct16BitSignedAccelerated */
    /* skip val->integerDotProduct16BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct32BitUnsignedAccelerated */
    /* skip val->integerDotProduct32BitSignedAccelerated */
    /* skip val->integerDotProduct32BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct64BitUnsignedAccelerated */
    /* skip val->integerDotProduct64BitSignedAccelerated */
    /* skip val->integerDotProduct64BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_partial(const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->integerDotProduct8BitUnsignedAccelerated */
    /* skip val->integerDotProduct8BitSignedAccelerated */
    /* skip val->integerDotProduct8BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProduct4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProduct16BitUnsignedAccelerated */
    /* skip val->integerDotProduct16BitSignedAccelerated */
    /* skip val->integerDotProduct16BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct32BitUnsignedAccelerated */
    /* skip val->integerDotProduct32BitSignedAccelerated */
    /* skip val->integerDotProduct32BitMixedSignednessAccelerated */
    /* skip val->integerDotProduct64BitUnsignedAccelerated */
    /* skip val->integerDotProduct64BitSignedAccelerated */
    /* skip val->integerDotProduct64BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitSignedAccelerated */
    /* skip val->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated */
}

static inline void
vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceShaderIntegerDotProductProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES });
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self(const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkBool32(&val->graphicsPipelineLibraryFastLinking);
    size += vn_sizeof_VkBool32(&val->graphicsPipelineLibraryIndependentInterpolationDecoration);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkBool32(dec, &val->graphicsPipelineLibraryFastLinking);
    vn_decode_VkBool32(dec, &val->graphicsPipelineLibraryIndependentInterpolationDecoration);
}

static inline void
vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self_partial(const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->graphicsPipelineLibraryFastLinking */
    /* skip val->graphicsPipelineLibraryIndependentInterpolationDecoration */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_partial(const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->graphicsPipelineLibraryFastLinking */
    /* skip val->graphicsPipelineLibraryIndependentInterpolationDecoration */
}

static inline void
vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceProperties2 chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(393 /* VK_EXT_multi_draw */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiDrawPropertiesEXT_self((const VkPhysicalDeviceMultiDrawPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR:
            if (!vn_cs_renderer_protocol_has_extension(81 /* VK_KHR_push_descriptor */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePushDescriptorPropertiesKHR_self((const VkPhysicalDevicePushDescriptorPropertiesKHR *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDriverProperties_self((const VkPhysicalDeviceDriverProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceIDProperties_self((const VkPhysicalDeviceIDProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiviewProperties_self((const VkPhysicalDeviceMultiviewProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSubgroupProperties_self((const VkPhysicalDeviceSubgroupProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePointClippingProperties_self((const VkPhysicalDevicePointClippingProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_self((const VkPhysicalDeviceProtectedMemoryProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_self((const VkPhysicalDeviceSamplerFilterMinmaxProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(139 /* VK_EXT_inline_uniform_block */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_self((const VkPhysicalDeviceInlineUniformBlockProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMaintenance3Properties_self((const VkPhysicalDeviceMaintenance3Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(414 /* VK_KHR_maintenance4 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMaintenance4Properties_self((const VkPhysicalDeviceMaintenance4Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceFloatControlsProperties_self((const VkPhysicalDeviceFloatControlsProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(102 /* VK_EXT_conservative_rasterization */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self((const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_self((const VkPhysicalDeviceDescriptorIndexingProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_self((const VkPhysicalDeviceTimelineSemaphoreProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(191 /* VK_EXT_vertex_attribute_divisor */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self((const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(213 /* VK_EXT_pci_bus_info */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePCIBusInfoPropertiesEXT_self((const VkPhysicalDevicePCIBusInfoPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_self((const VkPhysicalDeviceDepthStencilResolveProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(29 /* VK_EXT_transform_feedback */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self((const VkPhysicalDeviceTransformFeedbackPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(282 /* VK_EXT_texel_buffer_alignment */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_self((const VkPhysicalDeviceTexelBufferAlignmentProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(226 /* VK_EXT_subgroup_size_control */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_self((const VkPhysicalDeviceSubgroupSizeControlProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(260 /* VK_EXT_line_rasterization */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceLineRasterizationPropertiesEXT_self((const VkPhysicalDeviceLineRasterizationPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan11Properties_self((const VkPhysicalDeviceVulkan11Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan12Properties_self((const VkPhysicalDeviceVulkan12Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_api_version(VK_API_VERSION_1_3))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan13Properties_self((const VkPhysicalDeviceVulkan13Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(288 /* VK_EXT_custom_border_color */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self((const VkPhysicalDeviceCustomBorderColorPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(456 /* VK_EXT_extended_dynamic_state3 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self((const VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(287 /* VK_EXT_robustness2 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceRobustness2PropertiesEXT_self((const VkPhysicalDeviceRobustness2PropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(255 /* VK_EXT_provoking_vertex */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProvokingVertexPropertiesEXT_self((const VkPhysicalDeviceProvokingVertexPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(281 /* VK_KHR_shader_integer_dot_product */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_self((const VkPhysicalDeviceShaderIntegerDotProductProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(321 /* VK_EXT_graphics_pipeline_library */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self((const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties2_self(const VkPhysicalDeviceProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPhysicalDeviceProperties(&val->properties);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties2(const VkPhysicalDeviceProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProperties2_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProperties2_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceProperties2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    VkBaseOutStructure *pnext = (VkBaseOutStructure *)val;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return;

    vn_decode_VkStructureType(dec, &stype);
    while (true) {
        assert(pnext);
        if (pnext->sType == stype)
            break;

        pnext = pnext->pNext;
    }

    switch ((int32_t)pnext->sType) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceMultiDrawPropertiesEXT_self(dec, (VkPhysicalDeviceMultiDrawPropertiesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevicePushDescriptorPropertiesKHR_self(dec, (VkPhysicalDevicePushDescriptorPropertiesKHR *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceDriverProperties_self(dec, (VkPhysicalDeviceDriverProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceIDProperties_self(dec, (VkPhysicalDeviceIDProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceMultiviewProperties_self(dec, (VkPhysicalDeviceMultiviewProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceSubgroupProperties_self(dec, (VkPhysicalDeviceSubgroupProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevicePointClippingProperties_self(dec, (VkPhysicalDevicePointClippingProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceProtectedMemoryProperties_self(dec, (VkPhysicalDeviceProtectedMemoryProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self(dec, (VkPhysicalDeviceSamplerFilterMinmaxProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceInlineUniformBlockProperties_self(dec, (VkPhysicalDeviceInlineUniformBlockProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceMaintenance3Properties_self(dec, (VkPhysicalDeviceMaintenance3Properties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceMaintenance4Properties_self(dec, (VkPhysicalDeviceMaintenance4Properties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceFloatControlsProperties_self(dec, (VkPhysicalDeviceFloatControlsProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self(dec, (VkPhysicalDeviceConservativeRasterizationPropertiesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceDescriptorIndexingProperties_self(dec, (VkPhysicalDeviceDescriptorIndexingProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceTimelineSemaphoreProperties_self(dec, (VkPhysicalDeviceTimelineSemaphoreProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self(dec, (VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self(dec, (VkPhysicalDevicePCIBusInfoPropertiesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceDepthStencilResolveProperties_self(dec, (VkPhysicalDeviceDepthStencilResolveProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self(dec, (VkPhysicalDeviceTransformFeedbackPropertiesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceTexelBufferAlignmentProperties_self(dec, (VkPhysicalDeviceTexelBufferAlignmentProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceSubgroupSizeControlProperties_self(dec, (VkPhysicalDeviceSubgroupSizeControlProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceLineRasterizationPropertiesEXT_self(dec, (VkPhysicalDeviceLineRasterizationPropertiesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVulkan11Properties_self(dec, (VkPhysicalDeviceVulkan11Properties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVulkan12Properties_self(dec, (VkPhysicalDeviceVulkan12Properties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceVulkan13Properties_self(dec, (VkPhysicalDeviceVulkan13Properties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self(dec, (VkPhysicalDeviceCustomBorderColorPropertiesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self(dec, (VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceRobustness2PropertiesEXT_self(dec, (VkPhysicalDeviceRobustness2PropertiesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self(dec, (VkPhysicalDeviceProvokingVertexPropertiesEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceShaderIntegerDotProductProperties_self(dec, (VkPhysicalDeviceShaderIntegerDotProductProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT:
        vn_decode_VkPhysicalDeviceProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self(dec, (VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *)pnext);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_decode_VkPhysicalDeviceProperties2_self(struct vn_cs_decoder *dec, VkPhysicalDeviceProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceProperties(dec, &val->properties);
}

static inline void
vn_decode_VkPhysicalDeviceProperties2(struct vn_cs_decoder *dec, VkPhysicalDeviceProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceProperties2_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceProperties2_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(393 /* VK_EXT_multi_draw */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiDrawPropertiesEXT_self_partial((const VkPhysicalDeviceMultiDrawPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR:
            if (!vn_cs_renderer_protocol_has_extension(81 /* VK_KHR_push_descriptor */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePushDescriptorPropertiesKHR_self_partial((const VkPhysicalDevicePushDescriptorPropertiesKHR *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDriverProperties_self_partial((const VkPhysicalDeviceDriverProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceIDProperties_self_partial((const VkPhysicalDeviceIDProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMultiviewProperties_self_partial((const VkPhysicalDeviceMultiviewProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSubgroupProperties_self_partial((const VkPhysicalDeviceSubgroupProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePointClippingProperties_self_partial((const VkPhysicalDevicePointClippingProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProtectedMemoryProperties_self_partial((const VkPhysicalDeviceProtectedMemoryProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial((const VkPhysicalDeviceSamplerFilterMinmaxProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(139 /* VK_EXT_inline_uniform_block */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceInlineUniformBlockProperties_self_partial((const VkPhysicalDeviceInlineUniformBlockProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMaintenance3Properties_self_partial((const VkPhysicalDeviceMaintenance3Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(414 /* VK_KHR_maintenance4 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMaintenance4Properties_self_partial((const VkPhysicalDeviceMaintenance4Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceFloatControlsProperties_self_partial((const VkPhysicalDeviceFloatControlsProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(102 /* VK_EXT_conservative_rasterization */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self_partial((const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDescriptorIndexingProperties_self_partial((const VkPhysicalDeviceDescriptorIndexingProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial((const VkPhysicalDeviceTimelineSemaphoreProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(191 /* VK_EXT_vertex_attribute_divisor */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self_partial((const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(213 /* VK_EXT_pci_bus_info */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDevicePCIBusInfoPropertiesEXT_self_partial((const VkPhysicalDevicePCIBusInfoPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceDepthStencilResolveProperties_self_partial((const VkPhysicalDeviceDepthStencilResolveProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(29 /* VK_EXT_transform_feedback */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial((const VkPhysicalDeviceTransformFeedbackPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(282 /* VK_EXT_texel_buffer_alignment */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial((const VkPhysicalDeviceTexelBufferAlignmentProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(226 /* VK_EXT_subgroup_size_control */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial((const VkPhysicalDeviceSubgroupSizeControlProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(260 /* VK_EXT_line_rasterization */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceLineRasterizationPropertiesEXT_self_partial((const VkPhysicalDeviceLineRasterizationPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan11Properties_self_partial((const VkPhysicalDeviceVulkan11Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan12Properties_self_partial((const VkPhysicalDeviceVulkan12Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_api_version(VK_API_VERSION_1_3))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceVulkan13Properties_self_partial((const VkPhysicalDeviceVulkan13Properties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(288 /* VK_EXT_custom_border_color */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self_partial((const VkPhysicalDeviceCustomBorderColorPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(456 /* VK_EXT_extended_dynamic_state3 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self_partial((const VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(287 /* VK_EXT_robustness2 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceRobustness2PropertiesEXT_self_partial((const VkPhysicalDeviceRobustness2PropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(255 /* VK_EXT_provoking_vertex */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceProvokingVertexPropertiesEXT_self_partial((const VkPhysicalDeviceProvokingVertexPropertiesEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(281 /* VK_KHR_shader_integer_dot_product */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial((const VkPhysicalDeviceShaderIntegerDotProductProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(321 /* VK_EXT_graphics_pipeline_library */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self_partial((const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties2_self_partial(const VkPhysicalDeviceProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPhysicalDeviceProperties_partial(&val->properties);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceProperties2_partial(const VkPhysicalDeviceProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceProperties2_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceProperties2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceProperties2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(393 /* VK_EXT_multi_draw */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiDrawPropertiesEXT_self_partial(enc, (const VkPhysicalDeviceMultiDrawPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR:
            if (!vn_cs_renderer_protocol_has_extension(81 /* VK_KHR_push_descriptor */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePushDescriptorPropertiesKHR_self_partial(enc, (const VkPhysicalDevicePushDescriptorPropertiesKHR *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDriverProperties_self_partial(enc, (const VkPhysicalDeviceDriverProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceIDProperties_self_partial(enc, (const VkPhysicalDeviceIDProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMultiviewProperties_self_partial(enc, (const VkPhysicalDeviceMultiviewProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupProperties_self_partial(enc, (const VkPhysicalDeviceSubgroupProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePointClippingProperties_self_partial(enc, (const VkPhysicalDevicePointClippingProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProtectedMemoryProperties_self_partial(enc, (const VkPhysicalDeviceProtectedMemoryProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSamplerFilterMinmaxProperties_self_partial(enc, (const VkPhysicalDeviceSamplerFilterMinmaxProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(139 /* VK_EXT_inline_uniform_block */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceInlineUniformBlockProperties_self_partial(enc, (const VkPhysicalDeviceInlineUniformBlockProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance3Properties_self_partial(enc, (const VkPhysicalDeviceMaintenance3Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(414 /* VK_KHR_maintenance4 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMaintenance4Properties_self_partial(enc, (const VkPhysicalDeviceMaintenance4Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceFloatControlsProperties_self_partial(enc, (const VkPhysicalDeviceFloatControlsProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(102 /* VK_EXT_conservative_rasterization */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceConservativeRasterizationPropertiesEXT_self_partial(enc, (const VkPhysicalDeviceConservativeRasterizationPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDescriptorIndexingProperties_self_partial(enc, (const VkPhysicalDeviceDescriptorIndexingProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTimelineSemaphoreProperties_self_partial(enc, (const VkPhysicalDeviceTimelineSemaphoreProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(191 /* VK_EXT_vertex_attribute_divisor */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT_self_partial(enc, (const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(213 /* VK_EXT_pci_bus_info */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDevicePCIBusInfoPropertiesEXT_self_partial(enc, (const VkPhysicalDevicePCIBusInfoPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceDepthStencilResolveProperties_self_partial(enc, (const VkPhysicalDeviceDepthStencilResolveProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(29 /* VK_EXT_transform_feedback */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTransformFeedbackPropertiesEXT_self_partial(enc, (const VkPhysicalDeviceTransformFeedbackPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(282 /* VK_EXT_texel_buffer_alignment */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceTexelBufferAlignmentProperties_self_partial(enc, (const VkPhysicalDeviceTexelBufferAlignmentProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(226 /* VK_EXT_subgroup_size_control */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceSubgroupSizeControlProperties_self_partial(enc, (const VkPhysicalDeviceSubgroupSizeControlProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(260 /* VK_EXT_line_rasterization */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceLineRasterizationPropertiesEXT_self_partial(enc, (const VkPhysicalDeviceLineRasterizationPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan11Properties_self_partial(enc, (const VkPhysicalDeviceVulkan11Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan12Properties_self_partial(enc, (const VkPhysicalDeviceVulkan12Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_api_version(VK_API_VERSION_1_3))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceVulkan13Properties_self_partial(enc, (const VkPhysicalDeviceVulkan13Properties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(288 /* VK_EXT_custom_border_color */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceCustomBorderColorPropertiesEXT_self_partial(enc, (const VkPhysicalDeviceCustomBorderColorPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(456 /* VK_EXT_extended_dynamic_state3 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExtendedDynamicState3PropertiesEXT_self_partial(enc, (const VkPhysicalDeviceExtendedDynamicState3PropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(287 /* VK_EXT_robustness2 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceRobustness2PropertiesEXT_self_partial(enc, (const VkPhysicalDeviceRobustness2PropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(255 /* VK_EXT_provoking_vertex */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceProvokingVertexPropertiesEXT_self_partial(enc, (const VkPhysicalDeviceProvokingVertexPropertiesEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES:
            if (!vn_cs_renderer_protocol_has_extension(281 /* VK_KHR_shader_integer_dot_product */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceShaderIntegerDotProductProperties_self_partial(enc, (const VkPhysicalDeviceShaderIntegerDotProductProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(321 /* VK_EXT_graphics_pipeline_library */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT_self_partial(enc, (const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceProperties2_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceProperties_partial(enc, &val->properties);
}

static inline void
vn_encode_VkPhysicalDeviceProperties2_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2 });
    vn_encode_VkPhysicalDeviceProperties2_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceProperties2_self_partial(enc, val);
}

/* struct VkDrmFormatModifierPropertiesEXT */

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesEXT(const VkDrmFormatModifierPropertiesEXT *val)
{
    size_t size = 0;
    size += vn_sizeof_uint64_t(&val->drmFormatModifier);
    size += vn_sizeof_uint32_t(&val->drmFormatModifierPlaneCount);
    size += vn_sizeof_VkFlags(&val->drmFormatModifierTilingFeatures);
    return size;
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesEXT(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesEXT *val)
{
    vn_decode_uint64_t(dec, &val->drmFormatModifier);
    vn_decode_uint32_t(dec, &val->drmFormatModifierPlaneCount);
    vn_decode_VkFlags(dec, &val->drmFormatModifierTilingFeatures);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesEXT_partial(const VkDrmFormatModifierPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->drmFormatModifier */
    /* skip val->drmFormatModifierPlaneCount */
    /* skip val->drmFormatModifierTilingFeatures */
    return size;
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesEXT_partial(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesEXT *val)
{
    /* skip val->drmFormatModifier */
    /* skip val->drmFormatModifierPlaneCount */
    /* skip val->drmFormatModifierTilingFeatures */
}

/* struct VkDrmFormatModifierPropertiesListEXT chain */

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesListEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesListEXT_self(const VkDrmFormatModifierPropertiesListEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->drmFormatModifierCount);
    if (val->pDrmFormatModifierProperties) {
        size += vn_sizeof_array_size(val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            size += vn_sizeof_VkDrmFormatModifierPropertiesEXT(&val->pDrmFormatModifierProperties[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesListEXT(const VkDrmFormatModifierPropertiesListEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDrmFormatModifierPropertiesListEXT_pnext(val->pNext);
    size += vn_sizeof_VkDrmFormatModifierPropertiesListEXT_self(val);

    return size;
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesListEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesListEXT_self(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesListEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->drmFormatModifierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->drmFormatModifierCount);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkDrmFormatModifierPropertiesEXT(dec, &val->pDrmFormatModifierProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pDrmFormatModifierProperties = NULL;
    }
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesListEXT(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesListEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT);

    assert(val->sType == stype);
    vn_decode_VkDrmFormatModifierPropertiesListEXT_pnext(dec, val->pNext);
    vn_decode_VkDrmFormatModifierPropertiesListEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesListEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesListEXT_self_partial(const VkDrmFormatModifierPropertiesListEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->drmFormatModifierCount);
    if (val->pDrmFormatModifierProperties) {
        size += vn_sizeof_array_size(val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            size += vn_sizeof_VkDrmFormatModifierPropertiesEXT_partial(&val->pDrmFormatModifierProperties[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesListEXT_partial(const VkDrmFormatModifierPropertiesListEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDrmFormatModifierPropertiesListEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkDrmFormatModifierPropertiesListEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesListEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesListEXT_self_partial(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesListEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->drmFormatModifierCount);
    if (val->pDrmFormatModifierProperties) {
        vn_encode_array_size(enc, val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            vn_encode_VkDrmFormatModifierPropertiesEXT_partial(enc, &val->pDrmFormatModifierProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesListEXT_partial(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesListEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT });
    vn_encode_VkDrmFormatModifierPropertiesListEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkDrmFormatModifierPropertiesListEXT_self_partial(enc, val);
}

/* struct VkFormatProperties3 chain */

static inline size_t
vn_sizeof_VkFormatProperties3_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkFormatProperties3_self(const VkFormatProperties3 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags64(&val->linearTilingFeatures);
    size += vn_sizeof_VkFlags64(&val->optimalTilingFeatures);
    size += vn_sizeof_VkFlags64(&val->bufferFeatures);
    return size;
}

static inline size_t
vn_sizeof_VkFormatProperties3(const VkFormatProperties3 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkFormatProperties3_pnext(val->pNext);
    size += vn_sizeof_VkFormatProperties3_self(val);

    return size;
}

static inline void
vn_decode_VkFormatProperties3_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkFormatProperties3_self(struct vn_cs_decoder *dec, VkFormatProperties3 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags64(dec, &val->linearTilingFeatures);
    vn_decode_VkFlags64(dec, &val->optimalTilingFeatures);
    vn_decode_VkFlags64(dec, &val->bufferFeatures);
}

static inline void
vn_decode_VkFormatProperties3(struct vn_cs_decoder *dec, VkFormatProperties3 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3);

    assert(val->sType == stype);
    vn_decode_VkFormatProperties3_pnext(dec, val->pNext);
    vn_decode_VkFormatProperties3_self(dec, val);
}

static inline size_t
vn_sizeof_VkFormatProperties3_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkFormatProperties3_self_partial(const VkFormatProperties3 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->linearTilingFeatures */
    /* skip val->optimalTilingFeatures */
    /* skip val->bufferFeatures */
    return size;
}

static inline size_t
vn_sizeof_VkFormatProperties3_partial(const VkFormatProperties3 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkFormatProperties3_pnext_partial(val->pNext);
    size += vn_sizeof_VkFormatProperties3_self_partial(val);

    return size;
}

static inline void
vn_encode_VkFormatProperties3_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkFormatProperties3_self_partial(struct vn_cs_encoder *enc, const VkFormatProperties3 *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->linearTilingFeatures */
    /* skip val->optimalTilingFeatures */
    /* skip val->bufferFeatures */
}

static inline void
vn_encode_VkFormatProperties3_partial(struct vn_cs_encoder *enc, const VkFormatProperties3 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3 });
    vn_encode_VkFormatProperties3_pnext_partial(enc, val->pNext);
    vn_encode_VkFormatProperties3_self_partial(enc, val);
}

/* struct VkDrmFormatModifierProperties2EXT */

static inline size_t
vn_sizeof_VkDrmFormatModifierProperties2EXT(const VkDrmFormatModifierProperties2EXT *val)
{
    size_t size = 0;
    size += vn_sizeof_uint64_t(&val->drmFormatModifier);
    size += vn_sizeof_uint32_t(&val->drmFormatModifierPlaneCount);
    size += vn_sizeof_VkFlags64(&val->drmFormatModifierTilingFeatures);
    return size;
}

static inline void
vn_decode_VkDrmFormatModifierProperties2EXT(struct vn_cs_decoder *dec, VkDrmFormatModifierProperties2EXT *val)
{
    vn_decode_uint64_t(dec, &val->drmFormatModifier);
    vn_decode_uint32_t(dec, &val->drmFormatModifierPlaneCount);
    vn_decode_VkFlags64(dec, &val->drmFormatModifierTilingFeatures);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierProperties2EXT_partial(const VkDrmFormatModifierProperties2EXT *val)
{
    size_t size = 0;
    /* skip val->drmFormatModifier */
    /* skip val->drmFormatModifierPlaneCount */
    /* skip val->drmFormatModifierTilingFeatures */
    return size;
}

static inline void
vn_encode_VkDrmFormatModifierProperties2EXT_partial(struct vn_cs_encoder *enc, const VkDrmFormatModifierProperties2EXT *val)
{
    /* skip val->drmFormatModifier */
    /* skip val->drmFormatModifierPlaneCount */
    /* skip val->drmFormatModifierTilingFeatures */
}

/* struct VkDrmFormatModifierPropertiesList2EXT chain */

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_self(const VkDrmFormatModifierPropertiesList2EXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->drmFormatModifierCount);
    if (val->pDrmFormatModifierProperties) {
        size += vn_sizeof_array_size(val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            size += vn_sizeof_VkDrmFormatModifierProperties2EXT(&val->pDrmFormatModifierProperties[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesList2EXT(const VkDrmFormatModifierPropertiesList2EXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_pnext(val->pNext);
    size += vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_self(val);

    return size;
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesList2EXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesList2EXT_self(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesList2EXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->drmFormatModifierCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->drmFormatModifierCount);
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkDrmFormatModifierProperties2EXT(dec, &val->pDrmFormatModifierProperties[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pDrmFormatModifierProperties = NULL;
    }
}

static inline void
vn_decode_VkDrmFormatModifierPropertiesList2EXT(struct vn_cs_decoder *dec, VkDrmFormatModifierPropertiesList2EXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT);

    assert(val->sType == stype);
    vn_decode_VkDrmFormatModifierPropertiesList2EXT_pnext(dec, val->pNext);
    vn_decode_VkDrmFormatModifierPropertiesList2EXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_self_partial(const VkDrmFormatModifierPropertiesList2EXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->drmFormatModifierCount);
    if (val->pDrmFormatModifierProperties) {
        size += vn_sizeof_array_size(val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            size += vn_sizeof_VkDrmFormatModifierProperties2EXT_partial(&val->pDrmFormatModifierProperties[i]);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_partial(const VkDrmFormatModifierPropertiesList2EXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesList2EXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesList2EXT_self_partial(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesList2EXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint32_t(enc, &val->drmFormatModifierCount);
    if (val->pDrmFormatModifierProperties) {
        vn_encode_array_size(enc, val->drmFormatModifierCount);
        for (uint32_t i = 0; i < val->drmFormatModifierCount; i++)
            vn_encode_VkDrmFormatModifierProperties2EXT_partial(enc, &val->pDrmFormatModifierProperties[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkDrmFormatModifierPropertiesList2EXT_partial(struct vn_cs_encoder *enc, const VkDrmFormatModifierPropertiesList2EXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT });
    vn_encode_VkDrmFormatModifierPropertiesList2EXT_pnext_partial(enc, val->pNext);
    vn_encode_VkDrmFormatModifierPropertiesList2EXT_self_partial(enc, val);
}

/* struct VkFormatProperties2 chain */

static inline size_t
vn_sizeof_VkFormatProperties2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
            if (!vn_cs_renderer_protocol_has_extension(159 /* VK_EXT_image_drm_format_modifier */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkFormatProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkDrmFormatModifierPropertiesListEXT_self((const VkDrmFormatModifierPropertiesListEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
            if (!vn_cs_renderer_protocol_has_extension(361 /* VK_KHR_format_feature_flags2 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkFormatProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkFormatProperties3_self((const VkFormatProperties3 *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
            if (!(vn_cs_renderer_protocol_has_extension(159 /* VK_EXT_image_drm_format_modifier */) && vn_cs_renderer_protocol_has_extension(361 /* VK_KHR_format_feature_flags2 */)))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkFormatProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_self((const VkDrmFormatModifierPropertiesList2EXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkFormatProperties2_self(const VkFormatProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFormatProperties(&val->formatProperties);
    return size;
}

static inline size_t
vn_sizeof_VkFormatProperties2(const VkFormatProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkFormatProperties2_pnext(val->pNext);
    size += vn_sizeof_VkFormatProperties2_self(val);

    return size;
}

static inline void
vn_decode_VkFormatProperties2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    VkBaseOutStructure *pnext = (VkBaseOutStructure *)val;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return;

    vn_decode_VkStructureType(dec, &stype);
    while (true) {
        assert(pnext);
        if (pnext->sType == stype)
            break;

        pnext = pnext->pNext;
    }

    switch ((int32_t)pnext->sType) {
    case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
        vn_decode_VkFormatProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkDrmFormatModifierPropertiesListEXT_self(dec, (VkDrmFormatModifierPropertiesListEXT *)pnext);
        break;
    case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
        vn_decode_VkFormatProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkFormatProperties3_self(dec, (VkFormatProperties3 *)pnext);
        break;
    case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
        vn_decode_VkFormatProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkDrmFormatModifierPropertiesList2EXT_self(dec, (VkDrmFormatModifierPropertiesList2EXT *)pnext);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_decode_VkFormatProperties2_self(struct vn_cs_decoder *dec, VkFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFormatProperties(dec, &val->formatProperties);
}

static inline void
vn_decode_VkFormatProperties2(struct vn_cs_decoder *dec, VkFormatProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2);

    assert(val->sType == stype);
    vn_decode_VkFormatProperties2_pnext(dec, val->pNext);
    vn_decode_VkFormatProperties2_self(dec, val);
}

static inline size_t
vn_sizeof_VkFormatProperties2_pnext_partial(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
            if (!vn_cs_renderer_protocol_has_extension(159 /* VK_EXT_image_drm_format_modifier */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkFormatProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkDrmFormatModifierPropertiesListEXT_self_partial((const VkDrmFormatModifierPropertiesListEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
            if (!vn_cs_renderer_protocol_has_extension(361 /* VK_KHR_format_feature_flags2 */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkFormatProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkFormatProperties3_self_partial((const VkFormatProperties3 *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
            if (!(vn_cs_renderer_protocol_has_extension(159 /* VK_EXT_image_drm_format_modifier */) && vn_cs_renderer_protocol_has_extension(361 /* VK_KHR_format_feature_flags2 */)))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkFormatProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkDrmFormatModifierPropertiesList2EXT_self_partial((const VkDrmFormatModifierPropertiesList2EXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkFormatProperties2_self_partial(const VkFormatProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFormatProperties_partial(&val->formatProperties);
    return size;
}

static inline size_t
vn_sizeof_VkFormatProperties2_partial(const VkFormatProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkFormatProperties2_pnext_partial(val->pNext);
    size += vn_sizeof_VkFormatProperties2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkFormatProperties2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT:
            if (!vn_cs_renderer_protocol_has_extension(159 /* VK_EXT_image_drm_format_modifier */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkFormatProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkDrmFormatModifierPropertiesListEXT_self_partial(enc, (const VkDrmFormatModifierPropertiesListEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3:
            if (!vn_cs_renderer_protocol_has_extension(361 /* VK_KHR_format_feature_flags2 */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkFormatProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkFormatProperties3_self_partial(enc, (const VkFormatProperties3 *)pnext);
            return;
        case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT:
            if (!(vn_cs_renderer_protocol_has_extension(159 /* VK_EXT_image_drm_format_modifier */) && vn_cs_renderer_protocol_has_extension(361 /* VK_KHR_format_feature_flags2 */)))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkFormatProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkDrmFormatModifierPropertiesList2EXT_self_partial(enc, (const VkDrmFormatModifierPropertiesList2EXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkFormatProperties2_self_partial(struct vn_cs_encoder *enc, const VkFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFormatProperties_partial(enc, &val->formatProperties);
}

static inline void
vn_encode_VkFormatProperties2_partial(struct vn_cs_encoder *enc, const VkFormatProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2 });
    vn_encode_VkFormatProperties2_pnext_partial(enc, val->pNext);
    vn_encode_VkFormatProperties2_self_partial(enc, val);
}

/* struct VkPhysicalDeviceExternalImageFormatInfo chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalImageFormatInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalImageFormatInfo_self(const VkPhysicalDeviceExternalImageFormatInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkExternalMemoryHandleTypeFlagBits(&val->handleType);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalImageFormatInfo(const VkPhysicalDeviceExternalImageFormatInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExternalImageFormatInfo_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExternalImageFormatInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExternalImageFormatInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExternalImageFormatInfo_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalImageFormatInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExternalMemoryHandleTypeFlagBits(enc, &val->handleType);
}

static inline void
vn_encode_VkPhysicalDeviceExternalImageFormatInfo(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalImageFormatInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO });
    vn_encode_VkPhysicalDeviceExternalImageFormatInfo_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExternalImageFormatInfo_self(enc, val);
}

/* struct VkPhysicalDeviceImageDrmFormatModifierInfoEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self(const VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint64_t(&val->drmFormatModifier);
    size += vn_sizeof_VkSharingMode(&val->sharingMode);
    size += vn_sizeof_uint32_t(&val->queueFamilyIndexCount);
    if (val->pQueueFamilyIndices) {
        size += vn_sizeof_array_size(val->queueFamilyIndexCount);
        size += vn_sizeof_uint32_t_array(val->pQueueFamilyIndices, val->queueFamilyIndexCount);
    } else {
        size += vn_sizeof_array_size(0);
    }
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(const VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint64_t(enc, &val->drmFormatModifier);
    vn_encode_VkSharingMode(enc, &val->sharingMode);
    vn_encode_uint32_t(enc, &val->queueFamilyIndexCount);
    if (val->pQueueFamilyIndices) {
        vn_encode_array_size(enc, val->queueFamilyIndexCount);
        vn_encode_uint32_t_array(enc, val->pQueueFamilyIndices, val->queueFamilyIndexCount);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void
vn_encode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageDrmFormatModifierInfoEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT });
    vn_encode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self(enc, val);
}

/* struct VkPhysicalDeviceImageFormatInfo2 chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceImageFormatInfo2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceImageFormatInfo2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceExternalImageFormatInfo_self((const VkPhysicalDeviceExternalImageFormatInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceImageFormatInfo2_pnext(pnext->pNext);
            size += vn_sizeof_VkImageFormatListCreateInfo_self((const VkImageFormatListCreateInfo *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
            if (!vn_cs_renderer_protocol_has_extension(159 /* VK_EXT_image_drm_format_modifier */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceImageFormatInfo2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self((const VkPhysicalDeviceImageDrmFormatModifierInfoEXT *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceImageFormatInfo2_pnext(pnext->pNext);
            size += vn_sizeof_VkImageStencilUsageCreateInfo_self((const VkImageStencilUsageCreateInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageFormatInfo2_self(const VkPhysicalDeviceImageFormatInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFormat(&val->format);
    size += vn_sizeof_VkImageType(&val->type);
    size += vn_sizeof_VkImageTiling(&val->tiling);
    size += vn_sizeof_VkFlags(&val->usage);
    size += vn_sizeof_VkFlags(&val->flags);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceImageFormatInfo2(const VkPhysicalDeviceImageFormatInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceImageFormatInfo2_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceImageFormatInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceImageFormatInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceImageFormatInfo2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceExternalImageFormatInfo_self(enc, (const VkPhysicalDeviceExternalImageFormatInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceImageFormatInfo2_pnext(enc, pnext->pNext);
            vn_encode_VkImageFormatListCreateInfo_self(enc, (const VkImageFormatListCreateInfo *)pnext);
            return;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT:
            if (!vn_cs_renderer_protocol_has_extension(159 /* VK_EXT_image_drm_format_modifier */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceImageFormatInfo2_pnext(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceImageDrmFormatModifierInfoEXT_self(enc, (const VkPhysicalDeviceImageDrmFormatModifierInfoEXT *)pnext);
            return;
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceImageFormatInfo2_pnext(enc, pnext->pNext);
            vn_encode_VkImageStencilUsageCreateInfo_self(enc, (const VkImageStencilUsageCreateInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceImageFormatInfo2_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageFormatInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFormat(enc, &val->format);
    vn_encode_VkImageType(enc, &val->type);
    vn_encode_VkImageTiling(enc, &val->tiling);
    vn_encode_VkFlags(enc, &val->usage);
    vn_encode_VkFlags(enc, &val->flags);
}

static inline void
vn_encode_VkPhysicalDeviceImageFormatInfo2(struct vn_cs_encoder *enc, const VkPhysicalDeviceImageFormatInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2 });
    vn_encode_VkPhysicalDeviceImageFormatInfo2_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceImageFormatInfo2_self(enc, val);
}

/* struct VkExternalMemoryProperties */

static inline size_t
vn_sizeof_VkExternalMemoryProperties(const VkExternalMemoryProperties *val)
{
    size_t size = 0;
    size += vn_sizeof_VkFlags(&val->externalMemoryFeatures);
    size += vn_sizeof_VkFlags(&val->exportFromImportedHandleTypes);
    size += vn_sizeof_VkFlags(&val->compatibleHandleTypes);
    return size;
}

static inline void
vn_decode_VkExternalMemoryProperties(struct vn_cs_decoder *dec, VkExternalMemoryProperties *val)
{
    vn_decode_VkFlags(dec, &val->externalMemoryFeatures);
    vn_decode_VkFlags(dec, &val->exportFromImportedHandleTypes);
    vn_decode_VkFlags(dec, &val->compatibleHandleTypes);
}

static inline size_t
vn_sizeof_VkExternalMemoryProperties_partial(const VkExternalMemoryProperties *val)
{
    size_t size = 0;
    /* skip val->externalMemoryFeatures */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
    return size;
}

static inline void
vn_encode_VkExternalMemoryProperties_partial(struct vn_cs_encoder *enc, const VkExternalMemoryProperties *val)
{
    /* skip val->externalMemoryFeatures */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
}

/* struct VkExternalImageFormatProperties chain */

static inline size_t
vn_sizeof_VkExternalImageFormatProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalImageFormatProperties_self(const VkExternalImageFormatProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkExternalMemoryProperties(&val->externalMemoryProperties);
    return size;
}

static inline size_t
vn_sizeof_VkExternalImageFormatProperties(const VkExternalImageFormatProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalImageFormatProperties_pnext(val->pNext);
    size += vn_sizeof_VkExternalImageFormatProperties_self(val);

    return size;
}

static inline void
vn_decode_VkExternalImageFormatProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkExternalImageFormatProperties_self(struct vn_cs_decoder *dec, VkExternalImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExternalMemoryProperties(dec, &val->externalMemoryProperties);
}

static inline void
vn_decode_VkExternalImageFormatProperties(struct vn_cs_decoder *dec, VkExternalImageFormatProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkExternalImageFormatProperties_pnext(dec, val->pNext);
    vn_decode_VkExternalImageFormatProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkExternalImageFormatProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalImageFormatProperties_self_partial(const VkExternalImageFormatProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkExternalMemoryProperties_partial(&val->externalMemoryProperties);
    return size;
}

static inline size_t
vn_sizeof_VkExternalImageFormatProperties_partial(const VkExternalImageFormatProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalImageFormatProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkExternalImageFormatProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkExternalImageFormatProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalImageFormatProperties_self_partial(struct vn_cs_encoder *enc, const VkExternalImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExternalMemoryProperties_partial(enc, &val->externalMemoryProperties);
}

static inline void
vn_encode_VkExternalImageFormatProperties_partial(struct vn_cs_encoder *enc, const VkExternalImageFormatProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES });
    vn_encode_VkExternalImageFormatProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkExternalImageFormatProperties_self_partial(enc, val);
}

/* struct VkSamplerYcbcrConversionImageFormatProperties chain */

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_self(const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_uint32_t(&val->combinedImageSamplerDescriptorCount);
    return size;
}

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties(const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_pnext(val->pNext);
    size += vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_self(val);

    return size;
}

static inline void
vn_decode_VkSamplerYcbcrConversionImageFormatProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkSamplerYcbcrConversionImageFormatProperties_self(struct vn_cs_decoder *dec, VkSamplerYcbcrConversionImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->combinedImageSamplerDescriptorCount);
}

static inline void
vn_decode_VkSamplerYcbcrConversionImageFormatProperties(struct vn_cs_decoder *dec, VkSamplerYcbcrConversionImageFormatProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkSamplerYcbcrConversionImageFormatProperties_pnext(dec, val->pNext);
    vn_decode_VkSamplerYcbcrConversionImageFormatProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_self_partial(const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->combinedImageSamplerDescriptorCount */
    return size;
}

static inline size_t
vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_partial(const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkSamplerYcbcrConversionImageFormatProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSamplerYcbcrConversionImageFormatProperties_self_partial(struct vn_cs_encoder *enc, const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->combinedImageSamplerDescriptorCount */
}

static inline void
vn_encode_VkSamplerYcbcrConversionImageFormatProperties_partial(struct vn_cs_encoder *enc, const VkSamplerYcbcrConversionImageFormatProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES });
    vn_encode_VkSamplerYcbcrConversionImageFormatProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkSamplerYcbcrConversionImageFormatProperties_self_partial(enc, val);
}

/* struct VkImageFormatProperties2 chain */

static inline size_t
vn_sizeof_VkImageFormatProperties2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageFormatProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkExternalImageFormatProperties_self((const VkExternalImageFormatProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageFormatProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_self((const VkSamplerYcbcrConversionImageFormatProperties *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageFormatProperties2_self(const VkImageFormatProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImageFormatProperties(&val->imageFormatProperties);
    return size;
}

static inline size_t
vn_sizeof_VkImageFormatProperties2(const VkImageFormatProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageFormatProperties2_pnext(val->pNext);
    size += vn_sizeof_VkImageFormatProperties2_self(val);

    return size;
}

static inline void
vn_decode_VkImageFormatProperties2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    VkBaseOutStructure *pnext = (VkBaseOutStructure *)val;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return;

    vn_decode_VkStructureType(dec, &stype);
    while (true) {
        assert(pnext);
        if (pnext->sType == stype)
            break;

        pnext = pnext->pNext;
    }

    switch ((int32_t)pnext->sType) {
    case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
        vn_decode_VkImageFormatProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkExternalImageFormatProperties_self(dec, (VkExternalImageFormatProperties *)pnext);
        break;
    case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
        vn_decode_VkImageFormatProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkSamplerYcbcrConversionImageFormatProperties_self(dec, (VkSamplerYcbcrConversionImageFormatProperties *)pnext);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_decode_VkImageFormatProperties2_self(struct vn_cs_decoder *dec, VkImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImageFormatProperties(dec, &val->imageFormatProperties);
}

static inline void
vn_decode_VkImageFormatProperties2(struct vn_cs_decoder *dec, VkImageFormatProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2);

    assert(val->sType == stype);
    vn_decode_VkImageFormatProperties2_pnext(dec, val->pNext);
    vn_decode_VkImageFormatProperties2_self(dec, val);
}

static inline size_t
vn_sizeof_VkImageFormatProperties2_pnext_partial(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageFormatProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkExternalImageFormatProperties_self_partial((const VkExternalImageFormatProperties *)pnext);
            return size;
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkImageFormatProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkSamplerYcbcrConversionImageFormatProperties_self_partial((const VkSamplerYcbcrConversionImageFormatProperties *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkImageFormatProperties2_self_partial(const VkImageFormatProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkImageFormatProperties_partial(&val->imageFormatProperties);
    return size;
}

static inline size_t
vn_sizeof_VkImageFormatProperties2_partial(const VkImageFormatProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkImageFormatProperties2_pnext_partial(val->pNext);
    size += vn_sizeof_VkImageFormatProperties2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkImageFormatProperties2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageFormatProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkExternalImageFormatProperties_self_partial(enc, (const VkExternalImageFormatProperties *)pnext);
            return;
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkImageFormatProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkSamplerYcbcrConversionImageFormatProperties_self_partial(enc, (const VkSamplerYcbcrConversionImageFormatProperties *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageFormatProperties2_self_partial(struct vn_cs_encoder *enc, const VkImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkImageFormatProperties_partial(enc, &val->imageFormatProperties);
}

static inline void
vn_encode_VkImageFormatProperties2_partial(struct vn_cs_encoder *enc, const VkImageFormatProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2 });
    vn_encode_VkImageFormatProperties2_pnext_partial(enc, val->pNext);
    vn_encode_VkImageFormatProperties2_self_partial(enc, val);
}

/* struct VkQueueFamilyProperties2 chain */

static inline size_t
vn_sizeof_VkQueueFamilyProperties2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkQueueFamilyProperties2_self(const VkQueueFamilyProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkQueueFamilyProperties(&val->queueFamilyProperties);
    return size;
}

static inline size_t
vn_sizeof_VkQueueFamilyProperties2(const VkQueueFamilyProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkQueueFamilyProperties2_pnext(val->pNext);
    size += vn_sizeof_VkQueueFamilyProperties2_self(val);

    return size;
}

static inline void
vn_decode_VkQueueFamilyProperties2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkQueueFamilyProperties2_self(struct vn_cs_decoder *dec, VkQueueFamilyProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkQueueFamilyProperties(dec, &val->queueFamilyProperties);
}

static inline void
vn_decode_VkQueueFamilyProperties2(struct vn_cs_decoder *dec, VkQueueFamilyProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2);

    assert(val->sType == stype);
    vn_decode_VkQueueFamilyProperties2_pnext(dec, val->pNext);
    vn_decode_VkQueueFamilyProperties2_self(dec, val);
}

static inline size_t
vn_sizeof_VkQueueFamilyProperties2_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkQueueFamilyProperties2_self_partial(const VkQueueFamilyProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkQueueFamilyProperties_partial(&val->queueFamilyProperties);
    return size;
}

static inline size_t
vn_sizeof_VkQueueFamilyProperties2_partial(const VkQueueFamilyProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkQueueFamilyProperties2_pnext_partial(val->pNext);
    size += vn_sizeof_VkQueueFamilyProperties2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkQueueFamilyProperties2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkQueueFamilyProperties2_self_partial(struct vn_cs_encoder *enc, const VkQueueFamilyProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkQueueFamilyProperties_partial(enc, &val->queueFamilyProperties);
}

static inline void
vn_encode_VkQueueFamilyProperties2_partial(struct vn_cs_encoder *enc, const VkQueueFamilyProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2 });
    vn_encode_VkQueueFamilyProperties2_pnext_partial(enc, val->pNext);
    vn_encode_VkQueueFamilyProperties2_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMemoryBudgetPropertiesEXT chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryBudgetPropertiesEXT_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self(const VkPhysicalDeviceMemoryBudgetPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_array_size(VK_MAX_MEMORY_HEAPS);
    size += vn_sizeof_VkDeviceSize_array(val->heapBudget, VK_MAX_MEMORY_HEAPS);
    size += vn_sizeof_array_size(VK_MAX_MEMORY_HEAPS);
    size += vn_sizeof_VkDeviceSize_array(val->heapUsage, VK_MAX_MEMORY_HEAPS);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryBudgetPropertiesEXT(const VkPhysicalDeviceMemoryBudgetPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMemoryBudgetPropertiesEXT_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryBudgetPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_MEMORY_HEAPS);
        vn_decode_VkDeviceSize_array(dec, val->heapBudget, array_size);
    }
    {
        const size_t array_size = vn_decode_array_size(dec, VK_MAX_MEMORY_HEAPS);
        vn_decode_VkDeviceSize_array(dec, val->heapUsage, array_size);
    }
}

static inline void
vn_decode_VkPhysicalDeviceMemoryBudgetPropertiesEXT(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryBudgetPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryBudgetPropertiesEXT_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self_partial(const VkPhysicalDeviceMemoryBudgetPropertiesEXT *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->heapBudget */
    /* skip val->heapUsage */
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryBudgetPropertiesEXT_partial(const VkPhysicalDeviceMemoryBudgetPropertiesEXT *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMemoryBudgetPropertiesEXT_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryBudgetPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->heapBudget */
    /* skip val->heapUsage */
}

static inline void
vn_encode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryBudgetPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT });
    vn_encode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self_partial(enc, val);
}

/* struct VkPhysicalDeviceMemoryProperties2 chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties2_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(238 /* VK_EXT_memory_budget */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceMemoryProperties2_pnext(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self((const VkPhysicalDeviceMemoryBudgetPropertiesEXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties2_self(const VkPhysicalDeviceMemoryProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPhysicalDeviceMemoryProperties(&val->memoryProperties);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties2(const VkPhysicalDeviceMemoryProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMemoryProperties2_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMemoryProperties2_self(val);

    return size;
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    VkBaseOutStructure *pnext = (VkBaseOutStructure *)val;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return;

    vn_decode_VkStructureType(dec, &stype);
    while (true) {
        assert(pnext);
        if (pnext->sType == stype)
            break;

        pnext = pnext->pNext;
    }

    switch ((int32_t)pnext->sType) {
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
        vn_decode_VkPhysicalDeviceMemoryProperties2_pnext(dec, pnext->pNext);
        vn_decode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self(dec, (VkPhysicalDeviceMemoryBudgetPropertiesEXT *)pnext);
        break;
    default:
        assert(false);
        break;
    }
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties2_self(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkPhysicalDeviceMemoryProperties(dec, &val->memoryProperties);
}

static inline void
vn_decode_VkPhysicalDeviceMemoryProperties2(struct vn_cs_decoder *dec, VkPhysicalDeviceMemoryProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2);

    assert(val->sType == stype);
    vn_decode_VkPhysicalDeviceMemoryProperties2_pnext(dec, val->pNext);
    vn_decode_VkPhysicalDeviceMemoryProperties2_self(dec, val);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties2_pnext_partial(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(238 /* VK_EXT_memory_budget */))
                break;
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceMemoryProperties2_pnext_partial(pnext->pNext);
            size += vn_sizeof_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self_partial((const VkPhysicalDeviceMemoryBudgetPropertiesEXT *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties2_self_partial(const VkPhysicalDeviceMemoryProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkPhysicalDeviceMemoryProperties_partial(&val->memoryProperties);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceMemoryProperties2_partial(const VkPhysicalDeviceMemoryProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceMemoryProperties2_pnext_partial(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceMemoryProperties2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT:
            if (!vn_cs_renderer_protocol_has_extension(238 /* VK_EXT_memory_budget */))
                break;
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceMemoryProperties2_pnext_partial(enc, pnext->pNext);
            vn_encode_VkPhysicalDeviceMemoryBudgetPropertiesEXT_self_partial(enc, (const VkPhysicalDeviceMemoryBudgetPropertiesEXT *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties2_self_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkPhysicalDeviceMemoryProperties_partial(enc, &val->memoryProperties);
}

static inline void
vn_encode_VkPhysicalDeviceMemoryProperties2_partial(struct vn_cs_encoder *enc, const VkPhysicalDeviceMemoryProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2 });
    vn_encode_VkPhysicalDeviceMemoryProperties2_pnext_partial(enc, val->pNext);
    vn_encode_VkPhysicalDeviceMemoryProperties2_self_partial(enc, val);
}

/* struct VkPhysicalDeviceSparseImageFormatInfo2 chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceSparseImageFormatInfo2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSparseImageFormatInfo2_self(const VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFormat(&val->format);
    size += vn_sizeof_VkImageType(&val->type);
    size += vn_sizeof_VkSampleCountFlagBits(&val->samples);
    size += vn_sizeof_VkFlags(&val->usage);
    size += vn_sizeof_VkImageTiling(&val->tiling);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceSparseImageFormatInfo2(const VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceSparseImageFormatInfo2_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceSparseImageFormatInfo2_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceSparseImageFormatInfo2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceSparseImageFormatInfo2_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFormat(enc, &val->format);
    vn_encode_VkImageType(enc, &val->type);
    vn_encode_VkSampleCountFlagBits(enc, &val->samples);
    vn_encode_VkFlags(enc, &val->usage);
    vn_encode_VkImageTiling(enc, &val->tiling);
}

static inline void
vn_encode_VkPhysicalDeviceSparseImageFormatInfo2(struct vn_cs_encoder *enc, const VkPhysicalDeviceSparseImageFormatInfo2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2 });
    vn_encode_VkPhysicalDeviceSparseImageFormatInfo2_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceSparseImageFormatInfo2_self(enc, val);
}

/* struct VkSparseImageFormatProperties2 chain */

static inline size_t
vn_sizeof_VkSparseImageFormatProperties2_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSparseImageFormatProperties2_self(const VkSparseImageFormatProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkSparseImageFormatProperties(&val->properties);
    return size;
}

static inline size_t
vn_sizeof_VkSparseImageFormatProperties2(const VkSparseImageFormatProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSparseImageFormatProperties2_pnext(val->pNext);
    size += vn_sizeof_VkSparseImageFormatProperties2_self(val);

    return size;
}

static inline void
vn_decode_VkSparseImageFormatProperties2_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkSparseImageFormatProperties2_self(struct vn_cs_decoder *dec, VkSparseImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkSparseImageFormatProperties(dec, &val->properties);
}

static inline void
vn_decode_VkSparseImageFormatProperties2(struct vn_cs_decoder *dec, VkSparseImageFormatProperties2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2);

    assert(val->sType == stype);
    vn_decode_VkSparseImageFormatProperties2_pnext(dec, val->pNext);
    vn_decode_VkSparseImageFormatProperties2_self(dec, val);
}

static inline size_t
vn_sizeof_VkSparseImageFormatProperties2_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkSparseImageFormatProperties2_self_partial(const VkSparseImageFormatProperties2 *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkSparseImageFormatProperties_partial(&val->properties);
    return size;
}

static inline size_t
vn_sizeof_VkSparseImageFormatProperties2_partial(const VkSparseImageFormatProperties2 *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkSparseImageFormatProperties2_pnext_partial(val->pNext);
    size += vn_sizeof_VkSparseImageFormatProperties2_self_partial(val);

    return size;
}

static inline void
vn_encode_VkSparseImageFormatProperties2_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSparseImageFormatProperties2_self_partial(struct vn_cs_encoder *enc, const VkSparseImageFormatProperties2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkSparseImageFormatProperties_partial(enc, &val->properties);
}

static inline void
vn_encode_VkSparseImageFormatProperties2_partial(struct vn_cs_encoder *enc, const VkSparseImageFormatProperties2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2 });
    vn_encode_VkSparseImageFormatProperties2_pnext_partial(enc, val->pNext);
    vn_encode_VkSparseImageFormatProperties2_self_partial(enc, val);
}

/* struct VkPhysicalDeviceExternalBufferInfo chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalBufferInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalBufferInfo_self(const VkPhysicalDeviceExternalBufferInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->flags);
    size += vn_sizeof_VkFlags(&val->usage);
    size += vn_sizeof_VkExternalMemoryHandleTypeFlagBits(&val->handleType);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalBufferInfo(const VkPhysicalDeviceExternalBufferInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExternalBufferInfo_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExternalBufferInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExternalBufferInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExternalBufferInfo_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalBufferInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkFlags(enc, &val->flags);
    vn_encode_VkFlags(enc, &val->usage);
    vn_encode_VkExternalMemoryHandleTypeFlagBits(enc, &val->handleType);
}

static inline void
vn_encode_VkPhysicalDeviceExternalBufferInfo(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalBufferInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO });
    vn_encode_VkPhysicalDeviceExternalBufferInfo_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExternalBufferInfo_self(enc, val);
}

/* struct VkExternalBufferProperties chain */

static inline size_t
vn_sizeof_VkExternalBufferProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalBufferProperties_self(const VkExternalBufferProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkExternalMemoryProperties(&val->externalMemoryProperties);
    return size;
}

static inline size_t
vn_sizeof_VkExternalBufferProperties(const VkExternalBufferProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalBufferProperties_pnext(val->pNext);
    size += vn_sizeof_VkExternalBufferProperties_self(val);

    return size;
}

static inline void
vn_decode_VkExternalBufferProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkExternalBufferProperties_self(struct vn_cs_decoder *dec, VkExternalBufferProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkExternalMemoryProperties(dec, &val->externalMemoryProperties);
}

static inline void
vn_decode_VkExternalBufferProperties(struct vn_cs_decoder *dec, VkExternalBufferProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkExternalBufferProperties_pnext(dec, val->pNext);
    vn_decode_VkExternalBufferProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkExternalBufferProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalBufferProperties_self_partial(const VkExternalBufferProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkExternalMemoryProperties_partial(&val->externalMemoryProperties);
    return size;
}

static inline size_t
vn_sizeof_VkExternalBufferProperties_partial(const VkExternalBufferProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalBufferProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkExternalBufferProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkExternalBufferProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalBufferProperties_self_partial(struct vn_cs_encoder *enc, const VkExternalBufferProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExternalMemoryProperties_partial(enc, &val->externalMemoryProperties);
}

static inline void
vn_encode_VkExternalBufferProperties_partial(struct vn_cs_encoder *enc, const VkExternalBufferProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES });
    vn_encode_VkExternalBufferProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkExternalBufferProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceExternalSemaphoreInfo chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalSemaphoreInfo_pnext(const void *val)
{
    const VkBaseInStructure *pnext = val;
    size_t size = 0;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
            size += vn_sizeof_simple_pointer(pnext);
            size += vn_sizeof_VkStructureType(&pnext->sType);
            size += vn_sizeof_VkPhysicalDeviceExternalSemaphoreInfo_pnext(pnext->pNext);
            size += vn_sizeof_VkSemaphoreTypeCreateInfo_self((const VkSemaphoreTypeCreateInfo *)pnext);
            return size;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalSemaphoreInfo_self(const VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkExternalSemaphoreHandleTypeFlagBits(&val->handleType);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalSemaphoreInfo(const VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExternalSemaphoreInfo_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExternalSemaphoreInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExternalSemaphoreInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    const VkBaseInStructure *pnext = val;

    while (pnext) {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO:
            vn_encode_simple_pointer(enc, pnext);
            vn_encode_VkStructureType(enc, &pnext->sType);
            vn_encode_VkPhysicalDeviceExternalSemaphoreInfo_pnext(enc, pnext->pNext);
            vn_encode_VkSemaphoreTypeCreateInfo_self(enc, (const VkSemaphoreTypeCreateInfo *)pnext);
            return;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    }

    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExternalSemaphoreInfo_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExternalSemaphoreHandleTypeFlagBits(enc, &val->handleType);
}

static inline void
vn_encode_VkPhysicalDeviceExternalSemaphoreInfo(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalSemaphoreInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO });
    vn_encode_VkPhysicalDeviceExternalSemaphoreInfo_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExternalSemaphoreInfo_self(enc, val);
}

/* struct VkExternalSemaphoreProperties chain */

static inline size_t
vn_sizeof_VkExternalSemaphoreProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalSemaphoreProperties_self(const VkExternalSemaphoreProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->exportFromImportedHandleTypes);
    size += vn_sizeof_VkFlags(&val->compatibleHandleTypes);
    size += vn_sizeof_VkFlags(&val->externalSemaphoreFeatures);
    return size;
}

static inline size_t
vn_sizeof_VkExternalSemaphoreProperties(const VkExternalSemaphoreProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalSemaphoreProperties_pnext(val->pNext);
    size += vn_sizeof_VkExternalSemaphoreProperties_self(val);

    return size;
}

static inline void
vn_decode_VkExternalSemaphoreProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkExternalSemaphoreProperties_self(struct vn_cs_decoder *dec, VkExternalSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->exportFromImportedHandleTypes);
    vn_decode_VkFlags(dec, &val->compatibleHandleTypes);
    vn_decode_VkFlags(dec, &val->externalSemaphoreFeatures);
}

static inline void
vn_decode_VkExternalSemaphoreProperties(struct vn_cs_decoder *dec, VkExternalSemaphoreProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkExternalSemaphoreProperties_pnext(dec, val->pNext);
    vn_decode_VkExternalSemaphoreProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkExternalSemaphoreProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalSemaphoreProperties_self_partial(const VkExternalSemaphoreProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
    /* skip val->externalSemaphoreFeatures */
    return size;
}

static inline size_t
vn_sizeof_VkExternalSemaphoreProperties_partial(const VkExternalSemaphoreProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalSemaphoreProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkExternalSemaphoreProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkExternalSemaphoreProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalSemaphoreProperties_self_partial(struct vn_cs_encoder *enc, const VkExternalSemaphoreProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
    /* skip val->externalSemaphoreFeatures */
}

static inline void
vn_encode_VkExternalSemaphoreProperties_partial(struct vn_cs_encoder *enc, const VkExternalSemaphoreProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES });
    vn_encode_VkExternalSemaphoreProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkExternalSemaphoreProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceExternalFenceInfo chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalFenceInfo_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalFenceInfo_self(const VkPhysicalDeviceExternalFenceInfo *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkExternalFenceHandleTypeFlagBits(&val->handleType);
    return size;
}

static inline size_t
vn_sizeof_VkPhysicalDeviceExternalFenceInfo(const VkPhysicalDeviceExternalFenceInfo *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkPhysicalDeviceExternalFenceInfo_pnext(val->pNext);
    size += vn_sizeof_VkPhysicalDeviceExternalFenceInfo_self(val);

    return size;
}

static inline void
vn_encode_VkPhysicalDeviceExternalFenceInfo_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkPhysicalDeviceExternalFenceInfo_self(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalFenceInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkExternalFenceHandleTypeFlagBits(enc, &val->handleType);
}

static inline void
vn_encode_VkPhysicalDeviceExternalFenceInfo(struct vn_cs_encoder *enc, const VkPhysicalDeviceExternalFenceInfo *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO });
    vn_encode_VkPhysicalDeviceExternalFenceInfo_pnext(enc, val->pNext);
    vn_encode_VkPhysicalDeviceExternalFenceInfo_self(enc, val);
}

/* struct VkExternalFenceProperties chain */

static inline size_t
vn_sizeof_VkExternalFenceProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalFenceProperties_self(const VkExternalFenceProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    size += vn_sizeof_VkFlags(&val->exportFromImportedHandleTypes);
    size += vn_sizeof_VkFlags(&val->compatibleHandleTypes);
    size += vn_sizeof_VkFlags(&val->externalFenceFeatures);
    return size;
}

static inline size_t
vn_sizeof_VkExternalFenceProperties(const VkExternalFenceProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalFenceProperties_pnext(val->pNext);
    size += vn_sizeof_VkExternalFenceProperties_self(val);

    return size;
}

static inline void
vn_decode_VkExternalFenceProperties_pnext(struct vn_cs_decoder *dec, const void *val)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        assert(false);
}

static inline void
vn_decode_VkExternalFenceProperties_self(struct vn_cs_decoder *dec, VkExternalFenceProperties *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->exportFromImportedHandleTypes);
    vn_decode_VkFlags(dec, &val->compatibleHandleTypes);
    vn_decode_VkFlags(dec, &val->externalFenceFeatures);
}

static inline void
vn_decode_VkExternalFenceProperties(struct vn_cs_decoder *dec, VkExternalFenceProperties *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    assert(stype == VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES);

    assert(val->sType == stype);
    vn_decode_VkExternalFenceProperties_pnext(dec, val->pNext);
    vn_decode_VkExternalFenceProperties_self(dec, val);
}

static inline size_t
vn_sizeof_VkExternalFenceProperties_pnext_partial(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkExternalFenceProperties_self_partial(const VkExternalFenceProperties *val)
{
    size_t size = 0;
    /* skip val->{sType,pNext} */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
    /* skip val->externalFenceFeatures */
    return size;
}

static inline size_t
vn_sizeof_VkExternalFenceProperties_partial(const VkExternalFenceProperties *val)
{
    size_t size = 0;

    size += vn_sizeof_VkStructureType(&val->sType);
    size += vn_sizeof_VkExternalFenceProperties_pnext_partial(val->pNext);
    size += vn_sizeof_VkExternalFenceProperties_self_partial(val);

    return size;
}

static inline void
vn_encode_VkExternalFenceProperties_pnext_partial(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkExternalFenceProperties_self_partial(struct vn_cs_encoder *enc, const VkExternalFenceProperties *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->exportFromImportedHandleTypes */
    /* skip val->compatibleHandleTypes */
    /* skip val->externalFenceFeatures */
}

static inline void
vn_encode_VkExternalFenceProperties_partial(struct vn_cs_encoder *enc, const VkExternalFenceProperties *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES });
    vn_encode_VkExternalFenceProperties_pnext_partial(enc, val->pNext);
    vn_encode_VkExternalFenceProperties_self_partial(enc, val);
}

/* struct VkPhysicalDeviceGroupProperties chain */

static inline size_t
vn_sizeof_VkPhysicalDeviceGroupProperties_pnext(const void *val)
{
    /* no known/supported struct */
    return vn_sizeof_simple_pointer(NULL);
}

static inline size_t
vn_sizeof_VkPhysicalDeviceGroupProperties_self(const VkPhysicalDeviceGroupProperties *val)
{
    size_t size = 0;
    /* skip val->{s