/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pull;

import net.sf.saxon.Configuration;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.instruct.ParentNodeConstructor;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.pull.TreeWalker;
import net.sf.saxon.pull.VirtualTreeWalker;
import net.sf.saxon.tinytree.TinyBuilder;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Value;

public abstract class UnconstructedParent
implements NodeInfo {
    protected ParentNodeConstructor instruction;
    protected XPathContextMajor savedXPathContext;
    protected NodeInfo node = null;

    protected UnconstructedParent(ParentNodeConstructor instruction, XPathContext context) {
        SequenceIterator currentIterator;
        StackFrame localStackFrame;
        ValueRepresentation[] local;
        this.instruction = instruction;
        this.savedXPathContext = context.newContext();
        this.savedXPathContext.setOriginatingConstructType(2063);
        if ((instruction.getDependencies() & 0x80) != 0 && (local = (localStackFrame = context.getStackFrame()).getStackFrameValues()) != null) {
            ValueRepresentation[] savedStackFrame = new ValueRepresentation[local.length];
            System.arraycopy(local, 0, savedStackFrame, 0, local.length);
            this.savedXPathContext.setStackFrame(localStackFrame.getStackFrameMap(), savedStackFrame);
        }
        if ((currentIterator = context.getCurrentIterator()) != null) {
            Item contextItem = currentIterator.current();
            UnfailingIterator single = SingletonIterator.makeIterator(contextItem);
            single.next();
            this.savedXPathContext.setCurrentIterator(single);
        }
        this.savedXPathContext.setReceiver(new SequenceOutputter());
    }

    public XPathContext getXPathContext() {
        return this.savedXPathContext;
    }

    public ParentNodeConstructor getInstruction() {
        return this.instruction;
    }

    public PullProvider getPuller() {
        if (this.node == null) {
            VirtualTreeWalker walker = new VirtualTreeWalker(this.instruction, this.savedXPathContext);
            walker.setPipelineConfiguration(this.savedXPathContext.getController().makePipelineConfiguration());
            walker.setNameCode(this.getNameCode());
            return walker;
        }
        return TreeWalker.makeTreeWalker(this.node);
    }

    void construct() throws XPathException {
        PipelineConfiguration pipe = this.savedXPathContext.getController().makePipelineConfiguration();
        PullProvider puller = this.getPuller();
        puller.setPipelineConfiguration(pipe);
        TinyBuilder builder = new TinyBuilder();
        builder.setPipelineConfiguration(pipe);
        builder.setSystemId(pipe.getLocationProvider().getSystemId(this.instruction.getLocationId()));
        builder.setBaseURI(pipe.getLocationProvider().getSystemId(this.instruction.getLocationId()));
        NamespaceReducer reducer = new NamespaceReducer();
        reducer.setUnderlyingReceiver(builder);
        reducer.setPipelineConfiguration(pipe);
        ComplexContentOutputter outputter = new ComplexContentOutputter();
        outputter.setReceiver(reducer);
        outputter.setPipelineConfiguration(pipe);
        new PullPushCopier(puller, outputter).copy();
        this.node = builder.getCurrentRoot();
    }

    void tryToConstruct() {
        try {
            this.construct();
        }
        catch (XPathException err) {
            throw new UncheckedXPathException(err);
        }
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        return this == other || !(other instanceof UnconstructedParent) && this.node != null && this.node.isSameNodeInfo(other);
    }

    public boolean equals(Object other) {
        return other instanceof NodeInfo && this.isSameNodeInfo((NodeInfo)other);
    }

    public int hashCode() {
        if (this.node != null) {
            return ((Object)this.node).hashCode();
        }
        return super.hashCode();
    }

    public String getSystemId() {
        return null;
    }

    public String getBaseURI() {
        if (this.node == null) {
            PipelineConfiguration pipe = this.savedXPathContext.getController().makePipelineConfiguration();
            return pipe.getLocationProvider().getSystemId(this.instruction.getLocationId());
        }
        return this.node.getBaseURI();
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo other) {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.compareOrder(other);
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public int getFingerprint() {
        int nc = this.getNameCode();
        if (nc == -1) {
            return -1;
        }
        return nc & 0xFFFFF;
    }

    public String getLocalPart() {
        return this.getNamePool().getLocalName(this.getNameCode());
    }

    public String getURI() {
        return this.getNamePool().getURI(this.getNameCode());
    }

    public String getDisplayName() {
        return this.getNamePool().getDisplayName(this.getNameCode());
    }

    public String getPrefix() {
        return this.getNamePool().getPrefix(this.getNameCode());
    }

    public Configuration getConfiguration() {
        return this.savedXPathContext.getConfiguration();
    }

    public NamePool getNamePool() {
        return this.getConfiguration().getNamePool();
    }

    public int getTypeAnnotation() {
        return 630;
    }

    public NodeInfo getParent() {
        return null;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.iterateAxis(axisNumber);
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.iterateAxis(axisNumber, nodeTest);
    }

    public String getAttributeValue(int fingerprint) {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.getAttributeValue(fingerprint);
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return null;
    }

    public boolean hasChildNodes() {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.hasChildNodes();
    }

    public void generateId(FastStringBuffer buffer) {
        if (this.node == null) {
            this.tryToConstruct();
        }
        this.node.generateId(buffer);
    }

    public int getDocumentNumber() {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.getDocumentNumber();
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        if (this.node == null) {
            if (whichNamespaces == 2 && copyAnnotations) {
                VirtualTreeWalker pull = new VirtualTreeWalker(this.instruction, this.savedXPathContext);
                pull.setPipelineConfiguration(out.getPipelineConfiguration());
                PullPushCopier copier = new PullPushCopier(pull, out);
                copier.append();
                return;
            }
            this.construct();
        }
        this.node.copy(out, whichNamespaces, copyAnnotations, locationId);
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        if (this.node == null) {
            this.tryToConstruct();
        }
        return this.node.getDeclaredNamespaces(buffer);
    }

    public void setSystemId(String systemId) {
    }

    public CharSequence getStringValueCS() {
        if (this.node == null) {
            try {
                PullProvider puller = this.getPuller();
                puller.next();
                return puller.getStringValue();
            }
            catch (XPathException e) {
                throw new UncheckedXPathException(e);
            }
        }
        return this.node.getStringValueCS();
    }

    public SequenceIterator getTypedValue() throws XPathException {
        if (this.node == null) {
            this.construct();
        }
        return this.node.getTypedValue();
    }

    public Value atomize() throws XPathException {
        if (this.node == null) {
            this.construct();
        }
        return this.node.atomize();
    }
}

