//////////////////////////////////////////////////////////////////////////////
// Name:        SVGRadialGradientElement.h
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by generate.py
//////////////////////////////////////////////////////////////////////////////

#ifndef WX_SVG_RADIAL_GRADIENT_ELEMENT_H
#define WX_SVG_RADIAL_GRADIENT_ELEMENT_H

#include "SVGGradientElement.h"
#include "SVGAnimatedLength.h"
#include "SVGSVGElement.h"
#include "String_wxsvg.h"
#include "Element.h"

class wxSVGRadialGradientElement:
  public wxSVGGradientElement
{
  protected:
    wxSVGAnimatedLength m_cx;
    wxSVGAnimatedLength m_cy;
    wxSVGAnimatedLength m_r;
    wxSVGAnimatedLength m_fx;
    wxSVGAnimatedLength m_fy;

  public:
    inline const wxSVGAnimatedLength& GetCx() const { WX_SVG_ANIM_LENGTH_CALC_WIDTH(m_cx, GetViewportElement()); return m_cx; }
    inline void SetCx(const wxSVGAnimatedLength& n) { m_cx = n; }
    inline void SetCx(const wxSVGLength& n) { m_cx.SetBaseVal(n); }

    inline const wxSVGAnimatedLength& GetCy() const { WX_SVG_ANIM_LENGTH_CALC_HEIGHT(m_cy, GetViewportElement()); return m_cy; }
    inline void SetCy(const wxSVGAnimatedLength& n) { m_cy = n; }
    inline void SetCy(const wxSVGLength& n) { m_cy.SetBaseVal(n); }

    inline const wxSVGAnimatedLength& GetR() const { WX_SVG_ANIM_LENGTH_CALC_SIZE(m_r, GetViewportElement()); return m_r; }
    inline void SetR(const wxSVGAnimatedLength& n) { m_r = n; }
    inline void SetR(const wxSVGLength& n) { m_r.SetBaseVal(n); }

    inline const wxSVGAnimatedLength& GetFx() const { WX_SVG_ANIM_LENGTH_CALC_WIDTH(m_fx, GetViewportElement()); return m_fx; }
    inline void SetFx(const wxSVGAnimatedLength& n) { m_fx = n; }
    inline void SetFx(const wxSVGLength& n) { m_fx.SetBaseVal(n); }

    inline const wxSVGAnimatedLength& GetFy() const { WX_SVG_ANIM_LENGTH_CALC_HEIGHT(m_fy, GetViewportElement()); return m_fy; }
    inline void SetFy(const wxSVGAnimatedLength& n) { m_fy = n; }
    inline void SetFy(const wxSVGLength& n) { m_fy.SetBaseVal(n); }

  public:
    wxSVGRadialGradientElement(wxString tagName = wxT("radialGradient")):
      wxSVGGradientElement(tagName) {}
    virtual ~wxSVGRadialGradientElement() {}
    wxSvgXmlNode* CloneNode(bool deep = true) { return new wxSVGRadialGradientElement(*this); }

    double GetQualifiedR() const;
    double GetQualifiedCx() const;
    double GetQualifiedCy() const;
    double GetQualifiedFx() const;
    double GetQualifiedFy() const;

    bool HasAttribute(const wxString& name);
    wxString GetAttribute(const wxString& name);
    bool SetAttribute(const wxString& name, const wxString& value);
    wxSvgXmlAttrHash GetAttributes() const;
    virtual wxSVGDTD GetDtd() const { return wxSVG_RADIALGRADIENT_ELEMENT; }
};

#endif // WX_SVG_RADIAL_GRADIENT_ELEMENT_H
