// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SLI_4S_2OPIMM_TRACE_AARCH64_H_
#define VIXL_SIM_SLI_4S_2OPIMM_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_sli_4S_2OPIMM[] = {
  0xfffffffd, 0xfffffffe, 0xffffffff, 0x00000000,
  0xfffffffb, 0xfffffffc, 0xffffffff, 0x00000000,
  0xfffffff7, 0xfffffff8, 0xffffffff, 0x00000000,
  0xffffffef, 0xfffffff0, 0xffffffff, 0x00000000,
  0xffffffdf, 0xffffffe0, 0xffffffff, 0x00000000,
  0xffffffbf, 0xffffffc0, 0xffffffff, 0x00000000,
  0xffffff7f, 0xffffff80, 0xffffffff, 0x00000000,
  0xfffffeff, 0xffffff00, 0xffffffff, 0x00000000,
  0xfffffdff, 0xfffffe00, 0xffffffff, 0x00000000,
  0xfffffbff, 0xfffffc00, 0xffffffff, 0x00000000,
  0xfffff7ff, 0xfffff800, 0xffffffff, 0x00000000,
  0xffffefff, 0xfffff000, 0xffffffff, 0x00000000,
  0xffffdfff, 0xffffe000, 0xffffffff, 0x00000000,
  0xffffbfff, 0xffffc000, 0xffffffff, 0x00000000,
  0xffff7fff, 0xffff8000, 0xffffffff, 0x00000000,
  0xfffeffff, 0xffff0000, 0xffffffff, 0x00000000,
  0xfffdffff, 0xfffe0000, 0xffffffff, 0x00000000,
  0xfffbffff, 0xfffc0000, 0xffffffff, 0x00000000,
  0xfff7ffff, 0xfff80000, 0xffffffff, 0x00000000,
  0xffefffff, 0xfff00000, 0xffffffff, 0x00000000,
  0xffdfffff, 0xffe00000, 0xffffffff, 0x00000000,
  0xffbfffff, 0xffc00000, 0xffffffff, 0x00000000,
  0xff7fffff, 0xff800000, 0xffffffff, 0x00000000,
  0xfeffffff, 0xff000000, 0xffffffff, 0x00000000,
  0xfdffffff, 0xfe000000, 0xffffffff, 0x00000000,
  0xfbffffff, 0xfc000000, 0xffffffff, 0x00000000,
  0xf7ffffff, 0xf8000000, 0xffffffff, 0x00000000,
  0xefffffff, 0xf0000000, 0xffffffff, 0x00000000,
  0xdfffffff, 0xe0000000, 0xffffffff, 0x00000000,
  0xbfffffff, 0xc0000000, 0xffffffff, 0x00000000,
  0x7fffffff, 0x80000000, 0xffffffff, 0x00000000,
  0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
  0xfffffffe, 0xffffffff, 0x00000000, 0x00000001,
  0xfffffffc, 0xffffffff, 0x00000000, 0x00000003,
  0xfffffff8, 0xffffffff, 0x00000000, 0x00000007,
  0xfffffff0, 0xffffffff, 0x00000000, 0x0000000f,
  0xffffffe0, 0xffffffff, 0x00000000, 0x0000001f,
  0xffffffc0, 0xffffffff, 0x00000000, 0x0000003f,
  0xffffff80, 0xffffffff, 0x00000000, 0x0000007f,
  0xffffff00, 0xffffffff, 0x00000000, 0x000000ff,
  0xfffffe00, 0xffffffff, 0x00000000, 0x000001ff,
  0xfffffc00, 0xffffffff, 0x00000000, 0x000003ff,
  0xfffff800, 0xffffffff, 0x00000000, 0x000007ff,
  0xfffff000, 0xffffffff, 0x00000000, 0x00000fff,
  0xffffe000, 0xffffffff, 0x00000000, 0x00001fff,
  0xffffc000, 0xffffffff, 0x00000000, 0x00003fff,
  0xffff8000, 0xffffffff, 0x00000000, 0x00007fff,
  0xffff0000, 0xffffffff, 0x00000000, 0x0000ffff,
  0xfffe0000, 0xffffffff, 0x00000000, 0x0001ffff,
  0xfffc0000, 0xffffffff, 0x00000000, 0x0003ffff,
  0xfff80000, 0xffffffff, 0x00000000, 0x0007ffff,
  0xfff00000, 0xffffffff, 0x00000000, 0x000fffff,
  0xffe00000, 0xffffffff, 0x00000000, 0x001fffff,
  0xffc00000, 0xffffffff, 0x00000000, 0x003fffff,
  0xff800000, 0xffffffff, 0x00000000, 0x007fffff,
  0xff000000, 0xffffffff, 0x00000000, 0x00ffffff,
  0xfe000000, 0xffffffff, 0x00000000, 0x01ffffff,
  0xfc000000, 0xffffffff, 0x00000000, 0x03ffffff,
  0xf8000000, 0xffffffff, 0x00000000, 0x07ffffff,
  0xf0000000, 0xffffffff, 0x00000000, 0x0fffffff,
  0xe0000000, 0xffffffff, 0x00000000, 0x1fffffff,
  0xc0000000, 0xffffffff, 0x00000000, 0x3fffffff,
  0x80000000, 0xffffffff, 0x00000000, 0x7fffffff,
  0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
  0xffffffff, 0x00000000, 0x00000001, 0x00000002,
  0xffffffff, 0x00000000, 0x00000003, 0x00000004,
  0xffffffff, 0x00000000, 0x00000007, 0x00000008,
  0xffffffff, 0x00000000, 0x0000000f, 0x00000010,
  0xffffffff, 0x00000000, 0x0000001f, 0x00000020,
  0xffffffff, 0x00000000, 0x0000003f, 0x00000040,
  0xffffffff, 0x00000000, 0x0000007f, 0x00000080,
  0xffffffff, 0x00000000, 0x000000ff, 0x00000100,
  0xffffffff, 0x00000000, 0x000001ff, 0x00000200,
  0xffffffff, 0x00000000, 0x000003ff, 0x00000400,
  0xffffffff, 0x00000000, 0x000007ff, 0x00000800,
  0xffffffff, 0x00000000, 0x00000fff, 0x00001000,
  0xffffffff, 0x00000000, 0x00001fff, 0x00002000,
  0xffffffff, 0x00000000, 0x00003fff, 0x00004000,
  0xffffffff, 0x00000000, 0x00007fff, 0x00008000,
  0xffffffff, 0x00000000, 0x0000ffff, 0x00010000,
  0xffffffff, 0x00000000, 0x0001ffff, 0x00020000,
  0xffffffff, 0x00000000, 0x0003ffff, 0x00040000,
  0xffffffff, 0x00000000, 0x0007ffff, 0x00080000,
  0xffffffff, 0x00000000, 0x000fffff, 0x00100000,
  0xffffffff, 0x00000000, 0x001fffff, 0x00200000,
  0xffffffff, 0x00000000, 0x003fffff, 0x00400000,
  0xffffffff, 0x00000000, 0x007fffff, 0x00800000,
  0xffffffff, 0x00000000, 0x00ffffff, 0x01000000,
  0xffffffff, 0x00000000, 0x01ffffff, 0x02000000,
  0xffffffff, 0x00000000, 0x03ffffff, 0x04000000,
  0xffffffff, 0x00000000, 0x07ffffff, 0x08000000,
  0xffffffff, 0x00000000, 0x0fffffff, 0x10000000,
  0xffffffff, 0x00000000, 0x1fffffff, 0x20000000,
  0xffffffff, 0x00000000, 0x3fffffff, 0x40000000,
  0xffffffff, 0x00000000, 0x7fffffff, 0x80000000,
  0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000003, 0x00000004, 0x00000040,
  0x00000000, 0x00000007, 0x00000008, 0x00000080,
  0x00000000, 0x0000000f, 0x00000010, 0x00000100,
  0x00000000, 0x0000001f, 0x00000020, 0x00000200,
  0x00000000, 0x0000003f, 0x00000040, 0x00000400,
  0x00000000, 0x0000007f, 0x00000080, 0x00000800,
  0x00000000, 0x000000ff, 0x00000100, 0x00001000,
  0x00000000, 0x000001ff, 0x00000200, 0x00002000,
  0x00000000, 0x000003ff, 0x00000400, 0x00004000,
  0x00000000, 0x000007ff, 0x00000800, 0x00008000,
  0x00000000, 0x00000fff, 0x00001000, 0x00010000,
  0x00000000, 0x00001fff, 0x00002000, 0x00020000,
  0x00000000, 0x00003fff, 0x00004000, 0x00040000,
  0x00000000, 0x00007fff, 0x00008000, 0x00080000,
  0x00000000, 0x0000ffff, 0x00010000, 0x00100000,
  0x00000000, 0x0001ffff, 0x00020000, 0x00200000,
  0x00000000, 0x0003ffff, 0x00040000, 0x00400000,
  0x00000000, 0x0007ffff, 0x00080000, 0x00800000,
  0x00000000, 0x000fffff, 0x00100000, 0x01000000,
  0x00000000, 0x001fffff, 0x00200000, 0x02000000,
  0x00000000, 0x003fffff, 0x00400000, 0x04000000,
  0x00000000, 0x007fffff, 0x00800000, 0x08000000,
  0x00000000, 0x00ffffff, 0x01000000, 0x10000000,
  0x00000000, 0x01ffffff, 0x02000000, 0x20000000,
  0x00000000, 0x03ffffff, 0x04000000, 0x40000000,
  0x00000000, 0x07ffffff, 0x08000000, 0x80000000,
  0x00000000, 0x0fffffff, 0x10000000, 0x00000000,
  0x00000000, 0x1fffffff, 0x20000000, 0x00000000,
  0x00000000, 0x3fffffff, 0x40000000, 0x00000000,
  0x00000000, 0x7fffffff, 0x80000000, 0x00000000,
  0x00000000, 0xffffffff, 0x00000000, 0x00000000,
  0x00000001, 0x00000002, 0x00000020, 0x0000007d,
  0x00000003, 0x00000004, 0x00000040, 0x000000fb,
  0x00000007, 0x00000008, 0x00000080, 0x000001f7,
  0x0000000f, 0x00000010, 0x00000100, 0x000003ef,
  0x0000001f, 0x00000020, 0x00000200, 0x000007df,
  0x0000003f, 0x00000040, 0x00000400, 0x00000fbf,
  0x0000007f, 0x00000080, 0x00000800, 0x00001f7f,
  0x000000ff, 0x00000100, 0x00001000, 0x00003eff,
  0x000001ff, 0x00000200, 0x00002000, 0x00007dff,
  0x000003ff, 0x00000400, 0x00004000, 0x0000fbff,
  0x000007ff, 0x00000800, 0x00008000, 0x0001f7ff,
  0x00000fff, 0x00001000, 0x00010000, 0x0003efff,
  0x00001fff, 0x00002000, 0x00020000, 0x0007dfff,
  0x00003fff, 0x00004000, 0x00040000, 0x000fbfff,
  0x00007fff, 0x00008000, 0x00080000, 0x001f7fff,
  0x0000ffff, 0x00010000, 0x00100000, 0x003effff,
  0x0001ffff, 0x00020000, 0x00200000, 0x007dffff,
  0x0003ffff, 0x00040000, 0x00400000, 0x00fbffff,
  0x0007ffff, 0x00080000, 0x00800000, 0x01f7ffff,
  0x000fffff, 0x00100000, 0x01000000, 0x03efffff,
  0x001fffff, 0x00200000, 0x02000000, 0x07dfffff,
  0x003fffff, 0x00400000, 0x04000000, 0x0fbfffff,
  0x007fffff, 0x00800000, 0x08000000, 0x1f7fffff,
  0x00ffffff, 0x01000000, 0x10000000, 0x3effffff,
  0x01ffffff, 0x02000000, 0x20000000, 0x7dffffff,
  0x03ffffff, 0x04000000, 0x40000000, 0xfbffffff,
  0x07ffffff, 0x08000000, 0x80000000, 0xf7ffffff,
  0x0fffffff, 0x10000000, 0x00000000, 0xefffffff,
  0x1fffffff, 0x20000000, 0x00000000, 0xdfffffff,
  0x3fffffff, 0x40000000, 0x00000000, 0xbfffffff,
  0x7fffffff, 0x80000000, 0x00000000, 0x7fffffff,
  0xffffffff, 0x00000000, 0x00000000, 0xffffffff,
  0x00000002, 0x00000020, 0x0000007d, 0x0000007e,
  0x00000004, 0x00000040, 0x000000fb, 0x000000fc,
  0x00000008, 0x00000080, 0x000001f7, 0x000001f8,
  0x00000010, 0x00000100, 0x000003ef, 0x000003f0,
  0x00000020, 0x00000200, 0x000007df, 0x000007e0,
  0x00000040, 0x00000400, 0x00000fbf, 0x00000fc0,
  0x00000080, 0x00000800, 0x00001f7f, 0x00001f80,
  0x00000100, 0x00001000, 0x00003eff, 0x00003f00,
  0x00000200, 0x00002000, 0x00007dff, 0x00007e00,
  0x00000400, 0x00004000, 0x0000fbff, 0x0000fc00,
  0x00000800, 0x00008000, 0x0001f7ff, 0x0001f800,
  0x00001000, 0x00010000, 0x0003efff, 0x0003f000,
  0x00002000, 0x00020000, 0x0007dfff, 0x0007e000,
  0x00004000, 0x00040000, 0x000fbfff, 0x000fc000,
  0x00008000, 0x00080000, 0x001f7fff, 0x001f8000,
  0x00010000, 0x00100000, 0x003effff, 0x003f0000,
  0x00020000, 0x00200000, 0x007dffff, 0x007e0000,
  0x00040000, 0x00400000, 0x00fbffff, 0x00fc0000,
  0x00080000, 0x00800000, 0x01f7ffff, 0x01f80000,
  0x00100000, 0x01000000, 0x03efffff, 0x03f00000,
  0x00200000, 0x02000000, 0x07dfffff, 0x07e00000,
  0x00400000, 0x04000000, 0x0fbfffff, 0x0fc00000,
  0x00800000, 0x08000000, 0x1f7fffff, 0x1f800000,
  0x01000000, 0x10000000, 0x3effffff, 0x3f000000,
  0x02000000, 0x20000000, 0x7dffffff, 0x7e000000,
  0x04000000, 0x40000000, 0xfbffffff, 0xfc000000,
  0x08000000, 0x80000000, 0xf7ffffff, 0xf8000000,
  0x10000000, 0x00000000, 0xefffffff, 0xf0000000,
  0x20000000, 0x00000000, 0xdfffffff, 0xe0000000,
  0x40000000, 0x00000000, 0xbfffffff, 0xc0000000,
  0x80000000, 0x00000000, 0x7fffffff, 0x80000000,
  0x00000000, 0x00000000, 0xffffffff, 0x00000000,
  0x00000020, 0x0000007d, 0x0000007e, 0x0000007f,
  0x00000040, 0x000000fb, 0x000000fc, 0x000000ff,
  0x00000080, 0x000001f7, 0x000001f8, 0x000001ff,
  0x00000100, 0x000003ef, 0x000003f0, 0x000003ff,
  0x00000200, 0x000007df, 0x000007e0, 0x000007ff,
  0x00000400, 0x00000fbf, 0x00000fc0, 0x00000fff,
  0x00000800, 0x00001f7f, 0x00001f80, 0x00001fff,
  0x00001000, 0x00003eff, 0x00003f00, 0x00003fff,
  0x00002000, 0x00007dff, 0x00007e00, 0x00007fff,
  0x00004000, 0x0000fbff, 0x0000fc00, 0x0000ffff,
  0x00008000, 0x0001f7ff, 0x0001f800, 0x0001ffff,
  0x00010000, 0x0003efff, 0x0003f000, 0x0003ffff,
  0x00020000, 0x0007dfff, 0x0007e000, 0x0007ffff,
  0x00040000, 0x000fbfff, 0x000fc000, 0x000fffff,
  0x00080000, 0x001f7fff, 0x001f8000, 0x001fffff,
  0x00100000, 0x003effff, 0x003f0000, 0x003fffff,
  0x00200000, 0x007dffff, 0x007e0000, 0x007fffff,
  0x00400000, 0x00fbffff, 0x00fc0000, 0x00ffffff,
  0x00800000, 0x01f7ffff, 0x01f80000, 0x01ffffff,
  0x01000000, 0x03efffff, 0x03f00000, 0x03ffffff,
  0x02000000, 0x07dfffff, 0x07e00000, 0x07ffffff,
  0x04000000, 0x0fbfffff, 0x0fc00000, 0x0fffffff,
  0x08000000, 0x1f7fffff, 0x1f800000, 0x1fffffff,
  0x10000000, 0x3effffff, 0x3f000000, 0x3fffffff,
  0x20000000, 0x7dffffff, 0x7e000000, 0x7fffffff,
  0x40000000, 0xfbffffff, 0xfc000000, 0xffffffff,
  0x80000000, 0xf7ffffff, 0xf8000000, 0xffffffff,
  0x00000000, 0xefffffff, 0xf0000000, 0xffffffff,
  0x00000000, 0xdfffffff, 0xe0000000, 0xffffffff,
  0x00000000, 0xbfffffff, 0xc0000000, 0xffffffff,
  0x00000000, 0x7fffffff, 0x80000000, 0xffffffff,
  0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
  0x0000007d, 0x0000007e, 0x0000007f, 0x00007ffd,
  0x000000fb, 0x000000fc, 0x000000ff, 0x0000fffb,
  0x000001f7, 0x000001f8, 0x000001ff, 0x0001fff7,
  0x000003ef, 0x000003f0, 0x000003ff, 0x0003ffef,
  0x000007df, 0x000007e0, 0x000007ff, 0x0007ffdf,
  0x00000fbf, 0x00000fc0, 0x00000fff, 0x000fffbf,
  0x00001f7f, 0x00001f80, 0x00001fff, 0x001fff7f,
  0x00003eff, 0x00003f00, 0x00003fff, 0x003ffeff,
  0x00007dff, 0x00007e00, 0x00007fff, 0x007ffdff,
  0x0000fbff, 0x0000fc00, 0x0000ffff, 0x00fffbff,
  0x0001f7ff, 0x0001f800, 0x0001ffff, 0x01fff7ff,
  0x0003efff, 0x0003f000, 0x0003ffff, 0x03ffefff,
  0x0007dfff, 0x0007e000, 0x0007ffff, 0x07ffdfff,
  0x000fbfff, 0x000fc000, 0x000fffff, 0x0fffbfff,
  0x001f7fff, 0x001f8000, 0x001fffff, 0x1fff7fff,
  0x003effff, 0x003f0000, 0x003fffff, 0x3ffeffff,
  0x007dffff, 0x007e0000, 0x007fffff, 0x7ffdffff,
  0x00fbffff, 0x00fc0000, 0x00ffffff, 0xfffbffff,
  0x01f7ffff, 0x01f80000, 0x01ffffff, 0xfff7ffff,
  0x03efffff, 0x03f00000, 0x03ffffff, 0xffefffff,
  0x07dfffff, 0x07e00000, 0x07ffffff, 0xffdfffff,
  0x0fbfffff, 0x0fc00000, 0x0fffffff, 0xffbfffff,
  0x1f7fffff, 0x1f800000, 0x1fffffff, 0xff7fffff,
  0x3effffff, 0x3f000000, 0x3fffffff, 0xfeffffff,
  0x7dffffff, 0x7e000000, 0x7fffffff, 0xfdffffff,
  0xfbffffff, 0xfc000000, 0xffffffff, 0xfbffffff,
  0xf7ffffff, 0xf8000000, 0xffffffff, 0xf7ffffff,
  0xefffffff, 0xf0000000, 0xffffffff, 0xefffffff,
  0xdfffffff, 0xe0000000, 0xffffffff, 0xdfffffff,
  0xbfffffff, 0xc0000000, 0xffffffff, 0xbfffffff,
  0x7fffffff, 0x80000000, 0xffffffff, 0x7fffffff,
  0xffffffff, 0x00000000, 0xffffffff, 0xffffffff,
  0x0000007e, 0x0000007f, 0x00007ffd, 0x00007ffe,
  0x000000fc, 0x000000ff, 0x0000fffb, 0x0000fffc,
  0x000001f8, 0x000001ff, 0x0001fff7, 0x0001fff8,
  0x000003f0, 0x000003ff, 0x0003ffef, 0x0003fff0,
  0x000007e0, 0x000007ff, 0x0007ffdf, 0x0007ffe0,
  0x00000fc0, 0x00000fff, 0x000fffbf, 0x000fffc0,
  0x00001f80, 0x00001fff, 0x001fff7f, 0x001fff80,
  0x00003f00, 0x00003fff, 0x003ffeff, 0x003fff00,
  0x00007e00, 0x00007fff, 0x007ffdff, 0x007ffe00,
  0x0000fc00, 0x0000ffff, 0x00fffbff, 0x00fffc00,
  0x0001f800, 0x0001ffff, 0x01fff7ff, 0x01fff800,
  0x0003f000, 0x0003ffff, 0x03ffefff, 0x03fff000,
  0x0007e000, 0x0007ffff, 0x07ffdfff, 0x07ffe000,
  0x000fc000, 0x000fffff, 0x0fffbfff, 0x0fffc000,
  0x001f8000, 0x001fffff, 0x1fff7fff, 0x1fff8000,
  0x003f0000, 0x003fffff, 0x3ffeffff, 0x3fff0000,
  0x007e0000, 0x007fffff, 0x7ffdffff, 0x7ffe0000,
  0x00fc0000, 0x00ffffff, 0xfffbffff, 0xfffc0000,
  0x01f80000, 0x01ffffff, 0xfff7ffff, 0xfff80000,
  0x03f00000, 0x03ffffff, 0xffefffff, 0xfff00000,
  0x07e00000, 0x07ffffff, 0xffdfffff, 0xffe00000,
  0x0fc00000, 0x0fffffff, 0xffbfffff, 0xffc00000,
  0x1f800000, 0x1fffffff, 0xff7fffff, 0xff800000,
  0x3f000000, 0x3fffffff, 0xfeffffff, 0xff000000,
  0x7e000000, 0x7fffffff, 0xfdffffff, 0xfe000000,
  0xfc000000, 0xffffffff, 0xfbffffff, 0xfc000000,
  0xf8000000, 0xffffffff, 0xf7ffffff, 0xf8000000,
  0xf0000000, 0xffffffff, 0xefffffff, 0xf0000000,
  0xe0000000, 0xffffffff, 0xdfffffff, 0xe0000000,
  0xc0000000, 0xffffffff, 0xbfffffff, 0xc0000000,
  0x80000000, 0xffffffff, 0x7fffffff, 0x80000000,
  0x00000000, 0xffffffff, 0xffffffff, 0x00000000,
  0x0000007f, 0x00007ffd, 0x00007ffe, 0x00007fff,
  0x000000ff, 0x0000fffb, 0x0000fffc, 0x0000ffff,
  0x000001ff, 0x0001fff7, 0x0001fff8, 0x0001ffff,
  0x000003ff, 0x0003ffef, 0x0003fff0, 0x0003ffff,
  0x000007ff, 0x0007ffdf, 0x0007ffe0, 0x0007ffff,
  0x00000fff, 0x000fffbf, 0x000fffc0, 0x000fffff,
  0x00001fff, 0x001fff7f, 0x001fff80, 0x001fffff,
  0x00003fff, 0x003ffeff, 0x003fff00, 0x003fffff,
  0x00007fff, 0x007ffdff, 0x007ffe00, 0x007fffff,
  0x0000ffff, 0x00fffbff, 0x00fffc00, 0x00ffffff,
  0x0001ffff, 0x01fff7ff, 0x01fff800, 0x01ffffff,
  0x0003ffff, 0x03ffefff, 0x03fff000, 0x03ffffff,
  0x0007ffff, 0x07ffdfff, 0x07ffe000, 0x07ffffff,
  0x000fffff, 0x0fffbfff, 0x0fffc000, 0x0fffffff,
  0x001fffff, 0x1fff7fff, 0x1fff8000, 0x1fffffff,
  0x003fffff, 0x3ffeffff, 0x3fff0000, 0x3fffffff,
  0x007fffff, 0x7ffdffff, 0x7ffe0000, 0x7fffffff,
  0x00ffffff, 0xfffbffff, 0xfffc0000, 0xffffffff,
  0x01ffffff, 0xfff7ffff, 0xfff80000, 0xffffffff,
  0x03ffffff, 0xffefffff, 0xfff00000, 0xffffffff,
  0x07ffffff, 0xffdfffff, 0xffe00000, 0xffffffff,
  0x0fffffff, 0xffbfffff, 0xffc00000, 0xffffffff,
  0x1fffffff, 0xff7fffff, 0xff800000, 0xffffffff,
  0x3fffffff, 0xfeffffff, 0xff000000, 0xffffffff,
  0x7fffffff, 0xfdffffff, 0xfe000000, 0xffffffff,
  0xffffffff, 0xfbffffff, 0xfc000000, 0xffffffff,
  0xffffffff, 0xf7ffffff, 0xf8000000, 0xffffffff,
  0xffffffff, 0xefffffff, 0xf0000000, 0xffffffff,
  0xffffffff, 0xdfffffff, 0xe0000000, 0xffffffff,
  0xffffffff, 0xbfffffff, 0xc0000000, 0xffffffff,
  0xffffffff, 0x7fffffff, 0x80000000, 0xffffffff,
  0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
  0x00007ffd, 0x00007ffe, 0x00007fff, 0x33333333,
  0x0000fffb, 0x0000fffc, 0x0000ffff, 0x66666667,
  0x0001fff7, 0x0001fff8, 0x0001ffff, 0xcccccccf,
  0x0003ffef, 0x0003fff0, 0x0003ffff, 0x9999999f,
  0x0007ffdf, 0x0007ffe0, 0x0007ffff, 0x3333333f,
  0x000fffbf, 0x000fffc0, 0x000fffff, 0x6666667f,
  0x001fff7f, 0x001fff80, 0x001fffff, 0xccccccff,
  0x003ffeff, 0x003fff00, 0x003fffff, 0x999999ff,
  0x007ffdff, 0x007ffe00, 0x007fffff, 0x333333ff,
  0x00fffbff, 0x00fffc00, 0x00ffffff, 0x666667ff,
  0x01fff7ff, 0x01fff800, 0x01ffffff, 0xcccccfff,
  0x03ffefff, 0x03fff000, 0x03ffffff, 0x99999fff,
  0x07ffdfff, 0x07ffe000, 0x07ffffff, 0x33333fff,
  0x0fffbfff, 0x0fffc000, 0x0fffffff, 0x66667fff,
  0x1fff7fff, 0x1fff8000, 0x1fffffff, 0xccccffff,
  0x3ffeffff, 0x3fff0000, 0x3fffffff, 0x9999ffff,
  0x7ffdffff, 0x7ffe0000, 0x7fffffff, 0x3333ffff,
  0xfffbffff, 0xfffc0000, 0xffffffff, 0x6667ffff,
  0xfff7ffff, 0xfff80000, 0xffffffff, 0xcccfffff,
  0xffefffff, 0xfff00000, 0xffffffff, 0x999fffff,
  0xffdfffff, 0xffe00000, 0xffffffff, 0x333fffff,
  0xffbfffff, 0xffc00000, 0xffffffff, 0x667fffff,
  0xff7fffff, 0xff800000, 0xffffffff, 0xccffffff,
  0xfeffffff, 0xff000000, 0xffffffff, 0x99ffffff,
  0xfdffffff, 0xfe000000, 0xffffffff, 0x33ffffff,
  0xfbffffff, 0xfc000000, 0xffffffff, 0x67ffffff,
  0xf7ffffff, 0xf8000000, 0xffffffff, 0xcfffffff,
  0xefffffff, 0xf0000000, 0xffffffff, 0x9fffffff,
  0xdfffffff, 0xe0000000, 0xffffffff, 0x3fffffff,
  0xbfffffff, 0xc0000000, 0xffffffff, 0x7fffffff,
  0x7fffffff, 0x80000000, 0xffffffff, 0xffffffff,
  0xffffffff, 0x00000000, 0xffffffff, 0xffffffff,
  0x00007ffe, 0x00007fff, 0x33333333, 0x55555555,
  0x0000fffc, 0x0000ffff, 0x66666667, 0xaaaaaaab,
  0x0001fff8, 0x0001ffff, 0xcccccccf, 0x55555557,
  0x0003fff0, 0x0003ffff, 0x9999999f, 0xaaaaaaaf,
  0x0007ffe0, 0x0007ffff, 0x3333333f, 0x5555555f,
  0x000fffc0, 0x000fffff, 0x6666667f, 0xaaaaaabf,
  0x001fff80, 0x001fffff, 0xccccccff, 0x5555557f,
  0x003fff00, 0x003fffff, 0x999999ff, 0xaaaaaaff,
  0x007ffe00, 0x007fffff, 0x333333ff, 0x555555ff,
  0x00fffc00, 0x00ffffff, 0x666667ff, 0xaaaaabff,
  0x01fff800, 0x01ffffff, 0xcccccfff, 0x555557ff,
  0x03fff000, 0x03ffffff, 0x99999fff, 0xaaaaafff,
  0x07ffe000, 0x07ffffff, 0x33333fff, 0x55555fff,
  0x0fffc000, 0x0fffffff, 0x66667fff, 0xaaaabfff,
  0x1fff8000, 0x1fffffff, 0xccccffff, 0x55557fff,
  0x3fff0000, 0x3fffffff, 0x9999ffff, 0xaaaaffff,
  0x7ffe0000, 0x7fffffff, 0x3333ffff, 0x5555ffff,
  0xfffc0000, 0xffffffff, 0x6667ffff, 0xaaabffff,
  0xfff80000, 0xffffffff, 0xcccfffff, 0x5557ffff,
  0xfff00000, 0xffffffff, 0x999fffff, 0xaaafffff,
  0xffe00000, 0xffffffff, 0x333fffff, 0x555fffff,
  0xffc00000, 0xffffffff, 0x667fffff, 0xaabfffff,
  0xff800000, 0xffffffff, 0xccffffff, 0x557fffff,
  0xff000000, 0xffffffff, 0x99ffffff, 0xaaffffff,
  0xfe000000, 0xffffffff, 0x33ffffff, 0x55ffffff,
  0xfc000000, 0xffffffff, 0x67ffffff, 0xabffffff,
  0xf8000000, 0xffffffff, 0xcfffffff, 0x57ffffff,
  0xf0000000, 0xffffffff, 0x9fffffff, 0xafffffff,
  0xe0000000, 0xffffffff, 0x3fffffff, 0x5fffffff,
  0xc0000000, 0xffffffff, 0x7fffffff, 0xbfffffff,
  0x80000000, 0xffffffff, 0xffffffff, 0x7fffffff,
  0x00000000, 0xffffffff, 0xffffffff, 0xffffffff,
  0x00007fff, 0x33333333, 0x55555555, 0x7ffffffd,
  0x0000ffff, 0x66666667, 0xaaaaaaab, 0xfffffffb,
  0x0001ffff, 0xcccccccf, 0x55555557, 0xfffffff7,
  0x0003ffff, 0x9999999f, 0xaaaaaaaf, 0xffffffef,
  0x0007ffff, 0x3333333f, 0x5555555f, 0xffffffdf,
  0x000fffff, 0x6666667f, 0xaaaaaabf, 0xffffffbf,
  0x001fffff, 0xccccccff, 0x5555557f, 0xffffff7f,
  0x003fffff, 0x999999ff, 0xaaaaaaff, 0xfffffeff,
  0x007fffff, 0x333333ff, 0x555555ff, 0xfffffdff,
  0x00ffffff, 0x666667ff, 0xaaaaabff, 0xfffffbff,
  0x01ffffff, 0xcccccfff, 0x555557ff, 0xfffff7ff,
  0x03ffffff, 0x99999fff, 0xaaaaafff, 0xffffefff,
  0x07ffffff, 0x33333fff, 0x55555fff, 0xffffdfff,
  0x0fffffff, 0x66667fff, 0xaaaabfff, 0xffffbfff,
  0x1fffffff, 0xccccffff, 0x55557fff, 0xffff7fff,
  0x3fffffff, 0x9999ffff, 0xaaaaffff, 0xfffeffff,
  0x7fffffff, 0x3333ffff, 0x5555ffff, 0xfffdffff,
  0xffffffff, 0x6667ffff, 0xaaabffff, 0xfffbffff,
  0xffffffff, 0xcccfffff, 0x5557ffff, 0xfff7ffff,
  0xffffffff, 0x999fffff, 0xaaafffff, 0xffefffff,
  0xffffffff, 0x333fffff, 0x555fffff, 0xffdfffff,
  0xffffffff, 0x667fffff, 0xaabfffff, 0xffbfffff,
  0xffffffff, 0xccffffff, 0x557fffff, 0xff7fffff,
  0xffffffff, 0x99ffffff, 0xaaffffff, 0xfeffffff,
  0xffffffff, 0x33ffffff, 0x55ffffff, 0xfdffffff,
  0xffffffff, 0x67ffffff, 0xabffffff, 0xfbffffff,
  0xffffffff, 0xcfffffff, 0x57ffffff, 0xf7ffffff,
  0xffffffff, 0x9fffffff, 0xafffffff, 0xefffffff,
  0xffffffff, 0x3fffffff, 0x5fffffff, 0xdfffffff,
  0xffffffff, 0x7fffffff, 0xbfffffff, 0xbfffffff,
  0xffffffff, 0xffffffff, 0x7fffffff, 0x7fffffff,
  0xffffffff, 0xffffffff, 0xffffffff, 0xffffffff,
  0x33333333, 0x55555555, 0x7ffffffd, 0x7ffffffe,
  0x66666667, 0xaaaaaaab, 0xfffffffb, 0xfffffffc,
  0xcccccccf, 0x55555557, 0xfffffff7, 0xfffffff8,
  0x9999999f, 0xaaaaaaaf, 0xffffffef, 0xfffffff0,
  0x3333333f, 0x5555555f, 0xffffffdf, 0xffffffe0,
  0x6666667f, 0xaaaaaabf, 0xffffffbf, 0xffffffc0,
  0xccccccff, 0x5555557f, 0xffffff7f, 0xffffff80,
  0x999999ff, 0xaaaaaaff, 0xfffffeff, 0xffffff00,
  0x333333ff, 0x555555ff, 0xfffffdff, 0xfffffe00,
  0x666667ff, 0xaaaaabff, 0xfffffbff, 0xfffffc00,
  0xcccccfff, 0x555557ff, 0xfffff7ff, 0xfffff800,
  0x99999fff, 0xaaaaafff, 0xffffefff, 0xfffff000,
  0x33333fff, 0x55555fff, 0xffffdfff, 0xffffe000,
  0x66667fff, 0xaaaabfff, 0xffffbfff, 0xffffc000,
  0xccccffff, 0x55557fff, 0xffff7fff, 0xffff8000,
  0x9999ffff, 0xaaaaffff, 0xfffeffff, 0xffff0000,
  0x3333ffff, 0x5555ffff, 0xfffdffff, 0xfffe0000,
  0x6667ffff, 0xaaabffff, 0xfffbffff, 0xfffc0000,
  0xcccfffff, 0x5557ffff, 0xfff7ffff, 0xfff80000,
  0x999fffff, 0xaaafffff, 0xffefffff, 0xfff00000,
  0x333fffff, 0x555fffff, 0xffdfffff, 0xffe00000,
  0x667fffff, 0xaabfffff, 0xffbfffff, 0xffc00000,
  0xccffffff, 0x557fffff, 0xff7fffff, 0xff800000,
  0x99ffffff, 0xaaffffff, 0xfeffffff, 0xff000000,
  0x33ffffff, 0x55ffffff, 0xfdffffff, 0xfe000000,
  0x67ffffff, 0xabffffff, 0xfbffffff, 0xfc000000,
  0xcfffffff, 0x57ffffff, 0xf7ffffff, 0xf8000000,
  0x9fffffff, 0xafffffff, 0xefffffff, 0xf0000000,
  0x3fffffff, 0x5fffffff, 0xdfffffff, 0xe0000000,
  0x7fffffff, 0xbfffffff, 0xbfffffff, 0xc0000000,
  0xffffffff, 0x7fffffff, 0x7fffffff, 0x80000000,
  0xffffffff, 0xffffffff, 0xffffffff, 0x00000000,
  0x55555555, 0x7ffffffd, 0x7ffffffe, 0x7fffffff,
  0xaaaaaaab, 0xfffffffb, 0xfffffffc, 0xffffffff,
  0x55555557, 0xfffffff7, 0xfffffff8, 0xffffffff,
  0xaaaaaaaf, 0xffffffef, 0xfffffff0, 0xffffffff,
  0x5555555f, 0xffffffdf, 0xffffffe0, 0xffffffff,
  0xaaaaaabf, 0xffffffbf, 0xffffffc0, 0xffffffff,
  0x5555557f, 0xffffff7f, 0xffffff80, 0xffffffff,
  0xaaaaaaff, 0xfffffeff, 0xffffff00, 0xffffffff,
  0x555555ff, 0xfffffdff, 0xfffffe00, 0xffffffff,
  0xaaaaabff, 0xfffffbff, 0xfffffc00, 0xffffffff,
  0x555557ff, 0xfffff7ff, 0xfffff800, 0xffffffff,
  0xaaaaafff, 0xffffefff, 0xfffff000, 0xffffffff,
  0x55555fff, 0xffffdfff, 0xffffe000, 0xffffffff,
  0xaaaabfff, 0xffffbfff, 0xffffc000, 0xffffffff,
  0x55557fff, 0xffff7fff, 0xffff8000, 0xffffffff,
  0xaaaaffff, 0xfffeffff, 0xffff0000, 0xffffffff,
  0x5555ffff, 0xfffdffff, 0xfffe0000, 0xffffffff,
  0xaaabffff, 0xfffbffff, 0xfffc0000, 0xffffffff,
  0x5557ffff, 0xfff7ffff, 0xfff80000, 0xffffffff,
  0xaaafffff, 0xffefffff, 0xfff00000, 0xffffffff,
  0x555fffff, 0xffdfffff, 0xffe00000, 0xffffffff,
  0xaabfffff, 0xffbfffff, 0xffc00000, 0xffffffff,
  0x557fffff, 0xff7fffff, 0xff800000, 0xffffffff,
  0xaaffffff, 0xfeffffff, 0xff000000, 0xffffffff,
  0x55ffffff, 0xfdffffff, 0xfe000000, 0xffffffff,
  0xabffffff, 0xfbffffff, 0xfc000000, 0xffffffff,
  0x57ffffff, 0xf7ffffff, 0xf8000000, 0xffffffff,
  0xafffffff, 0xefffffff, 0xf0000000, 0xffffffff,
  0x5fffffff, 0xdfffffff, 0xe0000000, 0xffffffff,
  0xbfffffff, 0xbfffffff, 0xc0000000, 0xffffffff,
  0x7fffffff, 0x7fffffff, 0x80000000, 0xffffffff,
  0xffffffff, 0xffffffff, 0x00000000, 0xffffffff,
  0x7ffffffd, 0x7ffffffe, 0x7fffffff, 0x80000000,
  0xfffffffb, 0xfffffffc, 0xffffffff, 0x00000000,
  0xfffffff7, 0xfffffff8, 0xffffffff, 0x00000000,
  0xffffffef, 0xfffffff0, 0xffffffff, 0x00000000,
  0xffffffdf, 0xffffffe0, 0xffffffff, 0x00000000,
  0xffffffbf, 0xffffffc0, 0xffffffff, 0x00000000,
  0xffffff7f, 0xffffff80, 0xffffffff, 0x00000000,
  0xfffffeff, 0xffffff00, 0xffffffff, 0x00000000,
  0xfffffdff, 0xfffffe00, 0xffffffff, 0x00000000,
  0xfffffbff, 0xfffffc00, 0xffffffff, 0x00000000,
  0xfffff7ff, 0xfffff800, 0xffffffff, 0x00000000,
  0xffffefff, 0xfffff000, 0xffffffff, 0x00000000,
  0xffffdfff, 0xffffe000, 0xffffffff, 0x00000000,
  0xffffbfff, 0xffffc000, 0xffffffff, 0x00000000,
  0xffff7fff, 0xffff8000, 0xffffffff, 0x00000000,
  0xfffeffff, 0xffff0000, 0xffffffff, 0x00000000,
  0xfffdffff, 0xfffe0000, 0xffffffff, 0x00000000,
  0xfffbffff, 0xfffc0000, 0xffffffff, 0x00000000,
  0xfff7ffff, 0xfff80000, 0xffffffff, 0x00000000,
  0xffefffff, 0xfff00000, 0xffffffff, 0x00000000,
  0xffdfffff, 0xffe00000, 0xffffffff, 0x00000000,
  0xffbfffff, 0xffc00000, 0xffffffff, 0x00000000,
  0xff7fffff, 0xff800000, 0xffffffff, 0x00000000,
  0xfeffffff, 0xff000000, 0xffffffff, 0x00000000,
  0xfdffffff, 0xfe000000, 0xffffffff, 0x00000000,
  0xfbffffff, 0xfc000000, 0xffffffff, 0x00000000,
  0xf7ffffff, 0xf8000000, 0xffffffff, 0x00000000,
  0xefffffff, 0xf0000000, 0xffffffff, 0x00000000,
  0xdfffffff, 0xe0000000, 0xffffffff, 0x00000000,
  0xbfffffff, 0xc0000000, 0xffffffff, 0x00000000,
  0x7fffffff, 0x80000000, 0xffffffff, 0x00000000,
  0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
  0x7ffffffe, 0x7fffffff, 0x80000000, 0x80000001,
  0xfffffffc, 0xffffffff, 0x00000000, 0x00000003,
  0xfffffff8, 0xffffffff, 0x00000000, 0x00000007,
  0xfffffff0, 0xffffffff, 0x00000000, 0x0000000f,
  0xffffffe0, 0xffffffff, 0x00000000, 0x0000001f,
  0xffffffc0, 0xffffffff, 0x00000000, 0x0000003f,
  0xffffff80, 0xffffffff, 0x00000000, 0x0000007f,
  0xffffff00, 0xffffffff, 0x00000000, 0x000000ff,
  0xfffffe00, 0xffffffff, 0x00000000, 0x000001ff,
  0xfffffc00, 0xffffffff, 0x00000000, 0x000003ff,
  0xfffff800, 0xffffffff, 0x00000000, 0x000007ff,
  0xfffff000, 0xffffffff, 0x00000000, 0x00000fff,
  0xffffe000, 0xffffffff, 0x00000000, 0x00001fff,
  0xffffc000, 0xffffffff, 0x00000000, 0x00003fff,
  0xffff8000, 0xffffffff, 0x00000000, 0x00007fff,
  0xffff0000, 0xffffffff, 0x00000000, 0x0000ffff,
  0xfffe0000, 0xffffffff, 0x00000000, 0x0001ffff,
  0xfffc0000, 0xffffffff, 0x00000000, 0x0003ffff,
  0xfff80000, 0xffffffff, 0x00000000, 0x0007ffff,
  0xfff00000, 0xffffffff, 0x00000000, 0x000fffff,
  0xffe00000, 0xffffffff, 0x00000000, 0x001fffff,
  0xffc00000, 0xffffffff, 0x00000000, 0x003fffff,
  0xff800000, 0xffffffff, 0x00000000, 0x007fffff,
  0xff000000, 0xffffffff, 0x00000000, 0x00ffffff,
  0xfe000000, 0xffffffff, 0x00000000, 0x01ffffff,
  0xfc000000, 0xffffffff, 0x00000000, 0x03ffffff,
  0xf8000000, 0xffffffff, 0x00000000, 0x07ffffff,
  0xf0000000, 0xffffffff, 0x00000000, 0x0fffffff,
  0xe0000000, 0xffffffff, 0x00000000, 0x1fffffff,
  0xc0000000, 0xffffffff, 0x00000000, 0x3fffffff,
  0x80000000, 0xffffffff, 0x00000000, 0x7fffffff,
  0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
  0x7fffffff, 0x80000000, 0x80000001, 0xaaaaaaaa,
  0xffffffff, 0x00000000, 0x00000003, 0x55555554,
  0xffffffff, 0x00000000, 0x00000007, 0xaaaaaaa8,
  0xffffffff, 0x00000000, 0x0000000f, 0x55555550,
  0xffffffff, 0x00000000, 0x0000001f, 0xaaaaaaa0,
  0xffffffff, 0x00000000, 0x0000003f, 0x55555540,
  0xffffffff, 0x00000000, 0x0000007f, 0xaaaaaa80,
  0xffffffff, 0x00000000, 0x000000ff, 0x55555500,
  0xffffffff, 0x00000000, 0x000001ff, 0xaaaaaa00,
  0xffffffff, 0x00000000, 0x000003ff, 0x55555400,
  0xffffffff, 0x00000000, 0x000007ff, 0xaaaaa800,
  0xffffffff, 0x00000000, 0x00000fff, 0x55555000,
  0xffffffff, 0x00000000, 0x00001fff, 0xaaaaa000,
  0xffffffff, 0x00000000, 0x00003fff, 0x55554000,
  0xffffffff, 0x00000000, 0x00007fff, 0xaaaa8000,
  0xffffffff, 0x00000000, 0x0000ffff, 0x55550000,
  0xffffffff, 0x00000000, 0x0001ffff, 0xaaaa0000,
  0xffffffff, 0x00000000, 0x0003ffff, 0x55540000,
  0xffffffff, 0x00000000, 0x0007ffff, 0xaaa80000,
  0xffffffff, 0x00000000, 0x000fffff, 0x55500000,
  0xffffffff, 0x00000000, 0x001fffff, 0xaaa00000,
  0xffffffff, 0x00000000, 0x003fffff, 0x55400000,
  0xffffffff, 0x00000000, 0x007fffff, 0xaa800000,
  0xffffffff, 0x00000000, 0x00ffffff, 0x55000000,
  0xffffffff, 0x00000000, 0x01ffffff, 0xaa000000,
  0xffffffff, 0x00000000, 0x03ffffff, 0x54000000,
  0xffffffff, 0x00000000, 0x07ffffff, 0xa8000000,
  0xffffffff, 0x00000000, 0x0fffffff, 0x50000000,
  0xffffffff, 0x00000000, 0x1fffffff, 0xa0000000,
  0xffffffff, 0x00000000, 0x3fffffff, 0x40000000,
  0xffffffff, 0x00000000, 0x7fffffff, 0x80000000,
  0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
  0x80000000, 0x80000001, 0xaaaaaaaa, 0xcccccccc,
  0x00000000, 0x00000003, 0x55555554, 0x99999998,
  0x00000000, 0x00000007, 0xaaaaaaa8, 0x33333330,
  0x00000000, 0x0000000f, 0x55555550, 0x66666660,
  0x00000000, 0x0000001f, 0xaaaaaaa0, 0xccccccc0,
  0x00000000, 0x0000003f, 0x55555540, 0x99999980,
  0x00000000, 0x0000007f, 0xaaaaaa80, 0x33333300,
  0x00000000, 0x000000ff, 0x55555500, 0x66666600,
  0x00000000, 0x000001ff, 0xaaaaaa00, 0xcccccc00,
  0x00000000, 0x000003ff, 0x55555400, 0x99999800,
  0x00000000, 0x000007ff, 0xaaaaa800, 0x33333000,
  0x00000000, 0x00000fff, 0x55555000, 0x66666000,
  0x00000000, 0x00001fff, 0xaaaaa000, 0xccccc000,
  0x00000000, 0x00003fff, 0x55554000, 0x99998000,
  0x00000000, 0x00007fff, 0xaaaa8000, 0x33330000,
  0x00000000, 0x0000ffff, 0x55550000, 0x66660000,
  0x00000000, 0x0001ffff, 0xaaaa0000, 0xcccc0000,
  0x00000000, 0x0003ffff, 0x55540000, 0x99980000,
  0x00000000, 0x0007ffff, 0xaaa80000, 0x33300000,
  0x00000000, 0x000fffff, 0x55500000, 0x66600000,
  0x00000000, 0x001fffff, 0xaaa00000, 0xccc00000,
  0x00000000, 0x003fffff, 0x55400000, 0x99800000,
  0x00000000, 0x007fffff, 0xaa800000, 0x33000000,
  0x00000000, 0x00ffffff, 0x55000000, 0x66000000,
  0x00000000, 0x01ffffff, 0xaa000000, 0xcc000000,
  0x00000000, 0x03ffffff, 0x54000000, 0x98000000,
  0x00000000, 0x07ffffff, 0xa8000000, 0x30000000,
  0x00000000, 0x0fffffff, 0x50000000, 0x60000000,
  0x00000000, 0x1fffffff, 0xa0000000, 0xc0000000,
  0x00000000, 0x3fffffff, 0x40000000, 0x80000000,
  0x00000000, 0x7fffffff, 0x80000000, 0x00000000,
  0x00000000, 0xffffffff, 0x00000000, 0x00000000,
  0x80000001, 0xaaaaaaaa, 0xcccccccc, 0xffff8000,
  0x00000003, 0x55555554, 0x99999998, 0xffff0000,
  0x00000007, 0xaaaaaaa8, 0x33333330, 0xfffe0000,
  0x0000000f, 0x55555550, 0x66666660, 0xfffc0000,
  0x0000001f, 0xaaaaaaa0, 0xccccccc0, 0xfff80000,
  0x0000003f, 0x55555540, 0x99999980, 0xfff00000,
  0x0000007f, 0xaaaaaa80, 0x33333300, 0xffe00000,
  0x000000ff, 0x55555500, 0x66666600, 0xffc00000,
  0x000001ff, 0xaaaaaa00, 0xcccccc00, 0xff800000,
  0x000003ff, 0x55555400, 0x99999800, 0xff000000,
  0x000007ff, 0xaaaaa800, 0x33333000, 0xfe000000,
  0x00000fff, 0x55555000, 0x66666000, 0xfc000000,
  0x00001fff, 0xaaaaa000, 0xccccc000, 0xf8000000,
  0x00003fff, 0x55554000, 0x99998000, 0xf0000000,
  0x00007fff, 0xaaaa8000, 0x33330000, 0xe0000000,
  0x0000ffff, 0x55550000, 0x66660000, 0xc0000000,
  0x0001ffff, 0xaaaa0000, 0xcccc0000, 0x80000000,
  0x0003ffff, 0x55540000, 0x99980000, 0x00000000,
  0x0007ffff, 0xaaa80000, 0x33300000, 0x00000000,
  0x000fffff, 0x55500000, 0x66600000, 0x00000000,
  0x001fffff, 0xaaa00000, 0xccc00000, 0x00000000,
  0x003fffff, 0x55400000, 0x99800000, 0x00000000,
  0x007fffff, 0xaa800000, 0x33000000, 0x00000000,
  0x00ffffff, 0x55000000, 0x66000000, 0x00000000,
  0x01ffffff, 0xaa000000, 0xcc000000, 0x00000000,
  0x03ffffff, 0x54000000, 0x98000000, 0x00000000,
  0x07ffffff, 0xa8000000, 0x30000000, 0x00000000,
  0x0fffffff, 0x50000000, 0x60000000, 0x00000000,
  0x1fffffff, 0xa0000000, 0xc0000000, 0x00000000,
  0x3fffffff, 0x40000000, 0x80000000, 0x00000000,
  0x7fffffff, 0x80000000, 0x00000000, 0x00000000,
  0xffffffff, 0x00000000, 0x00000000, 0x00000000,
  0xaaaaaaaa, 0xcccccccc, 0xffff8000, 0xffff8001,
  0x55555554, 0x99999998, 0xffff0000, 0xffff0003,
  0xaaaaaaa8, 0x33333330, 0xfffe0000, 0xfffe0007,
  0x55555550, 0x66666660, 0xfffc0000, 0xfffc000f,
  0xaaaaaaa0, 0xccccccc0, 0xfff80000, 0xfff8001f,
  0x55555540, 0x99999980, 0xfff00000, 0xfff0003f,
  0xaaaaaa80, 0x33333300, 0xffe00000, 0xffe0007f,
  0x55555500, 0x66666600, 0xffc00000, 0xffc000ff,
  0xaaaaaa00, 0xcccccc00, 0xff800000, 0xff8001ff,
  0x55555400, 0x99999800, 0xff000000, 0xff0003ff,
  0xaaaaa800, 0x33333000, 0xfe000000, 0xfe0007ff,
  0x55555000, 0x66666000, 0xfc000000, 0xfc000fff,
  0xaaaaa000, 0xccccc000, 0xf8000000, 0xf8001fff,
  0x55554000, 0x99998000, 0xf0000000, 0xf0003fff,
  0xaaaa8000, 0x33330000, 0xe0000000, 0xe0007fff,
  0x55550000, 0x66660000, 0xc0000000, 0xc000ffff,
  0xaaaa0000, 0xcccc0000, 0x80000000, 0x8001ffff,
  0x55540000, 0x99980000, 0x00000000, 0x0003ffff,
  0xaaa80000, 0x33300000, 0x00000000, 0x0007ffff,
  0x55500000, 0x66600000, 0x00000000, 0x000fffff,
  0xaaa00000, 0xccc00000, 0x00000000, 0x001fffff,
  0x55400000, 0x99800000, 0x00000000, 0x003fffff,
  0xaa800000, 0x33000000, 0x00000000, 0x007fffff,
  0x55000000, 0x66000000, 0x00000000, 0x00ffffff,
  0xaa000000, 0xcc000000, 0x00000000, 0x01ffffff,
  0x54000000, 0x98000000, 0x00000000, 0x03ffffff,
  0xa8000000, 0x30000000, 0x00000000, 0x07ffffff,
  0x50000000, 0x60000000, 0x00000000, 0x0fffffff,
  0xa0000000, 0xc0000000, 0x00000000, 0x1fffffff,
  0x40000000, 0x80000000, 0x00000000, 0x3fffffff,
  0x80000000, 0x00000000, 0x00000000, 0x7fffffff,
  0x00000000, 0x00000000, 0x00000000, 0xffffffff,
  0xcccccccc, 0xffff8000, 0xffff8001, 0xffff8002,
  0x99999998, 0xffff0000, 0xffff0003, 0xffff0004,
  0x33333330, 0xfffe0000, 0xfffe0007, 0xfffe0008,
  0x66666660, 0xfffc0000, 0xfffc000f, 0xfffc0010,
  0xccccccc0, 0xfff80000, 0xfff8001f, 0xfff80020,
  0x99999980, 0xfff00000, 0xfff0003f, 0xfff00040,
  0x33333300, 0xffe00000, 0xffe0007f, 0xffe00080,
  0x66666600, 0xffc00000, 0xffc000ff, 0xffc00100,
  0xcccccc00, 0xff800000, 0xff8001ff, 0xff800200,
  0x99999800, 0xff000000, 0xff0003ff, 0xff000400,
  0x33333000, 0xfe000000, 0xfe0007ff, 0xfe000800,
  0x66666000, 0xfc000000, 0xfc000fff, 0xfc001000,
  0xccccc000, 0xf8000000, 0xf8001fff, 0xf8002000,
  0x99998000, 0xf0000000, 0xf0003fff, 0xf0004000,
  0x33330000, 0xe0000000, 0xe0007fff, 0xe0008000,
  0x66660000, 0xc0000000, 0xc000ffff, 0xc0010000,
  0xcccc0000, 0x80000000, 0x8001ffff, 0x80020000,
  0x99980000, 0x00000000, 0x0003ffff, 0x00040000,
  0x33300000, 0x00000000, 0x0007ffff, 0x00080000,
  0x66600000, 0x00000000, 0x000fffff, 0x00100000,
  0xccc00000, 0x00000000, 0x001fffff, 0x00200000,
  0x99800000, 0x00000000, 0x003fffff, 0x00400000,
  0x33000000, 0x00000000, 0x007fffff, 0x00800000,
  0x66000000, 0x00000000, 0x00ffffff, 0x01000000,
  0xcc000000, 0x00000000, 0x01ffffff, 0x02000000,
  0x98000000, 0x00000000, 0x03ffffff, 0x04000000,
  0x30000000, 0x00000000, 0x07ffffff, 0x08000000,
  0x60000000, 0x00000000, 0x0fffffff, 0x10000000,
  0xc0000000, 0x00000000, 0x1fffffff, 0x20000000,
  0x80000000, 0x00000000, 0x3fffffff, 0x40000000,
  0x00000000, 0x00000000, 0x7fffffff, 0x80000000,
  0x00000000, 0x00000000, 0xffffffff, 0x00000000,
  0xffff8000, 0xffff8001, 0xffff8002, 0xffff8003,
  0xffff0000, 0xffff0003, 0xffff0004, 0xffff0007,
  0xfffe0000, 0xfffe0007, 0xfffe0008, 0xfffe000f,
  0xfffc0000, 0xfffc000f, 0xfffc0010, 0xfffc001f,
  0xfff80000, 0xfff8001f, 0xfff80020, 0xfff8003f,
  0xfff00000, 0xfff0003f, 0xfff00040, 0xfff0007f,
  0xffe00000, 0xffe0007f, 0xffe00080, 0xffe000ff,
  0xffc00000, 0xffc000ff, 0xffc00100, 0xffc001ff,
  0xff800000, 0xff8001ff, 0xff800200, 0xff8003ff,
  0xff000000, 0xff0003ff, 0xff000400, 0xff0007ff,
  0xfe000000, 0xfe0007ff, 0xfe000800, 0xfe000fff,
  0xfc000000, 0xfc000fff, 0xfc001000, 0xfc001fff,
  0xf8000000, 0xf8001fff, 0xf8002000, 0xf8003fff,
  0xf0000000, 0xf0003fff, 0xf0004000, 0xf0007fff,
  0xe0000000, 0xe0007fff, 0xe0008000, 0xe000ffff,
  0xc0000000, 0xc000ffff, 0xc0010000, 0xc001ffff,
  0x80000000, 0x8001ffff, 0x80020000, 0x8003ffff,
  0x00000000, 0x0003ffff, 0x00040000, 0x0007ffff,
  0x00000000, 0x0007ffff, 0x00080000, 0x000fffff,
  0x00000000, 0x000fffff, 0x00100000, 0x001fffff,
  0x00000000, 0x001fffff, 0x00200000, 0x003fffff,
  0x00000000, 0x003fffff, 0x00400000, 0x007fffff,
  0x00000000, 0x007fffff, 0x00800000, 0x00ffffff,
  0x00000000, 0x00ffffff, 0x01000000, 0x01ffffff,
  0x00000000, 0x01ffffff, 0x02000000, 0x03ffffff,
  0x00000000, 0x03ffffff, 0x04000000, 0x07ffffff,
  0x00000000, 0x07ffffff, 0x08000000, 0x0fffffff,
  0x00000000, 0x0fffffff, 0x10000000, 0x1fffffff,
  0x00000000, 0x1fffffff, 0x20000000, 0x3fffffff,
  0x00000000, 0x3fffffff, 0x40000000, 0x7fffffff,
  0x00000000, 0x7fffffff, 0x80000000, 0xffffffff,
  0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
  0xffff8001, 0xffff8002, 0xffff8003, 0xffffff80,
  0xffff0003, 0xffff0004, 0xffff0007, 0xffffff00,
  0xfffe0007, 0xfffe0008, 0xfffe000f, 0xfffffe00,
  0xfffc000f, 0xfffc0010, 0xfffc001f, 0xfffffc00,
  0xfff8001f, 0xfff80020, 0xfff8003f, 0xfffff800,
  0xfff0003f, 0xfff00040, 0xfff0007f, 0xfffff000,
  0xffe0007f, 0xffe00080, 0xffe000ff, 0xffffe000,
  0xffc000ff, 0xffc00100, 0xffc001ff, 0xffffc000,
  0xff8001ff, 0xff800200, 0xff8003ff, 0xffff8000,
  0xff0003ff, 0xff000400, 0xff0007ff, 0xffff0000,
  0xfe0007ff, 0xfe000800, 0xfe000fff, 0xfffe0000,
  0xfc000fff, 0xfc001000, 0xfc001fff, 0xfffc0000,
  0xf8001fff, 0xf8002000, 0xf8003fff, 0xfff80000,
  0xf0003fff, 0xf0004000, 0xf0007fff, 0xfff00000,
  0xe0007fff, 0xe0008000, 0xe000ffff, 0xffe00000,
  0xc000ffff, 0xc0010000, 0xc001ffff, 0xffc00000,
  0x8001ffff, 0x80020000, 0x8003ffff, 0xff800000,
  0x0003ffff, 0x00040000, 0x0007ffff, 0xff000000,
  0x0007ffff, 0x00080000, 0x000fffff, 0xfe000000,
  0x000fffff, 0x00100000, 0x001fffff, 0xfc000000,
  0x001fffff, 0x00200000, 0x003fffff, 0xf8000000,
  0x003fffff, 0x00400000, 0x007fffff, 0xf0000000,
  0x007fffff, 0x00800000, 0x00ffffff, 0xe0000000,
  0x00ffffff, 0x01000000, 0x01ffffff, 0xc0000000,
  0x01ffffff, 0x02000000, 0x03ffffff, 0x80000000,
  0x03ffffff, 0x04000000, 0x07ffffff, 0x00000000,
  0x07ffffff, 0x08000000, 0x0fffffff, 0x00000000,
  0x0fffffff, 0x10000000, 0x1fffffff, 0x00000000,
  0x1fffffff, 0x20000000, 0x3fffffff, 0x00000000,
  0x3fffffff, 0x40000000, 0x7fffffff, 0x00000000,
  0x7fffffff, 0x80000000, 0xffffffff, 0x00000000,
  0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
  0xffff8002, 0xffff8003, 0xffffff80, 0xffffff81,
  0xffff0004, 0xffff0007, 0xffffff00, 0xffffff03,
  0xfffe0008, 0xfffe000f, 0xfffffe00, 0xfffffe07,
  0xfffc0010, 0xfffc001f, 0xfffffc00, 0xfffffc0f,
  0xfff80020, 0xfff8003f, 0xfffff800, 0xfffff81f,
  0xfff00040, 0xfff0007f, 0xfffff000, 0xfffff03f,
  0xffe00080, 0xffe000ff, 0xffffe000, 0xffffe07f,
  0xffc00100, 0xffc001ff, 0xffffc000, 0xffffc0ff,
  0xff800200, 0xff8003ff, 0xffff8000, 0xffff81ff,
  0xff000400, 0xff0007ff, 0xffff0000, 0xffff03ff,
  0xfe000800, 0xfe000fff, 0xfffe0000, 0xfffe07ff,
  0xfc001000, 0xfc001fff, 0xfffc0000, 0xfffc0fff,
  0xf8002000, 0xf8003fff, 0xfff80000, 0xfff81fff,
  0xf0004000, 0xf0007fff, 0xfff00000, 0xfff03fff,
  0xe0008000, 0xe000ffff, 0xffe00000, 0xffe07fff,
  0xc0010000, 0xc001ffff, 0xffc00000, 0xffc0ffff,
  0x80020000, 0x8003ffff, 0xff800000, 0xff81ffff,
  0x00040000, 0x0007ffff, 0xff000000, 0xff03ffff,
  0x00080000, 0x000fffff, 0xfe000000, 0xfe07ffff,
  0x00100000, 0x001fffff, 0xfc000000, 0xfc0fffff,
  0x00200000, 0x003fffff, 0xf8000000, 0xf81fffff,
  0x00400000, 0x007fffff, 0xf0000000, 0xf03fffff,
  0x00800000, 0x00ffffff, 0xe0000000, 0xe07fffff,
  0x01000000, 0x01ffffff, 0xc0000000, 0xc0ffffff,
  0x02000000, 0x03ffffff, 0x80000000, 0x81ffffff,
  0x04000000, 0x07ffffff, 0x00000000, 0x03ffffff,
  0x08000000, 0x0fffffff, 0x00000000, 0x07ffffff,
  0x10000000, 0x1fffffff, 0x00000000, 0x0fffffff,
  0x20000000, 0x3fffffff, 0x00000000, 0x1fffffff,
  0x40000000, 0x7fffffff, 0x00000000, 0x3fffffff,
  0x80000000, 0xffffffff, 0x00000000, 0x7fffffff,
  0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
  0xffff8003, 0xffffff80, 0xffffff81, 0xffffff82,
  0xffff0007, 0xffffff00, 0xffffff03, 0xffffff04,
  0xfffe000f, 0xfffffe00, 0xfffffe07, 0xfffffe08,
  0xfffc001f, 0xfffffc00, 0xfffffc0f, 0xfffffc10,
  0xfff8003f, 0xfffff800, 0xfffff81f, 0xfffff820,
  0xfff0007f, 0xfffff000, 0xfffff03f, 0xfffff040,
  0xffe000ff, 0xffffe000, 0xffffe07f, 0xffffe080,
  0xffc001ff, 0xffffc000, 0xffffc0ff, 0xffffc100,
  0xff8003ff, 0xffff8000, 0xffff81ff, 0xffff8200,
  0xff0007ff, 0xffff0000, 0xffff03ff, 0xffff0400,
  0xfe000fff, 0xfffe0000, 0xfffe07ff, 0xfffe0800,
  0xfc001fff, 0xfffc0000, 0xfffc0fff, 0xfffc1000,
  0xf8003fff, 0xfff80000, 0xfff81fff, 0xfff82000,
  0xf0007fff, 0xfff00000, 0xfff03fff, 0xfff04000,
  0xe000ffff, 0xffe00000, 0xffe07fff, 0xffe08000,
  0xc001ffff, 0xffc00000, 0xffc0ffff, 0xffc10000,
  0x8003ffff, 0xff800000, 0xff81ffff, 0xff820000,
  0x0007ffff, 0xff000000, 0xff03ffff, 0xff040000,
  0x000fffff, 0xfe000000, 0xfe07ffff, 0xfe080000,
  0x001fffff, 0xfc000000, 0xfc0fffff, 0xfc100000,
  0x003fffff, 0xf8000000, 0xf81fffff, 0xf8200000,
  0x007fffff, 0xf0000000, 0xf03fffff, 0xf0400000,
  0x00ffffff, 0xe0000000, 0xe07fffff, 0xe0800000,
  0x01ffffff, 0xc0000000, 0xc0ffffff, 0xc1000000,
  0x03ffffff, 0x80000000, 0x81ffffff, 0x82000000,
  0x07ffffff, 0x00000000, 0x03ffffff, 0x04000000,
  0x0fffffff, 0x00000000, 0x07ffffff, 0x08000000,
  0x1fffffff, 0x00000000, 0x0fffffff, 0x10000000,
  0x3fffffff, 0x00000000, 0x1fffffff, 0x20000000,
  0x7fffffff, 0x00000000, 0x3fffffff, 0x40000000,
  0xffffffff, 0x00000000, 0x7fffffff, 0x80000000,
  0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
  0xffffff80, 0xffffff81, 0xffffff82, 0xffffff83,
  0xffffff00, 0xffffff03, 0xffffff04, 0xffffff07,
  0xfffffe00, 0xfffffe07, 0xfffffe08, 0xfffffe0f,
  0xfffffc00, 0xfffffc0f, 0xfffffc10, 0xfffffc1f,
  0xfffff800, 0xfffff81f, 0xfffff820, 0xfffff83f,
  0xfffff000, 0xfffff03f, 0xfffff040, 0xfffff07f,
  0xffffe000, 0xffffe07f, 0xffffe080, 0xffffe0ff,
  0xffffc000, 0xffffc0ff, 0xffffc100, 0xffffc1ff,
  0xffff8000, 0xffff81ff, 0xffff8200, 0xffff83ff,
  0xffff0000, 0xffff03ff, 0xffff0400, 0xffff07ff,
  0xfffe0000, 0xfffe07ff, 0xfffe0800, 0xfffe0fff,
  0xfffc0000, 0xfffc0fff, 0xfffc1000, 0xfffc1fff,
  0xfff80000, 0xfff81fff, 0xfff82000, 0xfff83fff,
  0xfff00000, 0xfff03fff, 0xfff04000, 0xfff07fff,
  0xffe00000, 0xffe07fff, 0xffe08000, 0xffe0ffff,
  0xffc00000, 0xffc0ffff, 0xffc10000, 0xffc1ffff,
  0xff800000, 0xff81ffff, 0xff820000, 0xff83ffff,
  0xff000000, 0xff03ffff, 0xff040000, 0xff07ffff,
  0xfe000000, 0xfe07ffff, 0xfe080000, 0xfe0fffff,
  0xfc000000, 0xfc0fffff, 0xfc100000, 0xfc1fffff,
  0xf8000000, 0xf81fffff, 0xf8200000, 0xf83fffff,
  0xf0000000, 0xf03fffff, 0xf0400000, 0xf07fffff,
  0xe0000000, 0xe07fffff, 0xe0800000, 0xe0ffffff,
  0xc0000000, 0xc0ffffff, 0xc1000000, 0xc1ffffff,
  0x80000000, 0x81ffffff, 0x82000000, 0x83ffffff,
  0x00000000, 0x03ffffff, 0x04000000, 0x07ffffff,
  0x00000000, 0x07ffffff, 0x08000000, 0x0fffffff,
  0x00000000, 0x0fffffff, 0x10000000, 0x1fffffff,
  0x00000000, 0x1fffffff, 0x20000000, 0x3fffffff,
  0x00000000, 0x3fffffff, 0x40000000, 0x7fffffff,
  0x00000000, 0x7fffffff, 0x80000000, 0xffffffff,
  0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
  0xffffff81, 0xffffff82, 0xffffff83, 0xffffffe0,
  0xffffff03, 0xffffff04, 0xffffff07, 0xffffffc0,
  0xfffffe07, 0xfffffe08, 0xfffffe0f, 0xffffff80,
  0xfffffc0f, 0xfffffc10, 0xfffffc1f, 0xffffff00,
  0xfffff81f, 0xfffff820, 0xfffff83f, 0xfffffe00,
  0xfffff03f, 0xfffff040, 0xfffff07f, 0xfffffc00,
  0xffffe07f, 0xffffe080, 0xffffe0ff, 0xfffff800,
  0xffffc0ff, 0xffffc100, 0xffffc1ff, 0xfffff000,
  0xffff81ff, 0xffff8200, 0xffff83ff, 0xffffe000,
  0xffff03ff, 0xffff0400, 0xffff07ff, 0xffffc000,
  0xfffe07ff, 0xfffe0800, 0xfffe0fff, 0xffff8000,
  0xfffc0fff, 0xfffc1000, 0xfffc1fff, 0xffff0000,
  0xfff81fff, 0xfff82000, 0xfff83fff, 0xfffe0000,
  0xfff03fff, 0xfff04000, 0xfff07fff, 0xfffc0000,
  0xffe07fff, 0xffe08000, 0xffe0ffff, 0xfff80000,
  0xffc0ffff, 0xffc10000, 0xffc1ffff, 0xfff00000,
  0xff81ffff, 0xff820000, 0xff83ffff, 0xffe00000,
  0xff03ffff, 0xff040000, 0xff07ffff, 0xffc00000,
  0xfe07ffff, 0xfe080000, 0xfe0fffff, 0xff800000,
  0xfc0fffff, 0xfc100000, 0xfc1fffff, 0xff000000,
  0xf81fffff, 0xf8200000, 0xf83fffff, 0xfe000000,
  0xf03fffff, 0xf0400000, 0xf07fffff, 0xfc000000,
  0xe07fffff, 0xe0800000, 0xe0ffffff, 0xf8000000,
  0xc0ffffff, 0xc1000000, 0xc1ffffff, 0xf0000000,
  0x81ffffff, 0x82000000, 0x83ffffff, 0xe0000000,
  0x03ffffff, 0x04000000, 0x07ffffff, 0xc0000000,
  0x07ffffff, 0x08000000, 0x0fffffff, 0x80000000,
  0x0fffffff, 0x10000000, 0x1fffffff, 0x00000000,
  0x1fffffff, 0x20000000, 0x3fffffff, 0x00000000,
  0x3fffffff, 0x40000000, 0x7fffffff, 0x00000000,
  0x7fffffff, 0x80000000, 0xffffffff, 0x00000000,
  0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
  0xffffff82, 0xffffff83, 0xffffffe0, 0xfffffffd,
  0xffffff04, 0xffffff07, 0xffffffc0, 0xfffffffb,
  0xfffffe08, 0xfffffe0f, 0xffffff80, 0xfffffff7,
  0xfffffc10, 0xfffffc1f, 0xffffff00, 0xffffffef,
  0xfffff820, 0xfffff83f, 0xfffffe00, 0xffffffdf,
  0xfffff040, 0xfffff07f, 0xfffffc00, 0xffffffbf,
  0xffffe080, 0xffffe0ff, 0xfffff800, 0xffffff7f,
  0xffffc100, 0xffffc1ff, 0xfffff000, 0xfffffeff,
  0xffff8200, 0xffff83ff, 0xffffe000, 0xfffffdff,
  0xffff0400, 0xffff07ff, 0xffffc000, 0xfffffbff,
  0xfffe0800, 0xfffe0fff, 0xffff8000, 0xfffff7ff,
  0xfffc1000, 0xfffc1fff, 0xffff0000, 0xffffefff,
  0xfff82000, 0xfff83fff, 0xfffe0000, 0xffffdfff,
  0xfff04000, 0xfff07fff, 0xfffc0000, 0xffffbfff,
  0xffe08000, 0xffe0ffff, 0xfff80000, 0xffff7fff,
  0xffc10000, 0xffc1ffff, 0xfff00000, 0xfffeffff,
  0xff820000, 0xff83ffff, 0xffe00000, 0xfffdffff,
  0xff040000, 0xff07ffff, 0xffc00000, 0xfffbffff,
  0xfe080000, 0xfe0fffff, 0xff800000, 0xfff7ffff,
  0xfc100000, 0xfc1fffff, 0xff000000, 0xffefffff,
  0xf8200000, 0xf83fffff, 0xfe000000, 0xffdfffff,
  0xf0400000, 0xf07fffff, 0xfc000000, 0xffbfffff,
  0xe0800000, 0xe0ffffff, 0xf8000000, 0xff7fffff,
  0xc1000000, 0xc1ffffff, 0xf0000000, 0xfeffffff,
  0x82000000, 0x83ffffff, 0xe0000000, 0xfdffffff,
  0x04000000, 0x07ffffff, 0xc0000000, 0xfbffffff,
  0x08000000, 0x0fffffff, 0x80000000, 0xf7ffffff,
  0x10000000, 0x1fffffff, 0x00000000, 0xefffffff,
  0x20000000, 0x3fffffff, 0x00000000, 0xdfffffff,
  0x40000000, 0x7fffffff, 0x00000000, 0xbfffffff,
  0x80000000, 0xffffffff, 0x00000000, 0x7fffffff,
  0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
  0xffffff83, 0xffffffe0, 0xfffffffd, 0xfffffffe,
  0xffffff07, 0xffffffc0, 0xfffffffb, 0xfffffffc,
  0xfffffe0f, 0xffffff80, 0xfffffff7, 0xfffffff8,
  0xfffffc1f, 0xffffff00, 0xffffffef, 0xfffffff0,
  0xfffff83f, 0xfffffe00, 0xffffffdf, 0xffffffe0,
  0xfffff07f, 0xfffffc00, 0xffffffbf, 0xffffffc0,
  0xffffe0ff, 0xfffff800, 0xffffff7f, 0xffffff80,
  0xffffc1ff, 0xfffff000, 0xfffffeff, 0xffffff00,
  0xffff83ff, 0xffffe000, 0xfffffdff, 0xfffffe00,
  0xffff07ff, 0xffffc000, 0xfffffbff, 0xfffffc00,
  0xfffe0fff, 0xffff8000, 0xfffff7ff, 0xfffff800,
  0xfffc1fff, 0xffff0000, 0xffffefff, 0xfffff000,
  0xfff83fff, 0xfffe0000, 0xffffdfff, 0xffffe000,
  0xfff07fff, 0xfffc0000, 0xffffbfff, 0xffffc000,
  0xffe0ffff, 0xfff80000, 0xffff7fff, 0xffff8000,
  0xffc1ffff, 0xfff00000, 0xfffeffff, 0xffff0000,
  0xff83ffff, 0xffe00000, 0xfffdffff, 0xfffe0000,
  0xff07ffff, 0xffc00000, 0xfffbffff, 0xfffc0000,
  0xfe0fffff, 0xff800000, 0xfff7ffff, 0xfff80000,
  0xfc1fffff, 0xff000000, 0xffefffff, 0xfff00000,
  0xf83fffff, 0xfe000000, 0xffdfffff, 0xffe00000,
  0xf07fffff, 0xfc000000, 0xffbfffff, 0xffc00000,
  0xe0ffffff, 0xf8000000, 0xff7fffff, 0xff800000,
  0xc1ffffff, 0xf0000000, 0xfeffffff, 0xff000000,
  0x83ffffff, 0xe0000000, 0xfdffffff, 0xfe000000,
  0x07ffffff, 0xc0000000, 0xfbffffff, 0xfc000000,
  0x0fffffff, 0x80000000, 0xf7ffffff, 0xf8000000,
  0x1fffffff, 0x00000000, 0xefffffff, 0xf0000000,
  0x3fffffff, 0x00000000, 0xdfffffff, 0xe0000000,
  0x7fffffff, 0x00000000, 0xbfffffff, 0xc0000000,
  0xffffffff, 0x00000000, 0x7fffffff, 0x80000000,
  0xffffffff, 0x00000000, 0xffffffff, 0x00000000,
  0xffffffe0, 0xfffffffd, 0xfffffffe, 0xffffffff,
  0xffffffc0, 0xfffffffb, 0xfffffffc, 0xffffffff,
  0xffffff80, 0xfffffff7, 0xfffffff8, 0xffffffff,
  0xffffff00, 0xffffffef, 0xfffffff0, 0xffffffff,
  0xfffffe00, 0xffffffdf, 0xffffffe0, 0xffffffff,
  0xfffffc00, 0xffffffbf, 0xffffffc0, 0xffffffff,
  0xfffff800, 0xffffff7f, 0xffffff80, 0xffffffff,
  0xfffff000, 0xfffffeff, 0xffffff00, 0xffffffff,
  0xffffe000, 0xfffffdff, 0xfffffe00, 0xffffffff,
  0xffffc000, 0xfffffbff, 0xfffffc00, 0xffffffff,
  0xffff8000, 0xfffff7ff, 0xfffff800, 0xffffffff,
  0xffff0000, 0xffffefff, 0xfffff000, 0xffffffff,
  0xfffe0000, 0xffffdfff, 0xffffe000, 0xffffffff,
  0xfffc0000, 0xffffbfff, 0xffffc000, 0xffffffff,
  0xfff80000, 0xffff7fff, 0xffff8000, 0xffffffff,
  0xfff00000, 0xfffeffff, 0xffff0000, 0xffffffff,
  0xffe00000, 0xfffdffff, 0xfffe0000, 0xffffffff,
  0xffc00000, 0xfffbffff, 0xfffc0000, 0xffffffff,
  0xff800000, 0xfff7ffff, 0xfff80000, 0xffffffff,
  0xff000000, 0xffefffff, 0xfff00000, 0xffffffff,
  0xfe000000, 0xffdfffff, 0xffe00000, 0xffffffff,
  0xfc000000, 0xffbfffff, 0xffc00000, 0xffffffff,
  0xf8000000, 0xff7fffff, 0xff800000, 0xffffffff,
  0xf0000000, 0xfeffffff, 0xff000000, 0xffffffff,
  0xe0000000, 0xfdffffff, 0xfe000000, 0xffffffff,
  0xc0000000, 0xfbffffff, 0xfc000000, 0xffffffff,
  0x80000000, 0xf7ffffff, 0xf8000000, 0xffffffff,
  0x00000000, 0xefffffff, 0xf0000000, 0xffffffff,
  0x00000000, 0xdfffffff, 0xe0000000, 0xffffffff,
  0x00000000, 0xbfffffff, 0xc0000000, 0xffffffff,
  0x00000000, 0x7fffffff, 0x80000000, 0xffffffff,
  0x00000000, 0xffffffff, 0x00000000, 0xffffffff,
};
const unsigned kExpectedCount_NEON_sli_4S_2OPIMM = 992;

#endif  // VIXL_SIM_SLI_4S_2OPIMM_TRACE_AARCH64_H_
