from typing import Optional

from trac.core import Component


def _eachline(filename: str, encoding: str = 'utf-8'): ...


def _writelines(filename: str, lines, encoding: str = 'utf-8'): ...


class AbstractPasswordFileStore(Component):

    def has_user(self, user: str) -> bool: ...
    def get_users(self) -> [str]: ...
    def set_password(self, user: str, password: str, old_password: str = None, overwrite: bool = True) -> bool: ...
    def delete_user(self, user: str) -> bool: ...
    def check_password(self, user: str, password: str) -> Optional[bool]: ...
    def _update_file(self, prefix: str, userline: Optional[str], overwrite: bool = True) -> bool: ...


class HtPasswdStore(AbstractPasswordFileStore):

    def config_key(self) -> str: ...
    def prefix(self, user: str) -> str: ...
    def userline(self, user: str, password: str) -> str: ...
    def _check_userline(self, user: str, password: str, suffix: str) -> bool: ...
    def _get_users(self, filename: str) -> [str]: ...


class HtDigestStore(AbstractPasswordFileStore):

    def config_key(self) -> str: ...
    def prefix(self, user: str) -> str: ...
    def userline(self, user: str, password: str) -> str: ...
    def _check_userline(self, user: str, password: str, suffix: str) -> bool: ...
    def _get_users(self, filename: str) -> [str]: ...
