'\"
'\" Smithsonian Astrophysical Observatory, Cambridge, MA, USA
'\" This code has been modified under the terms listed below and is made
'\" available under the same terms.
'\"
'\" Copyright 1991-1997 by Bell Labs Innovations for Lucent Technologies.
'\"
'\" Permission to use, copy, modify, and distribute this software and its
'\" documentation for any purpose and without fee is hereby granted, provided
'\" that the above copyright notice appear in all copies and that both that the
'\" copyright notice and warranty disclaimer appear in supporting documentation,
'\" and that the names of Lucent Technologies any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the software
'\" without specific, written prior permission.
'\"
'\" Lucent Technologies disclaims all warranties with regard to this software,
'\" including all implied warranties of merchantability and fitness.  In no event
'\" shall Lucent Technologies be liable for any special, indirect or
'\" consequential damages or any damages whatsoever resulting from loss of use,
'\" data or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or performance
'\" of this software.  
'\"
.TH intro n BLT_VERSION BLT "BLT Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
BLT \- Introduction to the BLT library
.BE
.SH DESCRIPTION
BLT is a library of extensions to the Tk library.  It adds new
commands and variables to the application's interpreter.
.LP
.SH COMMANDS
The following commands are added to the interpreter from the BLT library:
.TP 15
\fBgraph\fR 
A 2D plotting widget.  Plots two variable data in a window with an optional 
legend and annotations.   It has of several components; coordinate axes, 
crosshairs, a legend, and a collection of elements and tags.
.TP 15
\fBbarchart\fR 
A barchart widget.  Plots two-variable data as rectangular bars in a 
window.  The x-coordinate values designate the position of the bar along 
the x-axis, while the y-coordinate values designate the magnitude.
The \fBbarchart\fR widget has of several components; coordinate axes, 
crosshairs, a legend, and a collection of elements and tags.
.TP 15
\fBvector\fR 
Creates a vector of floating point values.  The vector's components
can be manipulated in three ways: through a Tcl array variable, a Tcl
command, or the C API.
.SH ADDING BLT TO YOUR APPLICATIONS
It's easy to add BLT to an existing Tk application.  BLT requires no 
patches or edits to the Tcl or Tk libraries.  To add BLT, simply add the 
following code snippet to your application's tkAppInit.c file.  
.PP
if (Tkblt_Init(interp) != TCL_OK) {
.PP
    return TCL_ERROR;
.PP
}
.TP 15
Recompile and link with the tkblt library and that's it.
.PP
Alternately, you can dynamically load tkblt, simply by invoking the
command
.PP
% package require tkblt
.PP
from your Tcl script.
.SH BUGS
Send bug reports, requests, suggestions, etc. to 
wjoye@cfa.harvard.edu
.SH KEYWORDS
BLT
