#include <SyFi.h>

using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 

int main() { 

    initSyFi(2); 

    Dof dof(true, true); 

    // create two triangles
    Triangle t1(lst(0,0), lst(1,0), lst(0,1)); 
    Triangle t2(lst(1,1), lst(1,0), lst(0,1)); 

    // create the polynomial space
    ex Nj = pol(1,2,"a"); 
    cout <<"Nj " <<Nj<<endl; 
    Line line; 
    ex   dofi; 

    // dofs on first triangle
    for (unsigned int i=0; i< 3; i++) {
        line = t1.line(i);         // pick out the i'th line 
        dofi = line.integrate(Nj); // create the dof which is a line integral 
        dof.insert_dof(1,i, dofi); // insert local dof in global set of dofs 
    }

    // dofs on second triangle
    for (unsigned int i=0; i< 3; i++) {
        line = t2.line(i);         // pick out the i'th line
        dofi = line.integrate(Nj); // create the dof which is a line integral 
        dof.insert_dof(2,i, dofi); // insert local dof in global set of dofs 
    }

    // Print out the global degrees of freedom an their 
    // corresponding local degrees of freedom 
    vector<pair<unsigned int,unsigned int> > vec; 
    pair<unsigned int,unsigned int> index; 
    ex exdof; 
    for (unsigned int i=0; i< dof.size(); i++) {
        exdof = dof.glob_dof(i); 
        vec = dof.glob2loc(i);
        cout <<"global dof " <<i<<" dof "<<exdof<<endl; 
        for (unsigned int j=0; j<vec.size(); j++) { 
            index = vec[j]; 
            cout <<"  element "<<index.first<<" local dof "<<index.second<<endl; 
        }
    }


}



