; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mcpu=pwr9 -mtriple=powerpc64le-unknown-unknown -ppc-vsr-nums-as-vr \
; RUN:   -relocation-model=pic -ppc-asm-full-reg-names -verify-machineinstrs \
; RUN:   < %s | FileCheck %s
; RUN: llc -mcpu=pwr9 -mtriple=powerpc64-unknown-unknown -ppc-vsr-nums-as-vr \
; RUN:   -ppc-asm-full-reg-names -verify-machineinstrs \
; RUN:   < %s | FileCheck %s -check-prefix=CHECK-BE

define dso_local void @testutof(<8 x i16> %a, ptr nocapture %ptr) local_unnamed_addr #0 {
; CHECK-LABEL: testutof:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh v2, v2, 14
; CHECK-NEXT:    xscvuxdsp f0, v2
; CHECK-NEXT:    stfs f0, 0(r5)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: testutof:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh v2, v2, 0
; CHECK-BE-NEXT:    xscvuxdsp f0, v2
; CHECK-BE-NEXT:    stfs f0, 0(r5)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %a, i32 0
  %conv = uitofp i16 %vecext to float
  store float %conv, ptr %ptr, align 4
  ret void
}

define dso_local void @testutod(<8 x i16> %a, ptr nocapture %ptr) local_unnamed_addr #0 {
; CHECK-LABEL: testutod:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh v2, v2, 14
; CHECK-NEXT:    xscvuxddp f0, v2
; CHECK-NEXT:    stfd f0, 0(r5)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: testutod:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh v2, v2, 0
; CHECK-BE-NEXT:    xscvuxddp f0, v2
; CHECK-BE-NEXT:    stfd f0, 0(r5)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %a, i32 0
  %conv = uitofp i16 %vecext to double
  store double %conv, ptr %ptr, align 8
  ret void
}

define dso_local void @teststof(<8 x i16> %a, ptr nocapture %ptr) local_unnamed_addr #0 {
; CHECK-LABEL: teststof:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh v2, v2, 14
; CHECK-NEXT:    vextsh2d v2, v2
; CHECK-NEXT:    xscvsxdsp f0, v2
; CHECK-NEXT:    stfs f0, 0(r5)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: teststof:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh v2, v2, 0
; CHECK-BE-NEXT:    vextsh2d v2, v2
; CHECK-BE-NEXT:    xscvsxdsp f0, v2
; CHECK-BE-NEXT:    stfs f0, 0(r5)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %a, i32 0
  %conv = sitofp i16 %vecext to float
  store float %conv, ptr %ptr, align 4
  ret void
}

define dso_local void @teststod(<8 x i16> %a, ptr nocapture %ptr) local_unnamed_addr #0 {
; CHECK-LABEL: teststod:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh v2, v2, 14
; CHECK-NEXT:    vextsh2d v2, v2
; CHECK-NEXT:    xscvsxddp f0, v2
; CHECK-NEXT:    stfd f0, 0(r5)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: teststod:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractuh v2, v2, 0
; CHECK-BE-NEXT:    vextsh2d v2, v2
; CHECK-BE-NEXT:    xscvsxddp f0, v2
; CHECK-BE-NEXT:    stfd f0, 0(r5)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <8 x i16> %a, i32 0
  %conv = sitofp i16 %vecext to double
  store double %conv, ptr %ptr, align 8
  ret void
}

define dso_local void @testsubtod(<16 x i8> %a, ptr nocapture %ptr) local_unnamed_addr #0 {
; CHECK-LABEL: testsubtod:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub v2, v2, 15
; CHECK-NEXT:    xscvuxddp f0, v2
; CHECK-NEXT:    stfd f0, 0(r5)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: testsubtod:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub v2, v2, 0
; CHECK-BE-NEXT:    xscvuxddp f0, v2
; CHECK-BE-NEXT:    stfd f0, 0(r5)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %a, i32 0
  %conv = uitofp i8 %vecext to double
  store double %conv, ptr %ptr, align 8
  ret void
}

define dso_local void @testsbtod(<16 x i8> %a, ptr nocapture %ptr) local_unnamed_addr #0 {
; CHECK-LABEL: testsbtod:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractuh v2, v2, 15
; CHECK-NEXT:    vextsh2d v2, v2
; CHECK-NEXT:    xscvsxddp f0, v2
; CHECK-NEXT:    stfd f0, 0(r5)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: testsbtod:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub v2, v2, 0
; CHECK-BE-NEXT:    vextsh2d v2, v2
; CHECK-BE-NEXT:    xscvsxddp f0, v2
; CHECK-BE-NEXT:    stfd f0, 0(r5)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %a, i32 0
  %conv = sitofp i8 %vecext to double
  store double %conv, ptr %ptr, align 8
  ret void
}

define dso_local void @testsubtof(<16 x i8> %a, ptr nocapture %ptr) local_unnamed_addr #0 {
; CHECK-LABEL: testsubtof:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub v2, v2, 15
; CHECK-NEXT:    xscvuxdsp f0, v2
; CHECK-NEXT:    stfs f0, 0(r5)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: testsubtof:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub v2, v2, 0
; CHECK-BE-NEXT:    xscvuxdsp f0, v2
; CHECK-BE-NEXT:    stfs f0, 0(r5)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %a, i32 0
  %conv = uitofp i8 %vecext to float
  store float %conv, ptr %ptr, align 8
  ret void
}

define dso_local void @testsbtof(<16 x i8> %a, ptr nocapture %ptr) local_unnamed_addr #0 {
; CHECK-LABEL: testsbtof:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vextractub v2, v2, 15
; CHECK-NEXT:    vextsh2d v2, v2
; CHECK-NEXT:    xscvsxdsp f0, v2
; CHECK-NEXT:    stfs f0, 0(r5)
; CHECK-NEXT:    blr
;
; CHECK-BE-LABEL: testsbtof:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    vextractub v2, v2, 0
; CHECK-BE-NEXT:    vextsh2d v2, v2
; CHECK-BE-NEXT:    xscvsxdsp f0, v2
; CHECK-BE-NEXT:    stfs f0, 0(r5)
; CHECK-BE-NEXT:    blr
entry:
  %vecext = extractelement <16 x i8> %a, i32 0
  %conv = sitofp i8 %vecext to float
  store float %conv, ptr %ptr, align 8
  ret void
}
