8.2 Akordy

# Akordy

Sonic Pi posiada wbudowane wsparcie dla nazw akordów, które 
zwracają listy. Spróbuj sam: 

```
play chord(:E3, :minor)
```

Teraz, naprawdę zaczynamy dokądś zmierzać. To wygląda dużo ładniej niż 
czyste listy (i jest dużo łatwiejsze do czytania dla innych ludzi). 
Jakie więc inne akordy wspiera Sonic Pi? Całkiem *sporo*. Spróbuj tych: 

* `chord(:E3, :m7)`
* `chord(:E3, :minor)`
* `chord(:E3, :dim7)`
* `chord(:E3, :dom7)`

## Arpeggia

Możemy bardzo łatwo zmienić akordy w arpeggia za pomocą funkcji
`play_pattern`:

```
play_pattern chord(:E3, :m7)
```

Ok, to nie jest jakoś mocno fajne - zostało zagrane dość wolno. Funkcja 
`play_pattern` zagra każdą listę z przekazanej listy odzdzielając każdą 
nutę uruchomieniem polecenia `sleep 1` pomiędzy każdym uruchomieniem 
funkcji `play`. Możemy jednak użyć innej funkcji `play_pattern_timed` 
aby móc samodzielnie określić timing i przyśpieszyć bieg rzeczy: 

```
play_pattern_timed chord(:E3, :m7), 0.25
```

Możemy nawet przekazać listę czasów, która zostanie potraktowania jako 
krąg czasów: 

```
play_pattern_timed chord(:E3, :m13), [0.25, 0.5]
```

Jest to odpowiednik takiego kwała kodu: 

```
play 52
sleep 0.25
play 55
sleep 0.5
play 59
sleep 0.25
play 62
sleep 0.5
play 66
sleep 0.25
play 69
sleep 0.5
play 73
```

Który kawałek wydaje Ci się wygodnieszy do napisania, którego byś 
użył?
