/***************************************************************************
 SocNetV: Social Network Visualizer
 version: 2.4
 Written in Qt
 
                         dialogsimilaritymatches.h  -  description
                             -------------------
    copyright         : (C) 2005-2018 by Dimitris B. Kalamaras
    project site      : http://socnetv.org

 ***************************************************************************/

/*******************************************************************************
*     This program is free software: you can redistribute it and/or modify     *
*     it under the terms of the GNU General Public License as published by     *
*     the Free Software Foundation, either version 3 of the License, or        *
*     (at your option) any later version.                                      *
*                                                                              *
*     This program is distributed in the hope that it will be useful,          *
*     but WITHOUT ANY WARRANTY; without even the implied warranty of           *
*     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
*     GNU General Public License for more details.                             *
*                                                                              *
*     You should have received a copy of the GNU General Public License        *
*     along with this program.  If not, see <http://www.gnu.org/licenses/>.    *
********************************************************************************/

#ifndef DIALOGSIMILARITYMATCHES_H
#define DIALOGSIMILARITYMATCHES_H

#include <QDialog>
#include "ui_dialogsimilaritymatches.h"
 

class DialogSimilarityMatches: public QDialog
{
	Q_OBJECT
public:
    DialogSimilarityMatches (QWidget *parent = 0);
    ~DialogSimilarityMatches();
public slots:
	void gatherData();
signals:
    void userChoices(const QString &matrix,
                     const QString &varLocation,
                     const QString &method,
                     const bool &diagonal);
private slots:
    void on_buttonBox_accepted();

    void on_buttonBox_rejected();

private:
    Ui::DialogSimilarityMatches ui;
    QStringList matrixList, variablesLocationList, measureList;

};



#endif
